/* Generated by Frama-C */
#include "stddef.h"
#include "stdio.h"
void f_signed(int a, int b)
{
  int c = a << 2;
  __e_acsl_assert(0 <= a,"RTE","f_signed","shift: 0 <= a",
                  "tests/arith/bitwise.c",12);
  __e_acsl_assert((long)c == a << 2L,"Assertion","f_signed","c == a << 2",
                  "tests/arith/bitwise.c",12);
  /*@ assert c ≡ a << 2; */ ;
  int d = b >> 2;
  __e_acsl_assert(0 <= b,"RTE","f_signed","shift: 0 <= b",
                  "tests/arith/bitwise.c",14);
  __e_acsl_assert(d == b >> 2,"Assertion","f_signed","d == b >> 2",
                  "tests/arith/bitwise.c",14);
  /*@ assert d ≡ b >> 2; */ ;
  int e = a | b;
  __e_acsl_assert((long)e == (a | (long)b),"Assertion","f_signed",
                  "e == (a | b)","tests/arith/bitwise.c",16);
  /*@ assert e ≡ (a | b); */ ;
  int f = a & b;
  __e_acsl_assert((long)f == (a & (long)b),"Assertion","f_signed",
                  "f == (a & b)","tests/arith/bitwise.c",18);
  /*@ assert f ≡ (a & b); */ ;
  int g = a ^ b;
  __e_acsl_assert((long)g == (a ^ (long)b),"Assertion","f_signed",
                  "g == (a ^ b)","tests/arith/bitwise.c",20);
  /*@ assert g ≡ (a ^ b); */ ;
  return;
}

void f_unsigned(unsigned int a, unsigned int b)
{
  unsigned int c = a << 2u;
  __e_acsl_assert((unsigned long)c == a << 2UL,"Assertion","f_unsigned",
                  "c == a << 2","tests/arith/bitwise.c",26);
  /*@ assert c ≡ a << 2; */ ;
  unsigned int d = b >> 2u;
  __e_acsl_assert(d == b >> 2U,"Assertion","f_unsigned","d == b >> 2",
                  "tests/arith/bitwise.c",28);
  /*@ assert d ≡ b >> 2; */ ;
  unsigned int e = a | b;
  __e_acsl_assert(e == (a | b),"Assertion","f_unsigned","e == (a | b)",
                  "tests/arith/bitwise.c",30);
  /*@ assert e ≡ (a | b); */ ;
  unsigned int f = a & b;
  __e_acsl_assert(f == (a & b),"Assertion","f_unsigned","f == (a & b)",
                  "tests/arith/bitwise.c",32);
  /*@ assert f ≡ (a & b); */ ;
  unsigned int g = a ^ b;
  __e_acsl_assert(g == (a ^ b),"Assertion","f_unsigned","g == (a ^ b)",
                  "tests/arith/bitwise.c",34);
  /*@ assert g ≡ (a ^ b); */ ;
  return;
}

void g_signed(int a, int b)
{
  int c = a << b;
  {
    __e_acsl_mpz_t __gen_e_acsl_c;
    __e_acsl_mpz_t __gen_e_acsl_a;
    __e_acsl_mpz_t __gen_e_acsl_b;
    int __gen_e_acsl_b_shiftl_guard;
    __e_acsl_mp_bitcnt_t __gen_e_acsl_b_shiftl_coerced;
    __e_acsl_mpz_t __gen_e_acsl_;
    int __gen_e_acsl_a_shiftl_guard;
    __e_acsl_mpz_t __gen_e_acsl_shiftl;
    int __gen_e_acsl_eq;
    __gmpz_init_set_si(__gen_e_acsl_c,(long)c);
    __gmpz_init_set_si(__gen_e_acsl_a,(long)a);
    __gmpz_init_set_si(__gen_e_acsl_b,(long)b);
    __gen_e_acsl_b_shiftl_guard = __gmpz_fits_ulong_p((__e_acsl_mpz_struct const *)(__gen_e_acsl_b));
    /*@ assert
        E_ACSL: shiftl_rhs_fits_in_mp_bitcnt_t:
          0 ≤ b ≤ 18446744073709551615;
    */
    __e_acsl_assert(__gen_e_acsl_b_shiftl_guard,"RTE","g_signed",
                    "shiftl_rhs_fits_in_mp_bitcnt_t: 0 <= b <= 18446744073709551615",
                    "tests/arith/bitwise.c",40);
    __gen_e_acsl_b_shiftl_coerced = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl_b));
    __gmpz_init_set_si(__gen_e_acsl_,0L);
    __gen_e_acsl_a_shiftl_guard = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_a),
                                             (__e_acsl_mpz_struct const *)(__gen_e_acsl_));
    __gmpz_init(__gen_e_acsl_shiftl);
    /*@ assert E_ACSL: a ≥ 0; */
    __e_acsl_assert(__gen_e_acsl_a_shiftl_guard >= 0,"RTE","g_signed",
                    "a >= 0","tests/arith/bitwise.c",40);
    __gmpz_mul_2exp(__gen_e_acsl_shiftl,
                    (__e_acsl_mpz_struct const *)(__gen_e_acsl_a),
                    __gen_e_acsl_b_shiftl_coerced);
    __gen_e_acsl_eq = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_c),
                                 (__e_acsl_mpz_struct const *)(__gen_e_acsl_shiftl));
    __e_acsl_assert(__gen_e_acsl_eq == 0,"Assertion","g_signed",
                    "c == a << b","tests/arith/bitwise.c",40);
    __gmpz_clear(__gen_e_acsl_c);
    __gmpz_clear(__gen_e_acsl_a);
    __gmpz_clear(__gen_e_acsl_b);
    __gmpz_clear(__gen_e_acsl_);
    __gmpz_clear(__gen_e_acsl_shiftl);
  }
  /*@ assert c ≡ a << b; */ ;
  int d = a >> b;
  {
    __e_acsl_mpz_t __gen_e_acsl_d;
    __e_acsl_mpz_t __gen_e_acsl_a_2;
    __e_acsl_mpz_t __gen_e_acsl_b_2;
    int __gen_e_acsl_b_shiftr_guard;
    __e_acsl_mp_bitcnt_t __gen_e_acsl_b_shiftr_coerced;
    __e_acsl_mpz_t __gen_e_acsl__2;
    int __gen_e_acsl_a_shiftr_guard;
    __e_acsl_mpz_t __gen_e_acsl_shiftr;
    int __gen_e_acsl_eq_2;
    __gmpz_init_set_si(__gen_e_acsl_d,(long)d);
    __gmpz_init_set_si(__gen_e_acsl_a_2,(long)a);
    __gmpz_init_set_si(__gen_e_acsl_b_2,(long)b);
    __gen_e_acsl_b_shiftr_guard = __gmpz_fits_ulong_p((__e_acsl_mpz_struct const *)(__gen_e_acsl_b_2));
    /*@ assert
        E_ACSL: shiftr_rhs_fits_in_mp_bitcnt_t:
          0 ≤ b ≤ 18446744073709551615;
    */
    __e_acsl_assert(__gen_e_acsl_b_shiftr_guard,"RTE","g_signed",
                    "shiftr_rhs_fits_in_mp_bitcnt_t: 0 <= b <= 18446744073709551615",
                    "tests/arith/bitwise.c",42);
    __gen_e_acsl_b_shiftr_coerced = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl_b_2));
    __gmpz_init_set_si(__gen_e_acsl__2,0L);
    __gen_e_acsl_a_shiftr_guard = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_a_2),
                                             (__e_acsl_mpz_struct const *)(__gen_e_acsl__2));
    __gmpz_init(__gen_e_acsl_shiftr);
    /*@ assert E_ACSL: a ≥ 0; */
    __e_acsl_assert(__gen_e_acsl_a_shiftr_guard >= 0,"RTE","g_signed",
                    "a >= 0","tests/arith/bitwise.c",42);
    __gmpz_tdiv_q_2exp(__gen_e_acsl_shiftr,
                       (__e_acsl_mpz_struct const *)(__gen_e_acsl_a_2),
                       __gen_e_acsl_b_shiftr_coerced);
    __gen_e_acsl_eq_2 = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_d),
                                   (__e_acsl_mpz_struct const *)(__gen_e_acsl_shiftr));
    __e_acsl_assert(__gen_e_acsl_eq_2 == 0,"Assertion","g_signed",
                    "d == a >> b","tests/arith/bitwise.c",42);
    __gmpz_clear(__gen_e_acsl_d);
    __gmpz_clear(__gen_e_acsl_a_2);
    __gmpz_clear(__gen_e_acsl_b_2);
    __gmpz_clear(__gen_e_acsl__2);
    __gmpz_clear(__gen_e_acsl_shiftr);
  }
  /*@ assert d ≡ a >> b; */ ;
  {
    __e_acsl_mpz_t __gen_e_acsl__3;
    __e_acsl_mpz_t __gen_e_acsl__4;
    __e_acsl_mpz_t __gen_e_acsl_add;
    int __gen_e_acsl_cst_shiftl_guard;
    __e_acsl_mp_bitcnt_t __gen_e_acsl_cst_shiftl_coerced;
    __e_acsl_mpz_t __gen_e_acsl__5;
    int __gen_e_acsl_shiftl_guard;
    __e_acsl_mpz_t __gen_e_acsl_shiftl_2;
    int __gen_e_acsl_ne;
    __gmpz_init_set_ui(__gen_e_acsl__3,18446744073709551615UL);
    __gmpz_init_set_si(__gen_e_acsl__4,1L);
    __gmpz_init(__gen_e_acsl_add);
    __gmpz_add(__gen_e_acsl_add,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__3),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__4));
    __gen_e_acsl_cst_shiftl_guard = __gmpz_fits_ulong_p((__e_acsl_mpz_struct const *)(__gen_e_acsl__4));
    /*@ assert
        E_ACSL: shiftl_rhs_fits_in_mp_bitcnt_t:
          0 ≤ 1 ≤ 18446744073709551615;
    */
    __e_acsl_assert(__gen_e_acsl_cst_shiftl_guard,"RTE","g_signed",
                    "shiftl_rhs_fits_in_mp_bitcnt_t: 0 <= 1 <= 18446744073709551615",
                    "tests/arith/bitwise.c",44);
    __gen_e_acsl_cst_shiftl_coerced = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl__4));
    __gmpz_init_set_si(__gen_e_acsl__5,0L);
    __gen_e_acsl_shiftl_guard = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_add),
                                           (__e_acsl_mpz_struct const *)(__gen_e_acsl__5));
    __gmpz_init(__gen_e_acsl_shiftl_2);
    /*@ assert E_ACSL: 18446744073709551615ULL + 1 ≥ 0; */
    __e_acsl_assert(__gen_e_acsl_shiftl_guard >= 0,"RTE","g_signed",
                    "18446744073709551615ULL + 1 >= 0",
                    "tests/arith/bitwise.c",44);
    __gmpz_mul_2exp(__gen_e_acsl_shiftl_2,
                    (__e_acsl_mpz_struct const *)(__gen_e_acsl_add),
                    __gen_e_acsl_cst_shiftl_coerced);
    __gen_e_acsl_ne = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_shiftl_2),
                                 (__e_acsl_mpz_struct const *)(__gen_e_acsl__5));
    __e_acsl_assert(__gen_e_acsl_ne != 0,"Assertion","g_signed",
                    "(18446744073709551615ULL + 1) << 1 != 0",
                    "tests/arith/bitwise.c",44);
    __gmpz_clear(__gen_e_acsl__3);
    __gmpz_clear(__gen_e_acsl__4);
    __gmpz_clear(__gen_e_acsl_add);
    __gmpz_clear(__gen_e_acsl__5);
    __gmpz_clear(__gen_e_acsl_shiftl_2);
  }
  /*@ assert (18446744073709551615ULL + 1) << 1 ≢ 0; */ ;
  {
    __e_acsl_mpz_t __gen_e_acsl__6;
    __e_acsl_mpz_t __gen_e_acsl__7;
    __e_acsl_mpz_t __gen_e_acsl_add_2;
    int __gen_e_acsl_cst_shiftr_guard;
    __e_acsl_mp_bitcnt_t __gen_e_acsl_cst_shiftr_coerced;
    __e_acsl_mpz_t __gen_e_acsl__8;
    int __gen_e_acsl_shiftr_guard;
    __e_acsl_mpz_t __gen_e_acsl_shiftr_2;
    unsigned long __gen_e_acsl__9;
    __gmpz_init_set_ui(__gen_e_acsl__6,18446744073709551615UL);
    __gmpz_init_set_si(__gen_e_acsl__7,1L);
    __gmpz_init(__gen_e_acsl_add_2);
    __gmpz_add(__gen_e_acsl_add_2,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__6),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__7));
    __gen_e_acsl_cst_shiftr_guard = __gmpz_fits_ulong_p((__e_acsl_mpz_struct const *)(__gen_e_acsl__7));
    /*@ assert
        E_ACSL: shiftr_rhs_fits_in_mp_bitcnt_t:
          0 ≤ 1 ≤ 18446744073709551615;
    */
    __e_acsl_assert(__gen_e_acsl_cst_shiftr_guard,"RTE","g_signed",
                    "shiftr_rhs_fits_in_mp_bitcnt_t: 0 <= 1 <= 18446744073709551615",
                    "tests/arith/bitwise.c",45);
    __gen_e_acsl_cst_shiftr_coerced = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl__7));
    __gmpz_init_set_si(__gen_e_acsl__8,0L);
    __gen_e_acsl_shiftr_guard = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_add_2),
                                           (__e_acsl_mpz_struct const *)(__gen_e_acsl__8));
    __gmpz_init(__gen_e_acsl_shiftr_2);
    /*@ assert E_ACSL: 18446744073709551615ULL + 1 ≥ 0; */
    __e_acsl_assert(__gen_e_acsl_shiftr_guard >= 0,"RTE","g_signed",
                    "18446744073709551615ULL + 1 >= 0",
                    "tests/arith/bitwise.c",45);
    __gmpz_tdiv_q_2exp(__gen_e_acsl_shiftr_2,
                       (__e_acsl_mpz_struct const *)(__gen_e_acsl_add_2),
                       __gen_e_acsl_cst_shiftr_coerced);
    __gen_e_acsl__9 = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl_shiftr_2));
    __e_acsl_assert(__gen_e_acsl__9 != 0UL,"Assertion","g_signed",
                    "(18446744073709551615ULL + 1) >> 1 != 0",
                    "tests/arith/bitwise.c",45);
    __gmpz_clear(__gen_e_acsl__6);
    __gmpz_clear(__gen_e_acsl__7);
    __gmpz_clear(__gen_e_acsl_add_2);
    __gmpz_clear(__gen_e_acsl__8);
    __gmpz_clear(__gen_e_acsl_shiftr_2);
  }
  /*@ assert (18446744073709551615ULL + 1) >> 1 ≢ 0; */ ;
  {
    __e_acsl_mpz_t __gen_e_acsl__10;
    __e_acsl_mpz_t __gen_e_acsl__11;
    int __gen_e_acsl_cst_shiftl_guard_2;
    __e_acsl_mp_bitcnt_t __gen_e_acsl_cst_shiftl_coerced_2;
    __e_acsl_mpz_t __gen_e_acsl__12;
    int __gen_e_acsl_cst_shiftl_guard_3;
    __e_acsl_mpz_t __gen_e_acsl_shiftl_3;
    int __gen_e_acsl_ne_2;
    __gmpz_init_set_si(__gen_e_acsl__10,1L);
    __gmpz_init_set_si(__gen_e_acsl__11,65L);
    __gen_e_acsl_cst_shiftl_guard_2 = __gmpz_fits_ulong_p((__e_acsl_mpz_struct const *)(__gen_e_acsl__11));
    /*@ assert
        E_ACSL: shiftl_rhs_fits_in_mp_bitcnt_t:
          0 ≤ 65 ≤ 18446744073709551615;
    */
    __e_acsl_assert(__gen_e_acsl_cst_shiftl_guard_2,"RTE","g_signed",
                    "shiftl_rhs_fits_in_mp_bitcnt_t: 0 <= 65 <= 18446744073709551615",
                    "tests/arith/bitwise.c",46);
    __gen_e_acsl_cst_shiftl_coerced_2 = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl__11));
    __gmpz_init_set_si(__gen_e_acsl__12,0L);
    __gen_e_acsl_cst_shiftl_guard_3 = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl__10),
                                                 (__e_acsl_mpz_struct const *)(__gen_e_acsl__12));
    __gmpz_init(__gen_e_acsl_shiftl_3);
    /*@ assert E_ACSL: 1 ≥ 0; */
    __e_acsl_assert(__gen_e_acsl_cst_shiftl_guard_3 >= 0,"RTE","g_signed",
                    "1 >= 0","tests/arith/bitwise.c",46);
    __gmpz_mul_2exp(__gen_e_acsl_shiftl_3,
                    (__e_acsl_mpz_struct const *)(__gen_e_acsl__10),
                    __gen_e_acsl_cst_shiftl_coerced_2);
    __gen_e_acsl_ne_2 = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_shiftl_3),
                                   (__e_acsl_mpz_struct const *)(__gen_e_acsl__12));
    __e_acsl_assert(__gen_e_acsl_ne_2 != 0,"Assertion","g_signed",
                    "1 << 65 != 0","tests/arith/bitwise.c",46);
    __gmpz_clear(__gen_e_acsl__10);
    __gmpz_clear(__gen_e_acsl__11);
    __gmpz_clear(__gen_e_acsl__12);
    __gmpz_clear(__gen_e_acsl_shiftl_3);
  }
  /*@ assert 1 << 65 ≢ 0; */ ;
  {
    __e_acsl_mpz_t __gen_e_acsl__13;
    __e_acsl_mpz_t __gen_e_acsl__14;
    __e_acsl_mpz_t __gen_e_acsl_add_3;
    __e_acsl_mpz_t __gen_e_acsl__15;
    __e_acsl_mpz_t __gen_e_acsl_sub;
    __e_acsl_mpz_t __gen_e_acsl_bor;
    __e_acsl_mpz_t __gen_e_acsl__16;
    int __gen_e_acsl_ne_3;
    __gmpz_init_set_ui(__gen_e_acsl__13,18446744073709551615UL);
    __gmpz_init_set_si(__gen_e_acsl__14,1L);
    __gmpz_init(__gen_e_acsl_add_3);
    __gmpz_add(__gen_e_acsl_add_3,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__13),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__14));
    __gmpz_init_set_si(__gen_e_acsl__15,-9223372036854775807L - 1L);
    __gmpz_init(__gen_e_acsl_sub);
    __gmpz_sub(__gen_e_acsl_sub,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__15),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__14));
    __gmpz_init(__gen_e_acsl_bor);
    __gmpz_ior(__gen_e_acsl_bor,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_add_3),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_sub));
    __gmpz_init_set_si(__gen_e_acsl__16,0L);
    __gen_e_acsl_ne_3 = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_bor),
                                   (__e_acsl_mpz_struct const *)(__gen_e_acsl__16));
    __e_acsl_assert(__gen_e_acsl_ne_3 != 0,"Assertion","g_signed",
                    "((18446744073709551615ULL + 1) | ((-9223372036854775807LL - 1LL) - 1)) != 0",
                    "tests/arith/bitwise.c",47);
    __gmpz_clear(__gen_e_acsl__13);
    __gmpz_clear(__gen_e_acsl__14);
    __gmpz_clear(__gen_e_acsl_add_3);
    __gmpz_clear(__gen_e_acsl__15);
    __gmpz_clear(__gen_e_acsl_sub);
    __gmpz_clear(__gen_e_acsl_bor);
    __gmpz_clear(__gen_e_acsl__16);
  }
  /*@
  assert
  ((18446744073709551615ULL + 1) | ((-9223372036854775807LL - 1LL) - 1)) ≢
  0; */
  ;
  {
    __e_acsl_mpz_t __gen_e_acsl__17;
    __e_acsl_mpz_t __gen_e_acsl__18;
    __e_acsl_mpz_t __gen_e_acsl_add_4;
    __e_acsl_mpz_t __gen_e_acsl__19;
    __e_acsl_mpz_t __gen_e_acsl_sub_2;
    __e_acsl_mpz_t __gen_e_acsl_band;
    __e_acsl_mpz_t __gen_e_acsl_bxor;
    int __gen_e_acsl_ne_4;
    __gmpz_init_set_ui(__gen_e_acsl__17,18446744073709551615UL);
    __gmpz_init_set_si(__gen_e_acsl__18,1L);
    __gmpz_init(__gen_e_acsl_add_4);
    __gmpz_add(__gen_e_acsl_add_4,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__17),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__18));
    __gmpz_init_set_si(__gen_e_acsl__19,-9223372036854775807L - 1L);
    __gmpz_init(__gen_e_acsl_sub_2);
    __gmpz_sub(__gen_e_acsl_sub_2,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__19),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__18));
    __gmpz_init(__gen_e_acsl_band);
    __gmpz_and(__gen_e_acsl_band,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_add_4),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_sub_2));
    __gmpz_init(__gen_e_acsl_bxor);
    __gmpz_xor(__gen_e_acsl_bxor,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_add_4),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_sub_2));
    __gen_e_acsl_ne_4 = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_band),
                                   (__e_acsl_mpz_struct const *)(__gen_e_acsl_bxor));
    __e_acsl_assert(__gen_e_acsl_ne_4 != 0,"Assertion","g_signed",
                    "((18446744073709551615ULL + 1) & ((-9223372036854775807LL - 1LL) - 1)) !=\n((18446744073709551615ULL + 1) ^ ((-9223372036854775807LL - 1LL) - 1))",
                    "tests/arith/bitwise.c",48);
    __gmpz_clear(__gen_e_acsl__17);
    __gmpz_clear(__gen_e_acsl__18);
    __gmpz_clear(__gen_e_acsl_add_4);
    __gmpz_clear(__gen_e_acsl__19);
    __gmpz_clear(__gen_e_acsl_sub_2);
    __gmpz_clear(__gen_e_acsl_band);
    __gmpz_clear(__gen_e_acsl_bxor);
  }
  /*@
  assert
  ((18446744073709551615ULL + 1) & ((-9223372036854775807LL - 1LL) - 1)) ≢
  ((18446744073709551615ULL + 1) ^ ((-9223372036854775807LL - 1LL) - 1)); */
  ;
  return;
}

void g_unsigned(unsigned int a, unsigned int b)
{
  unsigned int c = a << b;
  {
    __e_acsl_mpz_t __gen_e_acsl_c;
    __e_acsl_mpz_t __gen_e_acsl_a;
    __e_acsl_mpz_t __gen_e_acsl_b;
    int __gen_e_acsl_b_shiftl_guard;
    __e_acsl_mp_bitcnt_t __gen_e_acsl_b_shiftl_coerced;
    __e_acsl_mpz_t __gen_e_acsl_;
    int __gen_e_acsl_a_shiftl_guard;
    __e_acsl_mpz_t __gen_e_acsl_shiftl;
    int __gen_e_acsl_eq;
    __gmpz_init_set_ui(__gen_e_acsl_c,(unsigned long)c);
    __gmpz_init_set_ui(__gen_e_acsl_a,(unsigned long)a);
    __gmpz_init_set_ui(__gen_e_acsl_b,(unsigned long)b);
    __gen_e_acsl_b_shiftl_guard = __gmpz_fits_ulong_p((__e_acsl_mpz_struct const *)(__gen_e_acsl_b));
    /*@ assert
        E_ACSL: shiftl_rhs_fits_in_mp_bitcnt_t:
          0 ≤ b ≤ 18446744073709551615;
    */
    __e_acsl_assert(__gen_e_acsl_b_shiftl_guard,"RTE","g_unsigned",
                    "shiftl_rhs_fits_in_mp_bitcnt_t: 0 <= b <= 18446744073709551615",
                    "tests/arith/bitwise.c",55);
    __gen_e_acsl_b_shiftl_coerced = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl_b));
    __gmpz_init_set_si(__gen_e_acsl_,0L);
    __gen_e_acsl_a_shiftl_guard = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_a),
                                             (__e_acsl_mpz_struct const *)(__gen_e_acsl_));
    __gmpz_init(__gen_e_acsl_shiftl);
    /*@ assert E_ACSL: a ≥ 0; */
    __e_acsl_assert(__gen_e_acsl_a_shiftl_guard >= 0,"RTE","g_unsigned",
                    "a >= 0","tests/arith/bitwise.c",55);
    __gmpz_mul_2exp(__gen_e_acsl_shiftl,
                    (__e_acsl_mpz_struct const *)(__gen_e_acsl_a),
                    __gen_e_acsl_b_shiftl_coerced);
    __gen_e_acsl_eq = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_c),
                                 (__e_acsl_mpz_struct const *)(__gen_e_acsl_shiftl));
    __e_acsl_assert(__gen_e_acsl_eq == 0,"Assertion","g_unsigned",
                    "c == a << b","tests/arith/bitwise.c",55);
    __gmpz_clear(__gen_e_acsl_c);
    __gmpz_clear(__gen_e_acsl_a);
    __gmpz_clear(__gen_e_acsl_b);
    __gmpz_clear(__gen_e_acsl_);
    __gmpz_clear(__gen_e_acsl_shiftl);
  }
  /*@ assert c ≡ a << b; */ ;
  unsigned int d = a >> b;
  {
    __e_acsl_mpz_t __gen_e_acsl_d;
    __e_acsl_mpz_t __gen_e_acsl_a_2;
    __e_acsl_mpz_t __gen_e_acsl_b_2;
    int __gen_e_acsl_b_shiftr_guard;
    __e_acsl_mp_bitcnt_t __gen_e_acsl_b_shiftr_coerced;
    __e_acsl_mpz_t __gen_e_acsl__2;
    int __gen_e_acsl_a_shiftr_guard;
    __e_acsl_mpz_t __gen_e_acsl_shiftr;
    int __gen_e_acsl_eq_2;
    __gmpz_init_set_ui(__gen_e_acsl_d,(unsigned long)d);
    __gmpz_init_set_ui(__gen_e_acsl_a_2,(unsigned long)a);
    __gmpz_init_set_ui(__gen_e_acsl_b_2,(unsigned long)b);
    __gen_e_acsl_b_shiftr_guard = __gmpz_fits_ulong_p((__e_acsl_mpz_struct const *)(__gen_e_acsl_b_2));
    /*@ assert
        E_ACSL: shiftr_rhs_fits_in_mp_bitcnt_t:
          0 ≤ b ≤ 18446744073709551615;
    */
    __e_acsl_assert(__gen_e_acsl_b_shiftr_guard,"RTE","g_unsigned",
                    "shiftr_rhs_fits_in_mp_bitcnt_t: 0 <= b <= 18446744073709551615",
                    "tests/arith/bitwise.c",57);
    __gen_e_acsl_b_shiftr_coerced = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl_b_2));
    __gmpz_init_set_si(__gen_e_acsl__2,0L);
    __gen_e_acsl_a_shiftr_guard = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_a_2),
                                             (__e_acsl_mpz_struct const *)(__gen_e_acsl__2));
    __gmpz_init(__gen_e_acsl_shiftr);
    /*@ assert E_ACSL: a ≥ 0; */
    __e_acsl_assert(__gen_e_acsl_a_shiftr_guard >= 0,"RTE","g_unsigned",
                    "a >= 0","tests/arith/bitwise.c",57);
    __gmpz_tdiv_q_2exp(__gen_e_acsl_shiftr,
                       (__e_acsl_mpz_struct const *)(__gen_e_acsl_a_2),
                       __gen_e_acsl_b_shiftr_coerced);
    __gen_e_acsl_eq_2 = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_d),
                                   (__e_acsl_mpz_struct const *)(__gen_e_acsl_shiftr));
    __e_acsl_assert(__gen_e_acsl_eq_2 == 0,"Assertion","g_unsigned",
                    "d == a >> b","tests/arith/bitwise.c",57);
    __gmpz_clear(__gen_e_acsl_d);
    __gmpz_clear(__gen_e_acsl_a_2);
    __gmpz_clear(__gen_e_acsl_b_2);
    __gmpz_clear(__gen_e_acsl__2);
    __gmpz_clear(__gen_e_acsl_shiftr);
  }
  /*@ assert d ≡ a >> b; */ ;
  {
    __e_acsl_mpz_t __gen_e_acsl__3;
    __e_acsl_mpz_t __gen_e_acsl__4;
    __e_acsl_mpz_t __gen_e_acsl_add;
    int __gen_e_acsl_cst_shiftl_guard;
    __e_acsl_mp_bitcnt_t __gen_e_acsl_cst_shiftl_coerced;
    __e_acsl_mpz_t __gen_e_acsl__5;
    int __gen_e_acsl_shiftl_guard;
    __e_acsl_mpz_t __gen_e_acsl_shiftl_2;
    int __gen_e_acsl_ne;
    __gmpz_init_set_ui(__gen_e_acsl__3,18446744073709551615UL);
    __gmpz_init_set_si(__gen_e_acsl__4,1L);
    __gmpz_init(__gen_e_acsl_add);
    __gmpz_add(__gen_e_acsl_add,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__3),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__4));
    __gen_e_acsl_cst_shiftl_guard = __gmpz_fits_ulong_p((__e_acsl_mpz_struct const *)(__gen_e_acsl__4));
    /*@ assert
        E_ACSL: shiftl_rhs_fits_in_mp_bitcnt_t:
          0 ≤ 1u ≤ 18446744073709551615;
    */
    __e_acsl_assert(__gen_e_acsl_cst_shiftl_guard,"RTE","g_unsigned",
                    "shiftl_rhs_fits_in_mp_bitcnt_t: 0 <= 1u <= 18446744073709551615",
                    "tests/arith/bitwise.c",59);
    __gen_e_acsl_cst_shiftl_coerced = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl__4));
    __gmpz_init_set_si(__gen_e_acsl__5,0L);
    __gen_e_acsl_shiftl_guard = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_add),
                                           (__e_acsl_mpz_struct const *)(__gen_e_acsl__5));
    __gmpz_init(__gen_e_acsl_shiftl_2);
    /*@ assert E_ACSL: 18446744073709551615ULL + 1u ≥ 0; */
    __e_acsl_assert(__gen_e_acsl_shiftl_guard >= 0,"RTE","g_unsigned",
                    "18446744073709551615ULL + 1u >= 0",
                    "tests/arith/bitwise.c",59);
    __gmpz_mul_2exp(__gen_e_acsl_shiftl_2,
                    (__e_acsl_mpz_struct const *)(__gen_e_acsl_add),
                    __gen_e_acsl_cst_shiftl_coerced);
    __gen_e_acsl_ne = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_shiftl_2),
                                 (__e_acsl_mpz_struct const *)(__gen_e_acsl__5));
    __e_acsl_assert(__gen_e_acsl_ne != 0,"Assertion","g_unsigned",
                    "(18446744073709551615ULL + 1u) << 1u != 0",
                    "tests/arith/bitwise.c",59);
    __gmpz_clear(__gen_e_acsl__3);
    __gmpz_clear(__gen_e_acsl__4);
    __gmpz_clear(__gen_e_acsl_add);
    __gmpz_clear(__gen_e_acsl__5);
    __gmpz_clear(__gen_e_acsl_shiftl_2);
  }
  /*@ assert (18446744073709551615ULL + 1u) << 1u ≢ 0; */ ;
  {
    __e_acsl_mpz_t __gen_e_acsl__6;
    __e_acsl_mpz_t __gen_e_acsl__7;
    __e_acsl_mpz_t __gen_e_acsl_add_2;
    int __gen_e_acsl_cst_shiftr_guard;
    __e_acsl_mp_bitcnt_t __gen_e_acsl_cst_shiftr_coerced;
    __e_acsl_mpz_t __gen_e_acsl__8;
    int __gen_e_acsl_shiftr_guard;
    __e_acsl_mpz_t __gen_e_acsl_shiftr_2;
    unsigned long __gen_e_acsl__9;
    __gmpz_init_set_ui(__gen_e_acsl__6,18446744073709551615UL);
    __gmpz_init_set_si(__gen_e_acsl__7,1L);
    __gmpz_init(__gen_e_acsl_add_2);
    __gmpz_add(__gen_e_acsl_add_2,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__6),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__7));
    __gen_e_acsl_cst_shiftr_guard = __gmpz_fits_ulong_p((__e_acsl_mpz_struct const *)(__gen_e_acsl__7));
    /*@ assert
        E_ACSL: shiftr_rhs_fits_in_mp_bitcnt_t:
          0 ≤ 1u ≤ 18446744073709551615;
    */
    __e_acsl_assert(__gen_e_acsl_cst_shiftr_guard,"RTE","g_unsigned",
                    "shiftr_rhs_fits_in_mp_bitcnt_t: 0 <= 1u <= 18446744073709551615",
                    "tests/arith/bitwise.c",60);
    __gen_e_acsl_cst_shiftr_coerced = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl__7));
    __gmpz_init_set_si(__gen_e_acsl__8,0L);
    __gen_e_acsl_shiftr_guard = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_add_2),
                                           (__e_acsl_mpz_struct const *)(__gen_e_acsl__8));
    __gmpz_init(__gen_e_acsl_shiftr_2);
    /*@ assert E_ACSL: 18446744073709551615ULL + 1u ≥ 0; */
    __e_acsl_assert(__gen_e_acsl_shiftr_guard >= 0,"RTE","g_unsigned",
                    "18446744073709551615ULL + 1u >= 0",
                    "tests/arith/bitwise.c",60);
    __gmpz_tdiv_q_2exp(__gen_e_acsl_shiftr_2,
                       (__e_acsl_mpz_struct const *)(__gen_e_acsl_add_2),
                       __gen_e_acsl_cst_shiftr_coerced);
    __gen_e_acsl__9 = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl_shiftr_2));
    __e_acsl_assert(__gen_e_acsl__9 != 0UL,"Assertion","g_unsigned",
                    "(18446744073709551615ULL + 1u) >> 1u != 0",
                    "tests/arith/bitwise.c",60);
    __gmpz_clear(__gen_e_acsl__6);
    __gmpz_clear(__gen_e_acsl__7);
    __gmpz_clear(__gen_e_acsl_add_2);
    __gmpz_clear(__gen_e_acsl__8);
    __gmpz_clear(__gen_e_acsl_shiftr_2);
  }
  /*@ assert (18446744073709551615ULL + 1u) >> 1u ≢ 0; */ ;
  {
    __e_acsl_mpz_t __gen_e_acsl__10;
    __e_acsl_mpz_t __gen_e_acsl__11;
    int __gen_e_acsl_cst_shiftl_guard_2;
    __e_acsl_mp_bitcnt_t __gen_e_acsl_cst_shiftl_coerced_2;
    __e_acsl_mpz_t __gen_e_acsl__12;
    int __gen_e_acsl_cst_shiftl_guard_3;
    __e_acsl_mpz_t __gen_e_acsl_shiftl_3;
    int __gen_e_acsl_ne_2;
    __gmpz_init_set_si(__gen_e_acsl__10,1L);
    __gmpz_init_set_si(__gen_e_acsl__11,65L);
    __gen_e_acsl_cst_shiftl_guard_2 = __gmpz_fits_ulong_p((__e_acsl_mpz_struct const *)(__gen_e_acsl__11));
    /*@ assert
        E_ACSL: shiftl_rhs_fits_in_mp_bitcnt_t:
          0 ≤ 65u ≤ 18446744073709551615;
    */
    __e_acsl_assert(__gen_e_acsl_cst_shiftl_guard_2,"RTE","g_unsigned",
                    "shiftl_rhs_fits_in_mp_bitcnt_t: 0 <= 65u <= 18446744073709551615",
                    "tests/arith/bitwise.c",61);
    __gen_e_acsl_cst_shiftl_coerced_2 = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl__11));
    __gmpz_init_set_si(__gen_e_acsl__12,0L);
    __gen_e_acsl_cst_shiftl_guard_3 = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl__10),
                                                 (__e_acsl_mpz_struct const *)(__gen_e_acsl__12));
    __gmpz_init(__gen_e_acsl_shiftl_3);
    /*@ assert E_ACSL: 1u ≥ 0; */
    __e_acsl_assert(__gen_e_acsl_cst_shiftl_guard_3 >= 0,"RTE","g_unsigned",
                    "1u >= 0","tests/arith/bitwise.c",61);
    __gmpz_mul_2exp(__gen_e_acsl_shiftl_3,
                    (__e_acsl_mpz_struct const *)(__gen_e_acsl__10),
                    __gen_e_acsl_cst_shiftl_coerced_2);
    __gen_e_acsl_ne_2 = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_shiftl_3),
                                   (__e_acsl_mpz_struct const *)(__gen_e_acsl__12));
    __e_acsl_assert(__gen_e_acsl_ne_2 != 0,"Assertion","g_unsigned",
                    "1u << 65u != 0","tests/arith/bitwise.c",61);
    __gmpz_clear(__gen_e_acsl__10);
    __gmpz_clear(__gen_e_acsl__11);
    __gmpz_clear(__gen_e_acsl__12);
    __gmpz_clear(__gen_e_acsl_shiftl_3);
  }
  /*@ assert 1u << 65u ≢ 0; */ ;
  {
    __e_acsl_mpz_t __gen_e_acsl__13;
    __e_acsl_mpz_t __gen_e_acsl__14;
    __e_acsl_mpz_t __gen_e_acsl_add_3;
    __e_acsl_mpz_t __gen_e_acsl_bor;
    __e_acsl_mpz_t __gen_e_acsl__15;
    int __gen_e_acsl_ne_3;
    __gmpz_init_set_ui(__gen_e_acsl__13,18446744073709551615UL);
    __gmpz_init_set_si(__gen_e_acsl__14,1L);
    __gmpz_init(__gen_e_acsl_add_3);
    __gmpz_add(__gen_e_acsl_add_3,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__13),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__14));
    __gmpz_init(__gen_e_acsl_bor);
    __gmpz_ior(__gen_e_acsl_bor,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_add_3),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__14));
    __gmpz_init_set_si(__gen_e_acsl__15,0L);
    __gen_e_acsl_ne_3 = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_bor),
                                   (__e_acsl_mpz_struct const *)(__gen_e_acsl__15));
    __e_acsl_assert(__gen_e_acsl_ne_3 != 0,"Assertion","g_unsigned",
                    "((18446744073709551615ULL + 1u) | 1u) != 0",
                    "tests/arith/bitwise.c",62);
    __gmpz_clear(__gen_e_acsl__13);
    __gmpz_clear(__gen_e_acsl__14);
    __gmpz_clear(__gen_e_acsl_add_3);
    __gmpz_clear(__gen_e_acsl_bor);
    __gmpz_clear(__gen_e_acsl__15);
  }
  /*@ assert ((18446744073709551615ULL + 1u) | 1u) ≢ 0; */ ;
  {
    __e_acsl_mpz_t __gen_e_acsl__16;
    __e_acsl_mpz_t __gen_e_acsl__17;
    __e_acsl_mpz_t __gen_e_acsl_add_4;
    __e_acsl_mpz_t __gen_e_acsl_band;
    __e_acsl_mpz_t __gen_e_acsl_bxor;
    int __gen_e_acsl_ne_4;
    __gmpz_init_set_ui(__gen_e_acsl__16,18446744073709551615UL);
    __gmpz_init_set_si(__gen_e_acsl__17,1L);
    __gmpz_init(__gen_e_acsl_add_4);
    __gmpz_add(__gen_e_acsl_add_4,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__16),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__17));
    __gmpz_init(__gen_e_acsl_band);
    __gmpz_and(__gen_e_acsl_band,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_add_4),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__17));
    __gmpz_init(__gen_e_acsl_bxor);
    __gmpz_xor(__gen_e_acsl_bxor,
               (__e_acsl_mpz_struct const *)(__gen_e_acsl_add_4),
               (__e_acsl_mpz_struct const *)(__gen_e_acsl__17));
    __gen_e_acsl_ne_4 = __gmpz_cmp((__e_acsl_mpz_struct const *)(__gen_e_acsl_band),
                                   (__e_acsl_mpz_struct const *)(__gen_e_acsl_bxor));
    __e_acsl_assert(__gen_e_acsl_ne_4 != 0,"Assertion","g_unsigned",
                    "((18446744073709551615ULL + 1u) & 1u) !=\n((18446744073709551615ULL + 1u) ^ 1u)",
                    "tests/arith/bitwise.c",63);
    __gmpz_clear(__gen_e_acsl__16);
    __gmpz_clear(__gen_e_acsl__17);
    __gmpz_clear(__gen_e_acsl_add_4);
    __gmpz_clear(__gen_e_acsl_band);
    __gmpz_clear(__gen_e_acsl_bxor);
  }
  /*@
  assert
  ((18446744073709551615ULL + 1u) & 1u) ≢
  ((18446744073709551615ULL + 1u) ^ 1u); */
  ;
  return;
}

int main(void)
{
  int __retres;
  int a = 4;
  int b = 8;
  f_signed(a,b);
  f_unsigned((unsigned int)a,(unsigned int)b);
  g_signed(a,b);
  g_unsigned((unsigned int)a,(unsigned int)b);
  __retres = 0;
  return __retres;
}


