package devices

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/iothub/mgmt/2018-12-01-preview/devices"

// AccessRights enumerates the values for access rights.
type AccessRights string

const (
	// DeviceConnect ...
	DeviceConnect AccessRights = "DeviceConnect"
	// RegistryRead ...
	RegistryRead AccessRights = "RegistryRead"
	// RegistryReadDeviceConnect ...
	RegistryReadDeviceConnect AccessRights = "RegistryRead, DeviceConnect"
	// RegistryReadRegistryWrite ...
	RegistryReadRegistryWrite AccessRights = "RegistryRead, RegistryWrite"
	// RegistryReadRegistryWriteDeviceConnect ...
	RegistryReadRegistryWriteDeviceConnect AccessRights = "RegistryRead, RegistryWrite, DeviceConnect"
	// RegistryReadRegistryWriteServiceConnect ...
	RegistryReadRegistryWriteServiceConnect AccessRights = "RegistryRead, RegistryWrite, ServiceConnect"
	// RegistryReadRegistryWriteServiceConnectDeviceConnect ...
	RegistryReadRegistryWriteServiceConnectDeviceConnect AccessRights = "RegistryRead, RegistryWrite, ServiceConnect, DeviceConnect"
	// RegistryReadServiceConnect ...
	RegistryReadServiceConnect AccessRights = "RegistryRead, ServiceConnect"
	// RegistryReadServiceConnectDeviceConnect ...
	RegistryReadServiceConnectDeviceConnect AccessRights = "RegistryRead, ServiceConnect, DeviceConnect"
	// RegistryWrite ...
	RegistryWrite AccessRights = "RegistryWrite"
	// RegistryWriteDeviceConnect ...
	RegistryWriteDeviceConnect AccessRights = "RegistryWrite, DeviceConnect"
	// RegistryWriteServiceConnect ...
	RegistryWriteServiceConnect AccessRights = "RegistryWrite, ServiceConnect"
	// RegistryWriteServiceConnectDeviceConnect ...
	RegistryWriteServiceConnectDeviceConnect AccessRights = "RegistryWrite, ServiceConnect, DeviceConnect"
	// ServiceConnect ...
	ServiceConnect AccessRights = "ServiceConnect"
	// ServiceConnectDeviceConnect ...
	ServiceConnectDeviceConnect AccessRights = "ServiceConnect, DeviceConnect"
)

// PossibleAccessRightsValues returns an array of possible values for the AccessRights const type.
func PossibleAccessRightsValues() []AccessRights {
	return []AccessRights{DeviceConnect, RegistryRead, RegistryReadDeviceConnect, RegistryReadRegistryWrite, RegistryReadRegistryWriteDeviceConnect, RegistryReadRegistryWriteServiceConnect, RegistryReadRegistryWriteServiceConnectDeviceConnect, RegistryReadServiceConnect, RegistryReadServiceConnectDeviceConnect, RegistryWrite, RegistryWriteDeviceConnect, RegistryWriteServiceConnect, RegistryWriteServiceConnectDeviceConnect, ServiceConnect, ServiceConnectDeviceConnect}
}

// Capabilities enumerates the values for capabilities.
type Capabilities string

const (
	// DeviceManagement ...
	DeviceManagement Capabilities = "DeviceManagement"
	// None ...
	None Capabilities = "None"
)

// PossibleCapabilitiesValues returns an array of possible values for the Capabilities const type.
func PossibleCapabilitiesValues() []Capabilities {
	return []Capabilities{DeviceManagement, None}
}

// Encoding enumerates the values for encoding.
type Encoding string

const (
	// Avro ...
	Avro Encoding = "Avro"
	// AvroDeflate ...
	AvroDeflate Encoding = "AvroDeflate"
	// JSON ...
	JSON Encoding = "JSON"
)

// PossibleEncodingValues returns an array of possible values for the Encoding const type.
func PossibleEncodingValues() []Encoding {
	return []Encoding{Avro, AvroDeflate, JSON}
}

// EndpointHealthStatus enumerates the values for endpoint health status.
type EndpointHealthStatus string

const (
	// Dead ...
	Dead EndpointHealthStatus = "dead"
	// Healthy ...
	Healthy EndpointHealthStatus = "healthy"
	// Unhealthy ...
	Unhealthy EndpointHealthStatus = "unhealthy"
	// Unknown ...
	Unknown EndpointHealthStatus = "unknown"
)

// PossibleEndpointHealthStatusValues returns an array of possible values for the EndpointHealthStatus const type.
func PossibleEndpointHealthStatusValues() []EndpointHealthStatus {
	return []EndpointHealthStatus{Dead, Healthy, Unhealthy, Unknown}
}

// IotHubNameUnavailabilityReason enumerates the values for iot hub name unavailability reason.
type IotHubNameUnavailabilityReason string

const (
	// AlreadyExists ...
	AlreadyExists IotHubNameUnavailabilityReason = "AlreadyExists"
	// Invalid ...
	Invalid IotHubNameUnavailabilityReason = "Invalid"
)

// PossibleIotHubNameUnavailabilityReasonValues returns an array of possible values for the IotHubNameUnavailabilityReason const type.
func PossibleIotHubNameUnavailabilityReasonValues() []IotHubNameUnavailabilityReason {
	return []IotHubNameUnavailabilityReason{AlreadyExists, Invalid}
}

// IotHubReplicaRoleType enumerates the values for iot hub replica role type.
type IotHubReplicaRoleType string

const (
	// Primary ...
	Primary IotHubReplicaRoleType = "primary"
	// Secondary ...
	Secondary IotHubReplicaRoleType = "secondary"
)

// PossibleIotHubReplicaRoleTypeValues returns an array of possible values for the IotHubReplicaRoleType const type.
func PossibleIotHubReplicaRoleTypeValues() []IotHubReplicaRoleType {
	return []IotHubReplicaRoleType{Primary, Secondary}
}

// IotHubScaleType enumerates the values for iot hub scale type.
type IotHubScaleType string

const (
	// IotHubScaleTypeAutomatic ...
	IotHubScaleTypeAutomatic IotHubScaleType = "Automatic"
	// IotHubScaleTypeManual ...
	IotHubScaleTypeManual IotHubScaleType = "Manual"
	// IotHubScaleTypeNone ...
	IotHubScaleTypeNone IotHubScaleType = "None"
)

// PossibleIotHubScaleTypeValues returns an array of possible values for the IotHubScaleType const type.
func PossibleIotHubScaleTypeValues() []IotHubScaleType {
	return []IotHubScaleType{IotHubScaleTypeAutomatic, IotHubScaleTypeManual, IotHubScaleTypeNone}
}

// IotHubSku enumerates the values for iot hub sku.
type IotHubSku string

const (
	// B1 ...
	B1 IotHubSku = "B1"
	// B2 ...
	B2 IotHubSku = "B2"
	// B3 ...
	B3 IotHubSku = "B3"
	// F1 ...
	F1 IotHubSku = "F1"
	// S1 ...
	S1 IotHubSku = "S1"
	// S2 ...
	S2 IotHubSku = "S2"
	// S3 ...
	S3 IotHubSku = "S3"
)

// PossibleIotHubSkuValues returns an array of possible values for the IotHubSku const type.
func PossibleIotHubSkuValues() []IotHubSku {
	return []IotHubSku{B1, B2, B3, F1, S1, S2, S3}
}

// IotHubSkuTier enumerates the values for iot hub sku tier.
type IotHubSkuTier string

const (
	// Basic ...
	Basic IotHubSkuTier = "Basic"
	// Free ...
	Free IotHubSkuTier = "Free"
	// Standard ...
	Standard IotHubSkuTier = "Standard"
)

// PossibleIotHubSkuTierValues returns an array of possible values for the IotHubSkuTier const type.
func PossibleIotHubSkuTierValues() []IotHubSkuTier {
	return []IotHubSkuTier{Basic, Free, Standard}
}

// IPFilterActionType enumerates the values for ip filter action type.
type IPFilterActionType string

const (
	// Accept ...
	Accept IPFilterActionType = "Accept"
	// Reject ...
	Reject IPFilterActionType = "Reject"
)

// PossibleIPFilterActionTypeValues returns an array of possible values for the IPFilterActionType const type.
func PossibleIPFilterActionTypeValues() []IPFilterActionType {
	return []IPFilterActionType{Accept, Reject}
}

// JobStatus enumerates the values for job status.
type JobStatus string

const (
	// JobStatusCancelled ...
	JobStatusCancelled JobStatus = "cancelled"
	// JobStatusCompleted ...
	JobStatusCompleted JobStatus = "completed"
	// JobStatusEnqueued ...
	JobStatusEnqueued JobStatus = "enqueued"
	// JobStatusFailed ...
	JobStatusFailed JobStatus = "failed"
	// JobStatusRunning ...
	JobStatusRunning JobStatus = "running"
	// JobStatusUnknown ...
	JobStatusUnknown JobStatus = "unknown"
)

// PossibleJobStatusValues returns an array of possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{JobStatusCancelled, JobStatusCompleted, JobStatusEnqueued, JobStatusFailed, JobStatusRunning, JobStatusUnknown}
}

// JobType enumerates the values for job type.
type JobType string

const (
	// JobTypeBackup ...
	JobTypeBackup JobType = "backup"
	// JobTypeExport ...
	JobTypeExport JobType = "export"
	// JobTypeFactoryResetDevice ...
	JobTypeFactoryResetDevice JobType = "factoryResetDevice"
	// JobTypeFirmwareUpdate ...
	JobTypeFirmwareUpdate JobType = "firmwareUpdate"
	// JobTypeImport ...
	JobTypeImport JobType = "import"
	// JobTypeReadDeviceProperties ...
	JobTypeReadDeviceProperties JobType = "readDeviceProperties"
	// JobTypeRebootDevice ...
	JobTypeRebootDevice JobType = "rebootDevice"
	// JobTypeUnknown ...
	JobTypeUnknown JobType = "unknown"
	// JobTypeUpdateDeviceConfiguration ...
	JobTypeUpdateDeviceConfiguration JobType = "updateDeviceConfiguration"
	// JobTypeWriteDeviceProperties ...
	JobTypeWriteDeviceProperties JobType = "writeDeviceProperties"
)

// PossibleJobTypeValues returns an array of possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{JobTypeBackup, JobTypeExport, JobTypeFactoryResetDevice, JobTypeFirmwareUpdate, JobTypeImport, JobTypeReadDeviceProperties, JobTypeRebootDevice, JobTypeUnknown, JobTypeUpdateDeviceConfiguration, JobTypeWriteDeviceProperties}
}

// RouteErrorSeverity enumerates the values for route error severity.
type RouteErrorSeverity string

const (
	// Error ...
	Error RouteErrorSeverity = "error"
	// Warning ...
	Warning RouteErrorSeverity = "warning"
)

// PossibleRouteErrorSeverityValues returns an array of possible values for the RouteErrorSeverity const type.
func PossibleRouteErrorSeverityValues() []RouteErrorSeverity {
	return []RouteErrorSeverity{Error, Warning}
}

// RoutingSource enumerates the values for routing source.
type RoutingSource string

const (
	// RoutingSourceDeviceJobLifecycleEvents ...
	RoutingSourceDeviceJobLifecycleEvents RoutingSource = "DeviceJobLifecycleEvents"
	// RoutingSourceDeviceLifecycleEvents ...
	RoutingSourceDeviceLifecycleEvents RoutingSource = "DeviceLifecycleEvents"
	// RoutingSourceDeviceMessages ...
	RoutingSourceDeviceMessages RoutingSource = "DeviceMessages"
	// RoutingSourceInvalid ...
	RoutingSourceInvalid RoutingSource = "Invalid"
	// RoutingSourceTwinChangeEvents ...
	RoutingSourceTwinChangeEvents RoutingSource = "TwinChangeEvents"
)

// PossibleRoutingSourceValues returns an array of possible values for the RoutingSource const type.
func PossibleRoutingSourceValues() []RoutingSource {
	return []RoutingSource{RoutingSourceDeviceJobLifecycleEvents, RoutingSourceDeviceLifecycleEvents, RoutingSourceDeviceMessages, RoutingSourceInvalid, RoutingSourceTwinChangeEvents}
}

// TestResultStatus enumerates the values for test result status.
type TestResultStatus string

const (
	// False ...
	False TestResultStatus = "false"
	// True ...
	True TestResultStatus = "true"
	// Undefined ...
	Undefined TestResultStatus = "undefined"
)

// PossibleTestResultStatusValues returns an array of possible values for the TestResultStatus const type.
func PossibleTestResultStatusValues() []TestResultStatus {
	return []TestResultStatus{False, True, Undefined}
}

// CertificateBodyDescription the JSON-serialized X509 Certificate.
type CertificateBodyDescription struct {
	// Certificate - base-64 representation of the X509 leaf certificate .cer file or just .pem file content.
	Certificate *string `json:"certificate,omitempty"`
}

// CertificateDescription the X509 Certificate.
type CertificateDescription struct {
	autorest.Response `json:"-"`
	Properties        *CertificateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the certificate.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; The entity tag.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// CertificateListDescription the JSON-serialized array of Certificate objects.
type CertificateListDescription struct {
	autorest.Response `json:"-"`
	// Value - The array of Certificate objects.
	Value *[]CertificateDescription `json:"value,omitempty"`
}

// CertificateProperties the description of an X509 CA Certificate.
type CertificateProperties struct {
	// Subject - READ-ONLY; The certificate's subject name.
	Subject *string `json:"subject,omitempty"`
	// Expiry - READ-ONLY; The certificate's expiration date and time.
	Expiry *date.TimeRFC1123 `json:"expiry,omitempty"`
	// Thumbprint - READ-ONLY; The certificate's thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// IsVerified - READ-ONLY; Determines whether certificate has been verified.
	IsVerified *bool `json:"isVerified,omitempty"`
	// Created - READ-ONLY; The certificate's create date and time.
	Created *date.TimeRFC1123 `json:"created,omitempty"`
	// Updated - READ-ONLY; The certificate's last update date and time.
	Updated *date.TimeRFC1123 `json:"updated,omitempty"`
	// Certificate - The certificate content
	Certificate *string `json:"certificate,omitempty"`
}

// CertificatePropertiesWithNonce the description of an X509 CA Certificate including the challenge nonce
// issued for the Proof-Of-Possession flow.
type CertificatePropertiesWithNonce struct {
	// Subject - READ-ONLY; The certificate's subject name.
	Subject *string `json:"subject,omitempty"`
	// Expiry - READ-ONLY; The certificate's expiration date and time.
	Expiry *date.TimeRFC1123 `json:"expiry,omitempty"`
	// Thumbprint - READ-ONLY; The certificate's thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// IsVerified - READ-ONLY; Determines whether certificate has been verified.
	IsVerified *bool `json:"isVerified,omitempty"`
	// Created - READ-ONLY; The certificate's create date and time.
	Created *date.TimeRFC1123 `json:"created,omitempty"`
	// Updated - READ-ONLY; The certificate's last update date and time.
	Updated *date.TimeRFC1123 `json:"updated,omitempty"`
	// VerificationCode - READ-ONLY; The certificate's verification code that will be used for proof of possession.
	VerificationCode *string `json:"verificationCode,omitempty"`
	// Certificate - READ-ONLY; The certificate content
	Certificate *string `json:"certificate,omitempty"`
}

// CertificateVerificationDescription the JSON-serialized leaf certificate
type CertificateVerificationDescription struct {
	// Certificate - base-64 representation of X509 certificate .cer file or just .pem file content.
	Certificate *string `json:"certificate,omitempty"`
}

// CertificateWithNonceDescription the X509 Certificate.
type CertificateWithNonceDescription struct {
	autorest.Response `json:"-"`
	Properties        *CertificatePropertiesWithNonce `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the certificate.
	Name *string `json:"name,omitempty"`
	// Etag - READ-ONLY; The entity tag.
	Etag *string `json:"etag,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// CloudToDeviceProperties the IoT hub cloud-to-device messaging properties.
type CloudToDeviceProperties struct {
	// MaxDeliveryCount - The max delivery count for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
	MaxDeliveryCount *int32 `json:"maxDeliveryCount,omitempty"`
	// DefaultTTLAsIso8601 - The default time to live for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
	DefaultTTLAsIso8601 *string             `json:"defaultTtlAsIso8601,omitempty"`
	Feedback            *FeedbackProperties `json:"feedback,omitempty"`
}

// EndpointHealthData the health data for an endpoint
type EndpointHealthData struct {
	// EndpointID - Id of the endpoint
	EndpointID *string `json:"endpointId,omitempty"`
	// HealthStatus - Health statuses have following meanings. The 'healthy' status shows that the endpoint is accepting messages as expected. The 'unhealthy' status shows that the endpoint is not accepting messages as expected and IoT Hub is retrying to send data to this endpoint. The status of an unhealthy endpoint will be updated to healthy when IoT Hub has established an eventually consistent state of health. The 'dead' status shows that the endpoint is not accepting messages, after IoT Hub retried sending messages for the retrial period. See IoT Hub metrics to identify errors and monitor issues with endpoints. The 'unknown' status shows that the IoT Hub has not established a connection with the endpoint. No messages have been delivered to or rejected from this endpoint. Possible values include: 'Unknown', 'Healthy', 'Unhealthy', 'Dead'
	HealthStatus EndpointHealthStatus `json:"healthStatus,omitempty"`
}

// EndpointHealthDataListResult the JSON-serialized array of EndpointHealthData objects with a next link.
type EndpointHealthDataListResult struct {
	autorest.Response `json:"-"`
	// Value - JSON-serialized array of Endpoint health data
	Value *[]EndpointHealthData `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to more results
	NextLink *string `json:"nextLink,omitempty"`
}

// EndpointHealthDataListResultIterator provides access to a complete listing of EndpointHealthData values.
type EndpointHealthDataListResultIterator struct {
	i    int
	page EndpointHealthDataListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EndpointHealthDataListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointHealthDataListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EndpointHealthDataListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EndpointHealthDataListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EndpointHealthDataListResultIterator) Response() EndpointHealthDataListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EndpointHealthDataListResultIterator) Value() EndpointHealthData {
	if !iter.page.NotDone() {
		return EndpointHealthData{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EndpointHealthDataListResultIterator type.
func NewEndpointHealthDataListResultIterator(page EndpointHealthDataListResultPage) EndpointHealthDataListResultIterator {
	return EndpointHealthDataListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ehdlr EndpointHealthDataListResult) IsEmpty() bool {
	return ehdlr.Value == nil || len(*ehdlr.Value) == 0
}

// endpointHealthDataListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ehdlr EndpointHealthDataListResult) endpointHealthDataListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ehdlr.NextLink == nil || len(to.String(ehdlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ehdlr.NextLink)))
}

// EndpointHealthDataListResultPage contains a page of EndpointHealthData values.
type EndpointHealthDataListResultPage struct {
	fn    func(context.Context, EndpointHealthDataListResult) (EndpointHealthDataListResult, error)
	ehdlr EndpointHealthDataListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EndpointHealthDataListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointHealthDataListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ehdlr)
	if err != nil {
		return err
	}
	page.ehdlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EndpointHealthDataListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EndpointHealthDataListResultPage) NotDone() bool {
	return !page.ehdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EndpointHealthDataListResultPage) Response() EndpointHealthDataListResult {
	return page.ehdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EndpointHealthDataListResultPage) Values() []EndpointHealthData {
	if page.ehdlr.IsEmpty() {
		return nil
	}
	return *page.ehdlr.Value
}

// Creates a new instance of the EndpointHealthDataListResultPage type.
func NewEndpointHealthDataListResultPage(getNextPage func(context.Context, EndpointHealthDataListResult) (EndpointHealthDataListResult, error)) EndpointHealthDataListResultPage {
	return EndpointHealthDataListResultPage{fn: getNextPage}
}

// ErrorDetails error details.
type ErrorDetails struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// HTTPStatusCode - READ-ONLY; The HTTP status code.
	HTTPStatusCode *string `json:"httpStatusCode,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *string `json:"details,omitempty"`
}

// EventHubConsumerGroupInfo the properties of the EventHubConsumerGroupInfo object.
type EventHubConsumerGroupInfo struct {
	autorest.Response `json:"-"`
	// Properties - The tags.
	Properties map[string]*string `json:"properties"`
	// ID - READ-ONLY; The Event Hub-compatible consumer group identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The Event Hub-compatible consumer group name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; the resource type.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; The etag.
	Etag *string `json:"etag,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubConsumerGroupInfo.
func (ehcgi EventHubConsumerGroupInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ehcgi.Properties != nil {
		objectMap["properties"] = ehcgi.Properties
	}
	return json.Marshal(objectMap)
}

// EventHubConsumerGroupsListResult the JSON-serialized array of Event Hub-compatible consumer group names
// with a next link.
type EventHubConsumerGroupsListResult struct {
	autorest.Response `json:"-"`
	// Value - List of consumer groups objects
	Value *[]EventHubConsumerGroupInfo `json:"value,omitempty"`
	// NextLink - READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// EventHubConsumerGroupsListResultIterator provides access to a complete listing of
// EventHubConsumerGroupInfo values.
type EventHubConsumerGroupsListResultIterator struct {
	i    int
	page EventHubConsumerGroupsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EventHubConsumerGroupsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventHubConsumerGroupsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EventHubConsumerGroupsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EventHubConsumerGroupsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EventHubConsumerGroupsListResultIterator) Response() EventHubConsumerGroupsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EventHubConsumerGroupsListResultIterator) Value() EventHubConsumerGroupInfo {
	if !iter.page.NotDone() {
		return EventHubConsumerGroupInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EventHubConsumerGroupsListResultIterator type.
func NewEventHubConsumerGroupsListResultIterator(page EventHubConsumerGroupsListResultPage) EventHubConsumerGroupsListResultIterator {
	return EventHubConsumerGroupsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ehcglr EventHubConsumerGroupsListResult) IsEmpty() bool {
	return ehcglr.Value == nil || len(*ehcglr.Value) == 0
}

// eventHubConsumerGroupsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ehcglr EventHubConsumerGroupsListResult) eventHubConsumerGroupsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ehcglr.NextLink == nil || len(to.String(ehcglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ehcglr.NextLink)))
}

// EventHubConsumerGroupsListResultPage contains a page of EventHubConsumerGroupInfo values.
type EventHubConsumerGroupsListResultPage struct {
	fn     func(context.Context, EventHubConsumerGroupsListResult) (EventHubConsumerGroupsListResult, error)
	ehcglr EventHubConsumerGroupsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EventHubConsumerGroupsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventHubConsumerGroupsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ehcglr)
	if err != nil {
		return err
	}
	page.ehcglr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EventHubConsumerGroupsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EventHubConsumerGroupsListResultPage) NotDone() bool {
	return !page.ehcglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EventHubConsumerGroupsListResultPage) Response() EventHubConsumerGroupsListResult {
	return page.ehcglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EventHubConsumerGroupsListResultPage) Values() []EventHubConsumerGroupInfo {
	if page.ehcglr.IsEmpty() {
		return nil
	}
	return *page.ehcglr.Value
}

// Creates a new instance of the EventHubConsumerGroupsListResultPage type.
func NewEventHubConsumerGroupsListResultPage(getNextPage func(context.Context, EventHubConsumerGroupsListResult) (EventHubConsumerGroupsListResult, error)) EventHubConsumerGroupsListResultPage {
	return EventHubConsumerGroupsListResultPage{fn: getNextPage}
}

// EventHubProperties the properties of the provisioned Event Hub-compatible endpoint used by the IoT hub.
type EventHubProperties struct {
	// RetentionTimeInDays - The retention time for device-to-cloud messages in days. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages
	RetentionTimeInDays *int64 `json:"retentionTimeInDays,omitempty"`
	// PartitionCount - The number of partitions for receiving device-to-cloud messages in the Event Hub-compatible endpoint. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
	PartitionCount *int32 `json:"partitionCount,omitempty"`
	// PartitionIds - READ-ONLY; The partition ids in the Event Hub-compatible endpoint.
	PartitionIds *[]string `json:"partitionIds,omitempty"`
	// Path - READ-ONLY; The Event Hub-compatible name.
	Path *string `json:"path,omitempty"`
	// Endpoint - READ-ONLY; The Event Hub-compatible endpoint.
	Endpoint *string `json:"endpoint,omitempty"`
}

// ExportDevicesRequest use to provide parameters when requesting an export of all devices in the IoT hub.
type ExportDevicesRequest struct {
	// ExportBlobContainerURI - The export blob container URI.
	ExportBlobContainerURI *string `json:"exportBlobContainerUri,omitempty"`
	// ExcludeKeys - The value indicating whether keys should be excluded during export.
	ExcludeKeys *bool `json:"excludeKeys,omitempty"`
}

// FallbackRouteProperties the properties of the fallback route. IoT Hub uses these properties when it
// routes messages to the fallback endpoint.
type FallbackRouteProperties struct {
	// Name - The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
	Name *string `json:"name,omitempty"`
	// Source - The source to which the routing rule is to be applied to. For example, DeviceMessages
	Source *string `json:"source,omitempty"`
	// Condition - The condition which is evaluated in order to apply the fallback route. If the condition is not provided it will evaluate to true by default. For grammar, See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
	Condition *string `json:"condition,omitempty"`
	// EndpointNames - The list of endpoints to which the messages that satisfy the condition are routed to. Currently only 1 endpoint is allowed.
	EndpointNames *[]string `json:"endpointNames,omitempty"`
	// IsEnabled - Used to specify whether the fallback route is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// FeedbackProperties the properties of the feedback queue for cloud-to-device messages.
type FeedbackProperties struct {
	// LockDurationAsIso8601 - The lock duration for the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
	LockDurationAsIso8601 *string `json:"lockDurationAsIso8601,omitempty"`
	// TTLAsIso8601 - The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
	TTLAsIso8601 *string `json:"ttlAsIso8601,omitempty"`
	// MaxDeliveryCount - The number of times the IoT hub attempts to deliver a message on the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
	MaxDeliveryCount *int32 `json:"maxDeliveryCount,omitempty"`
}

// ImportDevicesRequest use to provide parameters when requesting an import of all devices in the hub.
type ImportDevicesRequest struct {
	// InputBlobContainerURI - The input blob container URI.
	InputBlobContainerURI *string `json:"inputBlobContainerUri,omitempty"`
	// OutputBlobContainerURI - The output blob container URI.
	OutputBlobContainerURI *string `json:"outputBlobContainerUri,omitempty"`
}

// IotHubCapacity ioT Hub capacity information.
type IotHubCapacity struct {
	// Minimum - READ-ONLY; The minimum number of units.
	Minimum *int64 `json:"minimum,omitempty"`
	// Maximum - READ-ONLY; The maximum number of units.
	Maximum *int64 `json:"maximum,omitempty"`
	// Default - READ-ONLY; The default number of units.
	Default *int64 `json:"default,omitempty"`
	// ScaleType - READ-ONLY; The type of the scaling enabled. Possible values include: 'IotHubScaleTypeAutomatic', 'IotHubScaleTypeManual', 'IotHubScaleTypeNone'
	ScaleType IotHubScaleType `json:"scaleType,omitempty"`
}

// IotHubDescription the description of the IoT hub.
type IotHubDescription struct {
	autorest.Response `json:"-"`
	// Etag - The Etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal ETag convention.
	Etag *string `json:"etag,omitempty"`
	// Properties - IotHub properties
	Properties *IotHubProperties `json:"properties,omitempty"`
	// Sku - IotHub SKU info
	Sku *IotHubSkuInfo `json:"sku,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IotHubDescription.
func (ihd IotHubDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ihd.Etag != nil {
		objectMap["etag"] = ihd.Etag
	}
	if ihd.Properties != nil {
		objectMap["properties"] = ihd.Properties
	}
	if ihd.Sku != nil {
		objectMap["sku"] = ihd.Sku
	}
	if ihd.Location != nil {
		objectMap["location"] = ihd.Location
	}
	if ihd.Tags != nil {
		objectMap["tags"] = ihd.Tags
	}
	return json.Marshal(objectMap)
}

// IotHubDescriptionListResult the JSON-serialized array of IotHubDescription objects with a next link.
type IotHubDescriptionListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of IotHubDescription objects.
	Value *[]IotHubDescription `json:"value,omitempty"`
	// NextLink - READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// IotHubDescriptionListResultIterator provides access to a complete listing of IotHubDescription values.
type IotHubDescriptionListResultIterator struct {
	i    int
	page IotHubDescriptionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IotHubDescriptionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotHubDescriptionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IotHubDescriptionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IotHubDescriptionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IotHubDescriptionListResultIterator) Response() IotHubDescriptionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IotHubDescriptionListResultIterator) Value() IotHubDescription {
	if !iter.page.NotDone() {
		return IotHubDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IotHubDescriptionListResultIterator type.
func NewIotHubDescriptionListResultIterator(page IotHubDescriptionListResultPage) IotHubDescriptionListResultIterator {
	return IotHubDescriptionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ihdlr IotHubDescriptionListResult) IsEmpty() bool {
	return ihdlr.Value == nil || len(*ihdlr.Value) == 0
}

// iotHubDescriptionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ihdlr IotHubDescriptionListResult) iotHubDescriptionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ihdlr.NextLink == nil || len(to.String(ihdlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ihdlr.NextLink)))
}

// IotHubDescriptionListResultPage contains a page of IotHubDescription values.
type IotHubDescriptionListResultPage struct {
	fn    func(context.Context, IotHubDescriptionListResult) (IotHubDescriptionListResult, error)
	ihdlr IotHubDescriptionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IotHubDescriptionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotHubDescriptionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ihdlr)
	if err != nil {
		return err
	}
	page.ihdlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IotHubDescriptionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IotHubDescriptionListResultPage) NotDone() bool {
	return !page.ihdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IotHubDescriptionListResultPage) Response() IotHubDescriptionListResult {
	return page.ihdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IotHubDescriptionListResultPage) Values() []IotHubDescription {
	if page.ihdlr.IsEmpty() {
		return nil
	}
	return *page.ihdlr.Value
}

// Creates a new instance of the IotHubDescriptionListResultPage type.
func NewIotHubDescriptionListResultPage(getNextPage func(context.Context, IotHubDescriptionListResult) (IotHubDescriptionListResult, error)) IotHubDescriptionListResultPage {
	return IotHubDescriptionListResultPage{fn: getNextPage}
}

// IotHubLocationDescription public representation of one of the locations where a resource is provisioned.
type IotHubLocationDescription struct {
	// Location - Azure Geo Regions
	Location *string `json:"location,omitempty"`
	// Role - Specific Role assigned to this location. Possible values include: 'Primary', 'Secondary'
	Role IotHubReplicaRoleType `json:"role,omitempty"`
}

// IotHubNameAvailabilityInfo the properties indicating whether a given IoT hub name is available.
type IotHubNameAvailabilityInfo struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; The value which indicates whether the provided name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - READ-ONLY; The reason for unavailability. Possible values include: 'Invalid', 'AlreadyExists'
	Reason IotHubNameUnavailabilityReason `json:"reason,omitempty"`
	// Message - The detailed reason message.
	Message *string `json:"message,omitempty"`
}

// IotHubProperties the properties of an IoT hub.
type IotHubProperties struct {
	// AuthorizationPolicies - The shared access policies you can use to secure a connection to the IoT hub.
	AuthorizationPolicies *[]SharedAccessSignatureAuthorizationRule `json:"authorizationPolicies,omitempty"`
	// IPFilterRules - The IP filter rules.
	IPFilterRules *[]IPFilterRule `json:"ipFilterRules,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// State - READ-ONLY; The hub state.
	State *string `json:"state,omitempty"`
	// HostName - READ-ONLY; The name of the host.
	HostName *string `json:"hostName,omitempty"`
	// EventHubEndpoints - The Event Hub-compatible endpoint properties. The only possible keys to this dictionary is events. This key has to be present in the dictionary while making create or update calls for the IoT hub.
	EventHubEndpoints map[string]*EventHubProperties `json:"eventHubEndpoints"`
	Routing           *RoutingProperties             `json:"routing,omitempty"`
	// StorageEndpoints - The list of Azure Storage endpoints where you can upload files. Currently you can configure only one Azure Storage account and that MUST have its key as $default. Specifying more than one storage account causes an error to be thrown. Not specifying a value for this property when the enableFileUploadNotifications property is set to True, causes an error to be thrown.
	StorageEndpoints map[string]*StorageEndpointProperties `json:"storageEndpoints"`
	// MessagingEndpoints - The messaging endpoint properties for the file upload notification queue.
	MessagingEndpoints map[string]*MessagingEndpointProperties `json:"messagingEndpoints"`
	// EnableFileUploadNotifications - If True, file upload notifications are enabled.
	EnableFileUploadNotifications *bool                    `json:"enableFileUploadNotifications,omitempty"`
	CloudToDevice                 *CloudToDeviceProperties `json:"cloudToDevice,omitempty"`
	// Comments - IoT hub comments.
	Comments *string `json:"comments,omitempty"`
	// DeviceStreams - The device streams properties of iothub.
	DeviceStreams *IotHubPropertiesDeviceStreams `json:"deviceStreams,omitempty"`
	// Features - The capabilities and features enabled for the IoT hub. Possible values include: 'None', 'DeviceManagement'
	Features Capabilities `json:"features,omitempty"`
	// Locations - Primary and secondary location for iot hub
	Locations *[]IotHubLocationDescription `json:"locations,omitempty"`
}

// MarshalJSON is the custom marshaler for IotHubProperties.
func (ihp IotHubProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ihp.AuthorizationPolicies != nil {
		objectMap["authorizationPolicies"] = ihp.AuthorizationPolicies
	}
	if ihp.IPFilterRules != nil {
		objectMap["ipFilterRules"] = ihp.IPFilterRules
	}
	if ihp.EventHubEndpoints != nil {
		objectMap["eventHubEndpoints"] = ihp.EventHubEndpoints
	}
	if ihp.Routing != nil {
		objectMap["routing"] = ihp.Routing
	}
	if ihp.StorageEndpoints != nil {
		objectMap["storageEndpoints"] = ihp.StorageEndpoints
	}
	if ihp.MessagingEndpoints != nil {
		objectMap["messagingEndpoints"] = ihp.MessagingEndpoints
	}
	if ihp.EnableFileUploadNotifications != nil {
		objectMap["enableFileUploadNotifications"] = ihp.EnableFileUploadNotifications
	}
	if ihp.CloudToDevice != nil {
		objectMap["cloudToDevice"] = ihp.CloudToDevice
	}
	if ihp.Comments != nil {
		objectMap["comments"] = ihp.Comments
	}
	if ihp.DeviceStreams != nil {
		objectMap["deviceStreams"] = ihp.DeviceStreams
	}
	if ihp.Features != "" {
		objectMap["features"] = ihp.Features
	}
	if ihp.Locations != nil {
		objectMap["locations"] = ihp.Locations
	}
	return json.Marshal(objectMap)
}

// IotHubPropertiesDeviceStreams the device streams properties of iothub.
type IotHubPropertiesDeviceStreams struct {
	// StreamingEndpoints - List of Device Streams Endpoints.
	StreamingEndpoints *[]string `json:"streamingEndpoints,omitempty"`
}

// IotHubQuotaMetricInfo quota metrics properties.
type IotHubQuotaMetricInfo struct {
	// Name - READ-ONLY; The name of the quota metric.
	Name *string `json:"name,omitempty"`
	// CurrentValue - READ-ONLY; The current value for the quota metric.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// MaxValue - READ-ONLY; The maximum value of the quota metric.
	MaxValue *int64 `json:"maxValue,omitempty"`
}

// IotHubQuotaMetricInfoListResult the JSON-serialized array of IotHubQuotaMetricInfo objects with a next
// link.
type IotHubQuotaMetricInfoListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of quota metrics objects.
	Value *[]IotHubQuotaMetricInfo `json:"value,omitempty"`
	// NextLink - READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// IotHubQuotaMetricInfoListResultIterator provides access to a complete listing of IotHubQuotaMetricInfo
// values.
type IotHubQuotaMetricInfoListResultIterator struct {
	i    int
	page IotHubQuotaMetricInfoListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IotHubQuotaMetricInfoListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotHubQuotaMetricInfoListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IotHubQuotaMetricInfoListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IotHubQuotaMetricInfoListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IotHubQuotaMetricInfoListResultIterator) Response() IotHubQuotaMetricInfoListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IotHubQuotaMetricInfoListResultIterator) Value() IotHubQuotaMetricInfo {
	if !iter.page.NotDone() {
		return IotHubQuotaMetricInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IotHubQuotaMetricInfoListResultIterator type.
func NewIotHubQuotaMetricInfoListResultIterator(page IotHubQuotaMetricInfoListResultPage) IotHubQuotaMetricInfoListResultIterator {
	return IotHubQuotaMetricInfoListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ihqmilr IotHubQuotaMetricInfoListResult) IsEmpty() bool {
	return ihqmilr.Value == nil || len(*ihqmilr.Value) == 0
}

// iotHubQuotaMetricInfoListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ihqmilr IotHubQuotaMetricInfoListResult) iotHubQuotaMetricInfoListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ihqmilr.NextLink == nil || len(to.String(ihqmilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ihqmilr.NextLink)))
}

// IotHubQuotaMetricInfoListResultPage contains a page of IotHubQuotaMetricInfo values.
type IotHubQuotaMetricInfoListResultPage struct {
	fn      func(context.Context, IotHubQuotaMetricInfoListResult) (IotHubQuotaMetricInfoListResult, error)
	ihqmilr IotHubQuotaMetricInfoListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IotHubQuotaMetricInfoListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotHubQuotaMetricInfoListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ihqmilr)
	if err != nil {
		return err
	}
	page.ihqmilr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IotHubQuotaMetricInfoListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IotHubQuotaMetricInfoListResultPage) NotDone() bool {
	return !page.ihqmilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IotHubQuotaMetricInfoListResultPage) Response() IotHubQuotaMetricInfoListResult {
	return page.ihqmilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IotHubQuotaMetricInfoListResultPage) Values() []IotHubQuotaMetricInfo {
	if page.ihqmilr.IsEmpty() {
		return nil
	}
	return *page.ihqmilr.Value
}

// Creates a new instance of the IotHubQuotaMetricInfoListResultPage type.
func NewIotHubQuotaMetricInfoListResultPage(getNextPage func(context.Context, IotHubQuotaMetricInfoListResult) (IotHubQuotaMetricInfoListResult, error)) IotHubQuotaMetricInfoListResultPage {
	return IotHubQuotaMetricInfoListResultPage{fn: getNextPage}
}

// IotHubResourceCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type IotHubResourceCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *IotHubResourceCreateOrUpdateFuture) Result(client IotHubResourceClient) (ihd IotHubDescription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("devices.IotHubResourceCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ihd.Response.Response, err = future.GetResult(sender); err == nil && ihd.Response.Response.StatusCode != http.StatusNoContent {
		ihd, err = client.CreateOrUpdateResponder(ihd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "devices.IotHubResourceCreateOrUpdateFuture", "Result", ihd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IotHubResourceDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type IotHubResourceDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *IotHubResourceDeleteFuture) Result(client IotHubResourceClient) (so SetObject, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("devices.IotHubResourceDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if so.Response.Response, err = future.GetResult(sender); err == nil && so.Response.Response.StatusCode != http.StatusNoContent {
		so, err = client.DeleteResponder(so.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "devices.IotHubResourceDeleteFuture", "Result", so.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IotHubResourceUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type IotHubResourceUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *IotHubResourceUpdateFuture) Result(client IotHubResourceClient) (ihd IotHubDescription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("devices.IotHubResourceUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ihd.Response.Response, err = future.GetResult(sender); err == nil && ihd.Response.Response.StatusCode != http.StatusNoContent {
		ihd, err = client.UpdateResponder(ihd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "devices.IotHubResourceUpdateFuture", "Result", ihd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IotHubSkuDescription SKU properties.
type IotHubSkuDescription struct {
	// ResourceType - READ-ONLY; The type of the resource.
	ResourceType *string `json:"resourceType,omitempty"`
	// Sku - The type of the resource.
	Sku *IotHubSkuInfo `json:"sku,omitempty"`
	// Capacity - IotHub capacity
	Capacity *IotHubCapacity `json:"capacity,omitempty"`
}

// IotHubSkuDescriptionListResult the JSON-serialized array of IotHubSkuDescription objects with a next
// link.
type IotHubSkuDescriptionListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of IotHubSkuDescription.
	Value *[]IotHubSkuDescription `json:"value,omitempty"`
	// NextLink - READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// IotHubSkuDescriptionListResultIterator provides access to a complete listing of IotHubSkuDescription
// values.
type IotHubSkuDescriptionListResultIterator struct {
	i    int
	page IotHubSkuDescriptionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IotHubSkuDescriptionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotHubSkuDescriptionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IotHubSkuDescriptionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IotHubSkuDescriptionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IotHubSkuDescriptionListResultIterator) Response() IotHubSkuDescriptionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IotHubSkuDescriptionListResultIterator) Value() IotHubSkuDescription {
	if !iter.page.NotDone() {
		return IotHubSkuDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IotHubSkuDescriptionListResultIterator type.
func NewIotHubSkuDescriptionListResultIterator(page IotHubSkuDescriptionListResultPage) IotHubSkuDescriptionListResultIterator {
	return IotHubSkuDescriptionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ihsdlr IotHubSkuDescriptionListResult) IsEmpty() bool {
	return ihsdlr.Value == nil || len(*ihsdlr.Value) == 0
}

// iotHubSkuDescriptionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ihsdlr IotHubSkuDescriptionListResult) iotHubSkuDescriptionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ihsdlr.NextLink == nil || len(to.String(ihsdlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ihsdlr.NextLink)))
}

// IotHubSkuDescriptionListResultPage contains a page of IotHubSkuDescription values.
type IotHubSkuDescriptionListResultPage struct {
	fn     func(context.Context, IotHubSkuDescriptionListResult) (IotHubSkuDescriptionListResult, error)
	ihsdlr IotHubSkuDescriptionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IotHubSkuDescriptionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotHubSkuDescriptionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ihsdlr)
	if err != nil {
		return err
	}
	page.ihsdlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IotHubSkuDescriptionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IotHubSkuDescriptionListResultPage) NotDone() bool {
	return !page.ihsdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IotHubSkuDescriptionListResultPage) Response() IotHubSkuDescriptionListResult {
	return page.ihsdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IotHubSkuDescriptionListResultPage) Values() []IotHubSkuDescription {
	if page.ihsdlr.IsEmpty() {
		return nil
	}
	return *page.ihsdlr.Value
}

// Creates a new instance of the IotHubSkuDescriptionListResultPage type.
func NewIotHubSkuDescriptionListResultPage(getNextPage func(context.Context, IotHubSkuDescriptionListResult) (IotHubSkuDescriptionListResult, error)) IotHubSkuDescriptionListResultPage {
	return IotHubSkuDescriptionListResultPage{fn: getNextPage}
}

// IotHubSkuInfo information about the SKU of the IoT hub.
type IotHubSkuInfo struct {
	// Name - The name of the SKU. Possible values include: 'F1', 'S1', 'S2', 'S3', 'B1', 'B2', 'B3'
	Name IotHubSku `json:"name,omitempty"`
	// Tier - READ-ONLY; The billing tier for the IoT hub. Possible values include: 'Free', 'Standard', 'Basic'
	Tier IotHubSkuTier `json:"tier,omitempty"`
	// Capacity - The number of provisioned IoT Hub units. See: https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
	Capacity *int64 `json:"capacity,omitempty"`
}

// IPFilterRule the IP filter rules for the IoT hub.
type IPFilterRule struct {
	// FilterName - The name of the IP filter rule.
	FilterName *string `json:"filterName,omitempty"`
	// Action - The desired action for requests captured by this rule. Possible values include: 'Accept', 'Reject'
	Action IPFilterActionType `json:"action,omitempty"`
	// IPMask - A string that contains the IP address range in CIDR notation for the rule.
	IPMask *string `json:"ipMask,omitempty"`
}

// JobResponse the properties of the Job Response object.
type JobResponse struct {
	autorest.Response `json:"-"`
	// JobID - READ-ONLY; The job identifier.
	JobID *string `json:"jobId,omitempty"`
	// StartTimeUtc - READ-ONLY; The start time of the job.
	StartTimeUtc *date.TimeRFC1123 `json:"startTimeUtc,omitempty"`
	// EndTimeUtc - READ-ONLY; The time the job stopped processing.
	EndTimeUtc *date.TimeRFC1123 `json:"endTimeUtc,omitempty"`
	// Type - READ-ONLY; The type of the job. Possible values include: 'JobTypeUnknown', 'JobTypeExport', 'JobTypeImport', 'JobTypeBackup', 'JobTypeReadDeviceProperties', 'JobTypeWriteDeviceProperties', 'JobTypeUpdateDeviceConfiguration', 'JobTypeRebootDevice', 'JobTypeFactoryResetDevice', 'JobTypeFirmwareUpdate'
	Type JobType `json:"type,omitempty"`
	// Status - READ-ONLY; The status of the job. Possible values include: 'JobStatusUnknown', 'JobStatusEnqueued', 'JobStatusRunning', 'JobStatusCompleted', 'JobStatusFailed', 'JobStatusCancelled'
	Status JobStatus `json:"status,omitempty"`
	// FailureReason - READ-ONLY; If status == failed, this string containing the reason for the failure.
	FailureReason *string `json:"failureReason,omitempty"`
	// StatusMessage - READ-ONLY; The status message for the job.
	StatusMessage *string `json:"statusMessage,omitempty"`
	// ParentJobID - READ-ONLY; The job identifier of the parent job, if any.
	ParentJobID *string `json:"parentJobId,omitempty"`
}

// JobResponseListResult the JSON-serialized array of JobResponse objects with a next link.
type JobResponseListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of JobResponse objects.
	Value *[]JobResponse `json:"value,omitempty"`
	// NextLink - READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobResponseListResultIterator provides access to a complete listing of JobResponse values.
type JobResponseListResultIterator struct {
	i    int
	page JobResponseListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobResponseListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobResponseListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobResponseListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobResponseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobResponseListResultIterator) Response() JobResponseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobResponseListResultIterator) Value() JobResponse {
	if !iter.page.NotDone() {
		return JobResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobResponseListResultIterator type.
func NewJobResponseListResultIterator(page JobResponseListResultPage) JobResponseListResultIterator {
	return JobResponseListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jrlr JobResponseListResult) IsEmpty() bool {
	return jrlr.Value == nil || len(*jrlr.Value) == 0
}

// jobResponseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jrlr JobResponseListResult) jobResponseListResultPreparer(ctx context.Context) (*http.Request, error) {
	if jrlr.NextLink == nil || len(to.String(jrlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jrlr.NextLink)))
}

// JobResponseListResultPage contains a page of JobResponse values.
type JobResponseListResultPage struct {
	fn   func(context.Context, JobResponseListResult) (JobResponseListResult, error)
	jrlr JobResponseListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobResponseListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobResponseListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jrlr)
	if err != nil {
		return err
	}
	page.jrlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobResponseListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobResponseListResultPage) NotDone() bool {
	return !page.jrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobResponseListResultPage) Response() JobResponseListResult {
	return page.jrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobResponseListResultPage) Values() []JobResponse {
	if page.jrlr.IsEmpty() {
		return nil
	}
	return *page.jrlr.Value
}

// Creates a new instance of the JobResponseListResultPage type.
func NewJobResponseListResultPage(getNextPage func(context.Context, JobResponseListResult) (JobResponseListResult, error)) JobResponseListResultPage {
	return JobResponseListResultPage{fn: getNextPage}
}

// MatchedRoute routes that matched
type MatchedRoute struct {
	// Properties - Properties of routes that matched
	Properties *RouteProperties `json:"properties,omitempty"`
}

// MessagingEndpointProperties the properties of the messaging endpoints used by this IoT hub.
type MessagingEndpointProperties struct {
	// LockDurationAsIso8601 - The lock duration. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
	LockDurationAsIso8601 *string `json:"lockDurationAsIso8601,omitempty"`
	// TTLAsIso8601 - The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
	TTLAsIso8601 *string `json:"ttlAsIso8601,omitempty"`
	// MaxDeliveryCount - The number of times the IoT hub attempts to deliver a message. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
	MaxDeliveryCount *int32 `json:"maxDeliveryCount,omitempty"`
}

// Name name of Iot Hub type
type Name struct {
	// Value - IotHub type
	Value *string `json:"value,omitempty"`
	// LocalizedValue - Localized value of name
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// Operation ioT Hub REST API operation
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{read | write | action | delete}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Service provider: Microsoft Devices
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource Type: IotHubs
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Name of the operation
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; Description of the operation
	Description *string `json:"description,omitempty"`
}

// OperationInputs input values.
type OperationInputs struct {
	// Name - The name of the IoT hub to check.
	Name *string `json:"name,omitempty"`
}

// OperationListResult result of the request to list IoT Hub operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of IoT Hub operations supported by the Microsoft.Devices resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// RegistryStatistics identity registry statistics.
type RegistryStatistics struct {
	autorest.Response `json:"-"`
	// TotalDeviceCount - READ-ONLY; The total count of devices in the identity registry.
	TotalDeviceCount *int64 `json:"totalDeviceCount,omitempty"`
	// EnabledDeviceCount - READ-ONLY; The count of enabled devices in the identity registry.
	EnabledDeviceCount *int64 `json:"enabledDeviceCount,omitempty"`
	// DisabledDeviceCount - READ-ONLY; The count of disabled devices in the identity registry.
	DisabledDeviceCount *int64 `json:"disabledDeviceCount,omitempty"`
}

// Resource the common properties of an Azure resource.
type Resource struct {
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// RouteCompilationError compilation error when evaluating route
type RouteCompilationError struct {
	// Message - Route error message
	Message *string `json:"message,omitempty"`
	// Severity - Severity of the route error. Possible values include: 'Error', 'Warning'
	Severity RouteErrorSeverity `json:"severity,omitempty"`
	// Location - Location where the route error happened
	Location *RouteErrorRange `json:"location,omitempty"`
}

// RouteErrorPosition position where the route error happened
type RouteErrorPosition struct {
	// Line - Line where the route error happened
	Line *int32 `json:"line,omitempty"`
	// Column - Column where the route error happened
	Column *int32 `json:"column,omitempty"`
}

// RouteErrorRange range of route errors
type RouteErrorRange struct {
	// Start - Start where the route error happened
	Start *RouteErrorPosition `json:"start,omitempty"`
	// End - End where the route error happened
	End *RouteErrorPosition `json:"end,omitempty"`
}

// RouteProperties the properties of a routing rule that your IoT hub uses to route messages to endpoints.
type RouteProperties struct {
	// Name - The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
	Name *string `json:"name,omitempty"`
	// Source - The source that the routing rule is to be applied to, such as DeviceMessages. Possible values include: 'RoutingSourceInvalid', 'RoutingSourceDeviceMessages', 'RoutingSourceTwinChangeEvents', 'RoutingSourceDeviceLifecycleEvents', 'RoutingSourceDeviceJobLifecycleEvents'
	Source RoutingSource `json:"source,omitempty"`
	// Condition - The condition that is evaluated to apply the routing rule. If no condition is provided, it evaluates to true by default. For grammar, see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
	Condition *string `json:"condition,omitempty"`
	// EndpointNames - The list of endpoints to which messages that satisfy the condition are routed. Currently only one endpoint is allowed.
	EndpointNames *[]string `json:"endpointNames,omitempty"`
	// IsEnabled - Used to specify whether a route is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// RoutingEndpoints the properties related to the custom endpoints to which your IoT hub routes messages
// based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for
// paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
type RoutingEndpoints struct {
	// ServiceBusQueues - The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
	ServiceBusQueues *[]RoutingServiceBusQueueEndpointProperties `json:"serviceBusQueues,omitempty"`
	// ServiceBusTopics - The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
	ServiceBusTopics *[]RoutingServiceBusTopicEndpointProperties `json:"serviceBusTopics,omitempty"`
	// EventHubs - The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
	EventHubs *[]RoutingEventHubProperties `json:"eventHubs,omitempty"`
	// StorageContainers - The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
	StorageContainers *[]RoutingStorageContainerProperties `json:"storageContainers,omitempty"`
}

// RoutingEventHubProperties the properties related to an event hub endpoint.
type RoutingEventHubProperties struct {
	// ConnectionString - The connection string of the event hub endpoint.
	ConnectionString *string `json:"connectionString,omitempty"`
	// Name - The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
	Name *string `json:"name,omitempty"`
	// SubscriptionID - The subscription identifier of the event hub endpoint.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - The name of the resource group of the event hub endpoint.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
}

// RoutingMessage routing message
type RoutingMessage struct {
	// Body - Body of routing message
	Body *string `json:"body,omitempty"`
	// AppProperties - App properties
	AppProperties map[string]*string `json:"appProperties"`
	// SystemProperties - System properties
	SystemProperties map[string]*string `json:"systemProperties"`
}

// MarshalJSON is the custom marshaler for RoutingMessage.
func (rm RoutingMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rm.Body != nil {
		objectMap["body"] = rm.Body
	}
	if rm.AppProperties != nil {
		objectMap["appProperties"] = rm.AppProperties
	}
	if rm.SystemProperties != nil {
		objectMap["systemProperties"] = rm.SystemProperties
	}
	return json.Marshal(objectMap)
}

// RoutingProperties the routing related properties of the IoT hub. See:
// https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
type RoutingProperties struct {
	Endpoints *RoutingEndpoints `json:"endpoints,omitempty"`
	// Routes - The list of user-provided routing rules that the IoT hub uses to route messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and a maximum of 5 routing rules are allowed for free hubs.
	Routes *[]RouteProperties `json:"routes,omitempty"`
	// FallbackRoute - The properties of the route that is used as a fall-back route when none of the conditions specified in the 'routes' section are met. This is an optional parameter. When this property is not set, the messages which do not meet any of the conditions specified in the 'routes' section get routed to the built-in eventhub endpoint.
	FallbackRoute *FallbackRouteProperties `json:"fallbackRoute,omitempty"`
}

// RoutingServiceBusQueueEndpointProperties the properties related to service bus queue endpoint types.
type RoutingServiceBusQueueEndpointProperties struct {
	// ConnectionString - The connection string of the service bus queue endpoint.
	ConnectionString *string `json:"connectionString,omitempty"`
	// Name - The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types. The name need not be the same as the actual queue name.
	Name *string `json:"name,omitempty"`
	// SubscriptionID - The subscription identifier of the service bus queue endpoint.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - The name of the resource group of the service bus queue endpoint.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
}

// RoutingServiceBusTopicEndpointProperties the properties related to service bus topic endpoint types.
type RoutingServiceBusTopicEndpointProperties struct {
	// ConnectionString - The connection string of the service bus topic endpoint.
	ConnectionString *string `json:"connectionString,omitempty"`
	// Name - The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.  The name need not be the same as the actual topic name.
	Name *string `json:"name,omitempty"`
	// SubscriptionID - The subscription identifier of the service bus topic endpoint.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - The name of the resource group of the service bus topic endpoint.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
}

// RoutingStorageContainerProperties the properties related to a storage container endpoint.
type RoutingStorageContainerProperties struct {
	// ConnectionString - The connection string of the storage account.
	ConnectionString *string `json:"connectionString,omitempty"`
	// Name - The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
	Name *string `json:"name,omitempty"`
	// SubscriptionID - The subscription identifier of the storage account.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - The name of the resource group of the storage account.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// ContainerName - The name of storage container in the storage account.
	ContainerName *string `json:"containerName,omitempty"`
	// FileNameFormat - File name format for the blob. Default format is {iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}. All parameters are mandatory but can be reordered.
	FileNameFormat *string `json:"fileNameFormat,omitempty"`
	// BatchFrequencyInSeconds - Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds.
	BatchFrequencyInSeconds *int32 `json:"batchFrequencyInSeconds,omitempty"`
	// MaxChunkSizeInBytes - Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
	MaxChunkSizeInBytes *int32 `json:"maxChunkSizeInBytes,omitempty"`
	// Encoding - Encoding that is used to serialize messages to blobs. Supported values are 'avro', 'avrodeflate', and 'JSON'. Default value is 'avro'. Possible values include: 'Avro', 'AvroDeflate', 'JSON'
	Encoding Encoding `json:"encoding,omitempty"`
}

// RoutingTwin twin reference input parameter. This is an optional parameter
type RoutingTwin struct {
	// Tags - Twin Tags
	Tags       interface{}            `json:"tags,omitempty"`
	Properties *RoutingTwinProperties `json:"properties,omitempty"`
}

// RoutingTwinProperties ...
type RoutingTwinProperties struct {
	// Desired - Twin desired properties
	Desired interface{} `json:"desired,omitempty"`
	// Reported - Twin desired properties
	Reported interface{} `json:"reported,omitempty"`
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// SharedAccessSignatureAuthorizationRule the properties of an IoT hub shared access policy.
type SharedAccessSignatureAuthorizationRule struct {
	autorest.Response `json:"-"`
	// KeyName - The name of the shared access policy.
	KeyName *string `json:"keyName,omitempty"`
	// PrimaryKey - The primary key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - The secondary key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// Rights - The permissions assigned to the shared access policy. Possible values include: 'RegistryRead', 'RegistryWrite', 'ServiceConnect', 'DeviceConnect', 'RegistryReadRegistryWrite', 'RegistryReadServiceConnect', 'RegistryReadDeviceConnect', 'RegistryWriteServiceConnect', 'RegistryWriteDeviceConnect', 'ServiceConnectDeviceConnect', 'RegistryReadRegistryWriteServiceConnect', 'RegistryReadRegistryWriteDeviceConnect', 'RegistryReadServiceConnectDeviceConnect', 'RegistryWriteServiceConnectDeviceConnect', 'RegistryReadRegistryWriteServiceConnectDeviceConnect'
	Rights AccessRights `json:"rights,omitempty"`
}

// SharedAccessSignatureAuthorizationRuleListResult the list of shared access policies with a next link.
type SharedAccessSignatureAuthorizationRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of shared access policies.
	Value *[]SharedAccessSignatureAuthorizationRule `json:"value,omitempty"`
	// NextLink - READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// SharedAccessSignatureAuthorizationRuleListResultIterator provides access to a complete listing of
// SharedAccessSignatureAuthorizationRule values.
type SharedAccessSignatureAuthorizationRuleListResultIterator struct {
	i    int
	page SharedAccessSignatureAuthorizationRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SharedAccessSignatureAuthorizationRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SharedAccessSignatureAuthorizationRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SharedAccessSignatureAuthorizationRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SharedAccessSignatureAuthorizationRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SharedAccessSignatureAuthorizationRuleListResultIterator) Response() SharedAccessSignatureAuthorizationRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SharedAccessSignatureAuthorizationRuleListResultIterator) Value() SharedAccessSignatureAuthorizationRule {
	if !iter.page.NotDone() {
		return SharedAccessSignatureAuthorizationRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SharedAccessSignatureAuthorizationRuleListResultIterator type.
func NewSharedAccessSignatureAuthorizationRuleListResultIterator(page SharedAccessSignatureAuthorizationRuleListResultPage) SharedAccessSignatureAuthorizationRuleListResultIterator {
	return SharedAccessSignatureAuthorizationRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sasarlr SharedAccessSignatureAuthorizationRuleListResult) IsEmpty() bool {
	return sasarlr.Value == nil || len(*sasarlr.Value) == 0
}

// sharedAccessSignatureAuthorizationRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sasarlr SharedAccessSignatureAuthorizationRuleListResult) sharedAccessSignatureAuthorizationRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if sasarlr.NextLink == nil || len(to.String(sasarlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sasarlr.NextLink)))
}

// SharedAccessSignatureAuthorizationRuleListResultPage contains a page of
// SharedAccessSignatureAuthorizationRule values.
type SharedAccessSignatureAuthorizationRuleListResultPage struct {
	fn      func(context.Context, SharedAccessSignatureAuthorizationRuleListResult) (SharedAccessSignatureAuthorizationRuleListResult, error)
	sasarlr SharedAccessSignatureAuthorizationRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SharedAccessSignatureAuthorizationRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SharedAccessSignatureAuthorizationRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sasarlr)
	if err != nil {
		return err
	}
	page.sasarlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SharedAccessSignatureAuthorizationRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SharedAccessSignatureAuthorizationRuleListResultPage) NotDone() bool {
	return !page.sasarlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SharedAccessSignatureAuthorizationRuleListResultPage) Response() SharedAccessSignatureAuthorizationRuleListResult {
	return page.sasarlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SharedAccessSignatureAuthorizationRuleListResultPage) Values() []SharedAccessSignatureAuthorizationRule {
	if page.sasarlr.IsEmpty() {
		return nil
	}
	return *page.sasarlr.Value
}

// Creates a new instance of the SharedAccessSignatureAuthorizationRuleListResultPage type.
func NewSharedAccessSignatureAuthorizationRuleListResultPage(getNextPage func(context.Context, SharedAccessSignatureAuthorizationRuleListResult) (SharedAccessSignatureAuthorizationRuleListResult, error)) SharedAccessSignatureAuthorizationRuleListResultPage {
	return SharedAccessSignatureAuthorizationRuleListResultPage{fn: getNextPage}
}

// StorageEndpointProperties the properties of the Azure Storage endpoint for file upload.
type StorageEndpointProperties struct {
	// SasTTLAsIso8601 - The period of time for which the SAS URI generated by IoT Hub for file upload is valid. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
	SasTTLAsIso8601 *string `json:"sasTtlAsIso8601,omitempty"`
	// ConnectionString - The connection string for the Azure Storage account to which files are uploaded.
	ConnectionString *string `json:"connectionString,omitempty"`
	// ContainerName - The name of the root container where you upload files. The container need not exist but should be creatable using the connectionString specified.
	ContainerName *string `json:"containerName,omitempty"`
}

// TagsResource a container holding only the Tags for a resource, allowing the user to update the tags on
// an IoT Hub instance.
type TagsResource struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsResource.
func (tr TagsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// TestAllRoutesInput input for testing all routes
type TestAllRoutesInput struct {
	// RoutingSource - Routing source. Possible values include: 'RoutingSourceInvalid', 'RoutingSourceDeviceMessages', 'RoutingSourceTwinChangeEvents', 'RoutingSourceDeviceLifecycleEvents', 'RoutingSourceDeviceJobLifecycleEvents'
	RoutingSource RoutingSource `json:"routingSource,omitempty"`
	// Message - Routing message
	Message *RoutingMessage `json:"message,omitempty"`
	// Twin - Routing Twin Reference
	Twin *RoutingTwin `json:"twin,omitempty"`
}

// TestAllRoutesResult result of testing all routes
type TestAllRoutesResult struct {
	autorest.Response `json:"-"`
	// Routes - JSON-serialized array of matched routes
	Routes *[]MatchedRoute `json:"routes,omitempty"`
}

// TestRouteInput input for testing route
type TestRouteInput struct {
	// Message - Routing message
	Message *RoutingMessage `json:"message,omitempty"`
	// Route - Route properties
	Route *RouteProperties `json:"route,omitempty"`
	// Twin - Routing Twin Reference
	Twin *RoutingTwin `json:"twin,omitempty"`
}

// TestRouteResult result of testing one route
type TestRouteResult struct {
	autorest.Response `json:"-"`
	// Result - Result of testing route. Possible values include: 'Undefined', 'False', 'True'
	Result TestResultStatus `json:"result,omitempty"`
	// Details - Detailed result of testing route
	Details *TestRouteResultDetails `json:"details,omitempty"`
}

// TestRouteResultDetails detailed result of testing a route
type TestRouteResultDetails struct {
	// CompilationErrors - JSON-serialized list of route compilation errors
	CompilationErrors *[]RouteCompilationError `json:"compilationErrors,omitempty"`
}

// UserSubscriptionQuota user subscription quota response
type UserSubscriptionQuota struct {
	// ID - IotHub type id
	ID *string `json:"id,omitempty"`
	// Type - Response type
	Type *string `json:"type,omitempty"`
	// Unit - Unit of IotHub type
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - Current number of IotHub type
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - Numerical limit on IotHub type
	Limit *int32 `json:"limit,omitempty"`
	// Name - IotHub type
	Name *Name `json:"name,omitempty"`
}

// UserSubscriptionQuotaListResult json-serialized array of User subscription quota response
type UserSubscriptionQuotaListResult struct {
	autorest.Response `json:"-"`
	Value             *[]UserSubscriptionQuota `json:"value,omitempty"`
	// NextLink - READ-ONLY
	NextLink *string `json:"nextLink,omitempty"`
}
