/*
 ==============================================================================
 This file is part of the IEM plug-in suite.
 Author: Daniel Rudrich
 Copyright (c) 2017 - Institute of Electronic Music and Acoustics (IEM)
 https://iem.at

 The IEM plug-in suite is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 The IEM plug-in suite is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this software.  If not, see <https://www.gnu.org/licenses/>.
 ==============================================================================
 */

#ifndef hammerAitovSample_h
#define hammerAitovSample_h

#define nSamplePoints 426
const float hammerAitovSampleX[426] = {
    -9.8942823302790495e-01, -9.4562237517123438e-01, -9.7653817229723083e-01,
    -9.5892154250491690e-01, -9.8867544588247824e-01, -9.5892154250491679e-01,
    -9.7653817229723083e-01, -9.4562237517123438e-01, -8.6112914332692680e-01,
    -9.0596313391326455e-01, -8.7329387676999282e-01, -9.1550845659717472e-01,
    -8.5300597618283902e-01, -9.0991995150389882e-01, -8.5300597618283902e-01,
    -9.1550845659717472e-01, -8.7329387676999282e-01, -9.0596313391326455e-01,
    -8.6112914332692680e-01, -7.9501230438537918e-01, -8.3029661458928494e-01,
    -7.4131433526537283e-01, -7.9099950003568620e-01, -6.9443022574358737e-01,
    -7.7120003770640355e-01, -6.9443022574358737e-01, -7.9099950003568620e-01,
    -7.4131433526537283e-01, -8.3029661458928505e-01, -7.9501230438537918e-01,
    -7.0842893375742710e-01, -7.5639574473324822e-01, -6.7169359413984597e-01,
    -6.9740562672519002e-01, -5.6579607871736703e-01, -6.1967008938249135e-01,
    -4.9914036122026817e-01, -5.8910886481124225e-01, -4.9914036122026817e-01,
    -6.1967008938249135e-01, -5.6579607871736703e-01, -6.9740562672518946e-01,
    -6.7169359413984597e-01, -7.5639574473324844e-01, -7.0842893375742710e-01,
    -6.3578880451330455e-01, -6.5106527640941370e-01, -5.0601581936609574e-01,
    -5.2284594190360856e-01, -3.6182364198623596e-01, -4.1692267240601072e-01,
    -2.8167523923228210e-01, -3.7879446564668046e-01, -2.8167523923228210e-01,
    -4.1692267240601072e-01, -3.6182364198623596e-01, -5.2284594190360856e-01,
    -5.0601581936609574e-01, -6.5106527640941425e-01, -6.3578880451330455e-01,
    -5.9406355775518038e-01, -5.1491783695621851e-01, -5.0125373644613047e-01,
    -3.1266629474366164e-01, -3.2149019791965894e-01, -1.4334621098231232e-01,
    -1.9685353171630268e-01, -5.5154542350804789e-02, -1.5395974554799582e-01,
    -5.5154542350804789e-02, -1.9685353171630268e-01, -1.4334621098231232e-01,
    -3.2149019791965838e-01, -3.1266629474366164e-01, -5.0125373644613136e-01,
    -5.1491783695621851e-01, -5.9406355775518038e-01, -5.1723990890365068e-01,
    -3.5813645747788386e-01, -3.2107853426731159e-01, -1.0593532535962329e-01,
    -1.0734775411014962e-01, 7.6927088897341719e-02,  2.7793804570801141e-02,
    1.6873206582647687e-01,  7.3137517642518926e-02,  1.6873206582647685e-01,
    2.7793804570801141e-02,  7.6927088897341719e-02,  -1.0734775411014963e-01,
    -1.0593532535962329e-01, -3.2107853426731153e-01, -3.5813645747788386e-01,
    -5.1723990890365068e-01, -4.1017625752326192e-01, -3.9923569231691663e-01,
    -1.7923749366896338e-01, -1.2503085866823810e-01, 1.0057199136362120e-01,
    1.0662349975772990e-01,  2.8762707223681083e-01,  2.4567150099224064e-01,
    3.7973464499968468e-01,  2.9168467357555738e-01,  3.7973464499968462e-01,
    2.4567150099224064e-01,  2.8762707223681083e-01,  1.0662349975773046e-01,
    1.0057199136362120e-01,  -1.2503085866823868e-01, -1.7923749366896338e-01,
    -3.9923569231691663e-01, -4.1017625752326214e-01, -3.2005431801006917e-01,
    -2.5041665829459026e-01, 6.5619957937038181e-03,  7.2363248743749289e-02,
    2.9426214880030638e-01,  3.0870777333893895e-01,  4.7881751974206366e-01,
    4.4686631023507467e-01,  5.6905151949827804e-01,  4.9231419939479937e-01,
    5.6905151949827804e-01,  4.4686631023507467e-01,  4.7881751974206366e-01,
    3.0870777333893901e-01,  2.9426214880030638e-01,  7.2363248743748387e-02,
    6.5619957937038181e-03,  -2.5041665829459026e-01, -3.2005431801006951e-01,
    -2.0070155681837162e-01, -8.4187208008073583e-02, 1.8303324579757904e-01,
    2.5703093956542011e-01,  4.6390296134897951e-01,  4.8861785714056805e-01,
    6.4207936349823835e-01,  6.2293406353980030e-01,  7.2933663681947802e-01,
    6.6710369973691064e-01,  7.2933663681947802e-01,  6.2293406353980030e-01,
    6.4207936349823835e-01,  4.8861785714056810e-01,  4.6390296134897951e-01,
    2.5703093956542000e-01,  1.8303324579757904e-01,  -8.4187208008073583e-02,
    -2.0070155681837176e-01, -6.0887670498268653e-02, 8.1951095935592855e-02,
    3.3387283654542532e-01,  4.1598002486746927e-01,  5.9997573377796920e-01,
    6.3767020905662375e-01,  7.7058414869815461e-01,  7.6692942851300172e-01,
    8.5470572624642605e-01,  8.0957590673154300e-01,  8.5470572624642605e-01,
    7.6692942851300172e-01,  7.7058414869815461e-01,  6.3767020905662386e-01,
    5.9997573377796920e-01,  4.1598002486746904e-01,  3.3387283654542532e-01,
    8.1951095935592855e-02,  -6.0887670498268105e-02, 7.9279895879067155e-02,
    2.2628589161077531e-01,  4.4421736619701735e-01,  5.3802221305675013e-01,
    6.9500437457812791e-01,  7.4894117570862595e-01,  8.5915506593126645e-01,
    8.7343064723672637e-01,  9.4074124316293095e-01,  9.1469868000133425e-01,
    9.4074124316293095e-01,  8.7343064723672637e-01,  8.5915506593126645e-01,
    7.4894117570862595e-01,  6.9500437457812791e-01,  5.3802221305675002e-01,
    4.4421736619701735e-01,  2.2628589161077531e-01,  7.9279895879067558e-02,
    1.7599693312597767e-01,  3.2535083529900866e-01,  5.0255352882351878e-01,
    6.1451170162552049e-01,  7.4383409240983211e-01,  8.1739717339059925e-01,
    9.0431409325138068e-01,  9.3855901281978116e-01,  9.8449608748550044e-01,
    9.7888500666190836e-01,  9.8449608748550033e-01,  9.3855901281978116e-01,
    9.0431409325138068e-01,  8.1739717339059936e-01,  7.4383409240983211e-01,
    6.1451170162552005e-01,  5.0255352882351878e-01,  3.2535083529900866e-01,
    1.7599693312597864e-01,  -1.3227466940842578e-03, 1.7599693312597775e-01,
    3.5998833559701332e-01,  5.0255352882351878e-01,  6.3999152504706647e-01,
    7.4383409240983211e-01,  8.3999250141852788e-01,  9.0431409325138079e-01,
    9.5999289196795967e-01,  9.8449608748550044e-01,  9.9999300132187530e-01,
    9.8449608748550033e-01,  9.5999289196795967e-01,  9.0431409325138079e-01,
    8.3999250141852799e-01,  7.4383409240983211e-01,  6.3999152504706647e-01,
    5.0255352882351878e-01,  3.5998833559701332e-01,  1.7599693312597875e-01,
    -1.3227466940842578e-03, 7.9279895879067155e-02,  3.2283468078535987e-01,
    4.4421736619701735e-01,  6.1263607740966997e-01,  6.9500437457812791e-01,
    8.1572983410625177e-01,  8.5915506593126645e-01,  9.3697615394646783e-01,
    9.4074124316293095e-01,  9.7732590608283099e-01,  9.4074124316293095e-01,
    9.3697615394646783e-01,  8.5915506593126645e-01,  8.1572983410625188e-01,
    6.9500437457812791e-01,  6.1263607740966985e-01,  4.4421736619701735e-01,
    3.2283468078535987e-01,  7.9279895879067558e-02,  -6.0887670498268549e-02,
    2.2177449618114994e-01,  3.3387283654542549e-01,  5.3440518945971827e-01,
    5.9997573377796931e-01,  7.4568024443584235e-01,  7.7058414869815495e-01,
    8.7032092156909413e-01,  8.5470572624642627e-01,  9.1163209053935768e-01,
    8.5470572624642627e-01,  8.7032092156909413e-01,  7.7058414869815495e-01,
    7.4568024443584269e-01,  5.9997573377796931e-01,  5.3440518945971804e-01,
    3.3387283654542549e-01,  2.2177449618114994e-01,  -6.0887670498267994e-02,
    -2.0070155681837162e-01, 7.6253809019891552e-02,  1.8303324579757904e-01,
    4.1087884302695143e-01,  4.6390296134897951e-01,  6.3296170396166584e-01,
    6.4207936349823835e-01,  7.6240461660885883e-01,  7.2933663681947802e-01,
    8.0510505177902292e-01,  7.2933663681947802e-01,  7.6240461660885883e-01,
    6.4207936349823835e-01,  6.3296170396166596e-01,  4.6390296134897951e-01,
    4.1087884302695127e-01,  1.8303324579757904e-01,  7.6253809019891552e-02,
    -2.0070155681837176e-01, -3.2005431801006917e-01, -9.0239646018537414e-02,
    6.5619957937040679e-03,  2.5080566036358554e-01,  2.9426214880030654e-01,
    4.8267719196242531e-01,  4.7881751974206388e-01,  6.1716132927708900e-01,
    5.6905151949827826e-01,  6.6138341438238202e-01,  5.6905151949827826e-01,
    6.1716132927708900e-01,  4.7881751974206388e-01,  4.8267719196242559e-01,
    2.9426214880030654e-01,  2.5080566036358543e-01,  6.5619957937040679e-03,
    -9.0239646018537414e-02, -3.2005431801006951e-01, -4.1017625752326192e-01,
    -2.5612202158127184e-01, -1.7923749366896338e-01, 6.5451277050613585e-02,
    1.0057199136362120e-01,  3.0181563122906424e-01,  2.8762707223681083e-01,
    4.4006759814169177e-01,  3.7973464499968468e-01,  4.8555093042297365e-01,
    3.7973464499968462e-01,  4.4006759814169177e-01,  2.8762707223681083e-01,
    3.0181563122906468e-01,  1.0057199136362120e-01,  6.5451277050613266e-02,
    -1.7923749366896338e-01, -2.5612202158127184e-01, -4.1017625752326214e-01,
    -4.0404983400147271e-01, -3.5813645747788364e-01, -1.3214144559497293e-01,
    -1.0593532535962294e-01, 9.9120661508992708e-02,  7.6927088897342122e-02,
    2.3812274204495956e-01,  1.6873206582647707e-01,  2.8413647946732529e-01,
    1.6873206582647707e-01,  2.3812274204495956e-01,  7.6927088897342122e-02,
    9.9120661508992722e-02,  -1.0593532535962294e-01, -1.3214144559497348e-01,
    -3.5813645747788364e-01, -4.0404983400147271e-01, -5.2074726026037255e-01,
    -5.1491783695621851e-01, -3.2787341511467760e-01, -3.1266629474366164e-01,
    -1.1506638250603425e-01, -1.4334621098231232e-01, 1.9823938272352508e-02,
    -5.5154542350804789e-02, 6.5114068574948947e-02,  -5.5154542350804789e-02,
    1.9823938272352508e-02,  -1.4334621098231232e-01, -1.1506638250603426e-01,
    -3.1266629474366164e-01, -3.2787341511467749e-01, -5.1491783695621851e-01,
    -5.2074726026037255e-01, -5.9593591488260522e-01, -6.3578880451330455e-01,
    -5.0721232435235164e-01, -5.0601581936609552e-01, -3.2898209341939294e-01,
    -3.6182364198623596e-01, -2.0486370948021143e-01, -2.8167523923228188e-01,
    -1.6209716770165650e-01, -2.8167523923228188e-01, -2.0486370948021143e-01,
    -3.6182364198623596e-01, -3.2898209341939244e-01, -5.0601581936609552e-01,
    -5.0721232435235220e-01, -6.3578880451330455e-01, -5.9593591488260522e-01,
    -7.0842893375742710e-01, -6.5567536228108103e-01, -6.7169359413984597e-01,
    -5.2962774272594793e-01, -5.6579607871736703e-01, -4.2454182469795182e-01,
    -4.9914036122026817e-01, -3.8663296731700841e-01, -4.9914036122026817e-01,
    -4.2454182469795182e-01, -5.6579607871736703e-01, -5.2962774272594804e-01,
    -6.7169359413984597e-01, -6.5567536228108148e-01, -7.0842893375742710e-01,
    -7.5916297247481712e-01, -7.9501230438537895e-01, -7.0295993195600792e-01,
    -7.4131433526537227e-01, -6.2641780435651429e-01, -6.9443022574358704e-01,
    -5.9618394073263437e-01, -6.9443022574358704e-01, -6.2641780435651429e-01,
    -7.4131433526537227e-01, -7.0295993195600737e-01, -7.9501230438537895e-01,
    -7.5916297247481723e-01, -8.6112914332692680e-01, -8.3407858641754351e-01,
    -8.7329387676999282e-01, -7.9634789437509146e-01, -8.5300597618283902e-01,
    -7.7699557091707838e-01, -8.5300597618283902e-01, -7.9634789437509146e-01,
    -8.7329387676999282e-01, -8.3407858641754329e-01, -8.6112914332692680e-01,
    -9.0740672313746440e-01, -9.4562237517123426e-01, -9.1888390180491852e-01,
    -9.5892154250491679e-01, -9.1386821334589863e-01, -9.5892154250491668e-01,
    -9.1888390180491852e-01, -9.4562237517123426e-01, -9.0740672313746429e-01,
    -9.7732312869673676e-01, -9.9015709600166602e-01, -9.7732312869673676e-01
};
const float hammerAitovSampleY[426] = {
    -1.4502334876590658e-01, 1.0516091195246342e-01,  7.0450506826574583e-02,
    2.6295030618542486e-01,  1.5006952625061076e-01,  2.6295030618542486e-01,
    7.0450506826574583e-02,  1.0516091195246342e-01,  4.8677437164362423e-02,
    1.0428127232973203e-01,  3.6161643598064663e-01,  3.3905045618789836e-01,
    5.0964430770037672e-01,  4.1478389777707442e-01,  5.0964430770037672e-01,
    3.3905045618789836e-01,  3.6161643598064663e-01,  1.0428127232973285e-01,
    4.8677437164362423e-02,  2.8581463184568390e-01,  3.4941469027490019e-01,
    5.7705935637029804e-01,  5.6779447376482761e-01,  7.0987044190454907e-01,
    6.3659288547834225e-01,  7.0987044190454907e-01,  5.6779447376482761e-01,
    5.7705935637029804e-01,  3.4941469027490024e-01,  2.8581463184568390e-01,
    2.9595744498269620e-02,  1.8517965346228996e-01,  4.8489941353137678e-01,
    5.5380829345905946e-01,  7.4333215895898042e-01,  7.4798298031953436e-01,
    8.5785248663564728e-01,  8.0805367730170585e-01,  8.5785248663564728e-01,
    7.4798298031953436e-01,  7.4333215895898042e-01,  5.5380829345906002e-01,
    4.8489941353137678e-01,  1.8517965346228929e-01,  2.9595744498269620e-02,
    2.2388612418870393e-01,  3.8089331196621884e-01,  6.3683306931891104e-01,
    7.0926816165999995e-01,  8.5607398304439508e-01,  8.7491873123235697e-01,
    9.5116948768792620e-01,  9.2548082248928631e-01,  9.5116948768792620e-01,
    8.7491873123235697e-01,  8.5607398304439508e-01,  7.0926816165999995e-01,
    6.3683306931891104e-01,  3.8089331196621790e-01,  2.2388612418870393e-01,
    2.0796765907848576e-02,  3.8235348708435191e-01,  5.3310477466356254e-01,
    7.3613876542295353e-01,  8.1128296954442525e-01,  9.1396369817120859e-01,
    9.4701250681214821e-01,  9.9002242207495472e-01,  9.8807712085180699e-01,
    9.9002242207495472e-01,  9.4701250681214821e-01,  9.1396369817120859e-01,
    8.1128296954442536e-01,  7.3613876542295353e-01,  5.3310477466356165e-01,
    3.8235348708435191e-01,  2.0796765907848576e-02,  1.8236614835183212e-01,
    4.9541118493620717e-01,  6.3466959987904992e-01,  7.8053431128512940e-01,
    8.5841429015618198e-01,  9.1817559351392286e-01,  9.6515654838564335e-01,
    9.7670247984328662e-01,  9.9732186555449098e-01,  9.7670247984328651e-01,
    9.6515654838564335e-01,  9.1817559351392286e-01,  8.5841429015618209e-01,
    7.8053431128512940e-01,  6.3466959987904981e-01,  4.9541118493620717e-01,
    1.8236614835183212e-01,  4.7957087157740871e-02,  3.0964372482880231e-01,
    5.5615151776505711e-01,  6.8165661806374045e-01,  7.7063640807825973e-01,
    8.5185005892223731e-01,  8.7195695932850859e-01,  9.3225521559110680e-01,
    9.1518381068672094e-01,  9.5651453266592901e-01,  9.1518381068672083e-01,
    9.3225521559110680e-01,  8.7195695932850859e-01,  8.5185005892223720e-01,
    7.7063640807825973e-01,  6.8165661806374023e-01,  5.5615151776505711e-01,
    3.0964372482880231e-01,  4.7957087157740899e-02,  1.5383508547502925e-01,
    3.9250099379286774e-01,  5.6080423024050707e-01,  6.7334550750424416e-01,
    7.0970949377981696e-01,  7.9504144162431489e-01,  7.8027801634293037e-01,
    8.5285306271472039e-01,  8.1079681749980492e-01,  8.7041756018261585e-01,
    8.1079681749980492e-01,  8.5285306271472039e-01,  7.8027801634293037e-01,
    7.9504144162431511e-01,  7.0970949377981696e-01,  6.7334550750424427e-01,
    5.6080423024050707e-01,  3.9250099379286774e-01,  1.5383508547502941e-01,
    2.2419484725373706e-01,  4.2213567136375907e-01,  5.0944514822845888e-01,
    6.1225687199936851e-01,  6.0340523972663873e-01,  6.9337875107392843e-01,
    6.4952557585190318e-01,  7.3282571473111024e-01,  6.6995538943124355e-01,
    7.4496486749196822e-01,  6.6995538943124355e-01,  7.3282571473111024e-01,
    6.4952557585190318e-01,  6.9337875107392855e-01,  6.0340523972663873e-01,
    6.1225687199936829e-01,  5.0944514822845888e-01,  4.2213567136375907e-01,
    2.2419484725373723e-01,  2.4529669659225309e-01,  3.9257333922580839e-01,
    4.0673427430575182e-01,  5.0411049022905641e-01,  4.5945892861125803e-01,
    5.5388099505278954e-01,  4.8722324403524375e-01,  5.7911235069757172e-01,
    4.9992105081671656e-01,  5.8701520528841500e-01,  4.9992105081671656e-01,
    5.7911235069757172e-01,  4.8722324403524375e-01,  5.5388099505278954e-01,
    4.5945892861125803e-01,  5.0411049022905619e-01,  4.0673427430575182e-01,
    3.9257333922580839e-01,  2.4529669659225367e-01,  1.9953620751483692e-01,
    3.0363073203448121e-01,  2.6233626185686593e-01,  3.5762112526048240e-01,
    2.8732444913433969e-01,  3.8488484884787399e-01,  3.0176759898264788e-01,
    3.9947617244805805e-01,  3.0859256342690228e-01,  4.0413651753314334e-01,
    3.0859256342690228e-01,  3.9947617244805805e-01,  3.0176759898264788e-01,
    3.8488484884787383e-01,  2.8732444913433969e-01,  3.5762112526048229e-01,
    2.6233626185686593e-01,  3.0363073203448121e-01,  1.9953620751483792e-01,
    7.8969555154888751e-02,  1.6472461001914751e-01,  9.0620661563162799e-02,
    1.8406727126692463e-01,  9.7743431988864801e-02,  1.9572608851910697e-01,
    1.0217376149020091e-01,  2.0228368607784558e-01,  1.0431285226119984e-01,
    2.0441170155476796e-01,  1.0431285226119982e-01,  2.0228368607784558e-01,
    1.0217376149020091e-01,  1.9572608851910700e-01,  9.7743431988864801e-02,
    1.8406727126692449e-01,  9.0620661563162799e-02,  1.6472461001914751e-01,
    7.8969555154889182e-02,  3.4993390631858086e-06,  -7.8969555154888516e-02,
    -3.0851294254100881e-03, -9.0620661563162536e-02, -3.3878827477248348e-03,
    -9.7743431988864510e-02, -3.5885244898426240e-03, -1.0217376149020060e-01,
    -3.7036951596732840e-03, -1.0431285226119952e-01, -3.7412975379981514e-03,
    -1.0431285226119950e-01, -3.7036951596732840e-03, -1.0217376149020060e-01,
    -3.5885244898426231e-03, -9.7743431988864510e-02, -3.3878827477248387e-03,
    -9.0620661563162536e-02, -3.0851294254100881e-03, -7.8969555154888960e-02,
    3.4993390631858086e-06,  -1.9953620751483692e-01, -1.7034073177417974e-01,
    -2.6233626185686593e-01, -1.9058730785879699e-01, -2.8732444913433969e-01,
    -2.0271750480354181e-01, -3.0176759898264788e-01, -2.0953060441587470e-01,
    -3.0859256342690228e-01, -2.1174058019041458e-01, -3.0859256342690228e-01,
    -2.0953060441587470e-01, -3.0176759898264788e-01, -2.0271750480354184e-01,
    -2.8732444913433969e-01, -1.9058730785879693e-01, -2.6233626185686593e-01,
    -1.7034073177417974e-01, -1.9953620751483792e-01, -2.4529669659225312e-01,
    -3.0775747709572610e-01, -4.0673427430575165e-01, -3.6339242067279393e-01,
    -4.5945892861125787e-01, -3.9132546687416669e-01, -4.8722324403524336e-01,
    -4.0624519132005521e-01, -4.9992105081671634e-01, -4.1100721587198485e-01,
    -4.9992105081671634e-01, -4.0624519132005521e-01, -4.8722324403524336e-01,
    -3.9132546687416664e-01, -4.5945892861125787e-01, -3.6339242067279381e-01,
    -4.0673427430575165e-01, -3.0775747709572610e-01, -2.4529669659225370e-01,
    -2.2419484725373706e-01, -3.9467412372257271e-01, -5.0944514822845888e-01,
    -5.0869305501828310e-01, -6.0340523972663873e-01, -5.5942386269223454e-01,
    -6.4952557585190318e-01, -5.8509665422166601e-01, -6.6995538943124355e-01,
    -5.9313224124127395e-01, -6.6995538943124355e-01, -5.8509665422166601e-01,
    -6.4952557585190318e-01, -5.5942386269223465e-01, -6.0340523972663873e-01,
    -5.0869305501828299e-01, -5.0944514822845888e-01, -3.9467412372257271e-01,
    -2.2419484725373723e-01, -1.5383508547502925e-01, -4.2207362946537791e-01,
    -5.6080423024050707e-01, -6.1529202483993461e-01, -7.0970949377981685e-01,
    -6.9770700437947086e-01, -7.8027801634293026e-01, -7.3773638757022364e-01,
    -8.1079681749980481e-01, -7.5004798458492128e-01, -8.1079681749980481e-01,
    -7.3773638757022364e-01, -7.8027801634293026e-01, -6.9770700437947075e-01,
    -7.0970949377981685e-01, -6.1529202483993439e-01, -5.6080423024050707e-01,
    -4.2207362946537791e-01, -1.5383508547502941e-01, -4.7957087157740871e-02,
    -3.9041158686451399e-01, -5.5615151776505711e-01, -6.7457557764084219e-01,
    -7.7063640807825973e-01, -7.9787984623001840e-01, -8.7195695932850859e-01,
    -8.5642672782577345e-01, -9.1518381068672094e-01, -8.7420838131728329e-01,
    -9.1518381068672083e-01, -8.5642672782577345e-01, -8.7195695932850859e-01,
    -7.9787984623001829e-01, -7.7063640807825973e-01, -6.7457557764084208e-01,
    -5.5615151776505711e-01, -3.9041158686451399e-01, -4.7957087157740899e-02,
    -3.0580566222612315e-01, -4.9541118493620728e-01, -6.8093587052823434e-01,
    -7.8053431128512951e-01, -8.5297622318184441e-01, -9.1817559351392286e-01,
    -9.3426221984723101e-01, -9.7670247984328662e-01, -9.5878384479293044e-01,
    -9.7670247984328651e-01, -9.3426221984723101e-01, -9.1817559351392286e-01,
    -8.5297622318184452e-01, -7.8053431128512951e-01, -6.8093587052823423e-01,
    -4.9541118493620728e-01, -3.0580566222612315e-01, -1.7712327984382462e-01,
    -3.8235348708435191e-01, -6.3196804045766808e-01, -7.3613876542295353e-01,
    -8.5766970271183318e-01, -9.1396369817120859e-01, -9.6540996954898972e-01,
    -9.9002242207495472e-01, -9.9787782722817164e-01, -9.9002242207495472e-01,
    -9.6540996954898972e-01, -9.1396369817120859e-01, -8.5766970271183329e-01,
    -7.3613876542295353e-01, -6.3196804045766786e-01, -3.8235348708435191e-01,
    -1.7712327984382462e-01, -1.4528049607708819e-02, -2.2388612418870393e-01,
    -5.2850772453275841e-01, -6.3683306931891137e-01, -8.0858422686043452e-01,
    -8.5607398304439508e-01, -9.4537837819971893e-01, -9.5116948768792631e-01,
    -9.8677480116949734e-01, -9.5116948768792631e-01, -9.4537837819971893e-01,
    -8.5607398304439508e-01, -8.0858422686043485e-01, -6.3683306931891137e-01,
    -5.2850772453275763e-01, -2.2388612418870393e-01, -1.4528049607708819e-02,
    -2.9595744498269620e-02, -3.7460028005071766e-01, -4.8489941353137678e-01,
    -7.0461906881828829e-01, -7.4333215895898042e-01, -8.7132808607548462e-01,
    -8.5785248663564728e-01, -9.2223367352512409e-01, -8.5785248663564728e-01,
    -8.7132808607548462e-01, -7.4333215895898042e-01, -7.0461906881828840e-01,
    -4.8489941353137678e-01, -3.7460028005071677e-01, -2.9595744498269620e-02,
    -1.7750645812039359e-01, -2.8581463184568423e-01, -5.4731403258546096e-01,
    -5.7705935637029881e-01, -7.4244667379906981e-01, -7.0987044190454940e-01,
    -8.0284787401630875e-01, -7.0987044190454940e-01, -7.4244667379906981e-01,
    -5.7705935637029881e-01, -5.4731403258546163e-01, -2.8581463184568423e-01,
    -1.7750645812039326e-01, -4.8677437164362423e-02, -3.4130015525555257e-01,
    -3.6161643598064663e-01, -5.6042238731049643e-01, -5.0964430770037672e-01,
    -6.2950606254049957e-01, -5.0964430770037672e-01, -5.6042238731049643e-01,
    -3.6161643598064663e-01, -3.4130015525555335e-01, -4.8677437164362423e-02,
    -9.4917443622638362e-02, -1.0516091195246384e-01, -3.3007793864252843e-01,
    -2.6295030618542531e-01, -4.0601094644846097e-01, -2.6295030618542531e-01,
    -3.3007793864252843e-01, -1.0516091195246384e-01, -9.4917443622638750e-02,
    -6.0277522057913181e-02, -1.3996044168817004e-01, -6.0277522057913181e-02
};
const float hammerAitovSampleZ[426] = {
    0.0000000000000000e+00,  -3.0779783328158683e-01, -2.0349428526192753e-01,
    -1.0642655588236501e-01, 0.0000000000000000e+00,  1.0642655588236512e-01,
    2.0349428526192753e-01,  3.0779783328158683e-01,  -5.0605049710887806e-01,
    -4.1031233984776588e-01, -3.2648331967298327e-01, -2.1653880497000325e-01,
    -1.1244324890790776e-01, 0.0000000000000000e+00,  1.1244324890790788e-01,
    2.1653880497000325e-01,  3.2648331967298327e-01,  4.1031233984776577e-01,
    5.0605049710887806e-01,  -5.3503778567383953e-01, -4.3418533602790871e-01,
    -3.4271789500339134e-01, -2.2787985102991656e-01, -1.1768864551837875e-01,
    0.0000000000000000e+00,  1.1768864551837889e-01,  2.2787985102991656e-01,
    3.4271789500339134e-01,  4.3418533602790854e-01,  5.3503778567383953e-01,
    -7.0516135580653327e-01, -6.2735474278355541e-01, -5.6008952351246721e-01,
    -4.5488654179697308e-01, -3.5683623521922797e-01, -2.3776131198536549e-01,
    -1.2226205860338232e-01, 0.0000000000000000e+00,  1.2226205860338248e-01,
    2.3776131198536549e-01,  3.5683623521922797e-01,  4.5488654179697297e-01,
    5.6008952351246721e-01,  6.2735474278355541e-01,  7.0516135580653327e-01,
    -7.3867963248711765e-01, -6.5653201807173001e-01, -5.8171439072203968e-01,
    -4.7283273563742667e-01, -3.6908127513370420e-01, -2.4635888247147314e-01,
    -1.2623654500549572e-01, 0.0000000000000000e+00,  1.2623654500549589e-01,
    2.4635888247147314e-01,  3.6908127513370420e-01,  4.7283273563742650e-01,
    5.8171439072203968e-01,  6.5653201807173001e-01,  7.3867963248711765e-01,
    -8.0414922985415560e-01, -7.6724535325980669e-01, -6.8157464076189433e-01,
    -6.0028285513817525e-01, -4.8832775465742045e-01, -3.7963432698087546e-01,
    -2.5380307128202650e-01, -1.2966719032551594e-01, 0.0000000000000000e+00,
    1.2966719032551607e-01,  2.5380307128202650e-01,  3.7963432698087546e-01,
    4.8832775465742034e-01,  6.0028285513817525e-01,  6.8157464076189433e-01,
    7.6724535325980669e-01,  8.0414922985415560e-01,  -8.3618506598280062e-01,
    -7.9139499345478237e-01, -7.0292465728705344e-01, -6.1607133981999151e-01,
    -5.0159880994990924e-01, -3.8863324930985499e-01, -2.6019289293866438e-01,
    -1.3259621348252737e-01, 0.0000000000000000e+00,  1.3259621348252754e-01,
    2.6019289293866438e-01,  3.8863324930985499e-01,  5.0159880994990902e-01,
    6.1607133981999151e-01,  7.0292465728705356e-01,  7.9139499345478237e-01,
    8.3618506598280062e-01,  -9.1074450619015845e-01, -8.6297834599390566e-01,
    -8.1152289564182456e-01, -7.2091021592885407e-01, -6.2928912361282208e-01,
    -5.1281859015990661e-01, -3.9618395777095999e-01, -2.6560445516481557e-01,
    -1.3505625510836489e-01, 0.0000000000000000e+00,  1.3505625510836505e-01,
    2.6560445516481557e-01,  3.9618395777095999e-01,  5.1281859015990650e-01,
    6.2928912361282208e-01,  7.2091021592885418e-01,  8.1152289564182456e-01,
    8.6297834599390566e-01,  9.1074450619015834e-01,  -9.3482618705297293e-01,
    -8.8500534863930713e-01, -8.2792243329647475e-01, -7.3577808322557559e-01,
    -6.4009547898905073e-01, -5.2211935108751273e-01, -4.0236799077461427e-01,
    -2.7009656457461895e-01, -1.3707256796634723e-01, 0.0000000000000000e+00,
    1.3707256796634740e-01,  2.7009656457461895e-01,  4.0236799077461427e-01,
    5.2211935108751251e-01,  6.4009547898905073e-01,  7.3577808322557559e-01,
    8.2792243329647475e-01,  8.8500534863930713e-01,  9.3482618705297282e-01,
    -9.5365379229338543e-01, -9.0261508350463193e-01, -8.4081179337547751e-01,
    -7.4771426280074815e-01, -6.4861094588519319e-01, -5.2960220660654200e-01,
    -4.0724761175966478e-01, -2.7371449415518639e-01, -1.3866451011301845e-01,
    0.0000000000000000e+00,  1.3866451011301861e-01,  2.7371449415518639e-01,
    4.0724761175966478e-01,  5.2960220660654189e-01,  6.4861094588519319e-01,
    7.4771426280074837e-01,  8.4081179337547751e-01,  9.0261508350463193e-01,
    9.5365379229338532e-01,  -9.6753409357098230e-01, -9.1606232932265785e-01,
    -8.5035060952649710e-01, -7.5685747175560070e-01, -6.5492489019503775e-01,
    -5.3534339241370443e-01, -4.1086929825300122e-01, -2.7649256219698448e-01,
    -1.3984657475919560e-01, 0.0000000000000000e+00,  1.3984657475919574e-01,
    2.7649256219698448e-01,  4.1086929825300122e-01,  5.3534339241370421e-01,
    6.5492489019503775e-01,  7.5685747175560103e-01,  8.5035060952649710e-01,
    9.1606232932265785e-01,  9.6753409357098219e-01,  -9.7667804316468598e-01,
    -9.2552853755144771e-01, -8.5665081409168742e-01, -7.6330808264091066e-01,
    -6.5910058431692631e-01, -5.3939852470648308e-01, -4.1326612356796072e-01,
    -2.7845590694737032e-01, -1.4062909801984982e-01, 0.0000000000000000e+00,
    1.4062909801984999e-01,  2.7845590694737032e-01,  4.1326612356796072e-01,
    5.3939852470648297e-01,  6.5910058431692631e-01,  7.6330808264091088e-01,
    8.5665081409168742e-01,  9.2552853755144771e-01,  9.7667804316468576e-01,
    -9.8121806388227950e-01, -9.3113513349259736e-01, -8.5978360438245360e-01,
    -7.6713402232833849e-01, -6.6117854205341497e-01, -5.4180546251036388e-01,
    -4.1445933842763955e-01, -2.7962169050615027e-01, -1.4101873130501197e-01,
    0.0000000000000000e+00,  1.4101873130501213e-01,  2.7962169050615027e-01,
    4.1445933842763955e-01,  5.4180546251036366e-01,  6.6117854205341497e-01,
    7.6713402232833872e-01,  8.5978360438245360e-01,  9.3113513349259736e-01,
    9.8121806388227928e-01,  -9.9999912516408629e-01, -9.8121806388227950e-01,
    -9.3295170304283204e-01, -8.5978360438245360e-01, -7.6837449861276486e-01,
    -6.6117854205341497e-01, -5.4258614067503619e-01, -4.1445933842763955e-01,
    -2.7999987502346763e-01, -1.4101873130501197e-01, 0.0000000000000000e+00,
    1.4101873130501213e-01,  2.7999987502346763e-01,  4.1445933842763955e-01,
    5.4258614067503608e-01,  6.6117854205341497e-01,  7.6837449861276486e-01,
    8.5978360438245360e-01,  9.3295170304283204e-01,  9.8121806388227928e-01,
    9.9999912516408629e-01,  -9.7667804316468598e-01, -9.3100043178338632e-01,
    -8.5665081409168742e-01, -7.6704205539150783e-01, -6.5910058431692631e-01,
    -5.4174758974564252e-01, -4.1326612356796072e-01, -2.7959365648884665e-01,
    -1.4062909801984982e-01, 0.0000000000000000e+00,  1.4062909801984999e-01,
    2.7959365648884665e-01,  4.1326612356796072e-01,  5.4174758974564230e-01,
    6.5910058431692631e-01,  7.6704205539150805e-01,  8.5665081409168742e-01,
    9.3100043178338632e-01,  9.7667804316468576e-01,  -9.6753409357098230e-01,
    -9.2525748207473080e-01, -8.5035060952649710e-01, -7.6312321552688311e-01,
    -6.5492489019503775e-01, -5.3928225636842320e-01, -4.1086929825300122e-01,
    -2.7839960130800184e-01, -1.3984657475919560e-01, 0.0000000000000000e+00,
    1.3984657475919574e-01,  2.7839960130800184e-01,  4.1086929825300122e-01,
    5.3928225636842309e-01,  6.5492489019503775e-01,  7.6312321552688334e-01,
    8.5035060952649710e-01,  9.2525748207473080e-01,  9.6753409357098219e-01,
    -9.5365379229338543e-01, -9.1565151268033040e-01, -8.4081179337547751e-01,
    -7.5657778987292490e-01, -6.4861094588519319e-01, -5.3516765893357610e-01,
    -4.0724761175966478e-01, -2.7640749952219290e-01, -1.3866451011301845e-01,
    0.0000000000000000e+00,  1.3866451011301861e-01,  2.7640749952219290e-01,
    4.0724761175966478e-01,  5.3516765893357587e-01,  6.4861094588519319e-01,
    7.5657778987292512e-01,  8.4081179337547751e-01,  9.1565151268033040e-01,
    9.5365379229338532e-01,  -9.3482618705297293e-01, -9.0205912089860940e-01,
    -8.2792243329647475e-01, -7.4733676806240379e-01, -6.4009547898905073e-01,
    -5.2936534113888967e-01, -4.0236799077461427e-01, -2.7359991977296561e-01,
    -1.3707256796634723e-01, 0.0000000000000000e+00,  1.3707256796634740e-01,
    2.7359991977296561e-01,  4.0236799077461427e-01,  5.2936534113888956e-01,
    6.4009547898905073e-01,  7.4733676806240401e-01,  8.2792243329647475e-01,
    9.0205912089860940e-01,  9.3482618705297282e-01,  -9.1074450619015845e-01,
    -8.8429650169106433e-01, -8.1152289564182456e-01, -7.3529852467074075e-01,
    -6.2928912361282208e-01, -5.2181900667354353e-01, -3.9618395777095999e-01,
    -2.6995141957663576e-01, -1.3505625510836489e-01, 0.0000000000000000e+00,
    1.3505625510836505e-01,  2.6995141957663576e-01,  3.9618395777095999e-01,
    5.2181900667354331e-01,  6.2928912361282208e-01,  7.3529852467074086e-01,
    8.1152289564182456e-01,  8.8429650169106433e-01,  9.1074450619015834e-01,
    -8.6210592655069052e-01, -7.9139499345478237e-01, -7.2032282942027204e-01,
    -6.1607133981999151e-01, -5.1245161444614085e-01, -3.8863324930985499e-01,
    -2.6542732392712320e-01, -1.3259621348252737e-01, 0.0000000000000000e+00,
    1.3259621348252754e-01,  2.6542732392712320e-01,  3.8863324930985499e-01,
    5.1245161444614062e-01,  6.1607133981999151e-01,  7.2032282942027215e-01,
    7.9139499345478237e-01,  8.6210592655069052e-01,  -8.3513450094501673e-01,
    -7.6724535325980669e-01, -7.0222177373044592e-01, -6.0028285513817525e-01,
    -5.0116106060544119e-01, -3.7963432698087546e-01, -2.5998192661566422e-01,
    -1.2966719032551594e-01, 0.0000000000000000e+00,  1.2966719032551607e-01,
    2.5998192661566422e-01,  3.7963432698087546e-01,  5.0116106060544097e-01,
    6.0028285513817525e-01,  7.0222177373044614e-01,  7.6724535325980669e-01,
    8.3513450094501673e-01,  -8.0290056739774962e-01, -7.3867963248711765e-01,
    -6.8074609299965194e-01, -5.8171439072203968e-01, -4.8781382748125035e-01,
    -3.6908127513370420e-01, -2.5355587662382567e-01, -1.2623654500549572e-01,
    0.0000000000000000e+00,  1.2623654500549589e-01,  2.5355587662382567e-01,
    3.6908127513370420e-01,  4.8781382748125024e-01,  5.8171439072203968e-01,
    6.8074609299965205e-01,  7.3867963248711765e-01,  8.0290056739774962e-01,
    -7.0516135580653327e-01, -6.5556422224180078e-01, -5.6008952351246721e-01,
    -4.7223555773857756e-01, -3.5683623521922797e-01, -2.4607235825701007e-01,
    -1.2226205860338232e-01, 0.0000000000000000e+00,  1.2226205860338248e-01,
    2.4607235825701007e-01,  3.5683623521922797e-01,  4.7223555773857739e-01,
    5.6008952351246721e-01,  6.5556422224180078e-01,  7.0516135580653327e-01,
    -6.2622922204952469e-01, -5.3503778567383953e-01, -4.5419674569446861e-01,
    -3.4271789500339139e-01, -2.3743140261949641e-01, -1.1768864551837875e-01,
    0.0000000000000000e+00,  1.1768864551837889e-01,  2.3743140261949641e-01,
    3.4271789500339139e-01,  4.5419674569446850e-01,  5.3503778567383953e-01,
    6.2622922204952469e-01,  -5.0605049710887806e-01, -4.3339025796878267e-01,
    -3.2648331967298327e-01, -2.2750116247079261e-01, -1.1244324890790776e-01,
    0.0000000000000000e+00,  1.1244324890790788e-01,  2.2750116247079261e-01,
    3.2648331967298327e-01,  4.3339025796878256e-01,  5.0605049710887806e-01,
    -4.0939433032355521e-01, -3.0779783328158689e-01, -2.1610397827265473e-01,
    -1.0642655588236502e-01, 0.0000000000000000e+00,  1.0642655588236513e-01,
    2.1610397827265473e-01,  3.0779783328158689e-01,  4.0939433032355516e-01,
    -2.0299291231217795e-01, 0.0000000000000000e+00,  2.0299291231217795e-01
};
const float hammerAitovSampleVertices[852] = {
    9.6296205447948291e-01,  0.0000000000000000e+00,  -9.2592592592592604e-01,
    -3.0000000000000004e-01, -9.6164021164021185e-01, -1.9999999999999996e-01,
    -9.2592592592592615e-01, -9.9999999999999978e-02, -9.6164021164021163e-01,
    0.0000000000000000e+00,  -9.2592592592592604e-01, 1.0000000000000009e-01,
    -9.6164021164021185e-01, 1.9999999999999996e-01,  -9.2592592592592604e-01,
    3.0000000000000004e-01,  -8.5185185185185197e-01, -5.0000000000000000e-01,
    -8.8756613756613767e-01, -4.0000000000000008e-01, -8.5185185185185197e-01,
    -3.0000000000000010e-01, -8.8756613756613745e-01, -1.9999999999999996e-01,
    -8.5185185185185208e-01, -9.9999999999999978e-02, -8.8756613756613756e-01,
    0.0000000000000000e+00,  -8.5185185185185208e-01, 1.0000000000000009e-01,
    -8.8756613756613745e-01, 1.9999999999999996e-01,  -8.5185185185185197e-01,
    3.0000000000000010e-01,  -8.8756613756613756e-01, 3.9999999999999986e-01,
    -8.5185185185185197e-01, 5.0000000000000000e-01,  -7.7777777777777790e-01,
    -5.0000000000000011e-01, -8.1349206349206338e-01, -4.0000000000000008e-01,
    -7.7777777777777790e-01, -3.0000000000000004e-01, -8.1349206349206349e-01,
    -1.9999999999999996e-01, -7.7777777777777768e-01, -9.9999999999999964e-02,
    -8.1349206349206360e-01, 0.0000000000000000e+00,  -7.7777777777777768e-01,
    1.0000000000000009e-01,  -8.1349206349206349e-01, 1.9999999999999996e-01,
    -7.7777777777777790e-01, 3.0000000000000004e-01,  -8.1349206349206349e-01,
    3.9999999999999991e-01,  -7.7777777777777790e-01, 5.0000000000000011e-01,
    -7.0370370370370350e-01, -6.9999999999999996e-01, -7.3941798941798942e-01,
    -6.0000000000000009e-01, -7.0370370370370350e-01, -5.0000000000000000e-01,
    -7.3941798941798953e-01, -4.0000000000000008e-01, -7.0370370370370350e-01,
    -3.0000000000000010e-01, -7.3941798941798942e-01, -1.9999999999999998e-01,
    -7.0370370370370372e-01, -9.9999999999999978e-02, -7.3941798941798942e-01,
    0.0000000000000000e+00,  -7.0370370370370372e-01, 1.0000000000000010e-01,
    -7.3941798941798942e-01, 1.9999999999999998e-01,  -7.0370370370370350e-01,
    3.0000000000000010e-01,  -7.3941798941798920e-01, 3.9999999999999986e-01,
    -7.0370370370370350e-01, 5.0000000000000000e-01,  -7.3941798941798964e-01,
    6.0000000000000020e-01,  -7.0370370370370350e-01, 6.9999999999999996e-01,
    -6.2962962962962965e-01, -7.0000000000000007e-01, -6.6534391534391535e-01,
    -6.0000000000000009e-01, -6.2962962962962976e-01, -5.0000000000000000e-01,
    -6.6534391534391546e-01, -4.0000000000000002e-01, -6.2962962962962976e-01,
    -3.0000000000000010e-01, -6.6534391534391557e-01, -1.9999999999999998e-01,
    -6.2962962962962965e-01, -9.9999999999999978e-02, -6.6534391534391546e-01,
    0.0000000000000000e+00,  -6.2962962962962965e-01, 1.0000000000000012e-01,
    -6.6534391534391557e-01, 1.9999999999999998e-01,  -6.2962962962962976e-01,
    3.0000000000000010e-01,  -6.6534391534391557e-01, 3.9999999999999991e-01,
    -6.2962962962962976e-01, 5.0000000000000000e-01,  -6.6534391534391557e-01,
    6.0000000000000020e-01,  -6.2962962962962965e-01, 7.0000000000000007e-01,
    -5.9126984126984128e-01, -8.0000000000000016e-01, -5.5555555555555558e-01,
    -7.0000000000000007e-01, -5.9126984126984117e-01, -6.0000000000000009e-01,
    -5.5555555555555569e-01, -5.0000000000000000e-01, -5.9126984126984150e-01,
    -3.9999999999999997e-01, -5.5555555555555580e-01, -3.0000000000000010e-01,
    -5.9126984126984139e-01, -1.9999999999999993e-01, -5.5555555555555558e-01,
    -9.9999999999999978e-02, -5.9126984126984128e-01, 0.0000000000000000e+00,
    -5.5555555555555558e-01, 1.0000000000000007e-01,  -5.9126984126984139e-01,
    1.9999999999999993e-01,  -5.5555555555555580e-01, 3.0000000000000010e-01,
    -5.9126984126984139e-01, 3.9999999999999986e-01,  -5.5555555555555569e-01,
    5.0000000000000000e-01,  -5.9126984126984150e-01, 6.0000000000000020e-01,
    -5.5555555555555558e-01, 7.0000000000000007e-01,  -5.9126984126984128e-01,
    8.0000000000000016e-01,  -5.1719576719576688e-01, -8.0000000000000016e-01,
    -4.8148148148148145e-01, -7.0000000000000007e-01, -5.1719576719576710e-01,
    -6.0000000000000009e-01, -4.8148148148148157e-01, -5.0000000000000000e-01,
    -5.1719576719576721e-01, -4.0000000000000008e-01, -4.8148148148148140e-01,
    -3.0000000000000010e-01, -5.1719576719576710e-01, -1.9999999999999998e-01,
    -4.8148148148148140e-01, -9.9999999999999978e-02, -5.1719576719576721e-01,
    0.0000000000000000e+00,  -4.8148148148148140e-01, 1.0000000000000010e-01,
    -5.1719576719576710e-01, 1.9999999999999998e-01,  -4.8148148148148140e-01,
    3.0000000000000010e-01,  -5.1719576719576721e-01, 3.9999999999999986e-01,
    -4.8148148148148157e-01, 5.0000000000000000e-01,  -5.1719576719576710e-01,
    6.0000000000000020e-01,  -4.8148148148148145e-01, 7.0000000000000007e-01,
    -5.1719576719576688e-01, 8.0000000000000016e-01,  -4.0740740740740744e-01,
    -9.0000000000000002e-01, -4.4312169312169292e-01, -8.0000000000000016e-01,
    -4.0740740740740755e-01, -7.0000000000000007e-01, -4.4312169312169325e-01,
    -5.9999999999999998e-01, -4.0740740740740744e-01, -5.0000000000000000e-01,
    -4.4312169312169325e-01, -4.0000000000000002e-01, -4.0740740740740738e-01,
    -3.0000000000000010e-01, -4.4312169312169319e-01, -1.9999999999999993e-01,
    -4.0740740740740761e-01, -9.9999999999999978e-02, -4.4312169312169319e-01,
    0.0000000000000000e+00,  -4.0740740740740750e-01, 1.0000000000000010e-01,
    -4.4312169312169319e-01, 1.9999999999999993e-01,  -4.0740740740740738e-01,
    3.0000000000000010e-01,  -4.4312169312169308e-01, 3.9999999999999991e-01,
    -4.0740740740740744e-01, 5.0000000000000000e-01,  -4.4312169312169325e-01,
    6.0000000000000009e-01,  -4.0740740740740755e-01, 7.0000000000000007e-01,
    -4.4312169312169292e-01, 8.0000000000000016e-01,  -4.0740740740740766e-01,
    8.9999999999999991e-01,  -3.3333333333333348e-01, -9.0000000000000013e-01,
    -3.6904761904761890e-01, -8.0000000000000027e-01, -3.3333333333333320e-01,
    -7.0000000000000007e-01, -3.6904761904761896e-01, -5.9999999999999998e-01,
    -3.3333333333333337e-01, -5.0000000000000000e-01, -3.6904761904761918e-01,
    -4.0000000000000008e-01, -3.3333333333333337e-01, -3.0000000000000004e-01,
    -3.6904761904761918e-01, -1.9999999999999996e-01, -3.3333333333333348e-01,
    -9.9999999999999978e-02, -3.6904761904761907e-01, 0.0000000000000000e+00,
    -3.3333333333333348e-01, 1.0000000000000010e-01,  -3.6904761904761918e-01,
    1.9999999999999996e-01,  -3.3333333333333337e-01, 3.0000000000000004e-01,
    -3.6904761904761918e-01, 3.9999999999999980e-01,  -3.3333333333333337e-01,
    5.0000000000000000e-01,  -3.6904761904761935e-01, 6.0000000000000009e-01,
    -3.3333333333333320e-01, 7.0000000000000007e-01,  -3.6904761904761890e-01,
    8.0000000000000027e-01,  -3.3333333333333381e-01, 9.0000000000000002e-01,
    -2.5925925925925952e-01, -8.9999999999999991e-01, -2.9497354497354517e-01,
    -8.0000000000000016e-01, -2.5925925925925936e-01, -6.9999999999999996e-01,
    -2.9497354497354511e-01, -5.9999999999999987e-01, -2.5925925925925941e-01,
    -5.0000000000000000e-01, -2.9497354497354500e-01, -4.0000000000000002e-01,
    -2.5925925925925936e-01, -3.0000000000000004e-01, -2.9497354497354500e-01,
    -1.9999999999999996e-01, -2.5925925925925924e-01, -9.9999999999999978e-02,
    -2.9497354497354500e-01, 0.0000000000000000e+00,  -2.5925925925925924e-01,
    1.0000000000000010e-01,  -2.9497354497354500e-01, 1.9999999999999996e-01,
    -2.5925925925925936e-01, 3.0000000000000004e-01,  -2.9497354497354505e-01,
    3.9999999999999997e-01,  -2.5925925925925941e-01, 5.0000000000000000e-01,
    -2.9497354497354511e-01, 6.0000000000000020e-01,  -2.5925925925925936e-01,
    6.9999999999999996e-01,  -2.9497354497354517e-01, 8.0000000000000016e-01,
    -2.5925925925925969e-01, 8.9999999999999980e-01,  -1.8518518518518509e-01,
    -9.0000000000000013e-01, -2.2089947089947121e-01, -8.0000000000000016e-01,
    -1.8518518518518520e-01, -7.0000000000000007e-01, -2.2089947089947107e-01,
    -5.9999999999999987e-01, -1.8518518518518526e-01, -5.0000000000000011e-01,
    -2.2089947089947101e-01, -4.0000000000000008e-01, -1.8518518518518526e-01,
    -3.0000000000000010e-01, -2.2089947089947096e-01, -1.9999999999999996e-01,
    -1.8518518518518529e-01, -9.9999999999999978e-02, -2.2089947089947098e-01,
    0.0000000000000000e+00,  -1.8518518518518529e-01, 1.0000000000000009e-01,
    -2.2089947089947096e-01, 1.9999999999999996e-01,  -1.8518518518518526e-01,
    3.0000000000000010e-01,  -2.2089947089947107e-01, 3.9999999999999991e-01,
    -1.8518518518518526e-01, 5.0000000000000011e-01,  -2.2089947089947098e-01,
    6.0000000000000020e-01,  -1.8518518518518520e-01, 7.0000000000000007e-01,
    -2.2089947089947121e-01, 8.0000000000000016e-01,  -1.8518518518518517e-01,
    8.9999999999999980e-01,  -1.1111111111111098e-01, -9.0000000000000036e-01,
    -1.4682539682539689e-01, -8.0000000000000004e-01, -1.1111111111111108e-01,
    -7.0000000000000018e-01, -1.4682539682539686e-01, -5.9999999999999998e-01,
    -1.1111111111111117e-01, -5.0000000000000011e-01, -1.4682539682539689e-01,
    -4.0000000000000008e-01, -1.1111111111111116e-01, -3.0000000000000010e-01,
    -1.4682539682539683e-01, -1.9999999999999996e-01, -1.1111111111111119e-01,
    -9.9999999999999978e-02, -1.4682539682539689e-01, 0.0000000000000000e+00,
    -1.1111111111111119e-01, 1.0000000000000009e-01,  -1.4682539682539683e-01,
    1.9999999999999996e-01,  -1.1111111111111116e-01, 3.0000000000000010e-01,
    -1.4682539682539686e-01, 4.0000000000000002e-01,  -1.1111111111111117e-01,
    5.0000000000000011e-01,  -1.4682539682539680e-01, 6.0000000000000009e-01,
    -1.1111111111111108e-01, 7.0000000000000018e-01,  -1.4682539682539689e-01,
    8.0000000000000004e-01,  -1.1111111111111148e-01, 8.9999999999999980e-01,
    -3.7037037037036979e-02, -9.0000000000000036e-01, -7.2751322751322886e-02,
    -8.0000000000000004e-01, -3.7037037037037090e-02, -6.9999999999999996e-01,
    -7.2751322751322858e-02, -5.9999999999999998e-01, -3.7037037037037084e-02,
    -5.0000000000000011e-01, -7.2751322751322817e-02, -4.0000000000000008e-01,
    -3.7037037037037084e-02, -3.0000000000000010e-01, -7.2751322751322817e-02,
    -1.9999999999999996e-01, -3.7037037037037104e-02, -9.9999999999999978e-02,
    -7.2751322751322817e-02, 0.0000000000000000e+00,  -3.7037037037037097e-02,
    1.0000000000000010e-01,  -7.2751322751322817e-02, 1.9999999999999996e-01,
    -3.7037037037037084e-02, 3.0000000000000010e-01,  -7.2751322751322831e-02,
    3.9999999999999991e-01,  -3.7037037037037084e-02, 5.0000000000000011e-01,
    -7.2751322751322817e-02, 6.0000000000000020e-01,  -3.7037037037037090e-02,
    6.9999999999999996e-01,  -7.2751322751322886e-02, 8.0000000000000004e-01,
    -3.7037037037037174e-02, 8.9999999999999969e-01,  -1.3227490084659948e-03,
    -9.9999825033046841e-01, 3.7037037037036862e-02,  -9.0000000000000036e-01,
    1.3227513227512676e-03,  -8.0000000000000016e-01, 3.7037037037036979e-02,
    -6.9999999999999996e-01, 1.3227513227512665e-03,  -6.0000000000000009e-01,
    3.7037037037036973e-02,  -5.0000000000000011e-01, 1.3227513227512676e-03,
    -4.0000000000000008e-01, 3.7037037037036973e-02,  -3.0000000000000010e-01,
    1.3227513227512672e-03,  -1.9999999999999996e-01, 3.7037037037036993e-02,
    -9.9999999999999978e-02, 1.3227513227512674e-03,  0.0000000000000000e+00,
    3.7037037037036986e-02,  1.0000000000000010e-01,  1.3227513227512672e-03,
    1.9999999999999996e-01,  3.7037037037036973e-02,  3.0000000000000010e-01,
    1.3227513227512672e-03,  4.0000000000000002e-01,  3.7037037037036973e-02,
    5.0000000000000011e-01,  1.3227513227512680e-03,  6.0000000000000009e-01,
    3.7037037037036979e-02,  6.9999999999999996e-01,  1.3227513227512676e-03,
    8.0000000000000016e-01,  3.7037037037037063e-02,  8.9999999999999969e-01,
    -1.3227490084659948e-03, 9.9999825033046841e-01,  1.1111111111111098e-01,
    -9.0000000000000036e-01, 7.5396825396825462e-02,  -8.0000000000000016e-01,
    1.1111111111111108e-01,  -7.0000000000000018e-01, 7.5396825396825462e-02,
    -6.0000000000000009e-01, 1.1111111111111117e-01,  -5.0000000000000011e-01,
    7.5396825396825434e-02,  -4.0000000000000008e-01, 1.1111111111111116e-01,
    -3.0000000000000010e-01, 7.5396825396825462e-02,  -1.9999999999999996e-01,
    1.1111111111111119e-01,  -9.9999999999999978e-02, 7.5396825396825434e-02,
    0.0000000000000000e+00,  1.1111111111111119e-01,  1.0000000000000009e-01,
    7.5396825396825462e-02,  1.9999999999999996e-01,  1.1111111111111116e-01,
    3.0000000000000010e-01,  7.5396825396825448e-02,  3.9999999999999991e-01,
    1.1111111111111117e-01,  5.0000000000000011e-01,  7.5396825396825420e-02,
    6.0000000000000020e-01,  1.1111111111111108e-01,  7.0000000000000018e-01,
    7.5396825396825462e-02,  8.0000000000000016e-01,  1.1111111111111148e-01,
    8.9999999999999980e-01,  1.8518518518518504e-01,  -9.0000000000000013e-01,
    1.4947089947089945e-01,  -8.0000000000000016e-01, 1.8518518518518512e-01,
    -7.0000000000000007e-01, 1.4947089947089948e-01,  -6.0000000000000009e-01,
    1.8518518518518515e-01,  -5.0000000000000011e-01, 1.4947089947089942e-01,
    -4.0000000000000002e-01, 1.8518518518518512e-01,  -3.0000000000000010e-01,
    1.4947089947089939e-01,  -1.9999999999999996e-01, 1.8518518518518517e-01,
    -9.9999999999999978e-02, 1.4947089947089939e-01,  0.0000000000000000e+00,
    1.8518518518518517e-01,  1.0000000000000009e-01,  1.4947089947089939e-01,
    1.9999999999999996e-01,  1.8518518518518512e-01,  3.0000000000000010e-01,
    1.4947089947089939e-01,  3.9999999999999997e-01,  1.8518518518518515e-01,
    5.0000000000000011e-01,  1.4947089947089942e-01,  6.0000000000000020e-01,
    1.8518518518518512e-01,  7.0000000000000007e-01,  1.4947089947089945e-01,
    8.0000000000000016e-01,  1.8518518518518515e-01,  8.9999999999999980e-01,
    2.5925925925925952e-01,  -8.9999999999999991e-01, 2.2354497354497380e-01,
    -7.9999999999999993e-01, 2.5925925925925936e-01,  -6.9999999999999996e-01,
    2.2354497354497360e-01,  -6.0000000000000009e-01, 2.5925925925925941e-01,
    -5.0000000000000000e-01, 2.2354497354497360e-01,  -4.0000000000000008e-01,
    2.5925925925925936e-01,  -3.0000000000000004e-01, 2.2354497354497352e-01,
    -1.9999999999999998e-01, 2.5925925925925924e-01,  -9.9999999999999978e-02,
    2.2354497354497366e-01,  0.0000000000000000e+00,  2.5925925925925924e-01,
    1.0000000000000010e-01,  2.2354497354497352e-01,  1.9999999999999998e-01,
    2.5925925925925936e-01,  3.0000000000000004e-01,  2.2354497354497366e-01,
    3.9999999999999991e-01,  2.5925925925925941e-01,  5.0000000000000000e-01,
    2.2354497354497352e-01,  6.0000000000000020e-01,  2.5925925925925936e-01,
    6.9999999999999996e-01,  2.2354497354497380e-01,  7.9999999999999993e-01,
    2.5925925925925969e-01,  8.9999999999999980e-01,  3.3333333333333348e-01,
    -9.0000000000000013e-01, 2.9761904761904773e-01,  -8.0000000000000016e-01,
    3.3333333333333320e-01,  -7.0000000000000007e-01, 2.9761904761904767e-01,
    -5.9999999999999998e-01, 3.3333333333333337e-01,  -5.0000000000000000e-01,
    2.9761904761904762e-01,  -4.0000000000000002e-01, 3.3333333333333331e-01,
    -3.0000000000000004e-01, 2.9761904761904756e-01,  -1.9999999999999996e-01,
    3.3333333333333337e-01,  -9.9999999999999978e-02, 2.9761904761904756e-01,
    0.0000000000000000e+00,  3.3333333333333337e-01,  1.0000000000000010e-01,
    2.9761904761904756e-01,  1.9999999999999996e-01,  3.3333333333333331e-01,
    3.0000000000000004e-01,  2.9761904761904756e-01,  3.9999999999999997e-01,
    3.3333333333333337e-01,  5.0000000000000000e-01,  2.9761904761904762e-01,
    6.0000000000000020e-01,  3.3333333333333320e-01,  7.0000000000000007e-01,
    2.9761904761904773e-01,  8.0000000000000016e-01,  3.3333333333333381e-01,
    9.0000000000000002e-01,  4.0740740740740744e-01,  -9.0000000000000002e-01,
    3.7169312169312152e-01,  -8.0000000000000038e-01, 4.0740740740740755e-01,
    -7.0000000000000007e-01, 3.7169312169312180e-01,  -5.9999999999999987e-01,
    4.0740740740740744e-01,  -5.0000000000000000e-01, 3.7169312169312174e-01,
    -4.0000000000000008e-01, 4.0740740740740738e-01,  -3.0000000000000010e-01,
    3.7169312169312169e-01,  -1.9999999999999996e-01, 4.0740740740740761e-01,
    -9.9999999999999978e-02, 3.7169312169312180e-01,  0.0000000000000000e+00,
    4.0740740740740750e-01,  1.0000000000000010e-01,  3.7169312169312169e-01,
    1.9999999999999996e-01,  4.0740740740740738e-01,  3.0000000000000010e-01,
    3.7169312169312158e-01,  3.9999999999999986e-01,  4.0740740740740744e-01,
    5.0000000000000000e-01,  3.7169312169312180e-01,  6.0000000000000009e-01,
    4.0740740740740755e-01,  7.0000000000000007e-01,  3.7169312169312152e-01,
    8.0000000000000038e-01,  4.0740740740740766e-01,  8.9999999999999991e-01,
    4.4576719576719553e-01,  -8.0000000000000004e-01, 4.8148148148148145e-01,
    -7.0000000000000007e-01, 4.4576719576719553e-01,  -5.9999999999999998e-01,
    4.8148148148148145e-01,  -5.0000000000000000e-01, 4.4576719576719570e-01,
    -4.0000000000000008e-01, 4.8148148148148134e-01,  -3.0000000000000010e-01,
    4.4576719576719581e-01,  -1.9999999999999996e-01, 4.8148148148148140e-01,
    -9.9999999999999978e-02, 4.4576719576719581e-01,  0.0000000000000000e+00,
    4.8148148148148140e-01,  1.0000000000000010e-01,  4.4576719576719581e-01,
    1.9999999999999996e-01,  4.8148148148148134e-01,  3.0000000000000010e-01,
    4.4576719576719565e-01,  3.9999999999999986e-01,  4.8148148148148145e-01,
    5.0000000000000000e-01,  4.4576719576719570e-01,  6.0000000000000020e-01,
    4.8148148148148145e-01,  7.0000000000000007e-01,  4.4576719576719553e-01,
    8.0000000000000004e-01,  5.1984126984127010e-01,  -8.0000000000000004e-01,
    5.5555555555555558e-01,  -7.0000000000000007e-01, 5.1984126984127010e-01,
    -5.9999999999999987e-01, 5.5555555555555569e-01,  -5.0000000000000000e-01,
    5.1984126984126988e-01,  -4.0000000000000013e-01, 5.5555555555555580e-01,
    -3.0000000000000010e-01, 5.1984126984126988e-01,  -1.9999999999999996e-01,
    5.5555555555555558e-01,  -9.9999999999999978e-02, 5.1984126984126988e-01,
    0.0000000000000000e+00,  5.5555555555555558e-01,  1.0000000000000007e-01,
    5.1984126984126988e-01,  1.9999999999999996e-01,  5.5555555555555580e-01,
    3.0000000000000010e-01,  5.1984126984126999e-01,  3.9999999999999997e-01,
    5.5555555555555569e-01,  5.0000000000000000e-01,  5.1984126984126988e-01,
    6.0000000000000009e-01,  5.5555555555555558e-01,  7.0000000000000007e-01,
    5.1984126984127010e-01,  8.0000000000000004e-01,  5.9391534391534351e-01,
    -8.0000000000000004e-01, 6.2962962962962965e-01,  -7.0000000000000007e-01,
    5.9391534391534384e-01,  -5.9999999999999998e-01, 6.2962962962962965e-01,
    -5.0000000000000000e-01, 5.9391534391534395e-01,  -4.0000000000000008e-01,
    6.2962962962962976e-01,  -3.0000000000000010e-01, 5.9391534391534395e-01,
    -1.9999999999999993e-01, 6.2962962962962954e-01,  -9.9999999999999978e-02,
    5.9391534391534384e-01,  0.0000000000000000e+00,  6.2962962962962954e-01,
    1.0000000000000012e-01,  5.9391534391534395e-01,  1.9999999999999993e-01,
    6.2962962962962976e-01,  3.0000000000000010e-01,  5.9391534391534373e-01,
    3.9999999999999991e-01,  6.2962962962962965e-01,  5.0000000000000000e-01,
    5.9391534391534384e-01,  6.0000000000000009e-01,  6.2962962962962965e-01,
    7.0000000000000007e-01,  5.9391534391534351e-01,  8.0000000000000004e-01,
    7.0370370370370350e-01,  -6.9999999999999996e-01, 6.6798941798941802e-01,
    -6.0000000000000009e-01, 7.0370370370370350e-01,  -5.0000000000000000e-01,
    6.6798941798941813e-01,  -4.0000000000000002e-01, 7.0370370370370350e-01,
    -3.0000000000000010e-01, 6.6798941798941813e-01,  -1.9999999999999996e-01,
    7.0370370370370372e-01,  -9.9999999999999978e-02, 6.6798941798941802e-01,
    0.0000000000000000e+00,  7.0370370370370372e-01,  1.0000000000000010e-01,
    6.6798941798941813e-01,  1.9999999999999996e-01,  7.0370370370370350e-01,
    3.0000000000000010e-01,  6.6798941798941824e-01,  3.9999999999999991e-01,
    7.0370370370370350e-01,  5.0000000000000000e-01,  6.6798941798941813e-01,
    6.0000000000000020e-01,  7.0370370370370350e-01,  6.9999999999999996e-01,
    7.4206349206349209e-01,  -6.0000000000000009e-01, 7.7777777777777768e-01,
    -5.0000000000000000e-01, 7.4206349206349209e-01,  -4.0000000000000008e-01,
    7.7777777777777757e-01,  -3.0000000000000004e-01, 7.4206349206349209e-01,
    -1.9999999999999998e-01, 7.7777777777777768e-01,  -9.9999999999999964e-02,
    7.4206349206349198e-01,  0.0000000000000000e+00,  7.7777777777777768e-01,
    1.0000000000000009e-01,  7.4206349206349209e-01,  1.9999999999999998e-01,
    7.7777777777777757e-01,  3.0000000000000004e-01,  7.4206349206349176e-01,
    3.9999999999999991e-01,  7.7777777777777768e-01,  5.0000000000000000e-01,
    7.4206349206349209e-01,  6.0000000000000009e-01,  8.5185185185185197e-01,
    -5.0000000000000000e-01, 8.1613756613756627e-01,  -4.0000000000000008e-01,
    8.5185185185185197e-01,  -3.0000000000000010e-01, 8.1613756613756627e-01,
    -1.9999999999999998e-01, 8.5185185185185208e-01,  -9.9999999999999978e-02,
    8.1613756613756594e-01,  0.0000000000000000e+00,  8.5185185185185208e-01,
    1.0000000000000009e-01,  8.1613756613756627e-01,  1.9999999999999998e-01,
    8.5185185185185197e-01,  3.0000000000000010e-01,  8.1613756613756605e-01,
    3.9999999999999991e-01,  8.5185185185185197e-01,  5.0000000000000000e-01,
    8.9021164021164012e-01,  -4.0000000000000002e-01, 9.2592592592592604e-01,
    -3.0000000000000010e-01, 8.9021164021164012e-01,  -1.9999999999999996e-01,
    9.2592592592592615e-01,  -9.9999999999999992e-02, 8.9021164021164023e-01,
    0.0000000000000000e+00,  9.2592592592592604e-01,  1.0000000000000010e-01,
    8.9021164021164012e-01,  1.9999999999999996e-01,  9.2592592592592604e-01,
    3.0000000000000010e-01,  8.9021164021164012e-01,  3.9999999999999997e-01,
    9.6428571428571441e-01,  -1.9999999999999996e-01, 9.6428571428571430e-01,
    0.0000000000000000e+00,  9.6428571428571441e-01,  1.9999999999999996e-01
};
const int hammerAitovSampleIndices[2472] = {
    137, 118, 117, 322, 303, 302, 5,   13,  14,  379, 363, 378, 391, 390, 403, 397, 398, 383, 49,
    34,  48,  164, 145, 144, 32,  19,  31,  218, 219, 199, 141, 122, 121, 3,   11,  12,  12,  13,
    3,   24,  23,  37,  258, 276, 277, 5,   6,   4,   16,  26,  27,  16,  27,  28,  89,  73,  72,
    131, 228, 112, 54,  55,  40,  25,  38,  39,  82,  100, 101, 241, 221, 240, 161, 180, 181, 105,
    124, 106, 169, 187, 188, 206, 205, 226, 387, 388, 371, 158, 159, 140, 338, 319, 337, 367, 383,
    384, 332, 331, 349, 406, 394, 393, 383, 382, 396, 292, 312, 293, 210, 230, 211, 116, 135, 117,
    248, 249, 229, 254, 272, 273, 275, 256, 274, 378, 362, 361, 30,  31,  8,   119, 100, 118, 30,
    46,  31,  138, 137, 156, 64,  47,  63,  173, 172, 192, 77,  61,  60,  62,  45,  61,  79,  78,
    97,  232, 231, 251, 191, 210, 211, 95,  114, 96,  133, 113, 132, 173, 154, 153, 230, 229, 249,
    134, 115, 133, 133, 114, 113, 172, 190, 191, 171, 152, 151, 154, 134, 153, 235, 236, 215, 213,
    214, 193, 252, 270, 271, 175, 157, 156, 176, 194, 195, 81,  99,  82,  117, 98,  116, 121, 139,
    140, 179, 180, 161, 34,  50,  35,  47,  46,  62,  19,  33,  20,  1,   10,  11,  21,  33,  34,
    9,   1,   8,   35,  50,  36,  23,  35,  36,  37,  36,  52,  83,  66,  65,  141, 140, 160, 177,
    157, 176, 87,  70,  69,  24,  14,  13,  53,  38,  52,  26,  14,  25,  40,  55,  56,  54,  38,
    53,  16,  28,  17,  26,  16,  15,  28,  41,  29,  91,  75,  74,  187, 206, 188, 90,  109, 91,
    42,  29,  41,  128, 127, 147, 72,  56,  55,  129, 110, 128, 317, 298, 316, 130, 149, 131, 185,
    166, 165, 148, 167, 168, 186, 205, 206, 226, 205, 225, 183, 164, 163, 186, 167, 185, 181, 182,
    163, 199, 200, 180, 144, 125, 143, 182, 183, 163, 73,  91,  74,  104, 124, 105, 196, 177, 176,
    140, 159, 160, 234, 215, 214, 220, 200, 199, 180, 179, 198, 240, 219, 239, 197, 198, 178, 335,
    317, 334, 294, 314, 295, 337, 336, 353, 260, 280, 261, 352, 370, 353, 318, 319, 300, 321, 339,
    340, 260, 279, 280, 301, 302, 283, 224, 204, 203, 244, 225, 224, 205, 204, 224, 188, 207, 228,
    246, 225, 245, 265, 245, 264, 247, 228, 227, 354, 372, 355, 322, 304, 303, 356, 355, 372, 386,
    371, 370, 323, 322, 340, 302, 301, 320, 357, 356, 374, 371, 354, 370, 372, 388, 373, 372, 354,
    371, 373, 388, 389, 397, 410, 398, 335, 353, 336, 330, 312, 311, 350, 333, 349, 296, 277, 295,
    331, 313, 330, 410, 409, 420, 366, 365, 382, 405, 414, 415, 420, 419, 425, 418, 417, 0,   424,
    423, 425, 416, 415, 423, 364, 380, 365, 345, 329, 328, 365, 381, 382, 332, 333, 315, 418, 408,
    407, 396, 382, 381, 365, 366, 348, 366, 350, 349, 198, 179, 178, 274, 254, 273, 257, 238, 237,
    195, 194, 214, 293, 275, 274, 255, 235, 254, 290, 289, 308, 288, 287, 306, 233, 252, 253, 290,
    308, 309, 232, 212, 211, 231, 250, 251, 287, 268, 267, 229, 208, 248, 268, 250, 249, 270, 251,
    250, 308, 289, 288, 287, 269, 268, 307, 308, 288, 267, 208, 286, 307, 325, 326, 289, 270, 269,
    405, 393, 404, 392, 379, 378, 359, 358, 375, 290, 310, 291, 360, 342, 359, 286, 287, 267, 95,
    96,  78,  77,  95,  78,  45,  46,  30,  63,  62,  79,  45,  60,  61,  60,  45,  30,  47,  62,
    63,  46,  45,  62,  31,  19,  8,   31,  46,  32,  1,   9,   10,  8,   19,  20,  64,  81,  65,
    63,  80,  81,  48,  32,  47,  33,  19,  32,  81,  64,  63,  32,  46,  47,  80,  79,  97,  62,
    61,  79,  81,  80,  99,  63,  79,  80,  80,  98,  99,  116, 97,  96,  99,  98,  118, 80,  97,
    98,  97,  116, 98,  134, 133, 152, 94,  95,  77,  114, 133, 115, 97,  78,  96,  79,  61,  78,
    61,  77,  78,  60,  94,  77,  94,  114, 95,  94,  113, 114, 208, 113, 94,  152, 171, 153, 208,
    132, 113, 170, 190, 171, 96,  115, 116, 96,  114, 115, 117, 136, 137, 135, 115, 134, 132, 152,
    133, 151, 170, 171, 152, 153, 134, 172, 191, 192, 229, 209, 208, 209, 210, 189, 170, 151, 208,
    189, 170, 208, 189, 190, 170, 132, 151, 152, 132, 208, 151, 171, 172, 153, 171, 190, 172, 175,
    155, 174, 211, 231, 232, 233, 234, 213, 192, 191, 212, 174, 193, 194, 192, 212, 193, 172, 173,
    153, 192, 193, 174, 156, 155, 175, 173, 192, 174, 135, 154, 136, 173, 174, 155, 134, 154, 135,
    173, 155, 154, 115, 135, 116, 154, 155, 136, 136, 117, 135, 118, 98,  117, 156, 136, 155, 156,
    137, 136, 81,  82,  65,  99,  118, 100, 120, 100, 119, 82,  99,  100, 84,  101, 102, 101, 100,
    120, 138, 119, 137, 139, 120, 119, 157, 138, 156, 119, 118, 137, 174, 194, 175, 193, 214, 194,
    216, 195, 215, 176, 175, 194, 197, 178, 196, 158, 140, 139, 158, 138, 157, 139, 119, 138, 196,
    176, 195, 157, 175, 176, 178, 177, 196, 158, 157, 177, 216, 217, 197, 179, 160, 159, 237, 238,
    217, 218, 199, 198, 178, 159, 177, 178, 179, 159, 218, 198, 197, 199, 180, 198, 142, 143, 123,
    102, 101, 120, 159, 158, 177, 139, 138, 158, 121, 102, 120, 84,  67,  83,  86,  85,  103, 68,
    52,  51,  139, 121, 120, 140, 141, 121, 85,  67,  84,  83,  65,  82,  51,  52,  36,  68,  53,
    52,  68,  51,  67,  21,  35,  22,  51,  66,  67,  51,  36,  50,  103, 84,  102, 67,  66,  83,
    101, 83,  82,  101, 84,  83,  66,  50,  49,  48,  47,  64,  65,  49,  64,  33,  32,  48,  51,
    50,  66,  35,  23,  22,  64,  49,  48,  65,  66,  49,  21,  34,  35,  21,  20,  33,  48,  34,
    33,  49,  50,  34,  20,  9,   8,   20,  10,  9,   11,  22,  12,  11,  10,  22,  10,  21,  22,
    10,  20,  21,  11,  2,   1,   4,   3,   13,  2,   11,  3,   38,  37,  52,  23,  12,  22,  38,
    25,  37,  13,  12,  24,  37,  23,  36,  24,  12,  23,  2,   4,   6,   2,   3,   4,   13,  5,
    4,   14,  15,  5,   86,  87,  69,  71,  55,  70,  24,  25,  14,  24,  37,  25,  70,  53,  69,
    70,  54,  53,  103, 85,  84,  69,  53,  68,  121, 122, 102, 142, 141, 160, 86,  105, 87,  124,
    104, 123, 85,  68,  67,  85,  69,  68,  85,  86,  69,  122, 141, 123, 38,  54,  39,  70,  55,
    54,  88,  87,  105, 88,  71,  87,  87,  71,  70,  72,  57,  56,  56,  41,  40,  56,  42,  41,
    28,  27,  41,  39,  54,  40,  39,  27,  26,  40,  41,  27,  27,  39,  40,  26,  25,  39,  5,
    15,  6,   14,  26,  15,  15,  7,   6,   7,   16,  17,  7,   15,  16,  71,  72,  55,  57,  42,
    56,  88,  89,  71,  145, 127, 126, 58,  43,  42,  29,  18,  28,  17,  18,  7,   17,  28,  18,
    43,  29,  42,  43,  18,  29,  57,  58,  42,  44,  18,  43,  93,  76,  75,  44,  43,  58,  59,
    76,  44,  58,  59,  44,  58,  57,  74,  75,  59,  74,  59,  58,  74,  111, 93,  92,  73,  57,
    72,  109, 92,  91,  76,  59,  75,  92,  93,  75,  112, 76,  93,  91,  92,  75,  111, 112, 93,
    110, 111, 92,  129, 148, 149, 108, 109, 90,  128, 147, 129, 89,  90,  73,  145, 126, 125, 91,
    73,  90,  74,  57,  73,  71,  89,  72,  106, 125, 126, 89,  107, 90,  89,  88,  107, 107, 108,
    90,  146, 165, 166, 183, 165, 164, 166, 147, 146, 129, 147, 148, 166, 148, 147, 108, 128, 109,
    127, 146, 147, 109, 128, 110, 149, 168, 150, 109, 110, 92,  129, 130, 110, 111, 130, 112, 111,
    110, 130, 130, 131, 112, 129, 149, 130, 148, 168, 149, 149, 150, 131, 168, 187, 169, 150, 169,
    228, 150, 168, 169, 169, 188, 228, 303, 284, 283, 150, 228, 131, 168, 167, 187, 167, 166, 185,
    188, 206, 207, 187, 186, 206, 203, 204, 184, 205, 186, 204, 187, 167, 186, 148, 166, 167, 184,
    185, 165, 204, 186, 185, 242, 223, 222, 204, 185, 184, 202, 203, 184, 223, 224, 203, 181, 180,
    200, 222, 203, 202, 202, 201, 222, 202, 183, 182, 163, 144, 162, 163, 164, 144, 184, 183, 202,
    184, 165, 183, 162, 181, 163, 201, 202, 182, 145, 125, 144, 164, 165, 146, 108, 127, 128, 108,
    107, 126, 88,  106, 107, 88,  105, 106, 108, 126, 127, 107, 106, 126, 146, 145, 164, 146, 127,
    145, 144, 143, 162, 104, 105, 86,  125, 124, 143, 125, 106, 124, 103, 104, 86,  123, 143, 124,
    103, 122, 104, 103, 102, 122, 122, 123, 104, 142, 160, 161, 143, 142, 162, 160, 179, 161, 141,
    142, 123, 161, 162, 142, 219, 220, 199, 201, 182, 200, 161, 181, 162, 200, 182, 181, 240, 220,
    219, 201, 200, 220, 257, 258, 239, 258, 278, 259, 259, 240, 239, 259, 241, 240, 296, 297, 277,
    241, 259, 260, 258, 259, 239, 278, 297, 279, 278, 258, 277, 257, 256, 276, 334, 316, 315, 297,
    278, 277, 315, 316, 296, 334, 317, 316, 297, 298, 279, 317, 336, 318, 278, 279, 260, 318, 336,
    319, 316, 297, 296, 316, 298, 297, 262, 280, 281, 279, 298, 299, 298, 318, 299, 298, 317, 318,
    283, 282, 301, 299, 318, 300, 261, 280, 262, 280, 299, 281, 281, 299, 300, 280, 279, 299, 223,
    242, 243, 240, 221, 220, 242, 241, 261, 259, 278, 260, 261, 241, 260, 221, 201, 220, 242, 221,
    241, 222, 201, 221, 243, 242, 261, 222, 221, 242, 263, 244, 243, 225, 205, 224, 222, 223, 203,
    243, 244, 223, 262, 263, 243, 264, 284, 265, 223, 244, 224, 263, 245, 244, 244, 245, 225, 283,
    302, 303, 265, 247, 246, 207, 206, 226, 207, 227, 228, 207, 226, 227, 226, 246, 227, 266, 228,
    247, 227, 246, 247, 226, 225, 246, 245, 265, 246, 284, 266, 265, 228, 266, 285, 247, 265, 266,
    303, 285, 284, 266, 284, 285, 228, 304, 323, 228, 285, 304, 321, 322, 302, 304, 285, 303, 340,
    322, 321, 323, 304, 322, 264, 283, 284, 301, 281, 300, 263, 264, 245, 263, 282, 264, 261, 262,
    243, 281, 282, 262, 264, 282, 283, 263, 262, 282, 281, 301, 282, 300, 319, 320, 337, 353, 354,
    336, 317, 335, 400, 401, 387, 354, 353, 370, 337, 355, 338, 372, 373, 356, 338, 320, 319, 301,
    300, 320, 336, 337, 319, 354, 355, 337, 320, 321, 302, 320, 338, 321, 356, 357, 339, 357, 323,
    340, 339, 357, 340, 374, 323, 357, 339, 338, 355, 339, 321, 338, 374, 356, 373, 339, 355, 356,
    386, 387, 371, 388, 372, 371, 373, 389, 374, 389, 402, 413, 389, 388, 402, 400, 387, 386, 402,
    388, 387, 402, 401, 413, 402, 387, 401, 401, 400, 412, 421, 425, 422, 352, 369, 370, 401, 412,
    413, 400, 385, 399, 386, 370, 369, 385, 400, 386, 412, 422, 413, 399, 412, 400, 411, 422, 412,
    411, 421, 422, 419, 418, 0,   411, 420, 421, 417, 416, 423, 421, 420, 425, 411, 399, 410, 412,
    399, 411, 385, 384, 398, 411, 410, 420, 398, 384, 383, 351, 352, 335, 369, 385, 386, 351, 335,
    334, 352, 353, 335, 333, 351, 334, 368, 369, 352, 351, 368, 352, 384, 385, 369, 399, 398, 410,
    399, 385, 398, 369, 368, 384, 351, 333, 350, 295, 314, 296, 333, 334, 315, 333, 332, 349, 315,
    296, 314, 382, 367, 366, 368, 351, 350, 348, 366, 349, 382, 383, 367, 397, 383, 396, 384, 368,
    367, 350, 367, 368, 350, 366, 367, 407, 417, 418, 419, 420, 409, 408, 397, 396, 409, 410, 397,
    409, 418, 419, 408, 396, 395, 419, 0,   424, 409, 408, 418, 409, 397, 408, 393, 394, 379, 395,
    396, 381, 395, 407, 408, 407, 395, 406, 419, 424, 425, 0,   417, 424, 407, 416, 417, 406, 395,
    394, 417, 423, 424, 415, 414, 423, 416, 405, 415, 393, 392, 404, 405, 406, 393, 395, 381, 394,
    416, 406, 405, 416, 407, 406, 345, 362, 346, 379, 394, 380, 344, 361, 362, 392, 393, 379, 345,
    346, 329, 363, 379, 380, 310, 328, 311, 331, 348, 349, 346, 347, 329, 346, 363, 364, 347, 330,
    329, 347, 348, 331, 363, 380, 364, 394, 381, 380, 347, 364, 348, 380, 381, 365, 314, 313, 332,
    330, 347, 331, 348, 364, 365, 347, 346, 364, 315, 314, 332, 295, 276, 275, 330, 313, 312, 331,
    332, 313, 293, 294, 275, 294, 295, 275, 275, 276, 256, 295, 277, 276, 313, 294, 312, 313, 314,
    294, 258, 257, 276, 239, 219, 238, 217, 238, 218, 257, 239, 238, 217, 218, 197, 238, 219, 218,
    196, 216, 197, 237, 256, 257, 236, 237, 217, 236, 255, 237, 256, 255, 274, 256, 237, 255, 195,
    216, 196, 236, 217, 216, 216, 215, 236, 195, 214, 215, 254, 235, 253, 255, 236, 235, 272, 253,
    252, 235, 215, 234, 272, 254, 253, 274, 255, 254, 310, 292, 291, 292, 293, 273, 273, 293, 274,
    312, 294, 293, 291, 292, 273, 311, 312, 292, 310, 311, 292, 329, 330, 311, 290, 309, 310, 328,
    329, 311, 326, 309, 308, 327, 328, 309, 269, 270, 250, 289, 271, 270, 291, 272, 271, 291, 273,
    272, 271, 290, 291, 271, 289, 290, 213, 234, 214, 253, 235, 234, 212, 213, 193, 233, 253, 234,
    233, 232, 251, 213, 212, 232, 232, 233, 213, 252, 271, 272, 251, 252, 233, 251, 270, 252, 267,
    268, 248, 250, 231, 249, 191, 211, 212, 191, 190, 210, 230, 210, 209, 190, 189, 210, 208, 209,
    189, 229, 230, 209, 231, 230, 249, 231, 211, 230, 248, 268, 249, 287, 288, 269, 268, 269, 250,
    288, 289, 269, 306, 287, 286, 248, 208, 267, 358, 341, 305, 305, 306, 286, 286, 208, 305, 306,
    324, 307, 306, 305, 324, 325, 341, 342, 324, 305, 341, 343, 325, 342, 341, 358, 342, 306, 307,
    288, 326, 325, 343, 324, 325, 307, 324, 341, 325, 309, 326, 327, 308, 307, 326, 309, 328, 310,
    362, 378, 363, 327, 345, 328, 327, 344, 345, 360, 344, 343, 327, 326, 343, 343, 344, 327, 344,
    360, 361, 376, 361, 360, 377, 378, 361, 346, 362, 363, 345, 344, 362, 377, 392, 378, 404, 414,
    405, 391, 377, 390, 391, 392, 377, 391, 404, 392, 391, 403, 404, 404, 403, 414, 390, 376, 375,
    377, 361, 376, 343, 342, 360, 376, 359, 375, 342, 358, 359, 377, 376, 390, 360, 359, 376, 390,
    375, 403
};

#endif
