/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (C) 2003 Conexant Americas Inc. All Rights Reserved.
 * Copyright (C) 2004, 2005, 2006 Nokia Corporation
 * Copyright 2008 Johannes Berg <johannes@sipsolutions.net>
 * Copyright 2008 Christian Lamparter <chunkeey@web.de>
 *
 * based on:
 *  - cx3110x's pda.h from Nokia
 *  - cx3110-transfer.log by Johannes Berg
 */

#ifndef P54SPI_EEPROM_H
#define P54SPI_EEPROM_H

static unsigned char p54spi_eeprom[] = {

/* struct eeprom_pda_wrap */
0x47, 0x4d, 0x55, 0xaa,	/* magic */
0x00, 0x00,		/* pad */
0x00, 0x00,		/* eeprom_pda_data_wrap length */
0x00, 0x00, 0x00, 0x00,	/* arm opcode */

/* bogus MAC address */
0x04, 0x00, 0x01, 0x01,		/* PDR_MAC_ADDRESS */
	0x00, 0x02, 0xee, 0xc0, 0xff, 0xee,

/* struct bootrec_exp_if */
0x06, 0x00, 0x01, 0x10,		/* PDR_INTERFACE_LIST */
	0x00, 0x00,			/* role */
	0x0f, 0x00,			/* if_id */
	0x85, 0x00,			/* variant = Longbow RF, 2GHz */
	0x01, 0x00,			/* btm_compat */
	0x1f, 0x00,			/* top_compat */

0x03, 0x00, 0x02, 0x10,		/* PDR_HARDWARE_PLATFORM_COMPONENT_ID */
	0x03, 0x20, 0x00, 0x43,

/* struct pda_country[6] */
0x0d, 0x00, 0x07, 0x10,		/* PDR_COUNTRY_LIST */
	0x10, 0x00, 0x00, 0x00,
	0x20, 0x00, 0x00, 0x00,
	0x30, 0x00, 0x00, 0x00,
	0x31, 0x00, 0x00, 0x00,
	0x32, 0x00, 0x00, 0x00,
	0x40, 0x00, 0x00, 0x00,

/* struct pda_country */
0x03, 0x00, 0x08, 0x10,		/* PDR_DEFAULT_COUNTRY */
	0x30, 0x00, 0x00, 0x00,		/* ETSI */

0x03, 0x00, 0x00, 0x11,		/* PDR_ANTENNA_GAIN */
	0x08, 0x08, 0x08, 0x08,

0x0a, 0x00, 0xff, 0xca,		/* PDR_RSSI_LINEAR_APPROXIMATION_CUSTOMV2 */
	0x01, 0x00, 0x0a, 0x00,
	0x00, 0x00, 0x0a, 0x00,
		0x85, 0x09, 0x0a, 0x01, 0x72, 0xfe, 0x1a, 0x00, 0x00, 0x00,

/* struct pda_custom_wrapper */
0x10, 0x06, 0x5d, 0xb0,		/* PDR_PRISM_PA_CAL_CURVE_DATA_CUSTOM */
	0x0d, 0x00, 0xee, 0x00,		/* 13 entries, 238 bytes per entry */
	0x00, 0x00, 0x16, 0x0c,		/* no offset, 3094 total len */
		/* 2412 MHz */
		0x6c, 0x09,
			0x10, 0x01, 0x9a, 0x84,
				0xaa, 0x8a, 0xaa, 0x8a, 0xaa, 0x8a, 0xaa, 0x8a,
				0x3c, 0xb6, 0x3c, 0xb6, 0x3c, 0xb6, 0x3c, 0xb6,
				0x3c, 0xb6, 0x3c, 0xb6, 0x3c, 0xb6, 0x3c, 0xb6,
			0xf0, 0x00, 0x94, 0x6c,
				0x99, 0x82, 0x99, 0x82, 0x99, 0x82, 0x99, 0x82,
				0x2b, 0xae, 0x2b, 0xae, 0x2b, 0xae, 0x2b, 0xae,
				0x2b, 0xae, 0x2b, 0xae, 0x2b, 0xae, 0x2b, 0xae,
			0xd0, 0x00, 0xaa, 0x5a,
				0x88, 0x7a, 0x88, 0x7a, 0x88, 0x7a, 0x88, 0x7a,
				0x1a, 0xa6, 0x1a, 0xa6, 0x1a, 0xa6, 0x1a, 0xa6,
				0x1a, 0xa6, 0x1a, 0xa6, 0x1a, 0xa6, 0x1a, 0xa6,
			0xa0, 0x00, 0xf3, 0x47,
				0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e,
				0x00, 0x9a, 0x00, 0x9a, 0x00, 0x9a, 0x00, 0x9a,
				0x00, 0x9a, 0x00, 0x9a, 0x00, 0x9a, 0x00, 0x9a,
			0x50, 0x00, 0x59, 0x36,
				0x43, 0x5a, 0x43, 0x5a, 0x43, 0x5a, 0x43, 0x5a,
				0xd5, 0x85, 0xd5, 0x85, 0xd5, 0x85, 0xd5, 0x85,
				0xd5, 0x85, 0xd5, 0x85, 0xd5, 0x85, 0xd5, 0x85,
			0x00, 0x00, 0xe4, 0x2d,
				0x18, 0x46, 0x18, 0x46, 0x18, 0x46, 0x18, 0x46,
				0xaa, 0x71, 0xaa, 0x71, 0xaa, 0x71, 0xaa, 0x71,
				0xaa, 0x71, 0xaa, 0x71, 0xaa, 0x71, 0xaa, 0x71,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0x80, 0x00,

		/* 2417 MHz */
		0x71, 0x09,
			0x10, 0x01, 0xb9, 0x83,
				0x7d, 0x8a, 0x7d, 0x8a, 0x7d, 0x8a, 0x7d, 0x8a,
				0x0f, 0xb6, 0x0f, 0xb6, 0x0f, 0xb6, 0x0f, 0xb6,
				0x0f, 0xb6, 0x0f, 0xb6, 0x0f, 0xb6, 0x0f, 0xb6,
			0xf0, 0x00, 0x2e, 0x6c,
				0x68, 0x82, 0x68, 0x82, 0x68, 0x82, 0x68, 0x82,
				0xfa, 0xad, 0xfa, 0xad, 0xfa, 0xad, 0xfa, 0xad,
				0xfa, 0xad, 0xfa, 0xad, 0xfa, 0xad, 0xfa, 0xad,
			0xd0, 0x00, 0x8d, 0x5a,
				0x52, 0x7a, 0x52, 0x7a, 0x52, 0x7a, 0x52, 0x7a,
				0xe4, 0xa5, 0xe4, 0xa5, 0xe4, 0xa5, 0xe4, 0xa5,
				0xe4, 0xa5, 0xe4, 0xa5, 0xe4, 0xa5, 0xe4, 0xa5,
			0xa0, 0x00, 0x0a, 0x48,
				0x32, 0x6e, 0x32, 0x6e, 0x32, 0x6e, 0x32, 0x6e,
				0xc4, 0x99, 0xc4, 0x99, 0xc4, 0x99, 0xc4, 0x99,
				0xc4, 0x99, 0xc4, 0x99, 0xc4, 0x99, 0xc4, 0x99,
			0x50, 0x00, 0x7c, 0x36,
				0xfc, 0x59, 0xfc, 0x59, 0xfc, 0x59, 0xfc, 0x59,
				0x8e, 0x85, 0x8e, 0x85, 0x8e, 0x85, 0x8e, 0x85,
				0x8e, 0x85, 0x8e, 0x85, 0x8e, 0x85, 0x8e, 0x85,
			0x00, 0x00, 0xf5, 0x2d,
				0xc6, 0x45, 0xc6, 0x45, 0xc6, 0x45, 0xc6, 0x45,
				0x58, 0x71, 0x58, 0x71, 0x58, 0x71, 0x58, 0x71,
				0x58, 0x71, 0x58, 0x71, 0x58, 0x71, 0x58, 0x71,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0x80, 0x00,

		/* 2422 MHz */
		0x76, 0x09,
			0x10, 0x01, 0xb9, 0x83,
				0x7d, 0x8a, 0x7d, 0x8a, 0x7d, 0x8a, 0x7d, 0x8a,
				0x0f, 0xb6, 0x0f, 0xb6, 0x0f, 0xb6, 0x0f, 0xb6,
				0x0f, 0xb6, 0x0f, 0xb6, 0x0f, 0xb6, 0x0f, 0xb6,
			0xf0, 0x00, 0x2e, 0x6c,
				0x68, 0x82, 0x68, 0x82, 0x68, 0x82, 0x68, 0x82,
				0xfa, 0xad, 0xfa, 0xad, 0xfa, 0xad, 0xfa, 0xad,
				0xfa, 0xad, 0xfa, 0xad, 0xfa, 0xad, 0xfa, 0xad,
			0xd0, 0x00, 0x8d, 0x5a,
				0x52, 0x7a, 0x52, 0x7a, 0x52, 0x7a, 0x52, 0x7a,
				0xe4, 0xa5, 0xe4, 0xa5, 0xe4, 0xa5, 0xe4, 0xa5,
				0xe4, 0xa5, 0xe4, 0xa5, 0xe4, 0xa5, 0xe4, 0xa5,
			0xa0, 0x00, 0x0a, 0x48,
				0x32, 0x6e, 0x32, 0x6e, 0x32, 0x6e, 0x32, 0x6e,
				0xc4, 0x99, 0xc4, 0x99, 0xc4, 0x99, 0xc4, 0x99,
				0xc4, 0x99, 0xc4, 0x99, 0xc4, 0x99, 0xc4, 0x99,
			0x50, 0x00, 0x7c, 0x36,
				0xfc, 0x59, 0xfc, 0x59, 0xfc, 0x59, 0xfc, 0x59,
				0x8e, 0x85, 0x8e, 0x85, 0x8e, 0x85, 0x8e, 0x85,
				0x8e, 0x85, 0x8e, 0x85, 0x8e, 0x85, 0x8e, 0x85,
			0x00, 0x00, 0xf5, 0x2d,
				0xc6, 0x45, 0xc6, 0x45, 0xc6, 0x45, 0xc6, 0x45,
				0x58, 0x71, 0x58, 0x71, 0x58, 0x71, 0x58, 0x71,
				0x58, 0x71, 0x58, 0x71, 0x58, 0x71, 0x58, 0x71,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0x80, 0x00,

		/* 2427 MHz */
		0x7b, 0x09,
			0x10, 0x01, 0x48, 0x83,
				0x67, 0x8a, 0x67, 0x8a, 0x67, 0x8a, 0x67, 0x8a,
				0xf9, 0xb5, 0xf9, 0xb5, 0xf9, 0xb5, 0xf9, 0xb5,
				0xf9, 0xb5, 0xf9, 0xb5, 0xf9, 0xb5, 0xf9, 0xb5,
			0xf0, 0x00, 0xfb, 0x6b,
				0x50, 0x82, 0x50, 0x82, 0x50, 0x82, 0x50, 0x82,
				0xe2, 0xad, 0xe2, 0xad, 0xe2, 0xad, 0xe2, 0xad,
				0xe2, 0xad, 0xe2, 0xad, 0xe2, 0xad, 0xe2, 0xad,
			0xd0, 0x00, 0x7e, 0x5a,
				0x38, 0x7a, 0x38, 0x7a, 0x38, 0x7a, 0x38, 0x7a,
				0xca, 0xa5, 0xca, 0xa5, 0xca, 0xa5, 0xca, 0xa5,
				0xca, 0xa5, 0xca, 0xa5, 0xca, 0xa5, 0xca, 0xa5,
			0xa0, 0x00, 0x15, 0x48,
				0x14, 0x6e, 0x14, 0x6e, 0x14, 0x6e, 0x14, 0x6e,
				0xa6, 0x99, 0xa6, 0x99, 0xa6, 0x99, 0xa6, 0x99,
				0xa6, 0x99, 0xa6, 0x99, 0xa6, 0x99, 0xa6, 0x99,
			0x50, 0x00, 0x8e, 0x36,
				0xd9, 0x59, 0xd9, 0x59, 0xd9, 0x59, 0xd9, 0x59,
				0x6b, 0x85, 0x6b, 0x85, 0x6b, 0x85, 0x6b, 0x85,
				0x6b, 0x85, 0x6b, 0x85, 0x6b, 0x85, 0x6b, 0x85,
			0x00, 0x00, 0xfe, 0x2d,
				0x9d, 0x45, 0x9d, 0x45, 0x9d, 0x45, 0x9d, 0x45,
				0x2f, 0x71, 0x2f, 0x71, 0x2f, 0x71, 0x2f, 0x71,
				0x2f, 0x71, 0x2f, 0x71, 0x2f, 0x71, 0x2f, 0x71,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0x80, 0x00,

		/* 2432 MHz */
		0x80, 0x09,
			0x10, 0x01, 0xd7, 0x82,
				0x51, 0x8a, 0x51, 0x8a, 0x51, 0x8a, 0x51, 0x8a,
				0xe3, 0xb5, 0xe3, 0xb5, 0xe3, 0xb5, 0xe3, 0xb5,
				0xe3, 0xb5, 0xe3, 0xb5, 0xe3, 0xb5, 0xe3, 0xb5,
			0xf0, 0x00, 0xc8, 0x6b,
				0x37, 0x82, 0x37, 0x82, 0x37, 0x82, 0x37, 0x82,
				0xc9, 0xad, 0xc9, 0xad, 0xc9, 0xad, 0xc9, 0xad,
				0xc9, 0xad, 0xc9, 0xad, 0xc9, 0xad, 0xc9, 0xad,
			0xd0, 0x00, 0x6f, 0x5a,
				0x1d, 0x7a, 0x1d, 0x7a, 0x1d, 0x7a, 0x1d, 0x7a,
				0xaf, 0xa5, 0xaf, 0xa5, 0xaf, 0xa5, 0xaf, 0xa5,
				0xaf, 0xa5, 0xaf, 0xa5, 0xaf, 0xa5, 0xaf, 0xa5,
			0xa0, 0x00, 0x20, 0x48,
				0xf6, 0x6d, 0xf6, 0x6d, 0xf6, 0x6d, 0xf6, 0x6d,
				0x88, 0x99, 0x88, 0x99, 0x88, 0x99, 0x88, 0x99,
				0x88, 0x99, 0x88, 0x99, 0x88, 0x99, 0x88, 0x99,
			0x50, 0x00, 0x9f, 0x36,
				0xb5, 0x59, 0xb5, 0x59, 0xb5, 0x59, 0xb5, 0x59,
				0x47, 0x85, 0x47, 0x85, 0x47, 0x85, 0x47, 0x85,
				0x47, 0x85, 0x47, 0x85, 0x47, 0x85, 0x47, 0x85,
			0x00, 0x00, 0x06, 0x2e,
				0x74, 0x45, 0x74, 0x45, 0x74, 0x45, 0x74, 0x45,
				0x06, 0x71, 0x06, 0x71, 0x06, 0x71, 0x06, 0x71,
				0x06, 0x71, 0x06, 0x71, 0x06, 0x71, 0x06, 0x71,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0x80, 0x00,

		/* 2437 MHz */
		0x85, 0x09,
			0x10, 0x01, 0x67, 0x82,
				0x3a, 0x8a, 0x3a, 0x8a, 0x3a, 0x8a, 0x3a, 0x8a,
				0xcc, 0xb5, 0xcc, 0xb5, 0xcc, 0xb5, 0xcc, 0xb5,
				0xcc, 0xb5, 0xcc, 0xb5, 0xcc, 0xb5, 0xcc, 0xb5,
			0xf0, 0x00, 0x95, 0x6b,
				0x1f, 0x82, 0x1f, 0x82, 0x1f, 0x82, 0x1f, 0x82,
				0xb1, 0xad, 0xb1, 0xad, 0xb1, 0xad, 0xb1, 0xad,
				0xb1, 0xad, 0xb1, 0xad, 0xb1, 0xad, 0xb1, 0xad,
			0xd0, 0x00, 0x61, 0x5a,
				0x02, 0x7a, 0x02, 0x7a, 0x02, 0x7a, 0x02, 0x7a,
				0x94, 0xa5, 0x94, 0xa5, 0x94, 0xa5, 0x94, 0xa5,
				0x94, 0xa5, 0x94, 0xa5, 0x94, 0xa5, 0x94, 0xa5,
			0xa0, 0x00, 0x2c, 0x48,
				0xd8, 0x6d, 0xd8, 0x6d, 0xd8, 0x6d, 0xd8, 0x6d,
				0x6a, 0x99, 0x6a, 0x99, 0x6a, 0x99, 0x6a, 0x99,
				0x6a, 0x99, 0x6a, 0x99, 0x6a, 0x99, 0x6a, 0x99,
			0x50, 0x00, 0xb1, 0x36,
				0x92, 0x59, 0x92, 0x59, 0x92, 0x59, 0x92, 0x59,
				0x24, 0x85, 0x24, 0x85, 0x24, 0x85, 0x24, 0x85,
				0x24, 0x85, 0x24, 0x85, 0x24, 0x85, 0x24, 0x85,
			0x00, 0x00, 0x0f, 0x2e,
				0x4b, 0x45, 0x4b, 0x45, 0x4b, 0x45, 0x4b, 0x45,
				0xdd, 0x70, 0xdd, 0x70, 0xdd, 0x70, 0xdd, 0x70,
				0xdd, 0x70, 0xdd, 0x70, 0xdd, 0x70, 0xdd, 0x70,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0x80, 0x00,

		/* 2442 MHz */
		0x8a, 0x09,
			0x10, 0x01, 0xf6, 0x81,
				0x24, 0x8a, 0x24, 0x8a, 0x24, 0x8a, 0x24, 0x8a,
				0xb6, 0xb5, 0xb6, 0xb5, 0xb6, 0xb5, 0xb6, 0xb5,
				0xb6, 0xb5, 0xb6, 0xb5, 0xb6, 0xb5, 0xb6, 0xb5,
			0xf0, 0x00, 0x62, 0x6b,
				0x06, 0x82, 0x06, 0x82, 0x06, 0x82, 0x06, 0x82,
				0x98, 0xad, 0x98, 0xad, 0x98, 0xad, 0x98, 0xad,
				0x98, 0xad, 0x98, 0xad, 0x98, 0xad, 0x98, 0xad,
			0xd0, 0x00, 0x52, 0x5a,
				0xe7, 0x79, 0xe7, 0x79, 0xe7, 0x79, 0xe7, 0x79,
				0x79, 0xa5, 0x79, 0xa5, 0x79, 0xa5, 0x79, 0xa5,
				0x79, 0xa5, 0x79, 0xa5, 0x79, 0xa5, 0x79, 0xa5,
			0xa0, 0x00, 0x37, 0x48,
				0xba, 0x6d, 0xba, 0x6d, 0xba, 0x6d, 0xba, 0x6d,
				0x4c, 0x99, 0x4c, 0x99, 0x4c, 0x99, 0x4c, 0x99,
				0x4c, 0x99, 0x4c, 0x99, 0x4c, 0x99, 0x4c, 0x99,
			0x50, 0x00, 0xc2, 0x36,
				0x6e, 0x59, 0x6e, 0x59, 0x6e, 0x59, 0x6e, 0x59,
				0x00, 0x85, 0x00, 0x85, 0x00, 0x85, 0x00, 0x85,
				0x00, 0x85, 0x00, 0x85, 0x00, 0x85, 0x00, 0x85,
			0x00, 0x00, 0x17, 0x2e,
				0x22, 0x45, 0x22, 0x45, 0x22, 0x45, 0x22, 0x45,
				0xb4, 0x70, 0xb4, 0x70, 0xb4, 0x70, 0xb4, 0x70,
				0xb4, 0x70, 0xb4, 0x70, 0xb4, 0x70, 0xb4, 0x70,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0x80, 0x00,

		/* 2447 MHz */
		0x8f, 0x09,
			0x10, 0x01, 0x75, 0x83,
				0x61, 0x8a, 0x61, 0x8a, 0x61, 0x8a, 0x61, 0x8a,
				0xf3, 0xb5, 0xf3, 0xb5, 0xf3, 0xb5, 0xf3, 0xb5,
				0xf3, 0xb5, 0xf3, 0xb5, 0xf3, 0xb5, 0xf3, 0xb5,
			0xf0, 0x00, 0x4b, 0x6c,
				0x3f, 0x82, 0x3f, 0x82, 0x3f, 0x82, 0x3f, 0x82,
				0xd1, 0xad, 0xd1, 0xad, 0xd1, 0xad, 0xd1, 0xad,
				0xd1, 0xad, 0xd1, 0xad, 0xd1, 0xad, 0xd1, 0xad,
			0xd0, 0x00, 0xda, 0x5a,
				0x1c, 0x7a, 0x1c, 0x7a, 0x1c, 0x7a, 0x1c, 0x7a,
				0xae, 0xa5, 0xae, 0xa5, 0xae, 0xa5, 0xae, 0xa5,
				0xae, 0xa5, 0xae, 0xa5, 0xae, 0xa5, 0xae, 0xa5,
			0xa0, 0x00, 0x6d, 0x48,
				0xe9, 0x6d, 0xe9, 0x6d, 0xe9, 0x6d, 0xe9, 0x6d,
				0x7b, 0x99, 0x7b, 0x99, 0x7b, 0x99, 0x7b, 0x99,
				0x7b, 0x99, 0x7b, 0x99, 0x7b, 0x99, 0x7b, 0x99,
			0x50, 0x00, 0xc6, 0x36,
				0x92, 0x59, 0x92, 0x59, 0x92, 0x59, 0x92, 0x59,
				0x24, 0x85, 0x24, 0x85, 0x24, 0x85, 0x24, 0x85,
				0x24, 0x85, 0x24, 0x85, 0x24, 0x85, 0x24, 0x85,
			0x00, 0x00, 0x15, 0x2e,
				0x3c, 0x45, 0x3c, 0x45, 0x3c, 0x45, 0x3c, 0x45,
				0xce, 0x70, 0xce, 0x70, 0xce, 0x70, 0xce, 0x70,
				0xce, 0x70, 0xce, 0x70, 0xce, 0x70, 0xce, 0x70,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0x80, 0x00,

		/* 2452 MHz */
		0x94, 0x09,
			0x10, 0x01, 0xf4, 0x84,
				0x9e, 0x8a, 0x9e, 0x8a, 0x9e, 0x8a, 0x9e, 0x8a,
				0x30, 0xb6, 0x30, 0xb6, 0x30, 0xb6, 0x30, 0xb6,
				0x30, 0xb6, 0x30, 0xb6, 0x30, 0xb6, 0x30, 0xb6,
			0xf0, 0x00, 0x34, 0x6d,
				0x77, 0x82, 0x77, 0x82, 0x77, 0x82, 0x77, 0x82,
				0x09, 0xae, 0x09, 0xae, 0x09, 0xae, 0x09, 0xae,
				0x09, 0xae, 0x09, 0xae, 0x09, 0xae, 0x09, 0xae,
			0xd0, 0x00, 0x62, 0x5b,
				0x50, 0x7a, 0x50, 0x7a, 0x50, 0x7a, 0x50, 0x7a,
				0xe2, 0xa5, 0xe2, 0xa5, 0xe2, 0xa5, 0xe2, 0xa5,
				0xe2, 0xa5, 0xe2, 0xa5, 0xe2, 0xa5, 0xe2, 0xa5,
			0xa0, 0x00, 0xa2, 0x48,
				0x17, 0x6e, 0x17, 0x6e, 0x17, 0x6e, 0x17, 0x6e,
				0xa9, 0x99, 0xa9, 0x99, 0xa9, 0x99, 0xa9, 0x99,
				0xa9, 0x99, 0xa9, 0x99, 0xa9, 0x99, 0xa9, 0x99,
			0x50, 0x00, 0xc9, 0x36,
				0xb7, 0x59, 0xb7, 0x59, 0xb7, 0x59, 0xb7, 0x59,
				0x49, 0x85, 0x49, 0x85, 0x49, 0x85, 0x49, 0x85,
				0x49, 0x85, 0x49, 0x85, 0x49, 0x85, 0x49, 0x85,
			0x00, 0x00, 0x12, 0x2e,
				0x57, 0x45, 0x57, 0x45, 0x57, 0x45, 0x57, 0x45,
				0xe9, 0x70, 0xe9, 0x70, 0xe9, 0x70, 0xe9, 0x70,
				0xe9, 0x70, 0xe9, 0x70, 0xe9, 0x70, 0xe9, 0x70,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0x80, 0x00,

		/* 2452 MHz */
		0x99, 0x09,
			0x10, 0x01, 0x74, 0x86,
				0xdb, 0x8a, 0xdb, 0x8a, 0xdb, 0x8a, 0xdb, 0x8a,
				0x6d, 0xb6, 0x6d, 0xb6, 0x6d, 0xb6, 0x6d, 0xb6,
				0x6d, 0xb6, 0x6d, 0xb6, 0x6d, 0xb6, 0x6d, 0xb6,
			0xf0, 0x00, 0x1e, 0x6e,
				0xb0, 0x82, 0xb0, 0x82, 0xb0, 0x82, 0xb0, 0x82,
				0x42, 0xae, 0x42, 0xae, 0x42, 0xae, 0x42, 0xae,
				0x42, 0xae, 0x42, 0xae, 0x42, 0xae, 0x42, 0xae,
			0xd0, 0x00, 0xeb, 0x5b,
				0x85, 0x7a, 0x85, 0x7a, 0x85, 0x7a, 0x85, 0x7a,
				0x17, 0xa6, 0x17, 0xa6, 0x17, 0xa6, 0x17, 0xa6,
				0x17, 0xa6, 0x17, 0xa6, 0x17, 0xa6, 0x17, 0xa6,
			0xa0, 0x00, 0xd8, 0x48,
				0x46, 0x6e, 0x46, 0x6e, 0x46, 0x6e, 0x46, 0x6e,
				0xd8, 0x99, 0xd8, 0x99, 0xd8, 0x99, 0xd8, 0x99,
				0xd8, 0x99, 0xd8, 0x99, 0xd8, 0x99, 0xd8, 0x99,
			0x50, 0x00, 0xcd, 0x36,
				0xdb, 0x59, 0xdb, 0x59, 0xdb, 0x59, 0xdb, 0x59,
				0x6d, 0x85, 0x6d, 0x85, 0x6d, 0x85, 0x6d, 0x85,
				0x6d, 0x85, 0x6d, 0x85, 0x6d, 0x85, 0x6d, 0x85,
			0x00, 0x00, 0x10, 0x2e,
				0x71, 0x45, 0x71, 0x45, 0x71, 0x45, 0x71, 0x45,
				0x03, 0x71, 0x03, 0x71, 0x03, 0x71, 0x03, 0x71,
				0x03, 0x71, 0x03, 0x71, 0x03, 0x71, 0x03, 0x71,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0x80, 0x00,

		/* 2557 MHz */
		0x9e, 0x09,
			0x10, 0x01, 0xf3, 0x87,
				0x17, 0x8b, 0x17, 0x8b, 0x17, 0x8b, 0x17, 0x8b,
				0xa9, 0xb6, 0xa9, 0xb6, 0xa9, 0xb6, 0xa9, 0xb6,
				0xa9, 0xb6, 0xa9, 0xb6, 0xa9, 0xb6, 0xa9, 0xb6,
			0xf0, 0x00, 0x07, 0x6f,
				0xe9, 0x82, 0xe9, 0x82, 0xe9, 0x82, 0xe9, 0x82,
				0x7b, 0xae, 0x7b, 0xae, 0x7b, 0xae, 0x7b, 0xae,
				0x7b, 0xae, 0x7b, 0xae, 0x7b, 0xae, 0x7b, 0xae,
			0xd0, 0x00, 0x73, 0x5c,
				0xba, 0x7a, 0xba, 0x7a, 0xba, 0x7a, 0xba, 0x7a,
				0x4c, 0xa6, 0x4c, 0xa6, 0x4c, 0xa6, 0x4c, 0xa6,
				0x4c, 0xa6, 0x4c, 0xa6, 0x4c, 0xa6, 0x4c, 0xa6,
			0xa0, 0x00, 0x0d, 0x49,
				0x74, 0x6e, 0x74, 0x6e, 0x74, 0x6e, 0x74, 0x6e,
				0x06, 0x9a, 0x06, 0x9a, 0x06, 0x9a, 0x06, 0x9a,
				0x06, 0x9a, 0x06, 0x9a, 0x06, 0x9a, 0x06, 0x9a,
			0x50, 0x00, 0xd1, 0x36,
				0xff, 0x59, 0xff, 0x59, 0xff, 0x59, 0xff, 0x59,
				0x91, 0x85, 0x91, 0x85, 0x91, 0x85, 0x91, 0x85,
				0x91, 0x85, 0x91, 0x85, 0x91, 0x85, 0x91, 0x85,
			0x00, 0x00, 0x0e, 0x2e,
				0x8b, 0x45, 0x8b, 0x45, 0x8b, 0x45, 0x8b, 0x45,
				0x1d, 0x71, 0x1d, 0x71, 0x1d, 0x71, 0x1d, 0x71,
				0x1d, 0x71, 0x1d, 0x71, 0x1d, 0x71, 0x1d, 0x71,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0x80, 0x00,

		/* 2562 MHz */
		0xa3, 0x09,
			0x10, 0x01, 0x72, 0x89,
				0x54, 0x8b, 0x54, 0x8b, 0x54, 0x8b, 0x54, 0x8b,
				0xe6, 0xb6, 0xe6, 0xb6, 0xe6, 0xb6, 0xe6, 0xb6,
				0xe6, 0xb6, 0xe6, 0xb6, 0xe6, 0xb6, 0xe6, 0xb6,
			0xf0, 0x00, 0xf0, 0x6f,
				0x21, 0x83, 0x21, 0x83, 0x21, 0x83, 0x21, 0x83,
				0xb3, 0xae, 0xb3, 0xae, 0xb3, 0xae, 0xb3, 0xae,
				0xb3, 0xae, 0xb3, 0xae, 0xb3, 0xae, 0xb3, 0xae,
			0xd0, 0x00, 0xfb, 0x5c,
				0xee, 0x7a, 0xee, 0x7a, 0xee, 0x7a, 0xee, 0x7a,
				0x80, 0xa6, 0x80, 0xa6, 0x80, 0xa6, 0x80, 0xa6,
				0x80, 0xa6, 0x80, 0xa6, 0x80, 0xa6, 0x80, 0xa6,
			0xa0, 0x00, 0x43, 0x49,
				0xa3, 0x6e, 0xa3, 0x6e, 0xa3, 0x6e, 0xa3, 0x6e,
				0x35, 0x9a, 0x35, 0x9a, 0x35, 0x9a, 0x35, 0x9a,
				0x35, 0x9a, 0x35, 0x9a, 0x35, 0x9a, 0x35, 0x9a,
			0x50, 0x00, 0xd4, 0x36,
				0x24, 0x5a, 0x24, 0x5a, 0x24, 0x5a, 0x24, 0x5a,
				0xb6, 0x85, 0xb6, 0x85, 0xb6, 0x85, 0xb6, 0x85,
				0xb6, 0x85, 0xb6, 0x85, 0xb6, 0x85, 0xb6, 0x85,
			0x00, 0x00, 0x0b, 0x2e,
				0xa6, 0x45, 0xa6, 0x45, 0xa6, 0x45, 0xa6, 0x45,
				0x38, 0x71, 0x38, 0x71, 0x38, 0x71, 0x38, 0x71,
				0x38, 0x71, 0x38, 0x71, 0x38, 0x71, 0x38, 0x71,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0x80, 0x00,

		/* 2572 MHz */
		0xa8, 0x09,
			0x10, 0x01, 0xf1, 0x8a,
				0x91, 0x8b, 0x91, 0x8b, 0x91, 0x8b, 0x91, 0x8b,
				0x23, 0xb7, 0x23, 0xb7, 0x23, 0xb7, 0x23, 0xb7,
				0x23, 0xb7, 0x23, 0xb7, 0x23, 0xb7, 0x23, 0xb7,
			0xf0, 0x00, 0xd9, 0x70,
				0x5a, 0x83, 0x5a, 0x83, 0x5a, 0x83, 0x5a, 0x83,
				0xec, 0xae, 0xec, 0xae, 0xec, 0xae, 0xec, 0xae,
				0xec, 0xae, 0xec, 0xae, 0xec, 0xae, 0xec, 0xae,
			0xd0, 0x00, 0x83, 0x5d,
				0x23, 0x7b, 0x23, 0x7b, 0x23, 0x7b, 0x23, 0x7b,
				0xb5, 0xa6, 0xb5, 0xa6, 0xb5, 0xa6, 0xb5, 0xa6,
				0xb5, 0xa6, 0xb5, 0xa6, 0xb5, 0xa6, 0xb5, 0xa6,
			0xa0, 0x00, 0x78, 0x49,
				0xd1, 0x6e, 0xd1, 0x6e, 0xd1, 0x6e, 0xd1, 0x6e,
				0x63, 0x9a, 0x63, 0x9a, 0x63, 0x9a, 0x63, 0x9a,
				0x63, 0x9a, 0x63, 0x9a, 0x63, 0x9a, 0x63, 0x9a,
			0x50, 0x00, 0xd8, 0x36,
				0x48, 0x5a, 0x48, 0x5a, 0x48, 0x5a, 0x48, 0x5a,
				0xda, 0x85, 0xda, 0x85, 0xda, 0x85, 0xda, 0x85,
				0xda, 0x85, 0xda, 0x85, 0xda, 0x85, 0xda, 0x85,
			0x00, 0x00, 0x09, 0x2e,
				0xc0, 0x45, 0xc0, 0x45, 0xc0, 0x45, 0xc0, 0x45,
				0x52, 0x71, 0x52, 0x71, 0x52, 0x71, 0x52, 0x71,
				0x52, 0x71, 0x52, 0x71, 0x52, 0x71, 0x52, 0x71,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x80, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00,
				0x00, 0x00, 0x00, 0x00, 0x06, 0x80, 0x80, 0x00,

/*
 * Not really sure if this is actually the power_limit database,
 * it looks a bit "related" to PDR_PRISM_ZIF_TX_IQ_CALIBRATION
 */
/* struct pda_custom_wrapper */
0xae, 0x00, 0xef, 0xbe,      /* PDR_PRISM_PA_CAL_OUTPUT_POWER_LIMITS_CUSTOM */
	0x0d, 0x00, 0x1a, 0x00,		/* 13 entries, 26 bytes per entry */
	0x00, 0x00, 0x52, 0x01,		/* no offset, 338 bytes total */

		/* 2412 MHz */
		0x6c, 0x09,
			0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
			0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00,
			0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00,

		/* 2417 MHz */
		0x71, 0x09,
			0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
			0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
			0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00,

		/* 2422 MHz */
		0x76, 0x09,
			0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
			0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
			0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00,

		/* 2427 MHz */
		0x7b, 0x09,
			0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
			0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
			0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00,

		/* 2432 MHz */
		0x80, 0x09,
			0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
			0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
			0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00,

		/* 2437 MHz */
		0x85, 0x09,
			0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
			0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
			0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00,

		/* 2442 MHz */
		0x8a, 0x09,
			0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
			0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
			0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00,

		/* 2447 MHz */
		0x8f, 0x09,
			0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
			0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
			0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00,

		/* 2452 MHz */
		0x94, 0x09,
			0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
			0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
			0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00,

		/* 2457 MHz */
		0x99, 0x09,
			0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
			0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
			0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00,

		/* 2462 MHz */
		0x9e, 0x09,
			0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
			0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
			0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00,

		/* 2467 MHz */
		0xa3, 0x09,
			0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
			0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
			0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00,

		/* 2472 MHz */
		0xa8, 0x09,
			0x10, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x01,
			0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00,
			0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00, 0xd0, 0x00,

/* struct pda_iq_autocal_entry[13] */
0x42, 0x00, 0x06, 0x19,		/* PDR_PRISM_ZIF_TX_IQ_CALIBRATION */
	/* 2412 MHz */
	0x6c, 0x09, 0x26, 0x00, 0xf8, 0xff, 0xf7, 0xff, 0xff, 0x00,
	/* 2417 MHz */
	0x71, 0x09, 0x26, 0x00, 0xf8, 0xff, 0xf7, 0xff, 0xff, 0x00,
	/* 2422 MHz */
	0x76, 0x09, 0x26, 0x00, 0xf8, 0xff, 0xf7, 0xff, 0xff, 0x00,
	/* 2427 MHz */
	0x7b, 0x09, 0x26, 0x00, 0xf8, 0xff, 0xf7, 0xff, 0xff, 0x00,
	/* 2432 MHz */
	0x80, 0x09, 0x25, 0x00, 0xf7, 0xff, 0xf7, 0xff, 0xff, 0x00,
	/* 2437 MHz */
	0x85, 0x09, 0x25, 0x00, 0xf7, 0xff, 0xf7, 0xff, 0xff, 0x00,
	/* 2442 MHz */
	0x8a, 0x09, 0x25, 0x00, 0xf7, 0xff, 0xf7, 0xff, 0xff, 0x00,
	/* 2447 MHz */
	0x8f, 0x09, 0x25, 0x00, 0xf7, 0xff, 0xf7, 0xff, 0xff, 0x00,
	/* 2452 MHz */
	0x94, 0x09, 0x25, 0x00, 0xf7, 0xff, 0xf7, 0xff, 0xff, 0x00,
	/* 2457 MHz */
	0x99, 0x09, 0x25, 0x00, 0xf5, 0xff, 0xf9, 0xff, 0x00, 0x01,
	/* 2462 MHz */
	0x9e, 0x09, 0x25, 0x00, 0xf5, 0xff, 0xf9, 0xff, 0x00, 0x01,
	/* 2467 MHz */
	0xa3, 0x09, 0x25, 0x00, 0xf5, 0xff, 0xf9, 0xff, 0x00, 0x01,
	/* 2472 MHz */
	0xa8, 0x09, 0x25, 0x00, 0xf5, 0xff, 0xf9, 0xff, 0x00, 0x01,

0x02, 0x00, 0x00, 0x00,		/* PDR_END */
	0xb6, 0x04,
};

#endif /* P54SPI_EEPROM_H */

