/**
* @license Apache-2.0
*
* Copyright (c) 2020 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MAIN //

/**
* Adjusts the p-values via the Bonferroni method.
*
* @private
* @param {ProbabilityArray} pvalues - p-values to be adjusted
* @param {PositiveInteger} comparisons - number of comparisons
* @returns {ProbabilityArray} adjusted p-values
*/
function bonferroni( pvalues, comparisons ) {
	var pval;
	var i;
	for ( i = 0; i < pvalues.length; i++ ) {
		pval = pvalues[ i ];
		pvalues[ i ] = ( comparisons * pval > 1 ) ? 1 : comparisons * pval;
	}
	return pvalues;
}


// EXPORTS //

module.exports = bonferroni;
