/***************************************************************************
 Texture coordinate animation test. A flame.
 ***************************************************************************/

#include "Engine.h"
#include "Camera.h"
#include "BillBoard.h"
#include "KeyBehavior.h"
#include "Keyboard.h"
#include "TextureUtil.h"
#include "TexAnimation.h"

/** Main */
int main(int argc, char *argv[]) {
	cerr << "Fire test." << endl;

	if (argc < 2) {
		cerr << "Usage: firee <2x2 fire image-file>" << endl;
		return 0;
	}

	// Create the engine.
	Engine* engine = new Engine(argc, argv);
	engine->setLightning(0.5f, 0.1f);

	// Add a camera. Move a bit.
	Camera* camera = new Camera();
	Group* groupCamera = new Group();
	engine->add(groupCamera);
	groupCamera->setCamera(camera);
	groupCamera->setTranslation(0, 0, 7);
	engine->setEngineCamera(groupCamera);

	// Load a texture
	EmTexture* texture = TextureUtil::loadTexture(argv[1]);

	// Add a BillBoard
	BillBoard* billboard = new BillBoard(texture, 2.0, 3.0);
	billboard->setProperty(EM_BILLBOARD_ALPHATEST);          
	billboard->setProperty(EM_BILLBOARD_TRANS);              
	Group* groupBB = new Group();                            
	engine->add(groupBB);                                 
	groupBB->setBillBoard(billboard);                        

	TexAnimation * anim = new TexAnimation(3, 4, 0);  
	anim->add(0,  0);                                        
	anim->add(0.5,0);                                        
	anim->add(0.5,0.5);                                        
	anim->add(0,  0.5);                                        

	anim->add(0.5,  0);                                        
	anim->add(1,  0);                                        
	anim->add(1,  0.5);                                        
	anim->add(0.5,  0.5);                                        

	anim->add(0,  0.5);                                        
	anim->add(0.5,0.5);                                        
	anim->add(0.5,1);                                        
	anim->add(0,  1);                                        

	anim->add(0.5,0.5);                                        
	anim->add(1  ,0.5);                                        
	anim->add(1  ,1);                                        
	anim->add(0.5,1);                                        

	groupBB->addBehavior(anim);                              

	// Add a behavior to the billboard
	KeyBehavior* keyBeh = new KeyBehavior();
	groupBB->addBehavior(keyBeh);
		
	while (!Keyboard::isKeyDown(SDLK_ESCAPE)) {
		engine->tick();
		engine->render();
		engine->swap();
		SDL_Delay(20);
	}
	delete(engine);
	return 0;
}
