% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-jitterdodge.R
\name{position_jitterdodge}
\alias{position_jitterdodge}
\title{Simultaneously dodge and jitter}
\usage{
position_jitterdodge(
  jitter.width = NULL,
  jitter.height = 0,
  dodge.width = 0.75,
  reverse = FALSE,
  seed = NA
)
}
\arguments{
\item{jitter.width}{degree of jitter in x direction. Defaults to 40\% of the
resolution of the data.}

\item{jitter.height}{degree of jitter in y direction. Defaults to 0.}

\item{dodge.width}{the amount to dodge in the x direction. Defaults to 0.75,
the default \code{position_dodge()} width.}

\item{reverse}{If \code{TRUE}, will reverse the default stacking order.
This is useful if you're rotating both the plot and legend.}

\item{seed}{A random seed to make the jitter reproducible.
Useful if you need to apply the same jitter twice, e.g., for a point and
a corresponding label.
The random seed is reset after jittering.
If \code{NA} (the default value), the seed is initialised with a random value;
this makes sure that two subsequent calls start with a different seed.
Use \code{NULL} to use the current random seed and also avoid resetting
(the behaviour of \pkg{ggplot} 2.2.1 and earlier).}
}
\description{
This is primarily used for aligning points generated through
\code{geom_point()} with dodged boxplots (e.g., a \code{geom_boxplot()} with
a fill aesthetic supplied).
}
\examples{
set.seed(596)
dsub <- diamonds[sample(nrow(diamonds), 1000), ]
ggplot(dsub, aes(x = cut, y = carat, fill = clarity)) +
  geom_boxplot(outlier.size = 0) +
  geom_point(pch = 21, position = position_jitterdodge())
}
\seealso{
Other position adjustments: 
\code{\link{position_dodge}()},
\code{\link{position_identity}()},
\code{\link{position_jitter}()},
\code{\link{position_nudge}()},
\code{\link{position_stack}()}
}
\concept{position adjustments}
