% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift_longitude.R
\name{st_shift_longitude}
\alias{st_shift_longitude}
\alias{st_shift_longitude.sfc}
\alias{st_shift_longitude.sf}
\title{Shift or re-center geographical coordinates for a Pacific view}
\usage{
st_shift_longitude(x)

\method{st_shift_longitude}{sfc}(x, ...)

\method{st_shift_longitude}{sf}(x, ...)
}
\arguments{
\item{x}{object of class sf or sfc}

\item{...}{ignored}
}
\description{
All longitudes < 0 are added to 360, to avoid for instance parts of Alaska
  being represented on the far left and right of a plot because they have
  values straddling 180 degrees. In general, using a projected
  coordinate reference system is to be preferred, but this method permits a
  geographical coordinate reference system to be used. This is the sf
  equivalent of \code{\link[sp:recenter-methods]{recenter}} in the sp package and
  ST_ShiftLongitude in PostGIS.
}
\examples{
## sfc
pt1 = st_point(c(-170, 50))
pt2 = st_point(c(170, 50))
(sfc = st_sfc(pt1, pt2))
sfc = st_set_crs(sfc, 4326)
st_shift_longitude(sfc)

## sf
d = st_as_sf(data.frame(id = 1:2, geometry = sfc))
st_shift_longitude(d)
}
