# frozen_string_literal: true

require "rails"

module Roadie
  module Rails
    class Railtie < ::Rails::Railtie
      config.roadie = Roadie::Rails::Options.new

      initializer "roadie-rails.setup" do |app|
        config.roadie.asset_providers = [
          Roadie::FilesystemProvider.new(::Rails.root.join("public").to_s)
        ]

        if app.config.respond_to?(:assets) && app.config.assets
          if app.assets && defined?(Propshaft::Assembly) && app.assets.is_a?(Propshaft::Assembly)
            # Initialize AssetPropshaftProvider immediately for Propshaft 1.3.0+ compatibility
            # The after_initialize block was not executing correctly in Propshaft 1.3.0
            config.roadie.asset_providers << AssetPropshaftProvider.new(app.assets)
          elsif app.assets
            config.roadie.asset_providers << AssetPipelineProvider.new(app.assets)
          else
            app.config.assets.configure do |env|
              config.roadie.asset_providers <<
                AssetPipelineProvider.new(env)
            end
          end
        end
      end
    end
  end
end
