# Example Custom Logging Plugin

This is an example of a low level logging plugin.

Currently implemented are packet and flow loggers.

## Building

If in the Suricata source directory, this plugin can be built by
running `make`'.

## Building Standalone

This Makefile is not generated by automake so it can serve as an
example for plugins created outside of the Suricata source tree.

Building a standalone plugin has the following dependencies:

- Suricata is installed
- The Suricata library is installed: `make install-library`
- The Suricata development headers are installed: `make install-headers`
- The program `libsuricata-config` is in your path (installed with
  `make install-library`)

Modify the Makefile to use `libsuricata-config`.

Before building this plugin you will need to build and install Suricata from the
git main branch and install the development tools and headers:

- `make install-library`
- `make install-headers`

then make sure the newly installed tool `libsuricata-config` can be
found in your path, for example:
```
libsuricata-config --cflags
```

Then a simple `make` should build this plugin.

Or if the Suricata installation is not in the path, a command like the following
can be used:

```
PATH=/opt/suricata/bin:$PATH make
```

## Usage

To run the plugin, first add the path to the plugin you just compiled to
your `suricata.yaml`, for example:
```
plugins:
  - /usr/lib/suricata/plugins/c-custom-loggers/custom-loggers.so
```
