---
name: Fully-designed Feature Request
about: Create a fully-specified feature request
title: ''
labels: enhancement
assignees: ''
---

# Instructions

Before using the issue tracker, please read the following page
thoroughly and follow the guidelines it expresses:

https://github.com/bcpierce00/unison/wiki/Reporting-Bugs-and-Feature-Requests

If your feature request is not fully formed, please post on
unison-users@ or unison-hackers@ instead.

Pleaes delete the following dashed line and the text above it, leaving the
statement that you have read the wiki page.
----------------------------------------
I have thoroughly read the [Reporting Bugs and Feature Requests](https://github.com/bcpierce00/unison/wiki/Reporting-Bugs-and-Feature-Requests) wiki page.

# Motivation

Explain what you want to do.

# Background

Explain why the documentation and current behavior do not permit
achieving your goals.  For near misses, explain.

# Scope

Discuss whether the proposed behavior is aligned with unison's historical scope and why it is a reasonable change.

If there are portability concerns, discuss them.

# Will you write code?

Say whether you intend to implement the feature.  (If so, it is
entirely reasonable to ask first if it would be accepted if written,
if you don't want to spend time on a feature that won't be merged).

# Operation of the new feature

Explain how the new feature will behave, enough that someone else (who
is familiar with unison) could implement it.

Discuss problems that will arise and how they should be handled.

# Complexity vs Benefit

Discuss the tradeoff of complexity in the code base and documentation
vs the benefit to users.  Generally, proposed features should be of
fairly broad interest.
