/* $XConsortium: NextEvent.c,v 11.19 94/04/17 20:20:19 kaleb Exp $
 *  $XFree86 xc/lib/X11/NextEvent.c
 */

/*
 * Version: 1.0 small changes for patch library by Zdenek Kabelac
 * kabi@fi.muni.cz 1998-03-28 1998-09-21
 */

#define NEED_EVENTS
#include <X11/Xlibint.h>

#include "libi18n.h"
#ifdef DEBUG
#include <stdio.h>
#endif

/* 
 * Return next event in queue, or if none, flush output and wait for
 * events.
 */
int
XNextEvent (dpy, event)
	register Display *dpy;
	register XEvent *event;
{
	register _XQEvent *qelt;

	if (!initialized) {
#ifdef DEBUG
	    fprintf(stderr, "I18N not initialized in the first XNextEvent\n");
#endif
	    if (dpy->head == NULL)
		_XReadEvents(dpy);
	    qelt = dpy->head;
	    *event = qelt->event;
	    XSelectInput(dpy, event->xany.window,
			 FocusChangeMask | KeyPressMask);
	}

	while (1) {
	    do {
//		fprintf(stderr, "XEvent  %ld\n", appwindow);
		LockDisplay(dpy);
		if (dpy->head == NULL)
		    _XReadEvents(dpy);
		qelt = dpy->head;
		*event = qelt->event;
		_XDeq(dpy, NULL, qelt);
		UnlockDisplay(dpy);
	    } while (appwindow && XFilterEvent(event, appwindow));
//            break;
	    if (appwindow && initialized) {
		switch (event->type) {
		case FocusIn:
//		    fprintf(stderr, "Focus IN\n");
		    I18NFocusIn(xic);
		    break;
		case FocusOut:
//		    fprintf(stderr, "Focus OUT\n");
		    I18NFocusOut(xic);
		    break;
		}
		if (o_mask || ((event->type != FocusIn) &&
			       (event->type != FocusOut)))
		    break;
	    } else
                break;
	}
	return 0;
}
