/* $XConsortium: SelInput.c /main/7 1996/10/22 14:21:40 kaleb $
 * $XFree86: xc/lib/X11/SelInput.c
 */

/*
 * Version: 1.0 small changes for patch library by Zdenek Kabelac
 * kabi@fi.muni.cz 1998-03-28 1998-09-21
 */

#include <X11/Xlibint.h>

#include "libi18n.h"
#ifdef DEBUG
#include <stdio.h>
#endif

int initialized = 0;
int o_mask = 0;
Window appwindow = 0;
XIC xic = NULL;

int
XSelectInput (dpy, w, mask)
    register Display *dpy;
    Window w;
    long mask;
{
    register xChangeWindowAttributesReq *req;

    if (!initialized && w) {
	unsigned long mmask;
	
	if ((xic = I18NInit(dpy, w, &mmask))) {
#ifdef DEBUG
	    fprintf(stderr, "XSelectInput initialization\n");
#endif
	    o_mask = mask & FocusChangeMask;
	    mask |= FocusChangeMask | mmask ;
            if (!getenv("HACK_NOFILTER"))
		appwindow = w;
	    else
		appwindow = 0;
	    initialized++; /* mark, we made it */
#ifdef DEBUG
	    fprintf(stderr, "XInput window: %lx  0x%x %ld\n",
		    w, o_mask, (mask & KeyReleaseMask));
#endif
	}
#ifdef DEBUG
	else
	    fprintf(stderr, "Can't set XInput context\n");
#endif
    }
    LockDisplay(dpy);
    GetReqExtra (ChangeWindowAttributes, 4, req);
    req->window = w;
    req->valueMask = CWEventMask;
    OneDataCard32 (dpy, NEXTPTR(req,xChangeWindowAttributesReq), mask);
    UnlockDisplay(dpy);
    SyncHandle();
    return 1;
}
