/* $TOG: XKBBind.c /main/27 1997/06/10 06:53:17 kaleb $
 * $XFree86: xc/lib/X11/SelInput.c
 */

/*
 * Version: 1.0 small changes for patch library by Zdenek Kabelac
 * kabi@fi.muni.cz 1998-03-28 1998-09-21
 *
 * Sat Mar 20 1999 21:46:40 - a few cosmetic changes
 */

#include <X11/Xlibint.h>
#include <X11/Xlib.h>
#include <X11/keysymdef.h>
#include <X11/Xutil.h>
/* this include is not distributed as standard X header file */
#include "XKBlibint.h"

#include "libi18n.h"

#if XlibSpecificationRelease < 6
"ERROR, Sorry your X-Windows release is to old for this patch";
#endif

#ifdef DEBUG
#include <stdio.h>
#endif

/*
 * CUT & PASTE - why is this function static in original
 * X distribution? It's unchanged, but it have to be included here
 */
static int
#if NeedFunctionPrototypes
   _XkbLoadDpy(Display * dpy)
#else
   _XkbLoadDpy(dpy)
     Display *dpy;
#endif
{
    XkbInfoPtr xkbi;
    unsigned query, oldEvents;
    XkbDescRec *desc;

    if (!XkbUseExtension(dpy, NULL, NULL))
	return 0;

    xkbi = dpy->xkb_info;
    query = XkbAllClientInfoMask;
    desc = XkbGetMap(dpy, query, XkbUseCoreKbd);
    if (!desc) {
#ifdef DEBUG
	fprintf(stderr, "Warning! XkbGetMap failed!\n");
#endif
	return 0;
    }
    LockDisplay(dpy);
    xkbi->desc = desc;

    _XkbGetConverters(_XkbGetCharset(), &xkbi->cvt);
    _XkbGetConverters("ISO8859-1", &xkbi->latin1cvt);
    UnlockDisplay(dpy);
    oldEvents = xkbi->selected_events;
    if (!(xkbi->xlib_ctrls & XkbLC_IgnoreNewKeyboards)) {
	XkbSelectEventDetails(dpy, xkbi->desc->device_spec, XkbNewKeyboardNotify,
			      XkbNKN_KeycodesMask | XkbNKN_DeviceIDMask,
			      XkbNKN_KeycodesMask | XkbNKN_DeviceIDMask);
    }
    XkbSelectEventDetails(dpy, xkbi->desc->device_spec, XkbMapNotify,
			  XkbAllClientInfoMask, XkbAllClientInfoMask);
    LockDisplay(dpy);
    xkbi->selected_events = oldEvents;
    UnlockDisplay(dpy);
    return 1;
}

/*
 * Somewhat hacked version of original XLookupString
 */
int XLookupString(event, buffer, nbytes, keysym, status)
     register XKeyEvent *event;
     char *buffer;		/* buffer */
     int nbytes;		/* space in buffer for characters */
     KeySym *keysym;
     XComposeStatus *status;	/* not implemented */
{
    /*fprintf(stderr, "analyzing %p %d\n", buffer, event->send_event);*/
    if ((keysym != NULL) && (event->send_event == 0)
	&& (event->type == KeyPress) && xic && appwindow) {
	int bytes = 0;

	event->send_event++;
	/* first pass */
	bytes = I18NLookupString(event, buffer, nbytes, keysym, xic);
	/*event->send_event--;*/

#ifdef DEBUG
	fprintf(stderr, "O: 0x%-7lx%-20s%d  %c\n", *keysym,
		XKeysymToString(*keysym), bytes, buffer[0]);
#endif

	return bytes;
    } else {
	/* This is CUT & PASTE XKBBind.c function XLookupString */
	KeySym dummy;
	int rtrnLen;
	unsigned int new_mods;
	Display *dpy = event->display;
	XkbDescPtr xkb;

	if (_XkbUnavailable(dpy))
	    return _XLookupString(event, buffer, nbytes, keysym, status);
	_XkbCheckPendingRefresh(dpy, dpy->xkb_info);

	if (keysym == NULL)
	    keysym = &dummy;
	xkb= dpy->xkb_info->desc;
	if (!XkbTranslateKeyCode(xkb, event->keycode, event->state, &new_mods, keysym))
	    return 0;
	new_mods = (event->state & (~new_mods));

	/* We *should* use the new_mods (which does not contain any modifiers */
	/* that were used to compute the symbol here, but pre-XKB XLookupString */
	/* did not and we have to remain compatible.  Sigh. */
	if ((dpy->xkb_info->flags & XkbLC_ConsumeLookupMods) == 0)
	    new_mods = event->state;

	rtrnLen = XkbLookupKeyBinding(dpy, *keysym, new_mods, buffer, nbytes, NULL);
	if (rtrnLen > 0)
#ifdef USE_HARD_REMAP
	    return I18NKeyAnalyze(event, buffer, rtrnLen, keysym);
#else
	    return rtrnLen;
#endif

	rtrnLen = XkbTranslateKeySym(dpy, keysym, new_mods, buffer, nbytes, NULL);
	if ((event->state & ControlMask) && (nbytes > 0) &&
	    ((rtrnLen == 0) || ((rtrnLen == 1) && (buffer[0] >= ' '))) &&
	    (XkbGroupForCoreState(event->state) != XkbGroup1Index) &&
	    (dpy->xkb_info->xlib_ctrls & XkbLC_ControlFallback)) {
	    XKeyEvent tmp_ev;
	    tmp_ev = *event;
	    tmp_ev.state = XkbBuildCoreState(event->state, XkbGroup1Index);
	    return XLookupString(&tmp_ev, buffer, nbytes, keysym, status);
	}
#ifdef USE_HARD_REMAP
	return I18NKeyAnalyze(event, buffer, rtrnLen, keysym);
#else
	return rtrnLen;
#endif
    }
}
