#ifndef  __CON_IKCS_H
#define  __CON_IKCS_H

static struct remapKey keyboardHalfSk[] =
{
    {XK_2, 0xff & ''},
    {XK_3, 0xff & ''},
    {XK_4, 0xff & ''},
    {XK_5, 0xff & ''},
    {XK_6, 0xff & ''},
    {XK_7, 0xff & ''},
    {XK_8, 0xff & ''},
    {XK_9, 0xff & ''},
    {XK_0, 0xff & ''},
    {0,}
};

static struct remapKey keyboardFullSk[] =
{
    {XK_1, 0xff & '+'},
    {XK_exclam, XK_1},
    {XK_2, 0xff & ''},
    {XK_at, XK_2},
    {XK_3, 0xff & ''},
    {XK_numbersign, XK_3},
    {XK_4, 0xff & ''},
    {XK_dollar, XK_4},
    {XK_5, 0xff & ''},
    {XK_percent, XK_5},
    {XK_6, 0xff & ''},
    {XK_asciicircum, XK_6},
    {XK_7, 0xff & ''},
    {XK_ampersand, XK_7},
    {XK_8, 0xff & ''},
    {XK_asterisk, XK_8},
    {XK_9, 0xff & ''},
    {XK_parenleft, XK_9},
    {XK_0, 0xff & ''},
    {XK_parenright, XK_0},

    {XK_minus, XK_equal},
    {XK_underscore, XK_percent},

    {XK_bracketleft, 0xff & ''},
    {XK_braceleft, 0xff & '/'},
    {XK_bracketright, 0xff & ''},
    {XK_braceright, 0xff & '('},

    {XK_semicolon, 0xff & ''},
    {XK_apostrophe, 0xff & ''},
    {XK_colon, 0xff & '"'},
    {XK_quotedbl, 0xff & '!'},

    {XK_comma, 0xff & ','},
    {XK_less, 0xff & '?'},
    {XK_period, 0xff & '.'},
    {XK_greater, 0xff & ':'},
    {XK_question, 0xff & '_'},
    {XK_slash, 0xff & '-'},

    {0,}
};



static struct keyboardRec kbdHalfSkRec[] =
{
    {keyboardHalfSk, 0, 0},	/*  0 */

    KEYMAPS_MACRO

    KBD_MACRO

    {NULL,}
};

static struct keyboardRec kbdFullSkRec[] =
{
    {keyboardFullSk, 0, 0},	/*  0 */

    KEYMAPS_MACRO

    {keyboardStd, XK_equal, 1},
    {keyboardStd, XK_plus, 2},

    KBD_MACRO

    {NULL,}
};

/*
 * one standart keyboard and two national keyboards
 * (for programmers and for writers)
 */
static struct keyboardRec *nationalSkKey[] =
{
    kbdStdRec,
    kbdHalfSkRec,
    kbdFullSkRec,
    0
};

#endif
