#ifndef __CON_REMAP_H
#define __CON_REMAP_H

static struct remapKey keyboardStd[] =
{
    {0,}
};


static struct remapKey keyboardAcute[] =
{
    {XK_w, 0xff & ''},
    {XK_W, 0xff & ''},
    {XK_e, 0xff & ''},
    {XK_E, 0xff & ''},
    {XK_r, 0xff & ''},
    {XK_R, 0xff & ''},
    {XK_t, 0xff & ''},
    {XK_T, 0xff & ''},
    {XK_y, 0xff & ''},
    {XK_Y, 0xff & ''},
    {XK_u, 0xff & ''},
    {XK_U, 0xff & ''},
    {XK_i, 0xff & ''},
    {XK_I, 0xff & ''},
    {XK_o, 0xff & ''},
    {XK_O, 0xff & ''},
    {XK_p, 0xff & ''},
    {XK_P, 0xff & ''},

    {XK_a, 0xff & ''},
    {XK_A, 0xff & ''},
    {XK_s, 0xff & ''},
    {XK_S, 0xff & ''},
    {XK_d, 0xff & ''},
    {XK_D, 0xff & ''},
    {XK_h, 0xff & ''},
    {XK_H, 0xff & ''},
    {XK_l, 0xff & ''},
    {XK_L, 0xff & ''},

    {XK_z, 0xff & ''},
    {XK_Z, 0xff & ''},
    {XK_x, 0xff & ''},
    {XK_X, 0xff & ''},
    {XK_c, 0xff & ''},
    {XK_C, 0xff & ''},
    {XK_b, 0xff & ''},
    {XK_B, 0xff & ''},
    {XK_n, 0xff & ''},
    {XK_N, 0xff & ''},

    {XK_equal, 0xff & ''},

    {0,}
};

static struct remapKey keyboardCaron[] =
{
    {XK_e, 0xff & ''},
    {XK_E, 0xff & ''},
    {XK_r, 0xff & ''},
    {XK_R, 0xff & ''},
    {XK_t, 0xff & ''},
    {XK_T, 0xff & ''},
    {XK_u, 0xff & ''},
    {XK_U, 0xff & ''},
    {XK_i, 0xff & ''},
    {XK_I, 0xff & ''},
    {XK_o, 0xff & ''},
    {XK_O, 0xff & ''},

    {XK_a, 0xff & ''},
    {XK_A, 0xff & ''},
    {XK_s, 0xff & ''},
    {XK_S, 0xff & ''},
    {XK_d, 0xff & ''},
    {XK_D, 0xff & ''},
    {XK_l, 0xff & ''},
    {XK_L, 0xff & ''},

    {XK_z, 0xff & ''},
    {XK_Z, 0xff & ''},
    {XK_x, 0xff & ''},
    {XK_X, 0xff & ''},
    {XK_c, 0xff & ''},
    {XK_C, 0xff & ''},
    {XK_n, 0xff & ''},
    {XK_N, 0xff & ''},

    {XK_plus, 0xff & ''},
    {0,}
};

static struct remapKey keyboardFirst[] =
{
    {XK_w, 0xff & ''},
    {XK_W, 0xff & ''},
    {XK_e, 0xff & ''},
    {XK_E, 0xff & ''},
    {XK_r, 0xff & ''},
    {XK_R, 0xff & ''},
    {XK_t, 0xff & ''},
    {XK_T, 0xff & ''},
    {XK_y, 0xff & ''},
    {XK_Y, 0xff & ''},
    {XK_u, 0xff & ''},
    {XK_U, 0xff & ''},
    {XK_i, 0xff & ''},
    {XK_I, 0xff & ''},
    {XK_o, 0xff & ''},
    {XK_O, 0xff & ''},
    {XK_p, 0xff & ''},
    {XK_P, 0xff & ''},

    {XK_a, 0xff & ''},
    {XK_A, 0xff & ''},
    {XK_s, 0xff & ''},
    {XK_S, 0xff & ''},
    {XK_d, 0xff & ''},
    {XK_D, 0xff & ''},
    {XK_h, 0xff & ''},
    {XK_H, 0xff & ''},
    {XK_l, 0xff & ''},
    {XK_L, 0xff & ''},

    {XK_z, 0xff & ''},
    {XK_Z, 0xff & ''},
    {XK_x, 0xff & ''},
    {XK_X, 0xff & ''},
    {XK_c, 0xff & ''},
    {XK_C, 0xff & ''},
    {XK_b, 0xff & ''},
    {XK_B, 0xff & ''},
    {XK_n, 0xff & ''},
    {XK_N, 0xff & ''},

    {0,}
};

static struct remapKey keyboardSecond[] =
{
    {XK_equal, 0xff & ''},
    {XK_plus, 0xff & ''},

    {XK_e, 0xff & ''},
    {XK_E, 0xff & ''},
    {XK_r, 0xff & ''},
    {XK_R, 0xff & ''},
    {XK_t, 0xff & ''},
    {XK_T, 0xff & ''},
    {XK_u, 0xff & ''},
    {XK_U, 0xff & ''},
    {XK_i, 0xff & ''},
    {XK_I, 0xff & ''},
    {XK_o, 0xff & ''},
    {XK_O, 0xff & ''},

    {XK_a, 0xff & ''},
    {XK_A, 0xff & ''},
    {XK_s, 0xff & ''},
    {XK_S, 0xff & ''},
    {XK_d, 0xff & ''},
    {XK_D, 0xff & ''},
    {XK_l, 0xff & ''},
    {XK_L, 0xff & ''},

    {XK_z, 0xff & ''},
    {XK_Z, 0xff & ''},
    {XK_x, 0xff & ''},
    {XK_X, 0xff & ''},
    {XK_c, 0xff & ''},
    {XK_C, 0xff & ''},
    {XK_n, 0xff & ''},
    {XK_N, 0xff & ''},

    {0,}
};



static struct remapKey keyboardThird[] =
{
    {XK_a, 0xff & ''},
    {XK_A, 0xff & ''},
    {XK_e, 0xff & ''},
    {XK_E, 0xff & ''},
    {XK_u, 0xff & ''},
    {XK_U, 0xff & ''},
    {XK_o, 0xff & ''},
    {XK_O, 0xff & ''},

    {XK_s, 0xff & ''},
    {XK_S, 0xff & ''},
    {XK_l, 0xff & ''},
    {XK_L, 0xff & ''},

    {XK_z, 0xff & ''},
    {XK_Z, 0xff & ''},
    {XK_c, 0xff & ''},
    {XK_C, 0xff & ''},

    {0,}
};

static struct remapKey keyboardFourth[] =
{
    {XK_a, 0xff & ''},
    {XK_A, 0xff & ''},
    {XK_e, 0xff & ''},
    {XK_E, 0xff & ''},
    {XK_u, 0xff & ''},
    {XK_U, 0xff & ''},
    {XK_o, 0xff & ''},
    {XK_O, 0xff & ''},

    {XK_l, 0xff & ''},
    {XK_L, 0xff & ''},

    {0,}
};

static struct remapKey keyboardFifth[] =
{
    {XK_a, 0xff & ''},
    {XK_A, 0xff & ''},
    {XK_o, 0xff & ''},
    {XK_O, 0xff & ''},

    {XK_l, 0xff & '|'},
    {XK_L, 0xff & '|'},

    {0,}
};

#define KEYMAPS_MACRO \
    {keyboardAcute, 0, 0},	/*  1 */ \
    {keyboardCaron, 0, 0},	/*  2 */ \
    {keyboardFirst, 0, 0},	/*  3 */ \
    {keyboardSecond, 0, 0},	/*  4 */ \
    {keyboardThird, 0, 0},	/*  5 */ \
    {keyboardFourth, 0, 0},	/*  6 */ \
    {keyboardFifth, 0, 0},	/*  7 */

#ifdef XK_dead_acute
#define XKB_DEAD_KEYS \
    {keyboardStd, XK_dead_acute, 1}, \
    {keyboardStd, XK_dead_caron, 2}, \
    {keyboardStd, XK_dead_iota, 3}, \
    {keyboardStd, XK_dead_iota, 4}, \
    {keyboardStd, XK_dead_iota, 5}, \
    {keyboardStd, XK_dead_iota, 6}, \
    {keyboardStd, XK_dead_iota, 7}, \
    {keyboardStd, XK_dead_iota, 0},

#else
#define XKB_DEAD_KEYS
#endif

#ifdef XK_F22
#define F22_DEAD_KEYS \
    {keyboardStd, XK_F22, 3}, \
    {keyboardStd, XK_F22, 4}, \
    {keyboardStd, XK_F22, 5}, \
    {keyboardStd, XK_F22, 6}, \
    {keyboardStd, XK_F22, 7}, \
    {keyboardStd, XK_F22, 0},
#else
#define F22_DEAD_KEYS
#endif

#define KBD_MACRO \
    {keyboardStd, XK_Print, 3}, \
    {keyboardStd, XK_Print, 4}, \
    {keyboardStd, XK_Print, 5}, \
    {keyboardStd, XK_Print, 6}, \
    {keyboardStd, XK_Print, 7}, \
    {keyboardStd, XK_Print, 0}, \
    XKB_DEAD_KEYS \
    F22_DEAD_KEYS

static struct keyboardRec kbdStdRec[] =
{
    {keyboardStd, 0, 0},	/*  0 */

    KEYMAPS_MACRO
    
    KBD_MACRO

    {NULL,}
};

/* czech extra keyboard definition */
#include <con_ikcz.h>

/* slovak extra keyboard definition */
#include <con_iksk.h>

static struct keyboardRec *nationalEnKey[] =
{
    kbdStdRec,
    kbdStdRec,
    kbdStdRec,
    0
};

static struct keyboardLayoutRec nationalKey[] =
{
    { "cz", nationalCzKey },
    { "cs", nationalCzKey },
    { "sk", nationalSkKey },
    { NULL, nationalEnKey }
};

#endif
