#!/bin/sh
set -o nounset

oneTimeSetUp() {
	# Load the ./play.it library
	. lib/libplayit2.sh
}

# Check that icon_application does not get confused between applications with similar names.
test_icon_applications_mixup() {
	local \
		APPLICATIONS_LIST='APP_HOF APP_HOFEDIT' \
		APP_HOF_ID='heroes-of-might-and-magic-5-hammers-of-fate' \
		APP_HOFEDIT_ID='heroes-of-might-and-magic-5-hammers-of-fate-map-editor' \
		application

	application=$(icon_application 'APP_HOFEDIT_ID')

	assertEquals \
		'icon_application linked an icon to the wrong application.' \
		'APP_HOFEDIT' "$application"

	return 0
}
