/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 13:42:04 GMT 2018
 */

package uk.ac.sanger.artemis.util;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.util.WorkingGZIPInputStream;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class WorkingGZIPInputStream_ESTest extends WorkingGZIPInputStream_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      InputStream inputStream0 = mock(InputStream.class, new ViolatedAssumptionAnswer());
      doReturn(0, 0).when(inputStream0).read();
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream(inputStream0, 960);
        fail("Expecting exception: ZipException");
      
      } catch(Throwable e) {
         //
         // Not in GZIP format
         //
         verifyException("java.util.zip.GZIPInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream((InputStream) null, (-100));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.zip.InflaterInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      InputStream inputStream0 = mock(InputStream.class, new ViolatedAssumptionAnswer());
      doReturn(1822).when(inputStream0).read();
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream(inputStream0, 1854);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // codegen.java.io.InputStream$MockitoMock$890694829.read() returned value out of range -1..255: 1822
         //
         verifyException("java.util.zip.GZIPInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      InputStream inputStream0 = mock(InputStream.class, new ViolatedAssumptionAnswer());
      doReturn((-1)).when(inputStream0).read();
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream(inputStream0, 3127);
        fail("Expecting exception: EOFException");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.zip.GZIPInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      InputStream inputStream0 = mock(InputStream.class, new ViolatedAssumptionAnswer());
      doReturn(0, 0).when(inputStream0).read();
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream(inputStream0);
        fail("Expecting exception: ZipException");
      
      } catch(Throwable e) {
         //
         // Not in GZIP format
         //
         verifyException("java.util.zip.GZIPInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream((InputStream) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.zip.InflaterInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      InputStream inputStream0 = mock(InputStream.class, new ViolatedAssumptionAnswer());
      doReturn(1679).when(inputStream0).read();
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream(inputStream0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // codegen.java.io.InputStream$MockitoMock$890694829.read() returned value out of range -1..255: 1679
         //
         verifyException("java.util.zip.GZIPInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      InputStream inputStream0 = mock(InputStream.class, new ViolatedAssumptionAnswer());
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream(inputStream0, (-3932));
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // buffer size <= 0
         //
         verifyException("java.util.zip.InflaterInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test8()  throws Throwable  {
      InputStream inputStream0 = mock(InputStream.class, new ViolatedAssumptionAnswer());
      doReturn((-1)).when(inputStream0).read();
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream(inputStream0);
        fail("Expecting exception: EOFException");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.zip.GZIPInputStream", e);
      }
  }
}
