# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network private-endpoint dns-zone-group wait",
)
class Wait(AAZWaitCommand):
    """Place the CLI in a waiting state until a condition is met.
    """

    _aaz_info = {
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/privateendpoints/{}/privatednszonegroups/{}", "2022-01-01", "properties.privateDnsZoneConfigs[]"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="Name of the private dns zone group.",
            required=True,
            id_part="child_name_1",
        )
        _args_schema.endpoint_name = AAZStrArg(
            options=["--endpoint-name"],
            help="Name of the private endpoint.",
            required=True,
            id_part="name",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.PrivateDnsZoneGroupsGet(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=False)
        return result

    class PrivateDnsZoneGroupsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}/privateDnsZoneGroups/{privateDnsZoneGroupName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "privateDnsZoneGroupName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "privateEndpointName", self.ctx.args.endpoint_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _WaitHelper._build_schema_private_dns_zone_group_read(cls._schema_on_200)

            return cls._schema_on_200


class _WaitHelper:
    """Helper class for Wait"""

    _schema_private_dns_zone_group_read = None

    @classmethod
    def _build_schema_private_dns_zone_group_read(cls, _schema):
        if cls._schema_private_dns_zone_group_read is not None:
            _schema.etag = cls._schema_private_dns_zone_group_read.etag
            _schema.id = cls._schema_private_dns_zone_group_read.id
            _schema.name = cls._schema_private_dns_zone_group_read.name
            _schema.properties = cls._schema_private_dns_zone_group_read.properties
            return

        cls._schema_private_dns_zone_group_read = _schema_private_dns_zone_group_read = AAZObjectType()

        private_dns_zone_group_read = _schema_private_dns_zone_group_read
        private_dns_zone_group_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        private_dns_zone_group_read.id = AAZStrType()
        private_dns_zone_group_read.name = AAZStrType()
        private_dns_zone_group_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_private_dns_zone_group_read.properties
        properties.private_dns_zone_configs = AAZListType(
            serialized_name="privateDnsZoneConfigs",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        private_dns_zone_configs = _schema_private_dns_zone_group_read.properties.private_dns_zone_configs
        private_dns_zone_configs.Element = AAZObjectType()

        _element = _schema_private_dns_zone_group_read.properties.private_dns_zone_configs.Element
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_private_dns_zone_group_read.properties.private_dns_zone_configs.Element.properties
        properties.private_dns_zone_id = AAZStrType(
            serialized_name="privateDnsZoneId",
        )
        properties.record_sets = AAZListType(
            serialized_name="recordSets",
            flags={"read_only": True},
        )

        record_sets = _schema_private_dns_zone_group_read.properties.private_dns_zone_configs.Element.properties.record_sets
        record_sets.Element = AAZObjectType()

        _element = _schema_private_dns_zone_group_read.properties.private_dns_zone_configs.Element.properties.record_sets.Element
        _element.fqdn = AAZStrType()
        _element.ip_addresses = AAZListType(
            serialized_name="ipAddresses",
        )
        _element.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        _element.record_set_name = AAZStrType(
            serialized_name="recordSetName",
        )
        _element.record_type = AAZStrType(
            serialized_name="recordType",
        )
        _element.ttl = AAZIntType()

        ip_addresses = _schema_private_dns_zone_group_read.properties.private_dns_zone_configs.Element.properties.record_sets.Element.ip_addresses
        ip_addresses.Element = AAZStrType()

        _schema.etag = cls._schema_private_dns_zone_group_read.etag
        _schema.id = cls._schema_private_dns_zone_group_read.id
        _schema.name = cls._schema_private_dns_zone_group_read.name
        _schema.properties = cls._schema_private_dns_zone_group_read.properties


__all__ = ["Wait"]
