.TH "MPTOPDF" "1" "January 2007" "mptopdf 1.3.2" "ConTeXt"
.de URL
\\$2 \(laURL: \\$1 \(ra\\$3
..
.if \n[.g] .mso www.tmac
.de EX
.in +3
.nf
.ft CW
..
.de EE
.in -3
.ft R
.fi
..

.SH "NAME"
mptopdf \- convert MetaPost to PDF

.SH "SYNOPSIS"
\fBmptopdf\fP \fIFILE\fP [ ...  ]

.SH "DESCRIPTION"

\fBmptopdf\fP can convert MetaPost-generated EPS files to PDF, or it
can process a MetaPost source file directly (see
.BR mpost (1))
and convert the generated EPS files to PDF.

.SH "OPTIONS"
All switches are specified in full here but can be abbreviated to the
shortest unique prefix.   Thus, \fB--metaf\fP works the same as
\fB--metafun\fP.
.IP \fB--help\fP
Print a terse help message.
.IP "\fB--metafun\fP"
Use the metafun pre-compiled format to process the MetaPost source
file.  You usually don't need this option, since metafun input is
usually produced and processed as part of a
.BR texexec (1)
run.  Needs the \fB--rawmp\fP switch to take effect.
.IP \fB--rawmp\fP
Process the source file with
.BR mpost (1)
directly, rather than with
.BR texexec (1).
This option is needed if you want to specify \fB--metafun\fP.
.IP \fB--latex\fP
Typeseting labels using
.BR latex (1)
rather than plain
.BR tex (1).

.SH "USAGE"

To convert \fImanfig.20\fP to \fImanfig-20.pdf\fI:
.EX
mptopdf manfig.20
.EE

You can convert more than one EPS file at once:
.EX
mptopdf manfig.20 otherfig.17 finalfig.8
.EE

Or you can give
.BR mptopdf (1)
a pattern that it will expand:
.EX
mptopdf 'manfig.*'
.EE
Note the single quotes to protect the * from the shell.  Of course,
usually you can let the shell do the wildcard expansion and therefore
leave off the quotes.

To convert
.I figs.mp
to \fIfigs-1.pdf\fP, \fIfigs-2.pdf\fP, ...
.EX
mptopdf figs.mp
.EE

If the labels are typeset with
.BR latex (1):
.EX
mptopdf --latex figs.mp
.EE

.SH "SEE ALSO"
.IP \(bu
.BR tex (1),
.BR latex (1),
.BR mpost (1),
.BR texexec (1).
.IP \(bu
.URL "http://www.contextgarden.net" "ConTeXt wiki" .

.SH "AUTHOR"
.BR mptopdf (1)
is part of the ConTeXt package available from
.URL "http://www.pragma-ade.com/dir/general/manuals/" "PRAGMA ADE" .
This manpage was written by Sanjoy Mahajan <sanjoy@mit.edu> and is in
the public domain.
