/* GtkMult.c generated by valac 0.12.0, the Vala compiler
 * generated from GtkMult.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/*
    Multiplication Puzzle
    Copyright (C) 2004-2008,2011 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <config.h>
#include <pango/pango.h>


#define TYPE_GTK_MULT (gtk_mult_get_type ())
#define GTK_MULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GTK_MULT, GtkMult))
#define GTK_MULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GTK_MULT, GtkMultClass))
#define IS_GTK_MULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GTK_MULT))
#define IS_GTK_MULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GTK_MULT))
#define GTK_MULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GTK_MULT, GtkMultClass))

typedef struct _GtkMult GtkMult;
typedef struct _GtkMultClass GtkMultClass;
typedef struct _GtkMultPrivate GtkMultPrivate;

#define TYPE_MULT_PUZZLE (mult_puzzle_get_type ())
#define MULT_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULT_PUZZLE, MultPuzzle))
#define MULT_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULT_PUZZLE, MultPuzzleClass))
#define IS_MULT_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULT_PUZZLE))
#define IS_MULT_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULT_PUZZLE))
#define MULT_PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULT_PUZZLE, MultPuzzleClass))

typedef struct _MultPuzzle MultPuzzle;
typedef struct _MultPuzzleClass MultPuzzleClass;

#define TYPE_CANVAS (canvas_get_type ())
#define CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS, Canvas))
#define CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS, CanvasClass))
#define IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS))
#define IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS))
#define CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS, CanvasClass))

typedef struct _Canvas Canvas;
typedef struct _CanvasClass CanvasClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MULT_PUZZLE_CHAR (mult_puzzle_char_get_type ())

#define TYPE_MULT_PUZZLE_GUESS_STATUS (mult_puzzle_guess_status_get_type ())
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _GtkMult {
	GtkWindow parent_instance;
	GtkMultPrivate * priv;
};

struct _GtkMultClass {
	GtkWindowClass parent_class;
};

struct _GtkMultPrivate {
	MultPuzzle* _puzzle;
	gboolean _cheated;
	GtkStatusbar* _status;
	GtkAction* solve_action;
	GtkAction* hint_action;
	Canvas* canvas;
	GtkVBox* vbox;
	GTimer* timer;
	GtkLabel* timer_label;
	GtkLabel* score;
	GtkHBox* status_box;
	guint status_timeout_id;
	guint timer_timeout_id;
	GtkAboutDialog* _about;
};

typedef enum  {
	MULT_PUZZLE_CHAR_A = 65,
	MULT_PUZZLE_CHAR_B,
	MULT_PUZZLE_CHAR_C,
	MULT_PUZZLE_CHAR_D,
	MULT_PUZZLE_CHAR_E,
	MULT_PUZZLE_CHAR_F,
	MULT_PUZZLE_CHAR_G,
	MULT_PUZZLE_CHAR_H,
	MULT_PUZZLE_CHAR_I,
	MULT_PUZZLE_CHAR_J,
	MULT_PUZZLE_CHAR_INVALID
} MultPuzzleChar;

typedef enum  {
	MULT_PUZZLE_GUESS_STATUS_WRONG,
	MULT_PUZZLE_GUESS_STATUS_CORRECT,
	MULT_PUZZLE_GUESS_STATUS_KNOWN,
	MULT_PUZZLE_GUESS_STATUS_INVALID
} MultPuzzleGuessStatus;


static gpointer gtk_mult_parent_class = NULL;
extern gint gtk_mult_dpi;
gint gtk_mult_dpi = 0;
static gunichar gtk_mult_a_char;
static gunichar gtk_mult_a_char = 0U;
static gunichar gtk_mult_b_char;
static gunichar gtk_mult_b_char = 0U;
static gunichar gtk_mult_c_char;
static gunichar gtk_mult_c_char = 0U;
static gunichar gtk_mult_d_char;
static gunichar gtk_mult_d_char = 0U;
static gunichar gtk_mult_e_char;
static gunichar gtk_mult_e_char = 0U;
static gunichar gtk_mult_f_char;
static gunichar gtk_mult_f_char = 0U;
static gunichar gtk_mult_g_char;
static gunichar gtk_mult_g_char = 0U;
static gunichar gtk_mult_h_char;
static gunichar gtk_mult_h_char = 0U;
static gunichar gtk_mult_i_char;
static gunichar gtk_mult_i_char = 0U;
static gunichar gtk_mult_j_char;
static gunichar gtk_mult_j_char = 0U;
static gunichar gtk_mult_0_char;
static gunichar gtk_mult_0_char = 0U;
static gunichar gtk_mult_1_char;
static gunichar gtk_mult_1_char = 0U;
static gunichar gtk_mult_2_char;
static gunichar gtk_mult_2_char = 0U;
static gunichar gtk_mult_3_char;
static gunichar gtk_mult_3_char = 0U;
static gunichar gtk_mult_4_char;
static gunichar gtk_mult_4_char = 0U;
static gunichar gtk_mult_5_char;
static gunichar gtk_mult_5_char = 0U;
static gunichar gtk_mult_6_char;
static gunichar gtk_mult_6_char = 0U;
static gunichar gtk_mult_7_char;
static gunichar gtk_mult_7_char = 0U;
static gunichar gtk_mult_8_char;
static gunichar gtk_mult_8_char = 0U;
static gunichar gtk_mult_9_char;
static gunichar gtk_mult_9_char = 0U;

GType gtk_mult_get_type (void) G_GNUC_CONST;
GType mult_puzzle_get_type (void) G_GNUC_CONST;
GType canvas_get_type (void) G_GNUC_CONST;
#define GTK_MULT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GTK_MULT, GtkMultPrivate))
enum  {
	GTK_MULT_DUMMY_PROPERTY,
	GTK_MULT_PUZZLE,
	GTK_MULT_CHEATED,
	GTK_MULT_STATUS
};
#define GTK_MULT_ASPECT (8.0 / 6.0)
void gtk_mult_clear_guess_feedback (GtkMult* self);
static gboolean gtk_mult_pop_guess_feedback (GtkMult* self);
static gboolean gtk_mult_handle_key_press (GtkMult* self, GdkEventKey* event);
void canvas_clear_mode (Canvas* self);
void canvas_start_choice (Canvas* self, gchar ch);
static GtkWidget* gtk_mult_setup_menu (GtkMult* self);
static void gtk_mult_on_menu_game_new (GtkMult* self);
static void _gtk_mult_on_menu_game_new_gtk_action_activate (GtkAction* _sender, gpointer self);
static void gtk_mult_on_menu_game_hint (GtkMult* self);
static void _gtk_mult_on_menu_game_hint_gtk_action_activate (GtkAction* _sender, gpointer self);
static void gtk_mult_on_menu_game_solve (GtkMult* self);
static void _gtk_mult_on_menu_game_solve_gtk_action_activate (GtkAction* _sender, gpointer self);
static void gtk_mult_on_menu_game_close (GtkMult* self);
static void _gtk_mult_on_menu_game_close_gtk_action_activate (GtkAction* _sender, gpointer self);
static void gtk_mult_on_menu_help_about (GtkMult* self);
static void _gtk_mult_on_menu_help_about_gtk_action_activate (GtkAction* _sender, gpointer self);
static void gtk_mult_on_menu_select_new (GtkMult* self);
static void _gtk_mult_on_menu_select_new_gtk_menu_item_select (GtkMenuItem* _sender, gpointer self);
static void gtk_mult_on_menu_deselect (GtkMult* self);
static void _gtk_mult_on_menu_deselect_gtk_menu_item_deselect (GtkMenuItem* _sender, gpointer self);
static void gtk_mult_on_menu_select_hint (GtkMult* self);
static void _gtk_mult_on_menu_select_hint_gtk_menu_item_select (GtkMenuItem* _sender, gpointer self);
static void gtk_mult_on_menu_select_solve (GtkMult* self);
static void _gtk_mult_on_menu_select_solve_gtk_menu_item_select (GtkMenuItem* _sender, gpointer self);
static void gtk_mult_on_menu_select_close (GtkMult* self);
static void _gtk_mult_on_menu_select_close_gtk_menu_item_select (GtkMenuItem* _sender, gpointer self);
static void gtk_mult_on_menu_select_about (GtkMult* self);
static void _gtk_mult_on_menu_select_about_gtk_menu_item_select (GtkMenuItem* _sender, gpointer self);
static void gtk_mult_new_puzzle (GtkMult* self);
GtkStatusbar* gtk_mult_get_status (GtkMult* self);
static void gtk_mult_set_status (GtkMult* self, GtkStatusbar* value);
MultPuzzle* mult_puzzle_new (gint num_x, gint num_y);
MultPuzzle* mult_puzzle_construct (GType object_type, gint num_x, gint num_y);
static void gtk_mult_set_puzzle (GtkMult* self, MultPuzzle* value);
Canvas* canvas_new (GtkMult* mult);
Canvas* canvas_construct (GType object_type, GtkMult* mult);
static gboolean gtk_mult_update_timer (GtkMult* self);
static gboolean _gtk_mult_update_timer_gsource_func (gpointer self);
static void gtk_mult_set_cheated (GtkMult* self, gboolean value);
static void gtk_mult_update_score (GtkMult* self);
static void gtk_mult_on_puzzle_change (GtkMult* self, MultPuzzle* p);
MultPuzzle* gtk_mult_get_puzzle (GtkMult* self);
GType mult_puzzle_char_get_type (void) G_GNUC_CONST;
GType mult_puzzle_guess_status_get_type (void) G_GNUC_CONST;
static void gtk_mult_on_puzzle_guess (GtkMult* self, MultPuzzle* p, gint digit, MultPuzzleChar letter, MultPuzzleGuessStatus response);
static void _gtk_mult_on_puzzle_guess_mult_puzzle_guessed (MultPuzzle* _sender, gint digit, MultPuzzleChar letter, MultPuzzleGuessStatus status, gpointer self);
static void _gtk_mult_on_puzzle_change_mult_puzzle_changed (MultPuzzle* _sender, gpointer self);
gboolean mult_puzzle_get_is_done (MultPuzzle* self);
static gboolean _gtk_mult_pop_guess_feedback_gsource_func (gpointer self);
gint mult_puzzle_get_wrong_guesses (MultPuzzle* self);
gboolean gtk_mult_get_cheated (GtkMult* self);
void mult_puzzle_solve (MultPuzzle* self);
gboolean* mult_puzzle_get_needed_digits (MultPuzzle* self, int* result_length1);
MultPuzzleChar mult_puzzle_solve_digit (MultPuzzle* self, gint digit);
static GtkAboutDialog* gtk_mult_get_about (GtkMult* self);
static void gtk_mult_set_about (GtkMult* self, GtkAboutDialog* value);
static void _lambda0_ (GtkDialog* dlg, gint resp, GtkMult* self);
static void __lambda0__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
gint gtk_mult_main (gchar** args, int args_length1);
GtkMult* gtk_mult_new (void);
GtkMult* gtk_mult_construct (GType object_type);
static GObject * gtk_mult_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _gtk_mult_handle_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void _gtk_main_quit_gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void gtk_mult_finalize (GObject* obj);
static void _vala_gtk_mult_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gtk_mult_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* GTK_MULT_authors[2] = {"Michael Terry <mike@mterry.name>", NULL};
static const gchar* GTK_MULT_artists[3] = {"Eugenia Loli-Queru <eloli@hotmail.com>", "Michael Terry <mike@mterry.name>", NULL};

static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


void gtk_mult_clear_guess_feedback (GtkMult* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->status_timeout_id != 0) {
		g_source_remove (self->priv->status_timeout_id);
	}
	gtk_mult_pop_guess_feedback (self);
}


static gboolean gtk_mult_handle_key_press (GtkMult* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GdkModifierType _tmp0_;
	GdkModifierType state;
	gchar ch = '\0';
	guint _tmp1_;
	guint32 _tmp2_;
	gunichar ev_char;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_accelerator_get_default_mod_mask ();
	state = (*event).state & _tmp0_;
	state = state & (~0x03);
	if (state != 0) {
		result = FALSE;
		return result;
	}
	_tmp1_ = gdk_keyval_to_upper ((*event).keyval);
	_tmp2_ = gdk_keyval_to_unicode (_tmp1_);
	ev_char = (gunichar) _tmp2_;
	if (ev_char == gtk_mult_a_char) {
		ch = 'A';
	} else {
		if (ev_char == gtk_mult_b_char) {
			ch = 'B';
		} else {
			if (ev_char == gtk_mult_c_char) {
				ch = 'C';
			} else {
				if (ev_char == gtk_mult_d_char) {
					ch = 'D';
				} else {
					if (ev_char == gtk_mult_e_char) {
						ch = 'E';
					} else {
						if (ev_char == gtk_mult_f_char) {
							ch = 'F';
						} else {
							if (ev_char == gtk_mult_g_char) {
								ch = 'G';
							} else {
								if (ev_char == gtk_mult_h_char) {
									ch = 'H';
								} else {
									if (ev_char == gtk_mult_i_char) {
										ch = 'I';
									} else {
										if (ev_char == gtk_mult_j_char) {
											ch = 'J';
										} else {
											if (ev_char == gtk_mult_0_char) {
												ch = '0';
											} else {
												if (ev_char == gtk_mult_1_char) {
													ch = '1';
												} else {
													if (ev_char == gtk_mult_2_char) {
														ch = '2';
													} else {
														if (ev_char == gtk_mult_3_char) {
															ch = '3';
														} else {
															if (ev_char == gtk_mult_4_char) {
																ch = '4';
															} else {
																if (ev_char == gtk_mult_5_char) {
																	ch = '5';
																} else {
																	if (ev_char == gtk_mult_6_char) {
																		ch = '6';
																	} else {
																		if (ev_char == gtk_mult_7_char) {
																			ch = '7';
																		} else {
																			if (ev_char == gtk_mult_8_char) {
																				ch = '8';
																			} else {
																				if (ev_char == gtk_mult_9_char) {
																					ch = '9';
																				} else {
																					if ((*event).keyval == 65307) {
																						canvas_clear_mode (self->priv->canvas);
																						result = TRUE;
																						return result;
																					} else {
																						result = FALSE;
																						return result;
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	canvas_start_choice (self->priv->canvas, ch);
	result = TRUE;
	return result;
}


static void _gtk_mult_on_menu_game_new_gtk_action_activate (GtkAction* _sender, gpointer self) {
	gtk_mult_on_menu_game_new (self);
}


static void _gtk_mult_on_menu_game_hint_gtk_action_activate (GtkAction* _sender, gpointer self) {
	gtk_mult_on_menu_game_hint (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _gtk_mult_on_menu_game_solve_gtk_action_activate (GtkAction* _sender, gpointer self) {
	gtk_mult_on_menu_game_solve (self);
}


static void _gtk_mult_on_menu_game_close_gtk_action_activate (GtkAction* _sender, gpointer self) {
	gtk_mult_on_menu_game_close (self);
}


static void _gtk_mult_on_menu_help_about_gtk_action_activate (GtkAction* _sender, gpointer self) {
	gtk_mult_on_menu_help_about (self);
}


static void _gtk_mult_on_menu_select_new_gtk_menu_item_select (GtkMenuItem* _sender, gpointer self) {
	gtk_mult_on_menu_select_new (self);
}


static void _gtk_mult_on_menu_deselect_gtk_menu_item_deselect (GtkMenuItem* _sender, gpointer self) {
	gtk_mult_on_menu_deselect (self);
}


static void _gtk_mult_on_menu_select_hint_gtk_menu_item_select (GtkMenuItem* _sender, gpointer self) {
	gtk_mult_on_menu_select_hint (self);
}


static void _gtk_mult_on_menu_select_solve_gtk_menu_item_select (GtkMenuItem* _sender, gpointer self) {
	gtk_mult_on_menu_select_solve (self);
}


static void _gtk_mult_on_menu_select_close_gtk_menu_item_select (GtkMenuItem* _sender, gpointer self) {
	gtk_mult_on_menu_select_close (self);
}


static void _gtk_mult_on_menu_select_about_gtk_menu_item_select (GtkMenuItem* _sender, gpointer self) {
	gtk_mult_on_menu_select_about (self);
}


static GtkWidget* gtk_mult_setup_menu (GtkMult* self) {
	GtkWidget* result = NULL;
	GtkActionGroup* _tmp0_ = NULL;
	GtkActionGroup* action_group;
	const gchar* _tmp1_ = NULL;
	GtkAction* _tmp2_ = NULL;
	GtkAction* action;
	GtkAction* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkAction* _tmp5_ = NULL;
	GtkAction* _tmp6_;
	const gchar* _tmp7_ = NULL;
	GtkAction* _tmp8_ = NULL;
	GtkAction* _tmp9_;
	GtkAction* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkAction* _tmp12_ = NULL;
	GtkAction* _tmp13_ = NULL;
	gchar* _tmp14_;
	gchar* ui;
	GtkUIManager* _tmp15_ = NULL;
	GtkUIManager* manager;
	GtkAccelGroup* _tmp16_ = NULL;
	GtkWidget* _tmp17_ = NULL;
	GtkWidget* _tmp18_;
	GtkMenuItem* _tmp19_;
	GtkMenuItem* menu_item;
	GtkWidget* _tmp20_ = NULL;
	GtkWidget* _tmp21_;
	GtkMenuItem* _tmp22_;
	GtkWidget* _tmp23_ = NULL;
	GtkWidget* _tmp24_;
	GtkMenuItem* _tmp25_;
	GtkWidget* _tmp26_ = NULL;
	GtkWidget* _tmp27_;
	GtkMenuItem* _tmp28_;
	GtkWidget* _tmp29_ = NULL;
	GtkWidget* _tmp30_;
	GtkMenuItem* _tmp31_;
	GtkWidget* _tmp32_ = NULL;
	GtkWidget* _tmp33_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_action_group_new ("gmult-actions");
	action_group = _tmp0_;
	_tmp1_ = _ ("_Game");
	_tmp2_ = gtk_action_new ("GameMenuAction", _tmp1_, NULL, NULL);
	action = _tmp2_;
	gtk_action_group_add_action (action_group, action);
	_tmp3_ = gtk_action_new ("NewAction", NULL, NULL, GTK_STOCK_NEW);
	_g_object_unref0 (action);
	action = _tmp3_;
	g_signal_connect_object (action, "activate", (GCallback) _gtk_mult_on_menu_game_new_gtk_action_activate, self, 0);
	gtk_action_group_add_action_with_accel (action_group, action, "<control>N");
	_tmp4_ = _ ("_Hint");
	_tmp5_ = gtk_action_new ("HintAction", _tmp4_, NULL, NULL);
	_g_object_unref0 (action);
	action = _tmp5_;
	g_signal_connect_object (action, "activate", (GCallback) _gtk_mult_on_menu_game_hint_gtk_action_activate, self, 0);
	gtk_action_group_add_action_with_accel (action_group, action, "<control>H");
	_tmp6_ = _g_object_ref0 (action);
	_g_object_unref0 (self->priv->hint_action);
	self->priv->hint_action = _tmp6_;
	_tmp7_ = _ ("_Solve");
	_tmp8_ = gtk_action_new ("SolveAction", _tmp7_, NULL, NULL);
	_g_object_unref0 (action);
	action = _tmp8_;
	g_signal_connect_object (action, "activate", (GCallback) _gtk_mult_on_menu_game_solve_gtk_action_activate, self, 0);
	gtk_action_group_add_action (action_group, action);
	_tmp9_ = _g_object_ref0 (action);
	_g_object_unref0 (self->priv->solve_action);
	self->priv->solve_action = _tmp9_;
	_tmp10_ = gtk_action_new ("CloseAction", NULL, NULL, GTK_STOCK_CLOSE);
	_g_object_unref0 (action);
	action = _tmp10_;
	g_signal_connect_object (action, "activate", (GCallback) _gtk_mult_on_menu_game_close_gtk_action_activate, self, 0);
	gtk_action_group_add_action_with_accel (action_group, action, "<control>W");
	_tmp11_ = _ ("_Help");
	_tmp12_ = gtk_action_new ("HelpMenuAction", _tmp11_, NULL, NULL);
	_g_object_unref0 (action);
	action = _tmp12_;
	gtk_action_group_add_action (action_group, action);
	_tmp13_ = gtk_action_new ("AboutAction", NULL, NULL, GTK_STOCK_ABOUT);
	_g_object_unref0 (action);
	action = _tmp13_;
	g_signal_connect_object (action, "activate", (GCallback) _gtk_mult_on_menu_help_about_gtk_action_activate, self, 0);
	gtk_action_group_add_action (action_group, action);
	_tmp14_ = g_strdup ("\n" \
"<ui>\n" \
"  <menubar>\n" \
"    <menu name=\"GameMenu\" action=\"GameMenuAction\">\n" \
"      <menuitem name=\"New\" action=\"NewAction\" />\n" \
"      <separator />\n" \
"      <menuitem name=\"Hint\" action=\"HintAction\" />\n" \
"      <menuitem name=\"Solve\" action=\"SolveAction\" />\n" \
"      <separator />\n" \
"      <menuitem name=\"Close\" action=\"CloseAction\" />\n" \
"    </menu>\n" \
"    <menu name=\"HelpMenu\" action=\"HelpMenuAction\">\n" \
"      <menuitem name=\"About\" action=\"AboutAction\"/>\n" \
"    </menu>\n" \
"  </menubar>\n" \
"</ui>");
	ui = _tmp14_;
	_tmp15_ = gtk_ui_manager_new ();
	manager = _tmp15_;
	gtk_ui_manager_add_ui_from_string (manager, ui, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_error ("GtkMult.vala:206: Internal error: bad ui string.\n");
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (manager);
		_g_free0 (ui);
		_g_object_unref0 (action);
		_g_object_unref0 (action_group);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	gtk_ui_manager_insert_action_group (manager, action_group, 0);
	_tmp16_ = gtk_ui_manager_get_accel_group (manager);
	gtk_window_add_accel_group ((GtkWindow*) self, _tmp16_);
	_tmp17_ = gtk_ui_manager_get_widget (manager, "/ui/menubar/GameMenu/New");
	_tmp18_ = _tmp17_;
	_tmp19_ = _g_object_ref0 (GTK_IS_MENU_ITEM (_tmp18_) ? ((GtkMenuItem*) _tmp18_) : NULL);
	menu_item = _tmp19_;
	g_signal_connect_object (menu_item, "select", (GCallback) _gtk_mult_on_menu_select_new_gtk_menu_item_select, self, 0);
	g_signal_connect_object (menu_item, "deselect", (GCallback) _gtk_mult_on_menu_deselect_gtk_menu_item_deselect, self, 0);
	_tmp20_ = gtk_ui_manager_get_widget (manager, "/ui/menubar/GameMenu/Hint");
	_tmp21_ = _tmp20_;
	_tmp22_ = _g_object_ref0 (GTK_IS_MENU_ITEM (_tmp21_) ? ((GtkMenuItem*) _tmp21_) : NULL);
	_g_object_unref0 (menu_item);
	menu_item = _tmp22_;
	g_signal_connect_object (menu_item, "select", (GCallback) _gtk_mult_on_menu_select_hint_gtk_menu_item_select, self, 0);
	g_signal_connect_object (menu_item, "deselect", (GCallback) _gtk_mult_on_menu_deselect_gtk_menu_item_deselect, self, 0);
	_tmp23_ = gtk_ui_manager_get_widget (manager, "/ui/menubar/GameMenu/Solve");
	_tmp24_ = _tmp23_;
	_tmp25_ = _g_object_ref0 (GTK_IS_MENU_ITEM (_tmp24_) ? ((GtkMenuItem*) _tmp24_) : NULL);
	_g_object_unref0 (menu_item);
	menu_item = _tmp25_;
	g_signal_connect_object (menu_item, "select", (GCallback) _gtk_mult_on_menu_select_solve_gtk_menu_item_select, self, 0);
	g_signal_connect_object (menu_item, "deselect", (GCallback) _gtk_mult_on_menu_deselect_gtk_menu_item_deselect, self, 0);
	_tmp26_ = gtk_ui_manager_get_widget (manager, "/ui/menubar/GameMenu/Close");
	_tmp27_ = _tmp26_;
	_tmp28_ = _g_object_ref0 (GTK_IS_MENU_ITEM (_tmp27_) ? ((GtkMenuItem*) _tmp27_) : NULL);
	_g_object_unref0 (menu_item);
	menu_item = _tmp28_;
	g_signal_connect_object (menu_item, "select", (GCallback) _gtk_mult_on_menu_select_close_gtk_menu_item_select, self, 0);
	g_signal_connect_object (menu_item, "deselect", (GCallback) _gtk_mult_on_menu_deselect_gtk_menu_item_deselect, self, 0);
	_tmp29_ = gtk_ui_manager_get_widget (manager, "/ui/menubar/HelpMenu/About");
	_tmp30_ = _tmp29_;
	_tmp31_ = _g_object_ref0 (GTK_IS_MENU_ITEM (_tmp30_) ? ((GtkMenuItem*) _tmp30_) : NULL);
	_g_object_unref0 (menu_item);
	menu_item = _tmp31_;
	g_signal_connect_object (menu_item, "select", (GCallback) _gtk_mult_on_menu_select_about_gtk_menu_item_select, self, 0);
	g_signal_connect_object (menu_item, "deselect", (GCallback) _gtk_mult_on_menu_deselect_gtk_menu_item_deselect, self, 0);
	_tmp32_ = gtk_ui_manager_get_widget (manager, "/ui/menubar");
	_tmp33_ = _g_object_ref0 (_tmp32_);
	result = _tmp33_;
	_g_object_unref0 (menu_item);
	_g_object_unref0 (manager);
	_g_free0 (ui);
	_g_object_unref0 (action);
	_g_object_unref0 (action_group);
	return result;
}


static gboolean _gtk_mult_update_timer_gsource_func (gpointer self) {
	gboolean result;
	result = gtk_mult_update_timer (self);
	return result;
}


static void _gtk_mult_on_puzzle_guess_mult_puzzle_guessed (MultPuzzle* _sender, gint digit, MultPuzzleChar letter, MultPuzzleGuessStatus status, gpointer self) {
	gtk_mult_on_puzzle_guess (self, _sender, digit, letter, status);
}


static void _gtk_mult_on_puzzle_change_mult_puzzle_changed (MultPuzzle* _sender, gpointer self) {
	gtk_mult_on_puzzle_change (self, _sender);
}


static void gtk_mult_new_puzzle (GtkMult* self) {
	GtkStatusbar* _tmp0_ = NULL;
	GtkStatusbar* _tmp1_;
	MultPuzzle* _tmp2_ = NULL;
	MultPuzzle* _tmp3_;
	Canvas* _tmp4_ = NULL;
	GdkGeometry geom = {0};
	guint _tmp5_;
	g_return_if_fail (self != NULL);
	if (self->priv->canvas != NULL) {
		gtk_container_remove ((GtkContainer*) self->priv->vbox, (GtkWidget*) self->priv->canvas);
	}
	if (self->priv->_status != NULL) {
		gtk_container_remove ((GtkContainer*) self->priv->status_box, (GtkWidget*) self->priv->_status);
	}
	_tmp0_ = (GtkStatusbar*) gtk_statusbar_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	gtk_mult_set_status (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	gtk_box_pack_start ((GtkBox*) self->priv->status_box, (GtkWidget*) self->priv->_status, TRUE, TRUE, (guint) 0);
	gtk_box_reorder_child ((GtkBox*) self->priv->status_box, (GtkWidget*) self->priv->_status, 0);
	_tmp2_ = mult_puzzle_new (3, 2);
	_tmp3_ = _tmp2_;
	gtk_mult_set_puzzle (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = canvas_new (self);
	_g_object_unref0 (self->priv->canvas);
	self->priv->canvas = g_object_ref_sink (_tmp4_);
	gtk_box_pack_start ((GtkBox*) self->priv->vbox, (GtkWidget*) self->priv->canvas, TRUE, TRUE, (guint) 0);
	memset (&geom, 0, sizeof (GdkGeometry));
	geom.min_aspect = GTK_MULT_ASPECT;
	geom.max_aspect = GTK_MULT_ASPECT;
	gtk_window_set_geometry_hints ((GtkWindow*) self, (GtkWidget*) self->priv->canvas, &geom, GDK_HINT_ASPECT);
	g_timer_reset (self->priv->timer);
	gtk_mult_update_timer (self);
	if (self->priv->timer_timeout_id != 0) {
		g_source_remove (self->priv->timer_timeout_id);
	}
	_tmp5_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _gtk_mult_update_timer_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->timer_timeout_id = _tmp5_;
	gtk_mult_set_cheated (self, FALSE);
	gtk_widget_show_all ((GtkWidget*) self);
	gtk_mult_update_score (self);
	gtk_mult_on_puzzle_change (self, self->priv->_puzzle);
	if (self->priv->status_timeout_id != 0) {
		g_source_remove (self->priv->status_timeout_id);
	}
	self->priv->status_timeout_id = (guint) 0;
	g_signal_connect_object (self->priv->_puzzle, "guessed", (GCallback) _gtk_mult_on_puzzle_guess_mult_puzzle_guessed, self, 0);
	g_signal_connect_object (self->priv->_puzzle, "changed", (GCallback) _gtk_mult_on_puzzle_change_mult_puzzle_changed, self, 0);
}


static gboolean _gtk_mult_pop_guess_feedback_gsource_func (gpointer self) {
	gboolean result;
	result = gtk_mult_pop_guess_feedback (self);
	return result;
}


static void gtk_mult_on_puzzle_guess (GtkMult* self, MultPuzzle* p, gint digit, MultPuzzleChar letter, MultPuzzleGuessStatus response) {
	guint _tmp0_;
	guint context_id;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	gtk_mult_update_score (self);
	_tmp0_ = gtk_statusbar_get_context_id (self->priv->_status, "guess-feedback");
	context_id = _tmp0_;
	gtk_mult_clear_guess_feedback (self);
	_tmp1_ = mult_puzzle_get_is_done (self->priv->_puzzle);
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = _ ("Congratulations!");
		gtk_statusbar_push (self->priv->_status, context_id, _tmp2_);
	} else {
		gchar* message_pattern;
		message_pattern = NULL;
		switch (response) {
			case MULT_PUZZLE_GUESS_STATUS_WRONG:
			{
				const gchar* _tmp3_ = NULL;
				gchar* _tmp4_;
				_tmp3_ = _ ("Incorrect — %1$s is not %2$s");
				_tmp4_ = g_strdup (_tmp3_);
				_g_free0 (message_pattern);
				message_pattern = _tmp4_;
				break;
			}
			case MULT_PUZZLE_GUESS_STATUS_CORRECT:
			{
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_;
				_tmp5_ = _ ("Correct — %1$s is %2$s");
				_tmp6_ = g_strdup (_tmp5_);
				_g_free0 (message_pattern);
				message_pattern = _tmp6_;
				break;
			}
			default:
			case MULT_PUZZLE_GUESS_STATUS_KNOWN:
			case MULT_PUZZLE_GUESS_STATUS_INVALID:
			{
				break;
			}
		}
		if (message_pattern != NULL) {
			gchar* _tmp7_ = NULL;
			gchar* letter_str;
			gchar* _tmp8_ = NULL;
			gchar* digit_str;
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			guint _tmp13_;
			_tmp7_ = g_strdup_printf ("%c", (gint) ((gchar) letter));
			letter_str = _tmp7_;
			_tmp8_ = g_strdup_printf ("%i", digit);
			digit_str = _tmp8_;
			_tmp9_ = _ (letter_str);
			_tmp10_ = _ (digit_str);
			_tmp11_ = g_strdup_printf (message_pattern, _tmp9_, _tmp10_);
			_tmp12_ = _tmp11_;
			gtk_statusbar_push (self->priv->_status, context_id, _tmp12_);
			_g_free0 (_tmp12_);
			_tmp13_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _gtk_mult_pop_guess_feedback_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->status_timeout_id = _tmp13_;
			_g_free0 (digit_str);
			_g_free0 (letter_str);
		}
		_g_free0 (message_pattern);
	}
}


static void gtk_mult_on_puzzle_change (GtkMult* self, MultPuzzle* p) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = mult_puzzle_get_is_done (p);
	gtk_action_set_sensitive (self->priv->solve_action, !_tmp0_);
	_tmp1_ = mult_puzzle_get_is_done (p);
	gtk_action_set_sensitive (self->priv->hint_action, !_tmp1_);
}


static gboolean gtk_mult_pop_guess_feedback (GtkMult* self) {
	gboolean result = FALSE;
	guint _tmp0_;
	guint context_id;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_statusbar_get_context_id (self->priv->_status, "guess-feedback");
	context_id = _tmp0_;
	gtk_statusbar_pop (self->priv->_status, context_id);
	self->priv->status_timeout_id = (guint) 0;
	result = FALSE;
	return result;
}


static void gtk_mult_update_score (GtkMult* self) {
	gint _tmp0_;
	gint wrong;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* text;
	g_return_if_fail (self != NULL);
	_tmp0_ = mult_puzzle_get_wrong_guesses (self->priv->_puzzle);
	wrong = _tmp0_;
	if (self->priv->_cheated) {
		_tmp1_ = "*";
	} else {
		_tmp1_ = "";
	}
	_tmp2_ = _ ("Incorrect Guesses");
	_tmp3_ = g_strdup_printf ("%s: %i%s", _tmp2_, wrong, _tmp1_);
	text = _tmp3_;
	gtk_label_set_text (self->priv->score, text);
	_g_free0 (text);
}


static gboolean gtk_mult_update_timer (GtkMult* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gdouble _tmp1_;
	guint secs;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* text;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = mult_puzzle_get_is_done (self->priv->_puzzle);
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = g_timer_elapsed (self->priv->timer, NULL);
	secs = (guint) _tmp1_;
	_tmp2_ = _ ("Time");
	_tmp3_ = g_strdup_printf ("%s: %02u:%02u:%02u", _tmp2_, (secs / 60) / 60, (secs / 60) % 60, secs % 60);
	text = _tmp3_;
	gtk_label_set_text (self->priv->timer_label, text);
	result = TRUE;
	_g_free0 (text);
	return result;
}


static void gtk_mult_on_menu_deselect (GtkMult* self) {
	guint _tmp0_;
	guint context_id;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_statusbar_get_context_id (self->priv->_status, "menu-hover");
	context_id = _tmp0_;
	gtk_statusbar_pop (self->priv->_status, context_id);
}


static void gtk_mult_on_menu_game_close (GtkMult* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_destroy ((GtkWidget*) self);
}


static void gtk_mult_on_menu_select_close (GtkMult* self) {
	guint _tmp0_;
	guint context_id;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_statusbar_get_context_id (self->priv->_status, "menu-hover");
	context_id = _tmp0_;
	gtk_mult_clear_guess_feedback (self);
	_tmp1_ = _ ("Close Multiplication Puzzle");
	gtk_statusbar_push (self->priv->_status, context_id, _tmp1_);
}


static void gtk_mult_on_menu_game_new (GtkMult* self) {
	g_return_if_fail (self != NULL);
	gtk_mult_new_puzzle (self);
}


static void gtk_mult_on_menu_select_new (GtkMult* self) {
	guint _tmp0_;
	guint context_id;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_statusbar_get_context_id (self->priv->_status, "menu-hover");
	context_id = _tmp0_;
	gtk_mult_clear_guess_feedback (self);
	_tmp1_ = _ ("Start a new game");
	gtk_statusbar_push (self->priv->_status, context_id, _tmp1_);
}


static void gtk_mult_on_menu_game_solve (GtkMult* self) {
	guint _tmp0_;
	guint context_id;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_mult_set_cheated (self, TRUE);
	mult_puzzle_solve (self->priv->_puzzle);
	_tmp0_ = gtk_statusbar_get_context_id (self->priv->_status, "guess-feedback");
	context_id = _tmp0_;
	gtk_mult_clear_guess_feedback (self);
	_tmp1_ = _ ("Puzzle solved");
	gtk_statusbar_push (self->priv->_status, context_id, _tmp1_);
	gtk_mult_update_score (self);
}


static void gtk_mult_on_menu_select_solve (GtkMult* self) {
	guint _tmp0_;
	guint context_id;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_statusbar_get_context_id (self->priv->_status, "menu-hover");
	context_id = _tmp0_;
	gtk_mult_clear_guess_feedback (self);
	_tmp1_ = _ ("Solve this game");
	gtk_statusbar_push (self->priv->_status, context_id, _tmp1_);
}


static void gtk_mult_on_menu_game_hint (GtkMult* self) {
	MultPuzzleChar character;
	gint digit;
	gint _tmp0_;
	gboolean* _tmp1_ = NULL;
	gboolean* needed;
	gint needed_length1;
	gint _needed_size_;
	gint num_needed;
	gint32 _tmp3_;
	gint32 choice;
	guint _tmp7_;
	guint context_id;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* message_pattern;
	gchar* _tmp10_ = NULL;
	gchar* letter_str;
	gchar* _tmp11_ = NULL;
	gchar* digit_str;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	guint _tmp16_;
	g_return_if_fail (self != NULL);
	gtk_mult_set_cheated (self, TRUE);
	character = MULT_PUZZLE_CHAR_INVALID;
	digit = 0;
	_tmp1_ = mult_puzzle_get_needed_digits (self->priv->_puzzle, &_tmp0_);
	needed = _tmp1_;
	needed_length1 = _tmp0_;
	_needed_size_ = _tmp0_;
	num_needed = 0;
	{
		gboolean* n_collection;
		int n_collection_length1;
		int n_it;
		n_collection = needed;
		n_collection_length1 = needed_length1;
		for (n_it = 0; n_it < needed_length1; n_it = n_it + 1) {
			gboolean n;
			n = n_collection[n_it];
			{
				gint _tmp2_ = 0;
				if (n) {
					_tmp2_ = 1;
				} else {
					_tmp2_ = 0;
				}
				num_needed = num_needed + _tmp2_;
			}
		}
	}
	if (num_needed == 0) {
		needed = (g_free (needed), NULL);
		return;
	}
	_tmp3_ = g_random_int_range ((gint32) 0, (gint32) num_needed);
	choice = _tmp3_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				if (!_tmp4_) {
					i = i + 1;
				}
				_tmp4_ = FALSE;
				if (!(i < 10)) {
					break;
				}
				if (needed[i]) {
					_tmp5_ = choice == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					MultPuzzleChar _tmp6_;
					_tmp6_ = mult_puzzle_solve_digit (self->priv->_puzzle, i);
					character = _tmp6_;
					digit = i;
					break;
				} else {
					if (needed[i]) {
						choice = choice - 1;
					}
				}
			}
		}
	}
	_tmp7_ = gtk_statusbar_get_context_id (self->priv->_status, "guess-feedback");
	context_id = _tmp7_;
	gtk_mult_clear_guess_feedback (self);
	_tmp8_ = _ ("%1$s is %2$s");
	_tmp9_ = g_strdup (_tmp8_);
	message_pattern = _tmp9_;
	_tmp10_ = g_strdup_printf ("%c", (gint) ((gchar) character));
	letter_str = _tmp10_;
	_tmp11_ = g_strdup_printf ("%i", digit);
	digit_str = _tmp11_;
	_tmp12_ = _ (letter_str);
	_tmp13_ = _ (digit_str);
	_tmp14_ = g_strdup_printf (message_pattern, _tmp12_, _tmp13_);
	_tmp15_ = _tmp14_;
	gtk_statusbar_push (self->priv->_status, context_id, _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _gtk_mult_pop_guess_feedback_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->status_timeout_id = _tmp16_;
	gtk_mult_update_score (self);
	_g_free0 (digit_str);
	_g_free0 (letter_str);
	_g_free0 (message_pattern);
	needed = (g_free (needed), NULL);
}


static void gtk_mult_on_menu_select_hint (GtkMult* self) {
	guint _tmp0_;
	guint context_id;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_statusbar_get_context_id (self->priv->_status, "menu-hover");
	context_id = _tmp0_;
	gtk_mult_clear_guess_feedback (self);
	_tmp1_ = _ ("Reveal a digit at random");
	gtk_statusbar_push (self->priv->_status, context_id, _tmp1_);
}


static void _lambda0_ (GtkDialog* dlg, gint resp, GtkMult* self) {
	g_return_if_fail (dlg != NULL);
	gtk_widget_destroy ((GtkWidget*) dlg);
	gtk_mult_set_about (self, NULL);
}


static void __lambda0__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	_lambda0_ (_sender, response_id, self);
}


static void gtk_mult_on_menu_help_about (GtkMult* self) {
	GtkAboutDialog* _tmp0_ = NULL;
	GtkAboutDialog* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->_about != NULL) {
		gtk_window_present ((GtkWindow*) self->priv->_about);
		return;
	}
	_tmp0_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	gtk_mult_set_about (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = _ ("About Multiplication Puzzle");
	gtk_window_set_title ((GtkWindow*) self->priv->_about, _tmp2_);
	gtk_about_dialog_set_authors (self->priv->_about, GTK_MULT_authors);
	gtk_about_dialog_set_artists (self->priv->_about, GTK_MULT_artists);
	_tmp3_ = _ ("translator-credits");
	gtk_about_dialog_set_translator_credits (self->priv->_about, _tmp3_);
	gtk_about_dialog_set_logo_icon_name (self->priv->_about, PACKAGE);
	gtk_about_dialog_set_version (self->priv->_about, VERSION);
	gtk_about_dialog_set_copyright (self->priv->_about, "© 2003—2011 Michael Terry");
	gtk_about_dialog_set_website (self->priv->_about, "https://launchpad.net/gmult");
	gtk_about_dialog_set_license_type (self->priv->_about, GTK_LICENSE_GPL_3_0);
	gtk_window_set_transient_for ((GtkWindow*) self->priv->_about, (GtkWindow*) self);
	g_signal_connect_object ((GtkDialog*) self->priv->_about, "response", (GCallback) __lambda0__gtk_dialog_response, self, 0);
	gtk_widget_show ((GtkWidget*) self->priv->_about);
}


static void gtk_mult_on_menu_select_about (GtkMult* self) {
	guint _tmp0_;
	guint context_id;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_statusbar_get_context_id (self->priv->_status, "menu-hover");
	context_id = _tmp0_;
	gtk_mult_clear_guess_feedback (self);
	_tmp1_ = _ ("About Multiplication Puzzle");
	gtk_statusbar_push (self->priv->_status, context_id, _tmp1_);
}


gint gtk_mult_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* context;
	GOptionGroup* _tmp1_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkIconTheme* _tmp5_ = NULL;
	GtkMult* _tmp6_ = NULL;
	GtkMult* window;
	GError * _inner_error_ = NULL;
	textdomain (GETTEXT_PACKAGE);
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = g_option_context_new ("");
	context = _tmp0_;
	_tmp1_ = gtk_get_option_group (FALSE);
	g_option_context_add_group (context, _tmp1_);
	g_option_context_parse (context, &args_length1, &args, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = g_option_context_get_help (context, TRUE, NULL);
		_tmp3_ = _tmp2_;
		g_printerr ("%s\n\n%s", e->message, _tmp3_);
		_g_free0 (_tmp3_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	gtk_init (&args_length1, &args);
	_tmp4_ = _ ("Multiplication Puzzle");
	g_set_application_name (_tmp4_);
	_tmp5_ = gtk_icon_theme_get_default ();
	gtk_icon_theme_append_search_path (_tmp5_, THEME_DIR);
	gtk_window_set_default_icon_name (PACKAGE);
	_tmp6_ = gtk_mult_new ();
	window = g_object_ref_sink (_tmp6_);
	gtk_widget_show_all ((GtkWidget*) window);
	gtk_main ();
	result = 0;
	_g_object_unref0 (window);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return gtk_mult_main (argv, argc);
}


GtkMult* gtk_mult_construct (GType object_type) {
	GtkMult * self = NULL;
	self = (GtkMult*) g_object_new (object_type, NULL);
	return self;
}


GtkMult* gtk_mult_new (void) {
	return gtk_mult_construct (TYPE_GTK_MULT);
}


MultPuzzle* gtk_mult_get_puzzle (GtkMult* self) {
	MultPuzzle* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_puzzle;
	return result;
}


static void gtk_mult_set_puzzle (GtkMult* self, MultPuzzle* value) {
	MultPuzzle* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_puzzle);
	self->priv->_puzzle = _tmp0_;
	g_object_notify ((GObject *) self, "puzzle");
}


gboolean gtk_mult_get_cheated (GtkMult* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_cheated;
	return result;
}


static void gtk_mult_set_cheated (GtkMult* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_cheated = value;
	g_object_notify ((GObject *) self, "cheated");
}


GtkStatusbar* gtk_mult_get_status (GtkMult* self) {
	GtkStatusbar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_status;
	return result;
}


static void gtk_mult_set_status (GtkMult* self, GtkStatusbar* value) {
	GtkStatusbar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_status);
	self->priv->_status = _tmp0_;
	g_object_notify ((GObject *) self, "status");
}


static GtkAboutDialog* gtk_mult_get_about (GtkMult* self) {
	GtkAboutDialog* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_about;
	return result;
}


static void gtk_mult_set_about (GtkMult* self, GtkAboutDialog* value) {
	GtkAboutDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_about);
	self->priv->_about = _tmp0_;
}


static gboolean _gtk_mult_handle_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = gtk_mult_handle_key_press (self, event);
	return result;
}


static void _gtk_main_quit_gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	gtk_main_quit ();
}


static GObject * gtk_mult_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GtkMult * self;
	GtkVBox* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GTimer* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GValue dpiValue = {0};
	GdkScreen* _tmp4_ = NULL;
	gint _tmp5_;
	gint height;
	GtkVBox* _tmp6_ = NULL;
	GtkVBox* vb;
	GtkHBox* _tmp7_ = NULL;
	GtkWidget* _tmp8_ = NULL;
	GtkWidget* _tmp9_;
	GtkEventBox* _tmp10_ = NULL;
	GtkEventBox* eb;
	GtkEventBox* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	parent_class = G_OBJECT_CLASS (gtk_mult_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GTK_MULT (obj);
	_tmp0_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	_g_object_unref0 (self->priv->vbox);
	self->priv->vbox = g_object_ref_sink (_tmp0_);
	gtk_mult_set_status (self, NULL);
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->score);
	self->priv->score = g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->canvas);
	self->priv->canvas = NULL;
	self->priv->status_timeout_id = (guint) 0;
	_g_object_unref0 (self->priv->solve_action);
	self->priv->solve_action = NULL;
	_g_object_unref0 (self->priv->hint_action);
	self->priv->hint_action = NULL;
	_tmp2_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->timer);
	self->priv->timer = _tmp2_;
	_tmp3_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->timer_label);
	self->priv->timer_label = g_object_ref_sink (_tmp3_);
	self->priv->timer_timeout_id = (guint) 0;
	g_value_init (&dpiValue, G_TYPE_INT);
	_tmp4_ = gtk_window_get_screen ((GtkWindow*) self);
	gdk_screen_get_setting (_tmp4_, "gtk-xft-dpi", &dpiValue);
	_tmp5_ = g_value_get_int (&dpiValue);
	gtk_mult_dpi = _tmp5_ / PANGO_SCALE;
	height = 4 * gtk_mult_dpi;
	gtk_window_set_default_size ((GtkWindow*) self, (gint) (height * GTK_MULT_ASPECT), height);
	_tmp6_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	vb = g_object_ref_sink (_tmp6_);
	_tmp7_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	_g_object_unref0 (self->priv->status_box);
	self->priv->status_box = g_object_ref_sink (_tmp7_);
	_tmp8_ = gtk_mult_setup_menu (self);
	_tmp9_ = _tmp8_;
	gtk_box_pack_start ((GtkBox*) vb, _tmp9_, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (_tmp9_);
	gtk_box_pack_start ((GtkBox*) vb, (GtkWidget*) self->priv->vbox, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vb, (GtkWidget*) self->priv->status_box, FALSE, FALSE, (guint) 0);
	_tmp10_ = (GtkEventBox*) gtk_event_box_new ();
	eb = g_object_ref_sink (_tmp10_);
	gtk_container_add ((GtkContainer*) eb, (GtkWidget*) self->priv->score);
	gtk_container_set_border_width ((GtkContainer*) eb, (guint) 5);
	gtk_box_pack_start ((GtkBox*) self->priv->status_box, (GtkWidget*) eb, FALSE, FALSE, (guint) 0);
	_tmp11_ = (GtkEventBox*) gtk_event_box_new ();
	_g_object_unref0 (eb);
	eb = g_object_ref_sink (_tmp11_);
	gtk_container_add ((GtkContainer*) eb, (GtkWidget*) self->priv->timer_label);
	gtk_container_set_border_width ((GtkContainer*) eb, (guint) 5);
	gtk_box_pack_start ((GtkBox*) self->priv->status_box, (GtkWidget*) eb, FALSE, FALSE, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) vb);
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_KEY_PRESS_MASK);
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) _gtk_mult_handle_key_press_gtk_widget_key_press_event, self, 0);
	_tmp12_ = _ ("Multiplication Puzzle");
	gtk_window_set_title ((GtkWindow*) self, _tmp12_);
	gtk_mult_new_puzzle (self);
	g_signal_connect ((GtkWidget*) self, "destroy", (GCallback) _gtk_main_quit_gtk_widget_destroy, NULL);
	_g_object_unref0 (eb);
	_g_object_unref0 (vb);
	G_IS_VALUE (&dpiValue) ? (g_value_unset (&dpiValue), NULL) : NULL;
	return obj;
}


static void gtk_mult_class_init (GtkMultClass * klass) {
	const gchar* _tmp0_ = NULL;
	gunichar _tmp1_;
	gunichar _tmp2_;
	const gchar* _tmp3_ = NULL;
	gunichar _tmp4_;
	gunichar _tmp5_;
	const gchar* _tmp6_ = NULL;
	gunichar _tmp7_;
	gunichar _tmp8_;
	const gchar* _tmp9_ = NULL;
	gunichar _tmp10_;
	gunichar _tmp11_;
	const gchar* _tmp12_ = NULL;
	gunichar _tmp13_;
	gunichar _tmp14_;
	const gchar* _tmp15_ = NULL;
	gunichar _tmp16_;
	gunichar _tmp17_;
	const gchar* _tmp18_ = NULL;
	gunichar _tmp19_;
	gunichar _tmp20_;
	const gchar* _tmp21_ = NULL;
	gunichar _tmp22_;
	gunichar _tmp23_;
	const gchar* _tmp24_ = NULL;
	gunichar _tmp25_;
	gunichar _tmp26_;
	const gchar* _tmp27_ = NULL;
	gunichar _tmp28_;
	gunichar _tmp29_;
	const gchar* _tmp30_ = NULL;
	gunichar _tmp31_;
	gunichar _tmp32_;
	const gchar* _tmp33_ = NULL;
	gunichar _tmp34_;
	gunichar _tmp35_;
	const gchar* _tmp36_ = NULL;
	gunichar _tmp37_;
	gunichar _tmp38_;
	const gchar* _tmp39_ = NULL;
	gunichar _tmp40_;
	gunichar _tmp41_;
	const gchar* _tmp42_ = NULL;
	gunichar _tmp43_;
	gunichar _tmp44_;
	const gchar* _tmp45_ = NULL;
	gunichar _tmp46_;
	gunichar _tmp47_;
	const gchar* _tmp48_ = NULL;
	gunichar _tmp49_;
	gunichar _tmp50_;
	const gchar* _tmp51_ = NULL;
	gunichar _tmp52_;
	gunichar _tmp53_;
	const gchar* _tmp54_ = NULL;
	gunichar _tmp55_;
	gunichar _tmp56_;
	const gchar* _tmp57_ = NULL;
	gunichar _tmp58_;
	gunichar _tmp59_;
	gtk_mult_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkMultPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gtk_mult_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gtk_mult_set_property;
	G_OBJECT_CLASS (klass)->constructor = gtk_mult_constructor;
	G_OBJECT_CLASS (klass)->finalize = gtk_mult_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTK_MULT_PUZZLE, g_param_spec_object ("puzzle", "puzzle", "puzzle", TYPE_MULT_PUZZLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTK_MULT_CHEATED, g_param_spec_boolean ("cheated", "cheated", "cheated", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTK_MULT_STATUS, g_param_spec_object ("status", "status", "status", GTK_TYPE_STATUSBAR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	_tmp0_ = _ ("A");
	_tmp1_ = string_get_char (_tmp0_, (glong) 0);
	_tmp2_ = g_unichar_toupper (_tmp1_);
	gtk_mult_a_char = _tmp2_;
	_tmp3_ = _ ("B");
	_tmp4_ = string_get_char (_tmp3_, (glong) 0);
	_tmp5_ = g_unichar_toupper (_tmp4_);
	gtk_mult_b_char = _tmp5_;
	_tmp6_ = _ ("C");
	_tmp7_ = string_get_char (_tmp6_, (glong) 0);
	_tmp8_ = g_unichar_toupper (_tmp7_);
	gtk_mult_c_char = _tmp8_;
	_tmp9_ = _ ("D");
	_tmp10_ = string_get_char (_tmp9_, (glong) 0);
	_tmp11_ = g_unichar_toupper (_tmp10_);
	gtk_mult_d_char = _tmp11_;
	_tmp12_ = _ ("E");
	_tmp13_ = string_get_char (_tmp12_, (glong) 0);
	_tmp14_ = g_unichar_toupper (_tmp13_);
	gtk_mult_e_char = _tmp14_;
	_tmp15_ = _ ("F");
	_tmp16_ = string_get_char (_tmp15_, (glong) 0);
	_tmp17_ = g_unichar_toupper (_tmp16_);
	gtk_mult_f_char = _tmp17_;
	_tmp18_ = _ ("G");
	_tmp19_ = string_get_char (_tmp18_, (glong) 0);
	_tmp20_ = g_unichar_toupper (_tmp19_);
	gtk_mult_g_char = _tmp20_;
	_tmp21_ = _ ("H");
	_tmp22_ = string_get_char (_tmp21_, (glong) 0);
	_tmp23_ = g_unichar_toupper (_tmp22_);
	gtk_mult_h_char = _tmp23_;
	_tmp24_ = _ ("I");
	_tmp25_ = string_get_char (_tmp24_, (glong) 0);
	_tmp26_ = g_unichar_toupper (_tmp25_);
	gtk_mult_i_char = _tmp26_;
	_tmp27_ = _ ("J");
	_tmp28_ = string_get_char (_tmp27_, (glong) 0);
	_tmp29_ = g_unichar_toupper (_tmp28_);
	gtk_mult_j_char = _tmp29_;
	_tmp30_ = _ ("0");
	_tmp31_ = string_get_char (_tmp30_, (glong) 0);
	_tmp32_ = g_unichar_toupper (_tmp31_);
	gtk_mult_0_char = _tmp32_;
	_tmp33_ = _ ("1");
	_tmp34_ = string_get_char (_tmp33_, (glong) 0);
	_tmp35_ = g_unichar_toupper (_tmp34_);
	gtk_mult_1_char = _tmp35_;
	_tmp36_ = _ ("2");
	_tmp37_ = string_get_char (_tmp36_, (glong) 0);
	_tmp38_ = g_unichar_toupper (_tmp37_);
	gtk_mult_2_char = _tmp38_;
	_tmp39_ = _ ("3");
	_tmp40_ = string_get_char (_tmp39_, (glong) 0);
	_tmp41_ = g_unichar_toupper (_tmp40_);
	gtk_mult_3_char = _tmp41_;
	_tmp42_ = _ ("4");
	_tmp43_ = string_get_char (_tmp42_, (glong) 0);
	_tmp44_ = g_unichar_toupper (_tmp43_);
	gtk_mult_4_char = _tmp44_;
	_tmp45_ = _ ("5");
	_tmp46_ = string_get_char (_tmp45_, (glong) 0);
	_tmp47_ = g_unichar_toupper (_tmp46_);
	gtk_mult_5_char = _tmp47_;
	_tmp48_ = _ ("6");
	_tmp49_ = string_get_char (_tmp48_, (glong) 0);
	_tmp50_ = g_unichar_toupper (_tmp49_);
	gtk_mult_6_char = _tmp50_;
	_tmp51_ = _ ("7");
	_tmp52_ = string_get_char (_tmp51_, (glong) 0);
	_tmp53_ = g_unichar_toupper (_tmp52_);
	gtk_mult_7_char = _tmp53_;
	_tmp54_ = _ ("8");
	_tmp55_ = string_get_char (_tmp54_, (glong) 0);
	_tmp56_ = g_unichar_toupper (_tmp55_);
	gtk_mult_8_char = _tmp56_;
	_tmp57_ = _ ("9");
	_tmp58_ = string_get_char (_tmp57_, (glong) 0);
	_tmp59_ = g_unichar_toupper (_tmp58_);
	gtk_mult_9_char = _tmp59_;
}


static void gtk_mult_instance_init (GtkMult * self) {
	self->priv = GTK_MULT_GET_PRIVATE (self);
	self->priv->_about = NULL;
}


static void gtk_mult_finalize (GObject* obj) {
	GtkMult * self;
	self = GTK_MULT (obj);
	_g_object_unref0 (self->priv->_puzzle);
	_g_object_unref0 (self->priv->_status);
	_g_object_unref0 (self->priv->solve_action);
	_g_object_unref0 (self->priv->hint_action);
	_g_object_unref0 (self->priv->canvas);
	_g_object_unref0 (self->priv->vbox);
	_g_timer_destroy0 (self->priv->timer);
	_g_object_unref0 (self->priv->timer_label);
	_g_object_unref0 (self->priv->score);
	_g_object_unref0 (self->priv->status_box);
	_g_object_unref0 (self->priv->_about);
	G_OBJECT_CLASS (gtk_mult_parent_class)->finalize (obj);
}


GType gtk_mult_get_type (void) {
	static volatile gsize gtk_mult_type_id__volatile = 0;
	if (g_once_init_enter (&gtk_mult_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkMultClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtk_mult_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkMult), 0, (GInstanceInitFunc) gtk_mult_instance_init, NULL };
		GType gtk_mult_type_id;
		gtk_mult_type_id = g_type_register_static (GTK_TYPE_WINDOW, "GtkMult", &g_define_type_info, 0);
		g_once_init_leave (&gtk_mult_type_id__volatile, gtk_mult_type_id);
	}
	return gtk_mult_type_id__volatile;
}


static void _vala_gtk_mult_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GtkMult * self;
	self = GTK_MULT (object);
	switch (property_id) {
		case GTK_MULT_PUZZLE:
		g_value_set_object (value, gtk_mult_get_puzzle (self));
		break;
		case GTK_MULT_CHEATED:
		g_value_set_boolean (value, gtk_mult_get_cheated (self));
		break;
		case GTK_MULT_STATUS:
		g_value_set_object (value, gtk_mult_get_status (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gtk_mult_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GtkMult * self;
	self = GTK_MULT (object);
	switch (property_id) {
		case GTK_MULT_PUZZLE:
		gtk_mult_set_puzzle (self, g_value_get_object (value));
		break;
		case GTK_MULT_CHEATED:
		gtk_mult_set_cheated (self, g_value_get_boolean (value));
		break;
		case GTK_MULT_STATUS:
		gtk_mult_set_status (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



