//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcommunication_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/communication/armcommunication/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/communication/resource-manager/Microsoft.Communication/preview/2023-06-01-preview/examples/senderUsernames/listByDomain.json
func ExampleSenderUsernamesClient_NewListByDomainsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcommunication.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSenderUsernamesClient().NewListByDomainsPager("contosoResourceGroup", "contosoEmailService", "contoso.com", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SenderUsernameResourceCollection = armcommunication.SenderUsernameResourceCollection{
		// 	Value: []*armcommunication.SenderUsernameResource{
		// 		{
		// 			Name: to.Ptr("contosoNews"),
		// 			Type: to.Ptr("Microsoft.Communication/EmailServices/Domains/SenderUsernames"),
		// 			ID: to.Ptr("/subscriptions/11112222-3333-4444-5555-666677778888/resourceGroups/contosoResourceGroup/providers/Microsoft.Communication/EmailServices/contosoEmailService/Domains/contoso.com/senderUsernames/contosoNews"),
		// 			Properties: &armcommunication.SenderUsernameProperties{
		// 				DataLocation: to.Ptr("United States"),
		// 				DisplayName: to.Ptr("Contoso News"),
		// 				Username: to.Ptr("contosoNews"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("contosoAlerts"),
		// 			Type: to.Ptr("Microsoft.Communication/EmailServices/Domains/SenderUsernames"),
		// 			ID: to.Ptr("/subscriptions/11112222-3333-4444-5555-666677778888/resourceGroups/contosoResourceGroup/providers/Microsoft.Communication/EmailServices/contosoEmailService/Domains/contoso.com/senderUsernames/contosoAlerts"),
		// 			Properties: &armcommunication.SenderUsernameProperties{
		// 				DataLocation: to.Ptr("United States"),
		// 				DisplayName: to.Ptr("Contoso Alerts"),
		// 				Username: to.Ptr("contosoAlerts"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/communication/resource-manager/Microsoft.Communication/preview/2023-06-01-preview/examples/senderUsernames/get.json
func ExampleSenderUsernamesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcommunication.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSenderUsernamesClient().Get(ctx, "contosoResourceGroup", "contosoEmailService", "contoso.com", "contosoNewsAlerts", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SenderUsernameResource = armcommunication.SenderUsernameResource{
	// 	Name: to.Ptr("contoso.com"),
	// 	Type: to.Ptr("Microsoft.Communication/EmailServices/Domains/SenderUsernames"),
	// 	ID: to.Ptr("/subscriptions/11112222-3333-4444-5555-666677778888/resourceGroups/contosoResourceGroup/providers/Microsoft.Communication/EmailServices/contosoEmailService/Domains/contoso.com/senderUsernames/contosoNewsAlerts"),
	// 	Properties: &armcommunication.SenderUsernameProperties{
	// 		DataLocation: to.Ptr("United States"),
	// 		DisplayName: to.Ptr("Contoso News Alerts"),
	// 		Username: to.Ptr("contosoNewsAlerts"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/communication/resource-manager/Microsoft.Communication/preview/2023-06-01-preview/examples/senderUsernames/createOrUpdate.json
func ExampleSenderUsernamesClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcommunication.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSenderUsernamesClient().CreateOrUpdate(ctx, "contosoResourceGroup", "contosoEmailService", "contoso.com", "contosoNewsAlerts", armcommunication.SenderUsernameResource{
		Properties: &armcommunication.SenderUsernameProperties{
			DisplayName: to.Ptr("Contoso News Alerts"),
			Username:    to.Ptr("contosoNewsAlerts"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SenderUsernameResource = armcommunication.SenderUsernameResource{
	// 	Name: to.Ptr("contoso.com"),
	// 	Type: to.Ptr("Microsoft.Communication/EmailServices/Domains"),
	// 	ID: to.Ptr("/subscriptions/11112222-3333-4444-5555-666677778888/resourceGroups/contosoResourceGroup/providers/Microsoft.Communication/EmailServices/contosoEmailService/Domains/contoso.com/senderUsernames/contosoNewsAlerts"),
	// 	Properties: &armcommunication.SenderUsernameProperties{
	// 		DataLocation: to.Ptr("United States"),
	// 		DisplayName: to.Ptr("Contoso News Alerts"),
	// 		Username: to.Ptr("contosoNewsAlerts"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/communication/resource-manager/Microsoft.Communication/preview/2023-06-01-preview/examples/senderUsernames/delete.json
func ExampleSenderUsernamesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcommunication.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewSenderUsernamesClient().Delete(ctx, "MyResourceGroup", "MyEmailServiceResource", "mydomain.com", "contosoNewsAlerts", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
