//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstoragecache

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAmlFilesystemsClient creates a new instance of AmlFilesystemsClient.
func (c *ClientFactory) NewAmlFilesystemsClient() *AmlFilesystemsClient {
	subClient, _ := NewAmlFilesystemsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAscOperationsClient creates a new instance of AscOperationsClient.
func (c *ClientFactory) NewAscOperationsClient() *AscOperationsClient {
	subClient, _ := NewAscOperationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAscUsagesClient creates a new instance of AscUsagesClient.
func (c *ClientFactory) NewAscUsagesClient() *AscUsagesClient {
	subClient, _ := NewAscUsagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCachesClient creates a new instance of CachesClient.
func (c *ClientFactory) NewCachesClient() *CachesClient {
	subClient, _ := NewCachesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewManagementClient creates a new instance of ManagementClient.
func (c *ClientFactory) NewManagementClient() *ManagementClient {
	subClient, _ := NewManagementClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewSKUsClient creates a new instance of SKUsClient.
func (c *ClientFactory) NewSKUsClient() *SKUsClient {
	subClient, _ := NewSKUsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewStorageTargetClient creates a new instance of StorageTargetClient.
func (c *ClientFactory) NewStorageTargetClient() *StorageTargetClient {
	subClient, _ := NewStorageTargetClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewStorageTargetsClient creates a new instance of StorageTargetsClient.
func (c *ClientFactory) NewStorageTargetsClient() *StorageTargetsClient {
	subClient, _ := NewStorageTargetsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewUsageModelsClient creates a new instance of UsageModelsClient.
func (c *ClientFactory) NewUsageModelsClient() *UsageModelsClient {
	subClient, _ := NewUsageModelsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
