/*
 * Decompiled with CFR 0.152.
 */
package com.vldocking.swing.docking;

import com.vldocking.swing.docking.DockViewAsTab;
import com.vldocking.swing.docking.Dockable;
import com.vldocking.swing.docking.DockableState;
import com.vldocking.swing.docking.DockingUtilities;
import com.vldocking.swing.docking.event.DockDragEvent;
import com.vldocking.swing.docking.event.DockDropEvent;
import java.awt.Point;
import javax.swing.UIManager;

public class MaximizedDockViewAsTab
extends DockViewAsTab {
    private static final long serialVersionUID = 1L;

    public MaximizedDockViewAsTab(Dockable dockable) {
        super(dockable);
    }

    @Override
    protected void configureMaximizeButton() {
        if (this.isRestoreButtonDisplayed) {
            this.maximizeSmartIcon.setIcon(UIManager.getIcon("DockViewTitleBar.restore"));
            this.maximizeSmartIcon.setPressedIcon(UIManager.getIcon("DockViewTitleBar.restore.pressed"));
            this.maximizeSmartIcon.setRolloverIcon(UIManager.getIcon("DockViewTitleBar.restore.rollover"));
            this.maximizeAction.putValue("ShortDescription", UIManager.get("DockViewTitleBar.restoreButtonText"));
        }
    }

    @Override
    protected void configureFloatButton() {
        this.isFloatButtonDisplayed = false;
    }

    @Override
    protected void configureHideButton() {
        this.isHideButtonDisplayed = false;
    }

    @Override
    protected void configureCloseButton() {
        this.isCloseButtonDisplayed = false;
    }

    @Override
    protected DockViewAsTab.TabHeader createTabHeader() {
        return new MaximizedTabHeader();
    }

    @Override
    public void processDockableDrag(DockDragEvent event) {
        event.rejectDrag();
    }

    @Override
    public void processDockableDrop(DockDropEvent event) {
        event.rejectDrop();
    }

    protected class MaximizedTabHeader
    extends DockViewAsTab.TabHeader {
        private static final long serialVersionUID = 1L;

        protected MaximizedTabHeader() {
        }

        @Override
        public boolean startDragComponent(Point p) {
            Dockable target = this.getDockable();
            DockableState.Location targetState = target.getDockKey().getLocation();
            if (targetState == DockableState.Location.HIDDEN) {
                if (DockingUtilities.isChildOfCompoundDockable(target)) {
                    return false;
                }
            } else if (targetState == DockableState.Location.DOCKED) {
                Dockable max;
                boolean isChildOfMaximizedContainer = false;
                if (MaximizedDockViewAsTab.this.desktop != null && (max = MaximizedDockViewAsTab.this.desktop.getMaximizedDockable()) != null && max.getComponent().getParent().isAncestorOf(this)) {
                    isChildOfMaximizedContainer = true;
                }
                if (isChildOfMaximizedContainer) {
                    return false;
                }
            } else if (targetState == DockableState.Location.MAXIMIZED) {
                return false;
            }
            return true;
        }
    }
}

