# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Renderbuffer(Object):
    r"""
    Renderbuffer - Storage for FBO's
    
    Superclass: Object
    
    Lightweight API to open_gl Framebuffer Object EXT renderbuffers.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkRenderbuffer, obj, update, **traits)
    
    def _get_context(self):
        return wrap_vtk(self._vtk_obj.GetContext())
    def _set_context(self, arg):
        old_val = self._get_context()
        self._wrap_call(self._vtk_obj.SetContext,
                        deref_vtk(arg))
        self.trait_property_changed('context', old_val, arg)
    context = traits.Property(_get_context, _set_context, desc=\
        r"""
        
        """
    )

    def _get_handle(self):
        return self._vtk_obj.GetHandle()
    handle = traits.Property(_get_handle, desc=\
        r"""
        Get the name of the buffer for use opengl code.
        """
    )

    def _get_height(self):
        return self._vtk_obj.GetHeight()
    height = traits.Property(_get_height, desc=\
        r"""
        
        """
    )

    def _get_samples(self):
        return self._vtk_obj.GetSamples()
    samples = traits.Property(_get_samples, desc=\
        r"""
        
        """
    )

    def _get_width(self):
        return self._vtk_obj.GetWidth()
    width = traits.Property(_get_width, desc=\
        r"""
        Get the buffer dimensions. These are the properties of the open_gl
        renderbuffer this instance represents.
        """
    )

    def create(self, *args):
        """
        create(self, format:int, width:int, height:int) -> int
        C++: int create(unsigned int format, unsigned int width,
            unsigned int height)
        create(self, format:int, width:int, height:int, samples:int)
            -> int
        C++: int create(unsigned int format, unsigned int width,
            unsigned int height, unsigned int samples)
        Sets up an renderbufffer. Use mode to control READ or DRAW
        operation and format to control the internal format. (see open_gl
        doc for more info)
        """
        ret = self._wrap_call(self._vtk_obj.Create, *args)
        return ret

    def create_color_attachment(self, *args):
        """
        create_color_attachment(self, width:int, height:int) -> int
        C++: int create_color_attachment(unsigned int width,
            unsigned int height)
        Sets up an RGBAF renderbufffer for use as a color attachment. Use
        mode to control READ or DRAW operation.
        """
        ret = self._wrap_call(self._vtk_obj.CreateColorAttachment, *args)
        return ret

    def create_depth_attachment(self, *args):
        """
        create_depth_attachment(self, width:int, height:int) -> int
        C++: int create_depth_attachment(unsigned int width,
            unsigned int height)
        Sets up an DEPTH renderbufffer for use as a color attachment. Use
        mode to control READ or DRAW operation.
        """
        ret = self._wrap_call(self._vtk_obj.CreateDepthAttachment, *args)
        return ret

    def is_supported(self, *args):
        """
        is_supported(renWin:RenderWindow) -> bool
        C++: static bool is_supported(RenderWindow *renWin)
        Returns if the context supports the required extensions.
        Extension will be loaded when the context is set.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.IsSupported, *my_args)
        return ret

    def release_graphics_resources(self, *args):
        """
        release_graphics_resources(self, win:Window) -> None
        C++: void release_graphics_resources(Window *win)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReleaseGraphicsResources, *my_args)
        return ret

    def resize(self, *args):
        """
        resize(self, width:int, height:int) -> None
        C++: void resize(unsigned int width, unsigned int height)"""
        ret = self._wrap_call(self._vtk_obj.Resize, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Renderbuffer, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Renderbuffer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit Renderbuffer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Renderbuffer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

