/*
 * ion/ioncore/sizepolicy.h
 *
 * Copyright (c) Tuomo Valkonen 1999-2007.
 *
 * See the included file LICENSE for details.
 */

#ifndef ION_IONCORE_SIZEPOLICY_H
#define ION_IONCORE_SIZEPOLICY_H

#include "common.h"
#include "region.h"

/* Modifiers for some policies */
#define SIZEPOLICY_VERT_NONE    0x0000
#define SIZEPOLICY_VERT_TOP     0x0100
#define SIZEPOLICY_VERT_BOTTOM  0x0200
#define SIZEPOLICY_VERT_CENTER  0x0300
#define SIZEPOLICY_VERT_MASK    0x0300

#define SIZEPOLICY_HORIZ_NONE   0x0000
#define SIZEPOLICY_HORIZ_LEFT   0x0400
#define SIZEPOLICY_HORIZ_RIGHT  0x0800
#define SIZEPOLICY_HORIZ_CENTER 0x0c00
#define SIZEPOLICY_HORIZ_MASK   0x0c00

#define SIZEPOLICY_SHRUNK       0x1000

/* The policies */
#define SIZEPOLICY_MASK           0xff
#define SIZEPOLICY_DEFAULT        0x00
#define SIZEPOLICY_FULL_EXACT     0x01
#define SIZEPOLICY_FULL_BOUNDS    0x02
#define SIZEPOLICY_FREE           0x03
#define SIZEPOLICY_GRAVITY        0x04 /* uses vert/horiz flags */
#define SIZEPOLICY_FREE_GLUE      0x05 /* stateful; modifies v/h flags */
#define SIZEPOLICY_STRETCH_LEFT   0x06
#define SIZEPOLICY_STRETCH_RIGHT  0x07
#define SIZEPOLICY_STRETCH_TOP    0x08
#define SIZEPOLICY_STRETCH_BOTTOM 0x09
#define SIZEPOLICY_UNCONSTRAINED  0x10

#define SIZEPOLICY_GRAVITY_NORTHWEST (SIZEPOLICY_GRAVITY|SIZEPOLICY_VERT_TOP|SIZEPOLICY_HORIZ_LEFT)
#define SIZEPOLICY_GRAVITY_NORTH     (SIZEPOLICY_GRAVITY|SIZEPOLICY_VERT_TOP|SIZEPOLICY_HORIZ_CENTER)
#define SIZEPOLICY_GRAVITY_NORTHEAST (SIZEPOLICY_GRAVITY|SIZEPOLICY_VERT_TOP|SIZEPOLICY_HORIZ_RIGHT)
#define SIZEPOLICY_GRAVITY_WEST      (SIZEPOLICY_GRAVITY|SIZEPOLICY_VERT_CENTER|SIZEPOLICY_HORIZ_LEFT)
#define SIZEPOLICY_GRAVITY_CENTER    (SIZEPOLICY_GRAVITY|SIZEPOLICY_VERT_CENTER|SIZEPOLICY_HORIZ_CENTER)
#define SIZEPOLICY_GRAVITY_EAST      (SIZEPOLICY_GRAVITY|SIZEPOLICY_VERT_CENTER|SIZEPOLICY_HORIZ_RIGHT)
#define SIZEPOLICY_GRAVITY_SOUTHWEST (SIZEPOLICY_GRAVITY|SIZEPOLICY_VERT_BOTTOM|SIZEPOLICY_HORIZ_LEFT)
#define SIZEPOLICY_GRAVITY_SOUTH     (SIZEPOLICY_GRAVITY|SIZEPOLICY_VERT_BOTTOM|SIZEPOLICY_HORIZ_CENTER)
#define SIZEPOLICY_GRAVITY_SOUTHEAST (SIZEPOLICY_GRAVITY|SIZEPOLICY_VERT_BOTTOM|SIZEPOLICY_HORIZ_RIGHT)

#define SIZEPOLICY_FREE_GLUE__NORTHWEST (SIZEPOLICY_FREE_GLUE|SIZEPOLICY_VERT_TOP|SIZEPOLICY_HORIZ_LEFT)
#define SIZEPOLICY_FREE_GLUE__NORTH     (SIZEPOLICY_FREE_GLUE|SIZEPOLICY_VERT_TOP|SIZEPOLICY_HORIZ_CENTER)
#define SIZEPOLICY_FREE_GLUE__NORTHEAST (SIZEPOLICY_FREE_GLUE|SIZEPOLICY_VERT_TOP|SIZEPOLICY_HORIZ_RIGHT)
#define SIZEPOLICY_FREE_GLUE__WEST      (SIZEPOLICY_FREE_GLUE|SIZEPOLICY_VERT_CENTER|SIZEPOLICY_HORIZ_LEFT)
#define SIZEPOLICY_FREE_GLUE__CENTER    (SIZEPOLICY_FREE_GLUE|SIZEPOLICY_VERT_CENTER|SIZEPOLICY_HORIZ_CENTER)
#define SIZEPOLICY_FREE_GLUE__EAST      (SIZEPOLICY_FREE_GLUE|SIZEPOLICY_VERT_CENTER|SIZEPOLICY_HORIZ_RIGHT)
#define SIZEPOLICY_FREE_GLUE__SOUTHWEST (SIZEPOLICY_FREE_GLUE|SIZEPOLICY_VERT_BOTTOM|SIZEPOLICY_HORIZ_LEFT)
#define SIZEPOLICY_FREE_GLUE__SOUTH     (SIZEPOLICY_FREE_GLUE|SIZEPOLICY_VERT_BOTTOM|SIZEPOLICY_HORIZ_CENTER)
#define SIZEPOLICY_FREE_GLUE__SOUTHEAST (SIZEPOLICY_FREE_GLUE|SIZEPOLICY_VERT_BOTTOM|SIZEPOLICY_HORIZ_RIGHT)

typedef uint WSizePolicy;


extern void sizepolicy(WSizePolicy *szplcy, WRegion *reg,
                       const WRectangle *rq_geom, int rq_flags,
                       WFitParams *fp);


extern bool string2sizepolicy(const char *szplcy, WSizePolicy *value);
extern const char *sizepolicy2string(WSizePolicy szplcy);

#endif /* ION_IONCORE_SIZEPOLICY_H */
