/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToMolproInput
extends AbstractBasisSetXmlToText {
    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        this.enableSplitSP();
        return this.readBasisSet(data, elementList, optimize);
    }

    @Override
    protected void addHeader(StringBuffer output, Element root) throws FormatException {
        output.append("basis={\n!\n");
    }

    @Override
    protected void addFooter(StringBuffer output) throws FormatException {
        output.append("}\n");
    }

    @Override
    protected void addElementDescription(StringBuffer output, String element, Element contractions) {
        String elementName = this.mPertable.name(this.mPertable.atomicNumber(element));
        List descriptionList = contractions.getChildren("description", BSEProperties.mDcNs);
        Iterator iterator = descriptionList.iterator();
        while (iterator.hasNext()) {
            Element description = (Element)iterator.next();
            output.append("! " + elementName.toUpperCase() + "       " + description.getValue() + "\n");
            iterator.remove();
        }
    }

    @Override
    protected void readCmlMatrix(StringBuffer output, Vector matrices, String element, String shell) throws FormatException {
        this.readFirstColumn(output, matrices, element, shell);
        this.readRemainingColumns(output, matrices);
    }

    private void readFirstColumn(StringBuffer output, Vector matrices, String element, String shell) throws FormatException {
        boolean FIRSTCOLUMN = false;
        output.append(shell.toLowerCase() + ", " + element.toUpperCase() + " ");
        for (int k = 0; k < matrices.size(); ++k) {
            Matrix matrix = (Matrix)matrices.get(k);
            int rows = matrix.getNumRows();
            try {
                for (int i = 0; i < rows; ++i) {
                    String value = matrix.getValue(i, 0);
                    output.append(", " + value);
                }
                continue;
            }
            catch (IndexOutOfBoundsException ie) {
                throw new FormatException(ie.getMessage());
            }
        }
        output.append("\n");
    }

    private void readRemainingColumns(StringBuffer output, Vector matrices) throws FormatException {
        int totalRowsSoFar = 0;
        for (int k = 0; k < matrices.size(); ++k) {
            Matrix matrix = (Matrix)matrices.get(k);
            int rows = matrix.getNumRows();
            int columns = matrix.getNumColumns();
            for (int j = 1; j < columns; ++j) {
                String outputText = "";
                int startRow = 0;
                int endRow = -1;
                for (int i = 0; i < rows; ++i) {
                    try {
                        String value;
                        String value2 = value = matrix.getValue(i, j);
                        if (value2.indexOf(68) != -1) {
                            value2 = value2.replace('D', 'E');
                        } else if (value2.indexOf(100) != -1) {
                            value2 = value2.replace('d', 'E');
                        }
                        if (Double.parseDouble(value2) == 0.0) continue;
                        outputText = outputText + ", " + value;
                        if (startRow == 0) {
                            startRow = i + 1;
                        }
                        endRow = i + 1;
                        continue;
                    }
                    catch (IndexOutOfBoundsException ie) {
                        throw new FormatException(ie.getMessage());
                    }
                }
                if (endRow < startRow) continue;
                int cumulativeStartRow = totalRowsSoFar + startRow;
                int cumulativeEndRow = totalRowsSoFar + endRow;
                output.append("c, " + cumulativeStartRow + "." + cumulativeEndRow + outputText);
                output.append("\n");
            }
            totalRowsSoFar += rows;
        }
    }
}

