%feature("docstring") PERSALYS::FieldKarhunenLoeveAnalysis
"Create a Karhunen-Loeve decomposition of a DataFieldModel

Parameters
----------
name : str
    Name
dataModel : :class:`~persalys.DataFieldModel`
    Data to decompose

Notes
-----
The class has two main uses. Direct: when handling a :class:`~persalys.DataFieldModel`. Indirect: used internally in :class:`~persalys.FieldMonteCarloAnalysis`"

// --------------------------------------------------------------------

%feature("docstring") PERSALYS::FieldKarhunenLoeveAnalysis::getDataFieldModel
"DataFieldModel accessor.

Returns
-------
dataModel : :class:`~persalys.DataFieldModel`
    :class:`~persalys.DataFieldModel` associated to the analysis."

// --------------------------------------------------------------------

%feature("docstring") PERSALYS::FieldKarhunenLoeveAnalysis::getKarhunenLoeveThreshold
"Accessor to the limit ratio on eigenvalues.

Returns
-------
threshold : float, positive
    The threshold s defined in :py:meth:`openturns.KarhunenLoeveAlgorithm.setThreshold`"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FieldKarhunenLoeveAnalysis::setKarhunenLoeveThreshold
"Accessor to the limit ratio on eigenvalues.

Parameters
----------
threshold : float, positive
    The threshold s defined in :py:meth:`openturns.KarhunenLoeveAlgorithm.getThreshold`"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FieldKarhunenLoeveAnalysis::getQuantileLevel
"Probability level accessor.

Returns
-------
level : float
    Probability level"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FieldKarhunenLoeveAnalysis::setQuantileLevel
"Probability level accessor.

Parameters
----------
level : float, :math:`0 < p < 1`
    Probability level"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FieldKarhunenLoeveAnalysis::getResult
"Result accessor.

Returns
-------
result : :class:`persalys.FieldMonteCarloResult`
    Result"
