/***************************************************************************
  qgsbabelformatregistry.cpp
   -------------------
  begin                : July 2021
  copyright            : (C) 2021 by Nyall Dawson
  email                : nyall dot dawson at gmail dot com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "qgsbabelformatregistry.h"
#include "qgsbabelformat.h"
#include "qgsbabelgpsdevice.h"
#include <QString>
#include <QRegularExpression>

const QgsSettingsEntryString *QgsBabelFormatRegistry::settingsBabelWptDownload = new QgsSettingsEntryString( QStringLiteral( "wptdownload" ), sTreeBabelDevices );

const QgsSettingsEntryString *QgsBabelFormatRegistry::settingsBabelWptUpload = new QgsSettingsEntryString( QStringLiteral( "wptupload" ), sTreeBabelDevices );

const QgsSettingsEntryString *QgsBabelFormatRegistry::settingsBabelRteDownload = new QgsSettingsEntryString( QStringLiteral( "rtedownload" ), sTreeBabelDevices );

const QgsSettingsEntryString *QgsBabelFormatRegistry::settingsBabelRteUpload = new QgsSettingsEntryString( QStringLiteral( "rteupload" ), sTreeBabelDevices );

const QgsSettingsEntryString *QgsBabelFormatRegistry::settingsBabelTrkDownload = new QgsSettingsEntryString( QStringLiteral( "trkdownload" ), sTreeBabelDevices );

const QgsSettingsEntryString *QgsBabelFormatRegistry::settingsBabelTrkUpload = new QgsSettingsEntryString( QStringLiteral( "trkupload" ), sTreeBabelDevices );

QgsBabelFormatRegistry::QgsBabelFormatRegistry()
{
  //
  // this list is automatically generated by scripts/dump_babel_formats.py
  //
  mImporters[QStringLiteral( "alantrl" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "alantrl" ), QStringLiteral( "Alan Map500 tracklogs (.trl)" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "trl" )} );
  mImporters[QStringLiteral( "alanwpr" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "alanwpr" ), QStringLiteral( "Alan Map500 waypoints and routes (.wpr)" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes, {QStringLiteral( "wpr" )} );
  mImporters[QStringLiteral( "an1" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "an1" ), QStringLiteral( "DeLorme .an1 (drawing) file" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes, {QStringLiteral( "an1" )} );
  mImporters[QStringLiteral( "arc" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "arc" ), QStringLiteral( "GPSBabel arc filter file" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "txt" )} );
  mImporters[QStringLiteral( "bcr" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "bcr" ), QStringLiteral( "Motorrad Routenplaner (Map&Guide) .bcr files" ), Qgis::BabelFormatCapability::Routes, {QStringLiteral( "bcr" )} );
  mImporters[QStringLiteral( "bushnell" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "bushnell" ), QStringLiteral( "Bushnell GPS Waypoint file" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "wpt" )} );
  mImporters[QStringLiteral( "bushnell_trl" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "bushnell_trl" ), QStringLiteral( "Bushnell GPS Trail file" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "trl" )} );
  mImporters[QStringLiteral( "cambridge" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "cambridge" ), QStringLiteral( "Cambridge/Winpilot glider software" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "dat" )} );
  mImporters[QStringLiteral( "compegps" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "compegps" ), QStringLiteral( "CompeGPS data files (.wpt/.trk/.rte)" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {} );
  mImporters[QStringLiteral( "cst" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "cst" ), QStringLiteral( "CarteSurTable data file" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "cst" )} );
  mImporters[QStringLiteral( "csv" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "csv" ), QStringLiteral( "Comma separated values" ), Qgis::BabelFormatCapability::Waypoints, {} );
  mImporters[QStringLiteral( "cup" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "cup" ), QStringLiteral( "See You flight analysis data" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "cup" )} );
  mImporters[QStringLiteral( "destinator_itn" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "destinator_itn" ), QStringLiteral( "Destinator Itineraries (.dat)" ), Qgis::BabelFormatCapability::Routes, {QStringLiteral( "dat" )} );
  mImporters[QStringLiteral( "destinator_poi" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "destinator_poi" ), QStringLiteral( "Destinator Points of Interest (.dat)" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "dat" )} );
  mImporters[QStringLiteral( "destinator_trl" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "destinator_trl" ), QStringLiteral( "Destinator TrackLogs (.dat)" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "dat" )} );
  mImporters[QStringLiteral( "dmtlog" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "dmtlog" ), QStringLiteral( "TrackLogs digital mapping (.trl)" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "trl" )} );
  mImporters[QStringLiteral( "dna" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "dna" ), QStringLiteral( "Navitrak DNA marker format" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "dna" )} );
  mImporters[QStringLiteral( "easygps" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "easygps" ), QStringLiteral( "EasyGPS binary format" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "loc" )} );
  mImporters[QStringLiteral( "energympro" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "energympro" ), QStringLiteral( "Energympro GPS training watch" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "cpo" )} );
  mImporters[QStringLiteral( "enigma" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "enigma" ), QStringLiteral( "Enigma binary waypoint file (.ert)" ), Qgis::BabelFormatCapability::Routes, {QStringLiteral( "ert" )} );
  mImporters[QStringLiteral( "exif" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "exif" ), QStringLiteral( "Embedded Exif-GPS data (.jpg)" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "jpg" )} );
  mImporters[QStringLiteral( "f90g" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "f90g" ), QStringLiteral( "F90G Automobile DVR GPS log file" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "map" )} );
  mImporters[QStringLiteral( "flysight" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "flysight" ), QStringLiteral( "FlySight GPS File" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "csv" )} );
  mImporters[QStringLiteral( "fugawi" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "fugawi" ), QStringLiteral( "Fugawi" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "txt" )} );
  mImporters[QStringLiteral( "g7towin" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "g7towin" ), QStringLiteral( "G7ToWin data files (.g7t)" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "g7t" )} );
  mImporters[QStringLiteral( "garmin301" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "garmin301" ), QStringLiteral( "Garmin 301 Custom position and heartrate" ), Qgis::BabelFormatCapability::Waypoints, {} );
  mImporters[QStringLiteral( "garmin_fit" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "garmin_fit" ), QStringLiteral( "Flexible and Interoperable Data Transfer (FIT) Activity file" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "fit" )} );
  mImporters[QStringLiteral( "garmin_g1000" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "garmin_g1000" ), QStringLiteral( "Garmin G1000 datalog input filter file" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "csv" )} );
  mImporters[QStringLiteral( "garmin_gpi" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "garmin_gpi" ), QStringLiteral( "Garmin Points of Interest (.gpi)" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "gpi" )} );
  mImporters[QStringLiteral( "garmin_poi" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "garmin_poi" ), QStringLiteral( "Garmin POI database" ), Qgis::BabelFormatCapability::Waypoints, {} );
  mImporters[QStringLiteral( "garmin_txt" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "garmin_txt" ), QStringLiteral( "Garmin MapSource - txt (tab delimited)" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "txt" )} );
  mImporters[QStringLiteral( "garmin_xt" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "garmin_xt" ), QStringLiteral( "Mobile Garmin XT Track files" ), Qgis::BabelFormatCapability::Tracks, {} );
  mImporters[QStringLiteral( "gdb" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "gdb" ), QStringLiteral( "Garmin MapSource - gdb" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "gdb" )} );
  mImporters[QStringLiteral( "geo" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "geo" ), QStringLiteral( "Geocaching.com .loc" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "loc" )} );
  mImporters[QStringLiteral( "geojson" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "geojson" ), QStringLiteral( "GeoJson" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "json" )} );
  mImporters[QStringLiteral( "geonet" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "geonet" ), QStringLiteral( "GEOnet Names Server (GNS)" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "txt" )} );
  mImporters[QStringLiteral( "ggv_bin" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "ggv_bin" ), QStringLiteral( "Geogrid-Viewer binary overlay file (.ovl)" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "ovl" )} );
  mImporters[QStringLiteral( "ggv_log" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "ggv_log" ), QStringLiteral( "Geogrid-Viewer tracklogs (.log)" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "log" )} );
  mImporters[QStringLiteral( "ggv_ovl" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "ggv_ovl" ), QStringLiteral( "Geogrid-Viewer ascii overlay file (.ovl)" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "ovl" )} );
  mImporters[QStringLiteral( "glogbook" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "glogbook" ), QStringLiteral( "Garmin Logbook XML" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "xml" )} );
  mImporters[QStringLiteral( "gnav_trl" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "gnav_trl" ), QStringLiteral( "Google Navigator Tracklines (.trl)" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "trl" )} );
  mImporters[QStringLiteral( "googledir" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "googledir" ), QStringLiteral( "Google Directions XML" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "xml" )} );
  mImporters[QStringLiteral( "gopal" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "gopal" ), QStringLiteral( "GoPal GPS track log (.trk)" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "trk" )} );
  mImporters[QStringLiteral( "gpl" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "gpl" ), QStringLiteral( "DeLorme GPL" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "gpl" )} );
  mImporters[QStringLiteral( "gpsdrive" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "gpsdrive" ), QStringLiteral( "GpsDrive Format" ), Qgis::BabelFormatCapability::Waypoints, {} );
  mImporters[QStringLiteral( "gpsdrivetrack" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "gpsdrivetrack" ), QStringLiteral( "GpsDrive Format for Tracks" ), Qgis::BabelFormatCapability::Waypoints, {} );
  mImporters[QStringLiteral( "gpsman" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "gpsman" ), QStringLiteral( "GPSman" ), Qgis::BabelFormatCapability::Waypoints, {} );
  mImporters[QStringLiteral( "gpsutil" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "gpsutil" ), QStringLiteral( "gpsutil" ), Qgis::BabelFormatCapability::Waypoints, {} );
  mImporters[QStringLiteral( "gpx" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "gpx" ), QStringLiteral( "GPX XML" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "gpx" )} );
  mImporters[QStringLiteral( "gtm" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "gtm" ), QStringLiteral( "GPS TrackMaker" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "gtm" )} );
  mImporters[QStringLiteral( "gtrnctr" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "gtrnctr" ), QStringLiteral( "Garmin Training Center (.tcx/.crs/.hst/.xml)" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "tcx" ), QStringLiteral( "crs" ), QStringLiteral( "hst" ), QStringLiteral( "xml" )} );
  mImporters[QStringLiteral( "hiketech" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "hiketech" ), QStringLiteral( "HikeTech" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "gps" )} );
  mImporters[QStringLiteral( "holux" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "holux" ), QStringLiteral( "Holux (gm-100) .wpo Format" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "wpo" )} );
  mImporters[QStringLiteral( "humminbird" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "humminbird" ), QStringLiteral( "Humminbird waypoints and routes (.hwr)" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "hwr" )} );
  mImporters[QStringLiteral( "humminbird_ht" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "humminbird_ht" ), QStringLiteral( "Humminbird tracks (.ht)" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "ht" )} );
  mImporters[QStringLiteral( "iblue747" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "iblue747" ), QStringLiteral( "Data Logger iBlue747 csv" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "csv" )} );
  mImporters[QStringLiteral( "iblue757" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "iblue757" ), QStringLiteral( "Data Logger iBlue757 csv" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "csv" )} );
  mImporters[QStringLiteral( "igc" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "igc" ), QStringLiteral( "FAI/IGC Flight Recorder Data Format" ), Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {} );
  mImporters[QStringLiteral( "ignrando" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "ignrando" ), QStringLiteral( "IGN Rando track files" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "rdn" )} );
  mImporters[QStringLiteral( "igo2008_poi" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "igo2008_poi" ), QStringLiteral( "iGO2008 points of interest (.upoi)" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "upoi" )} );
  mImporters[QStringLiteral( "igo8" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "igo8" ), QStringLiteral( "IGO8 .trk" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "trk" )} );
  mImporters[QStringLiteral( "igoprimo_poi" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "igoprimo_poi" ), QStringLiteral( "iGo Primo points of interest (.upoi)" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "upoi" )} );
  mImporters[QStringLiteral( "ik3d" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "ik3d" ), QStringLiteral( "MagicMaps IK3D project file (.ikt)" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "ikt" )} );
  mImporters[QStringLiteral( "itracku-bin" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "itracku-bin" ), QStringLiteral( "XAiOX iTrackU Logger Binary File Format" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "bin" )} );
  mImporters[QStringLiteral( "jogmap" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "jogmap" ), QStringLiteral( "Jogmap.de XML format" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "xml" )} );
  mImporters[QStringLiteral( "jtr" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "jtr" ), QStringLiteral( "Jelbert GeoTagger data file" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "jtr" )} );
  mImporters[QStringLiteral( "kml" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "kml" ), QStringLiteral( "Google Earth (Keyhole) Markup Language" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "kml" )} );
  mImporters[QStringLiteral( "kompass_tk" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "kompass_tk" ), QStringLiteral( "Kompass (DAV) Track (.tk)" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "wp" )} );
  mImporters[QStringLiteral( "kompass_wp" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "kompass_wp" ), QStringLiteral( "Kompass (DAV) Waypoints (.wp)" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "wp" )} );
  mImporters[QStringLiteral( "land_air_sea" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "land_air_sea" ), QStringLiteral( "GPS Tracking Key Pro text" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "txt" )} );
  mImporters[QStringLiteral( "lmx" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "lmx" ), QStringLiteral( "Nokia Landmark Exchange" ), Qgis::BabelFormatCapability::Waypoints, {} );
  mImporters[QStringLiteral( "lowranceusr" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "lowranceusr" ), QStringLiteral( "Lowrance USR" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "usr" )} );
  mImporters[QStringLiteral( "m241-bin" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "m241-bin" ), QStringLiteral( "Holux M-241 (MTK based) Binary File Format" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "bin" )} );
  mImporters[QStringLiteral( "magellan" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "magellan" ), QStringLiteral( "Magellan SD files (as for Meridian)" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {} );
  mImporters[QStringLiteral( "magellanx" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "magellanx" ), QStringLiteral( "Magellan SD files (as for eXplorist)" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "upt" )} );
  mImporters[QStringLiteral( "maggeo" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "maggeo" ), QStringLiteral( "Magellan Explorist Geocaching" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "gs" )} );
  mImporters[QStringLiteral( "mainnav" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "mainnav" ), QStringLiteral( "Mainnav" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "nav" )} );
  mImporters[QStringLiteral( "mapasia_tr7" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "mapasia_tr7" ), QStringLiteral( "MapAsia track file (.tr7)" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "tr7" )} );
  mImporters[QStringLiteral( "mapbar" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "mapbar" ), QStringLiteral( "Mapbar (China) navigation track for Sonim Xp3300" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "trk" )} );
  mImporters[QStringLiteral( "mapconverter" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "mapconverter" ), QStringLiteral( "Mapopolis.com Mapconverter CSV" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "txt" )} );
  mImporters[QStringLiteral( "mapfactor" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "mapfactor" ), QStringLiteral( "Mapfactor Navigator" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "xml" )} );
  mImporters[QStringLiteral( "mapsend" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "mapsend" ), QStringLiteral( "Magellan Mapsend" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {} );
  mImporters[QStringLiteral( "mmo" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "mmo" ), QStringLiteral( "Memory-Map Navigator overlay files (.mmo)" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "mmo" )} );
  mImporters[QStringLiteral( "motoactv" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "motoactv" ), QStringLiteral( "Motoactiv CSV" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "csv" )} );
  mImporters[QStringLiteral( "mtk-bin" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "mtk-bin" ), QStringLiteral( "MTK Logger (iBlue 747,...) Binary File Format" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "bin" )} );
  mImporters[QStringLiteral( "mtk_locus" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "mtk_locus" ), QStringLiteral( "MediaTek Locus" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Tracks, {} );
  mImporters[QStringLiteral( "mxf" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "mxf" ), QStringLiteral( "MapTech Exchange Format" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "mxf" )} );
  mImporters[QStringLiteral( "mynav" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "mynav" ), QStringLiteral( "MyNav TRC format" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "trc" )} );
  mImporters[QStringLiteral( "navicache" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "navicache" ), QStringLiteral( "Navicache.com XML" ), Qgis::BabelFormatCapability::Waypoints, {} );
  mImporters[QStringLiteral( "navigonwpt" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "navigonwpt" ), QStringLiteral( "Navigon Waypoints" ), Qgis::BabelFormatCapability::Waypoints, {} );
  mImporters[QStringLiteral( "naviguide" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "naviguide" ), QStringLiteral( "Naviguide binary route file (.twl)" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "twl" )} );
  mImporters[QStringLiteral( "navitel_trk" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "navitel_trk" ), QStringLiteral( "Navitel binary track (.bin)" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "bin" )} );
  mImporters[QStringLiteral( "netstumbler" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "netstumbler" ), QStringLiteral( "NetStumbler Summary File (text)" ), Qgis::BabelFormatCapability::Waypoints, {} );
  mImporters[QStringLiteral( "nima" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "nima" ), QStringLiteral( "NIMA/GNIS Geographic Names File" ), Qgis::BabelFormatCapability::Waypoints, {} );
  mImporters[QStringLiteral( "nmea" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "nmea" ), QStringLiteral( "NMEA 0183 sentences" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Tracks, {} );
  mImporters[QStringLiteral( "nmn4" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "nmn4" ), QStringLiteral( "Navigon Mobile Navigator .rte files" ), Qgis::BabelFormatCapability::Routes, {QStringLiteral( "rte" )} );
  mImporters[QStringLiteral( "openoffice" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "openoffice" ), QStringLiteral( "Tab delimited fields useful for OpenOffice" ), Qgis::BabelFormatCapability::Waypoints, {} );
  mImporters[QStringLiteral( "osm" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "osm" ), QStringLiteral( "OpenStreetMap data files" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes, {QStringLiteral( "osm" )} );
  mImporters[QStringLiteral( "ozi" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "ozi" ), QStringLiteral( "OziExplorer" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {} );
  mImporters[QStringLiteral( "pcx" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "pcx" ), QStringLiteral( "Garmin PCX5" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "pcx" )} );
  mImporters[QStringLiteral( "pocketfms_bc" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "pocketfms_bc" ), QStringLiteral( "PocketFMS breadcrumbs" ), Qgis::BabelFormatCapability::Tracks, {} );
  mImporters[QStringLiteral( "pocketfms_fp" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "pocketfms_fp" ), QStringLiteral( "PocketFMS flightplan (.xml)" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes, {QStringLiteral( "xml" )} );
  mImporters[QStringLiteral( "pocketfms_wp" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "pocketfms_wp" ), QStringLiteral( "PocketFMS waypoints (.txt)" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "txt" )} );
  mImporters[QStringLiteral( "qstarz_bl-1000" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "qstarz_bl-1000" ), QStringLiteral( "Qstarz BL-1000" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Tracks, {} );
  mImporters[QStringLiteral( "raymarine" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "raymarine" ), QStringLiteral( "Raymarine Waypoint File (.rwf)" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes, {QStringLiteral( "rwf" )} );
  mImporters[QStringLiteral( "ricoh" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "ricoh" ), QStringLiteral( "Ricoh GPS Log File" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "log" )} );
  mImporters[QStringLiteral( "s_and_t" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "s_and_t" ), QStringLiteral( "Microsoft Streets and Trips 2002-2007" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "txt" )} );
  mImporters[QStringLiteral( "saplus" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "saplus" ), QStringLiteral( "DeLorme Street Atlas Plus" ), Qgis::BabelFormatCapability::Waypoints, {} );
  mImporters[QStringLiteral( "saroute" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "saroute" ), QStringLiteral( "DeLorme Street Atlas Route" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "anr" )} );
  mImporters[QStringLiteral( "sbn" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "sbn" ), QStringLiteral( "NaviGPS GT-31/BGT-31 SiRF binary logfile (.sbn)" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "sbn" )} );
  mImporters[QStringLiteral( "sbp" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "sbp" ), QStringLiteral( "NaviGPS GT-31/BGT-31 datalogger (.sbp)" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "sbp" )} );
  mImporters[QStringLiteral( "shape" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "shape" ), QStringLiteral( "ESRI shapefile" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "shp" )} );
  mImporters[QStringLiteral( "skyforce" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "skyforce" ), QStringLiteral( "Skymap / KMD150 ascii files" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {} );
  mImporters[QStringLiteral( "skytraq-bin" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "skytraq-bin" ), QStringLiteral( "SkyTraq Venus based loggers Binary File Format" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "bin" )} );
  mImporters[QStringLiteral( "stmsdf" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "stmsdf" ), QStringLiteral( "Suunto Trek Manager (STM) .sdf files" ), Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "sdf" )} );
  mImporters[QStringLiteral( "stmwpp" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "stmwpp" ), QStringLiteral( "Suunto Trek Manager (STM) WaypointPlus files" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "txt" )} );
  mImporters[QStringLiteral( "tef" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "tef" ), QStringLiteral( "Map&Guide 'TourExchangeFormat' XML" ), Qgis::BabelFormatCapability::Routes, {QStringLiteral( "xml" )} );
  mImporters[QStringLiteral( "teletype" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "teletype" ), QStringLiteral( "Teletype" ), Qgis::BabelFormatCapability::Waypoints, {} );
  mImporters[QStringLiteral( "tiger" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "tiger" ), QStringLiteral( "U.S. Census Bureau Tiger Mapping Service" ), Qgis::BabelFormatCapability::Waypoints, {} );
  mImporters[QStringLiteral( "tmpro" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "tmpro" ), QStringLiteral( "TopoMapPro Places File" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "tmpro" )} );
  mImporters[QStringLiteral( "tomtom" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "tomtom" ), QStringLiteral( "TomTom POI file (.ov2)" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "ov2" )} );
  mImporters[QStringLiteral( "tomtom_asc" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "tomtom_asc" ), QStringLiteral( "TomTom POI file (.asc)" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "asc" )} );
  mImporters[QStringLiteral( "tomtom_itn" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "tomtom_itn" ), QStringLiteral( "TomTom Itineraries (.itn)" ), Qgis::BabelFormatCapability::Routes, {QStringLiteral( "itn" )} );
  mImporters[QStringLiteral( "tomtom_itn_places" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "tomtom_itn_places" ), QStringLiteral( "TomTom Places Itineraries (.itn)" ), Qgis::BabelFormatCapability::Routes, {QStringLiteral( "itn" )} );
  mImporters[QStringLiteral( "tpg" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "tpg" ), QStringLiteral( "National Geographic Topo .tpg (waypoints)" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "tpg" )} );
  mImporters[QStringLiteral( "tpo2" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "tpo2" ), QStringLiteral( "National Geographic Topo 2.x .tpo" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "tpo" )} );
  mImporters[QStringLiteral( "tpo3" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "tpo3" ), QStringLiteral( "National Geographic Topo 3.x/4.x .tpo" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "tpo" )} );
  mImporters[QStringLiteral( "unicsv" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "unicsv" ), QStringLiteral( "Universal csv with field structure in first line" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {} );
  mImporters[QStringLiteral( "v900" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "v900" ), QStringLiteral( "Columbus/Visiontac V900 files (.csv)" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Tracks, {} );
  mImporters[QStringLiteral( "vidaone" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "vidaone" ), QStringLiteral( "VidaOne GPS for Pocket PC (.gpb)" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "gpb" )} );
  mImporters[QStringLiteral( "vitosmt" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "vitosmt" ), QStringLiteral( "Vito Navigator II tracks" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Routes | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "smt" )} );
  mImporters[QStringLiteral( "vitovtt" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "vitovtt" ), QStringLiteral( "Vito SmartMap tracks (.vtt)" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "vtt" )} );
  mImporters[QStringLiteral( "vpl" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "vpl" ), QStringLiteral( "Honda/Acura Navigation System VP Log File Format" ), Qgis::BabelFormatCapability::Tracks, {} );
  mImporters[QStringLiteral( "wbt-bin" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "wbt-bin" ), QStringLiteral( "Wintec WBT-100/200 Binary File Format" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "bin" )} );
  mImporters[QStringLiteral( "wbt-tk1" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "wbt-tk1" ), QStringLiteral( "Wintec WBT-201/G-Rays 2 Binary File Format" ), Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "tk1" )} );
  mImporters[QStringLiteral( "wfff" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "wfff" ), QStringLiteral( "WiFiFoFum 2.0 for PocketPC XML" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "xml" )} );
  mImporters[QStringLiteral( "wintec_tes" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "wintec_tes" ), QStringLiteral( "Wintec TES file" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "tes" )} );
  mImporters[QStringLiteral( "xmap" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "xmap" ), QStringLiteral( "DeLorme XMap HH Native .WPT" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "wpt" )} );
  mImporters[QStringLiteral( "xmap2006" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "xmap2006" ), QStringLiteral( "DeLorme XMap/SAHH 2006 Native .TXT" ), Qgis::BabelFormatCapability::Waypoints, {QStringLiteral( "txt" )} );
  mImporters[QStringLiteral( "xmapwpt" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "xmapwpt" ), QStringLiteral( "DeLorme XMat HH Street Atlas USA .WPT (PPC)" ), Qgis::BabelFormatCapability::Waypoints, {} );
  mImporters[QStringLiteral( "xol" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "xol" ), QStringLiteral( "Swiss Map 25/50/100 (.xol)" ), Qgis::BabelFormatCapability::Waypoints | Qgis::BabelFormatCapability::Tracks, {QStringLiteral( "xol" )} );
  mImporters[QStringLiteral( "yahoo" )] = new QgsBabelSimpleImportFormat( QStringLiteral( "yahoo" ), QStringLiteral( "Yahoo Geocode API data" ), Qgis::BabelFormatCapability::Waypoints, {} );

  reloadFromSettings();
}

QgsBabelFormatRegistry::~QgsBabelFormatRegistry()
{
  qDeleteAll( mImporters );
  qDeleteAll( mDevices );
}

QStringList QgsBabelFormatRegistry::importFormatNames() const
{
  return mImporters.keys();
}

QgsBabelSimpleImportFormat *QgsBabelFormatRegistry::importFormat( const QString &name )
{
  return mImporters.value( name );
}

QgsBabelSimpleImportFormat *QgsBabelFormatRegistry::importFormatByDescription( const QString &description )
{
  for ( auto it = mImporters.constBegin(); it != mImporters.constEnd(); ++it )
  {
    if ( it.value()->description().compare( description, Qt::CaseInsensitive ) == 0 )
      return it.value();

    // also need to test square bracket variant, see logic in importFileFilter()
    const QString descriptionSquareBrackets = it.value()->description().replace( '(', '[' ).replace( ')', ']' );
    if ( descriptionSquareBrackets.compare( description, Qt::CaseInsensitive ) == 0 )
      return it.value();
  }
  return nullptr;
}

QString QgsBabelFormatRegistry::importFileFilter() const
{
  QStringList res;
  QMap< QString, QString > descriptionToString;
  for ( auto it = mImporters.constBegin(); it != mImporters.constEnd(); ++it )
  {
    const QStringList extensions = it.value()->extensions();
    QString fileFilter;
    if ( !extensions.empty() )
    {
      fileFilter = '(';
      for ( const QString &extension : extensions )
        fileFilter.append( QStringLiteral( "*.%1" ).arg( extension ) );
      fileFilter.append( ')' );
    }
    else
    {
      fileFilter = QStringLiteral( "(*.*)" );
    }

    // we have to replace round brackets from the format description, or they are treated as the filter component!
    const QString description = it.value()->description().replace( '(', '[' ).replace( ')', ']' );

    descriptionToString.insert( description.toLower(), QStringLiteral( "%1 %2" ).arg( description, fileFilter ) );
  }

  // build the list in a sorted order of lowercase description
  for ( auto it = descriptionToString.constBegin(); it != descriptionToString.constEnd(); ++it )
    res << it.value();

  return res.join( QLatin1String( ";;" ) );
}

QStringList QgsBabelFormatRegistry::deviceNames() const
{
  return mDevices.keys();
}

QgsBabelGpsDeviceFormat *QgsBabelFormatRegistry::deviceFormat( const QString &name )
{
  return mDevices.value( name );
}

QMap<QString, QgsBabelGpsDeviceFormat *> QgsBabelFormatRegistry::devices() const
{
  return mDevices;
}

void QgsBabelFormatRegistry::reloadFromSettings()
{
  qDeleteAll( mDevices );
  mDevices.clear();

  mDevices[QStringLiteral( "Garmin serial" )] =
    new QgsBabelGpsDeviceFormat( QStringLiteral( "%babel -w -i garmin -o gpx %in %out" ),
                                 QStringLiteral( "%babel -w -i gpx -o garmin %in %out" ),
                                 QStringLiteral( "%babel -r -i garmin -o gpx %in %out" ),
                                 QStringLiteral( "%babel -r -i gpx -o garmin %in %out" ),
                                 QStringLiteral( "%babel -t -i garmin -o gpx %in %out" ),
                                 QStringLiteral( "%babel -t -i gpx -o garmin %in %out" ) );

  for ( const QString &device : sTreeBabelDevices->items() )
  {
    // don't leak memory if there's already a device with this name...
    delete mDevices.value( device );

    mDevices[device] = new QgsBabelGpsDeviceFormat( settingsBabelWptDownload->value( device ), settingsBabelWptUpload->value( device ),
        settingsBabelRteDownload->value( device ), settingsBabelRteUpload->value( device ),
        settingsBabelTrkDownload->value( device ), settingsBabelTrkUpload->value( device ) );
  }
}

