% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_createshard.R
\name{collection_createshard}
\alias{collection_createshard}
\title{Create a shard}
\usage{
collection_createshard(conn, name, shard, createNodeSet = NULL,
  raw = FALSE, ...)
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{name}{(character) The name of the core to be created. Required}

\item{shard}{(character) Required. The name of the shard to be created.}

\item{createNodeSet}{(character) Allows defining the nodes to spread the new
collection across. If not provided, the CREATE operation will create
shard-replica spread across all live Solr nodes. The format is a
comma-separated list of node_names, such as localhost:8983_solr,
localhost:8984_s olr, localhost:8985_solr.}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{...}{You can pass in parameters like \code{property.name=value}    to set
core property name to value. See the section Defining core.properties for
details on supported properties and values.
(https://lucene.apache.org/solr/guide/8_2/defining-core-properties.html)}
}
\description{
Create a shard
}
\examples{
\dontrun{
(conn <- SolrClient$new())
## FIXME - doesn't work right now
# conn$collection_create(name = "trees")
# conn$collection_createshard(name = "trees", shard = "newshard")
}
}
