# 2020-10-21 Triage Log

A variety of changes, nothing particularly notable from a performance
perspective. [#77792](https://github.com/rust-lang/rust/issues/77792) is an
interesting win on migrating to tracing values rather than the older log
formatting. [#76859](https://github.com/rust-lang/rust/issues/76859) is also
interesting, starting out as a functional fix but appears to have been a
performance win for incremental benchmarks in some cases as well.

Triage done by **@simulacrum**.
Revision range: [06a079c43efb062e335e6e6c9dabd3c750619980..22e6b9c68941996daa45786b4145e6196e51f0f4](https://perf.rust-lang.org/?start=06a079c43efb062e335e6e6c9dabd3c750619980&end=22e6b9c68941996daa45786b4145e6196e51f0f4&absolute=false&stat=instructions%3Au)

4 Regressions, 7 Improvements, 0 Mixed
2 of them in rollups

#### Regressions

[#77755](https://github.com/rust-lang/rust/issues/77755)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=e8529c79cce76b47b7b61060db36cf8201c688a3&end=2d6eccdb67aef48d0804cb473536b925f61a7f18&stat=instructions:u) (up to 1.3% on `full` builds of `deeply-nested-async-check`)
- [Nag](https://github.com/rust-lang/rust/pull/77755#issuecomment-714086526)

[#77873](https://github.com/rust-lang/rust/issues/77873)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=19e1aac6ea9879c6d10eed7106b3bc883e5bf9a5&end=93deabce03dc10a80244f5da3e3819452744da2a&stat=instructions:u) (up to 2.7% on `full` builds of `wg-grammar-check`)
- Functional change. Regression not significantly major to warrant a revert.

[#78060](https://github.com/rust-lang/rust/issues/78060)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=ffeeb20398bb9a25c1f75599b942f57c85a2140d&end=043eca7f0b34d12e61c44206beca740628647080&stat=instructions:u) (up to 1.2% on `incr-unchanged` builds of `clap-rs-check`)
- Rollup; likely due to BTreeMap or meta-prelude changes. Not worth deep
  investigation: regression is minor and interesting changes are likely not
  readily changeable.

[#77250](https://github.com/rust-lang/rust/issues/77250)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=19356453cbfb734bc60a1853c10e3095d05e0342&end=22e6b9c68941996daa45786b4145e6196e51f0f4&stat=instructions:u) (up to 3.1% on `incr-unchanged` builds of `packed-simd-check`)
- Functional change that we definitely want, performance regression is not too
  significant.

#### Improvements

[#76859](https://github.com/rust-lang/rust/issues/76859)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=06a079c43efb062e335e6e6c9dabd3c750619980&end=c71248b70870960af9993de4f31d3cba9bbce7e8&stat=instructions:u) (up to -58.0% on `incr-patched: Compiler new` builds of `regex-opt`)
- Correctness is the key here, but it seems like our hand-rolled incremental
  tracking was (at least on the perf benchmarks) worse anyway.

[#77792](https://github.com/rust-lang/rust/issues/77792)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=8dae8cdcc8fa879cea6a4bbbfa5b32e97be4c306&end=abbdec3be6cfce1175d0dc6737a2999cf43b530d&stat=instructions:u) (up to -1.7% on `incr-unchanged` builds of `deeply-nested-async-opt`)
- Switching to tracing spans and tracing's "values" over string-formatting seems
  to have been a improvement here. Definitely an interesting result --
  presumably tracing's handling is somehow more visible to LLVM?

[#77796](https://github.com/rust-lang/rust/issues/77796)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=abbdec3be6cfce1175d0dc6737a2999cf43b530d&end=afb4514c099fde6e3102373602bea9e6dacd4f88&stat=instructions:u) (up to -1.4% on `full` builds of `deeply-nested-async-check`)
- Seems like potentially a slight regression on wall times, but ultimately the
  change is good on its merits, so no action is taken at this time.

[#77947](https://github.com/rust-lang/rust/issues/77947)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=b6e2dc6cdece6b498b876bc7e9377ff7d63d93e7&end=9bd740a8f17d75168b683bcfb077b6e450047df5&stat=instructions:u) (up to -7.4% on `incr-unchanged` builds of `cranelift-codegen-debug`)
- Seems to be a mixed result on [wall
  times](https://perf.rust-lang.org/compare.html?start=b6e2dc6cdece6b498b876bc7e9377ff7d63d93e7&end=9bd740a8f17d75168b683bcfb077b6e450047df5&stat=wall-time)
  though.

[#77373](https://github.com/rust-lang/rust/issues/77373)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=6af9846fcc8797bf97e9fb387385208c2219f3d0&end=ffeeb20398bb9a25c1f75599b942f57c85a2140d&stat=instructions:u) (up to -1.6% on `full` builds of `deeply-nested-async-check`)
- Wall times are less positive, but mostly on incremental. Not deemed a concern.

[#77908](https://github.com/rust-lang/rust/issues/77908)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=cb2462c53f2cc3f140c0f1ea0976261cab968a34&end=f90e6173053f7e6b377d7f75367b511ceee7d9d1&stat=instructions:u) (up to -1.8% on `full` builds of `inflate-check`)

[#78151](https://github.com/rust-lang/rust/issues/78151)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=9832374f6e378971e1a933362cf9781b121bb845&end=981346fc07dd5ef414c5b1b21999f7604cece006&stat=instructions:u) (up to -7.6% on `incr-patched: println` builds of `regression-31157-opt`)

#### Nags requiring follow up

- https://github.com/rust-lang/rust/pull/77755#issuecomment-714086526
