// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_USUBW_2D_TRACE_AARCH64_H_
#define VIXL_SIM_USUBW_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_usubw_2D[] = {
  0xffffffffffff827d, 0xffffffffffff8100,
  0xffffffffffff817d, 0xffffffffff800300,
  0xffffffffff80037d, 0x0000000000000000,
  0x000000000000007d, 0xffffffffffffffff,
  0x000000000000007c, 0xfffffffffffffffe,
  0x000000000000007b, 0xffffffffffffffe0,
  0x000000000000005d, 0xffffffffffffff83,
  0x0000000000000000, 0xffffffffffffff82,
  0xffffffffffffffff, 0xffffffffffffff81,
  0xfffffffffffffffe, 0xffffffffffff8003,
  0xffffffffffff8080, 0xffffffffffff8002,
  0xffffffffffff807f, 0xffffffffffff8001,
  0xffffffffffff807e, 0xffffffffcccccccd,
  0xffffffffcccccd4a, 0xffffffffaaaaaaab,
  0xffffffffaaaaab28, 0xffffffff80000003,
  0xffffffff80000080, 0xffffffff80000002,
  0xffffffff8000007f, 0xffffffff80000001,
  0xffffffff8000007e, 0xffffffff80000000,
  0xffffffff8000007d, 0xffffffff7fffffff,
  0xffffffff8000007c, 0xffffffff55555556,
  0xffffffff555555d3, 0xffffffff33333334,
  0xffffffff333333b1, 0xffffffff00008000,
  0xffffffff0000807d, 0xffffffff00007fff,
  0xffffffff0000807c, 0xffffffff00007ffe,
  0xffffffff0000807b, 0xffffffff00007ffd,
  0xffffffff0000807a, 0xffffffff00000080,
  0xffffffff000000fd, 0xffffffff0000007f,
  0xffffffff000000fc, 0xffffffff0000007e,
  0xffffffff000000fb, 0xffffffff0000007d,
  0xffffffff000000fa, 0xffffffff00000020,
  0xffffffff0000009d, 0xffffffff00000003,
  0xffffffff00000003, 0xffffffff00000003,
  0xffffffff00000002, 0xffffffff00000002,
  0xffffffff00000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xffffffffffffffe1,
  0xffffffffffffffe0, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffccccccce,
  0xffffffffcccccccd, 0xffffffffaaaaaaac,
  0xffffffffaaaaaaab, 0xffffffff80000004,
  0xffffffff80000003, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000000,
  0xffffffff7fffffff, 0xffffffff55555557,
  0xffffffff55555556, 0xffffffff33333335,
  0xffffffff33333334, 0xffffffff00008001,
  0xffffffff00008000, 0xffffffff00008000,
  0xffffffff00007fff, 0xffffffff00007fff,
  0xffffffff00007ffe, 0xffffffff00007ffe,
  0xffffffff00007ffd, 0xffffffff00000081,
  0xffffffff00000080, 0xffffffff00000080,
  0xffffffff0000007f, 0xffffffff0000007f,
  0xffffffff0000007e, 0xffffffff0000007e,
  0xffffffff0000007d, 0xffffffff00000021,
  0xffffffff00000020, 0xffffffff00000004,
  0xffffffff00000004, 0xffffffff00000004,
  0xffffffff00000003, 0xffffffff00000003,
  0xffffffff00000002, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffe2,
  0xffffffffffffffe1, 0xffffffffffffff85,
  0xffffffffffffff84, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffff8005,
  0xffffffffffff8004, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffcccccccf,
  0xffffffffccccccce, 0xffffffffaaaaaaad,
  0xffffffffaaaaaaac, 0xffffffff80000005,
  0xffffffff80000004, 0xffffffff80000004,
  0xffffffff80000003, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff55555558,
  0xffffffff55555557, 0xffffffff33333336,
  0xffffffff33333335, 0xffffffff00008002,
  0xffffffff00008001, 0xffffffff00008001,
  0xffffffff00008000, 0xffffffff00008000,
  0xffffffff00007fff, 0xffffffff00007fff,
  0xffffffff00007ffe, 0xffffffff00000082,
  0xffffffff00000081, 0xffffffff00000081,
  0xffffffff00000080, 0xffffffff00000080,
  0xffffffff0000007f, 0xffffffff0000007f,
  0xffffffff0000007e, 0xffffffff00000022,
  0xffffffff00000021, 0xffffffff00000005,
  0xffffffff00000005, 0xffffffff00000042,
  0xffffffff00000004, 0xffffffff00000041,
  0xffffffff00000003, 0x0000000000000040,
  0x0000000000000002, 0x000000000000003f,
  0x0000000000000001, 0x000000000000003e,
  0x0000000000000000, 0x0000000000000020,
  0xffffffffffffffe2, 0xffffffffffffffc3,
  0xffffffffffffff85, 0xffffffffffffffc2,
  0xffffffffffffff84, 0xffffffffffffffc1,
  0xffffffffffffff83, 0xffffffffffff8043,
  0xffffffffffff8005, 0xffffffffffff8042,
  0xffffffffffff8004, 0xffffffffffff8041,
  0xffffffffffff8003, 0xffffffffcccccd0d,
  0xffffffffcccccccf, 0xffffffffaaaaaaeb,
  0xffffffffaaaaaaad, 0xffffffff80000043,
  0xffffffff80000005, 0xffffffff80000042,
  0xffffffff80000004, 0xffffffff80000041,
  0xffffffff80000003, 0xffffffff80000040,
  0xffffffff80000002, 0xffffffff8000003f,
  0xffffffff80000001, 0xffffffff55555596,
  0xffffffff55555558, 0xffffffff33333374,
  0xffffffff33333336, 0xffffffff00008040,
  0xffffffff00008002, 0xffffffff0000803f,
  0xffffffff00008001, 0xffffffff0000803e,
  0xffffffff00008000, 0xffffffff0000803d,
  0xffffffff00007fff, 0xffffffff000000c0,
  0xffffffff00000082, 0xffffffff000000bf,
  0xffffffff00000081, 0xffffffff000000be,
  0xffffffff00000080, 0xffffffff000000bd,
  0xffffffff0000007f, 0xffffffff00000060,
  0xffffffff00000022, 0xffffffff00000043,
  0xffffffff00000043, 0xffffffff0000007f,
  0xffffffff00000042, 0xffffffff0000007e,
  0xffffffff00000041, 0x000000000000007d,
  0x0000000000000040, 0x000000000000007c,
  0x000000000000003f, 0x000000000000007b,
  0x000000000000003e, 0x000000000000005d,
  0x0000000000000020, 0x0000000000000000,
  0xffffffffffffffc3, 0xffffffffffffffff,
  0xffffffffffffffc2, 0xfffffffffffffffe,
  0xffffffffffffffc1, 0xffffffffffff8080,
  0xffffffffffff8043, 0xffffffffffff807f,
  0xffffffffffff8042, 0xffffffffffff807e,
  0xffffffffffff8041, 0xffffffffcccccd4a,
  0xffffffffcccccd0d, 0xffffffffaaaaab28,
  0xffffffffaaaaaaeb, 0xffffffff80000080,
  0xffffffff80000043, 0xffffffff8000007f,
  0xffffffff80000042, 0xffffffff8000007e,
  0xffffffff80000041, 0xffffffff8000007d,
  0xffffffff80000040, 0xffffffff8000007c,
  0xffffffff8000003f, 0xffffffff555555d3,
  0xffffffff55555596, 0xffffffff333333b1,
  0xffffffff33333374, 0xffffffff0000807d,
  0xffffffff00008040, 0xffffffff0000807c,
  0xffffffff0000803f, 0xffffffff0000807b,
  0xffffffff0000803e, 0xffffffff0000807a,
  0xffffffff0000803d, 0xffffffff000000fd,
  0xffffffff000000c0, 0xffffffff000000fc,
  0xffffffff000000bf, 0xffffffff000000fb,
  0xffffffff000000be, 0xffffffff000000fa,
  0xffffffff000000bd, 0xffffffff0000009d,
  0xffffffff00000060, 0xffffffff00000080,
  0xffffffff00000080, 0xffffffff00000080,
  0xffffffff0000007f, 0xffffffff0000007f,
  0xffffffff0000007e, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007c, 0x000000000000007c,
  0x000000000000007b, 0x000000000000005e,
  0x000000000000005d, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xffffffffffff8081,
  0xffffffffffff8080, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff807f,
  0xffffffffffff807e, 0xffffffffcccccd4b,
  0xffffffffcccccd4a, 0xffffffffaaaaab29,
  0xffffffffaaaaab28, 0xffffffff80000081,
  0xffffffff80000080, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffff8000007f,
  0xffffffff8000007e, 0xffffffff8000007e,
  0xffffffff8000007d, 0xffffffff8000007d,
  0xffffffff8000007c, 0xffffffff555555d4,
  0xffffffff555555d3, 0xffffffff333333b2,
  0xffffffff333333b1, 0xffffffff0000807e,
  0xffffffff0000807d, 0xffffffff0000807d,
  0xffffffff0000807c, 0xffffffff0000807c,
  0xffffffff0000807b, 0xffffffff0000807b,
  0xffffffff0000807a, 0xffffffff000000fe,
  0xffffffff000000fd, 0xffffffff000000fd,
  0xffffffff000000fc, 0xffffffff000000fc,
  0xffffffff000000fb, 0xffffffff000000fb,
  0xffffffff000000fa, 0xffffffff0000009e,
  0xffffffff0000009d, 0xffffffff00000081,
  0xffffffff00000081, 0xffffffff00000081,
  0xffffffff00000080, 0xffffffff00000080,
  0xffffffff0000007f, 0x000000000000007f,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007c, 0x000000000000005f,
  0x000000000000005e, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffff8082,
  0xffffffffffff8081, 0xffffffffffff8081,
  0xffffffffffff8080, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffcccccd4c,
  0xffffffffcccccd4b, 0xffffffffaaaaab2a,
  0xffffffffaaaaab29, 0xffffffff80000082,
  0xffffffff80000081, 0xffffffff80000081,
  0xffffffff80000080, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffff8000007f,
  0xffffffff8000007e, 0xffffffff8000007e,
  0xffffffff8000007d, 0xffffffff555555d5,
  0xffffffff555555d4, 0xffffffff333333b3,
  0xffffffff333333b2, 0xffffffff0000807f,
  0xffffffff0000807e, 0xffffffff0000807e,
  0xffffffff0000807d, 0xffffffff0000807d,
  0xffffffff0000807c, 0xffffffff0000807c,
  0xffffffff0000807b, 0xffffffff000000ff,
  0xffffffff000000fe, 0xffffffff000000fe,
  0xffffffff000000fd, 0xffffffff000000fd,
  0xffffffff000000fc, 0xffffffff000000fc,
  0xffffffff000000fb, 0xffffffff0000009f,
  0xffffffff0000009e, 0xffffffff00000082,
  0xffffffff00000082, 0xffffffff00007fff,
  0xffffffff00000081, 0xffffffff00007ffe,
  0xffffffff00000080, 0x0000000000007ffd,
  0x000000000000007f, 0x0000000000007ffc,
  0x000000000000007e, 0x0000000000007ffb,
  0x000000000000007d, 0x0000000000007fdd,
  0x000000000000005f, 0x0000000000007f80,
  0x0000000000000002, 0x0000000000007f7f,
  0x0000000000000001, 0x0000000000007f7e,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff8082, 0xffffffffffffffff,
  0xffffffffffff8081, 0xfffffffffffffffe,
  0xffffffffffff8080, 0xffffffffcccd4cca,
  0xffffffffcccccd4c, 0xffffffffaaab2aa8,
  0xffffffffaaaaab2a, 0xffffffff80008000,
  0xffffffff80000082, 0xffffffff80007fff,
  0xffffffff80000081, 0xffffffff80007ffe,
  0xffffffff80000080, 0xffffffff80007ffd,
  0xffffffff8000007f, 0xffffffff80007ffc,
  0xffffffff8000007e, 0xffffffff5555d553,
  0xffffffff555555d5, 0xffffffff3333b331,
  0xffffffff333333b3, 0xffffffff0000fffd,
  0xffffffff0000807f, 0xffffffff0000fffc,
  0xffffffff0000807e, 0xffffffff0000fffb,
  0xffffffff0000807d, 0xffffffff0000fffa,
  0xffffffff0000807c, 0xffffffff0000807d,
  0xffffffff000000ff, 0xffffffff0000807c,
  0xffffffff000000fe, 0xffffffff0000807b,
  0xffffffff000000fd, 0xffffffff0000807a,
  0xffffffff000000fc, 0xffffffff0000801d,
  0xffffffff0000009f, 0xffffffff00008000,
  0xffffffff00008000, 0xffffffff00008000,
  0xffffffff00007fff, 0xffffffff00007fff,
  0xffffffff00007ffe, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007ffc,
  0x0000000000007ffb, 0x0000000000007fde,
  0x0000000000007fdd, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xffffffffcccd4ccb,
  0xffffffffcccd4cca, 0xffffffffaaab2aa9,
  0xffffffffaaab2aa8, 0xffffffff80008001,
  0xffffffff80008000, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffff80007fff,
  0xffffffff80007ffe, 0xffffffff80007ffe,
  0xffffffff80007ffd, 0xffffffff80007ffd,
  0xffffffff80007ffc, 0xffffffff5555d554,
  0xffffffff5555d553, 0xffffffff3333b332,
  0xffffffff3333b331, 0xffffffff0000fffe,
  0xffffffff0000fffd, 0xffffffff0000fffd,
  0xffffffff0000fffc, 0xffffffff0000fffc,
  0xffffffff0000fffb, 0xffffffff0000fffb,
  0xffffffff0000fffa, 0xffffffff0000807e,
  0xffffffff0000807d, 0xffffffff0000807d,
  0xffffffff0000807c, 0xffffffff0000807c,
  0xffffffff0000807b, 0xffffffff0000807b,
  0xffffffff0000807a, 0xffffffff0000801e,
  0xffffffff0000801d, 0xffffffff00008001,
  0xffffffff00008001, 0xffffffff00008001,
  0xffffffff00008000, 0xffffffff00008000,
  0xffffffff00007fff, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007fdf,
  0x0000000000007fde, 0x0000000000007f82,
  0x0000000000007f81, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffcccd4ccc,
  0xffffffffcccd4ccb, 0xffffffffaaab2aaa,
  0xffffffffaaab2aa9, 0xffffffff80008002,
  0xffffffff80008001, 0xffffffff80008001,
  0xffffffff80008000, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffff80007fff,
  0xffffffff80007ffe, 0xffffffff80007ffe,
  0xffffffff80007ffd, 0xffffffff5555d555,
  0xffffffff5555d554, 0xffffffff3333b333,
  0xffffffff3333b332, 0xffffffff0000ffff,
  0xffffffff0000fffe, 0xffffffff0000fffe,
  0xffffffff0000fffd, 0xffffffff0000fffd,
  0xffffffff0000fffc, 0xffffffff0000fffc,
  0xffffffff0000fffb, 0xffffffff0000807f,
  0xffffffff0000807e, 0xffffffff0000807e,
  0xffffffff0000807d, 0xffffffff0000807d,
  0xffffffff0000807c, 0xffffffff0000807c,
  0xffffffff0000807b, 0xffffffff0000801f,
  0xffffffff0000801e, 0xffffffff00008002,
  0xffffffff00008002, 0xffffffff7fffffff,
  0xffffffff00008001, 0xffffffff7ffffffe,
  0xffffffff00008000, 0x000000007ffffffd,
  0x0000000000007fff, 0x000000007ffffffc,
  0x0000000000007ffe, 0x000000007ffffffb,
  0x0000000000007ffd, 0x000000007fffffdd,
  0x0000000000007fdf, 0x000000007fffff80,
  0x0000000000007f82, 0x000000007fffff7f,
  0x0000000000007f81, 0x000000007fffff7e,
  0x0000000000007f80, 0x000000007fff8000,
  0x0000000000000002, 0x000000007fff7fff,
  0x0000000000000001, 0x000000007fff7ffe,
  0x0000000000000000, 0x000000004cccccca,
  0xffffffffcccd4ccc, 0x000000002aaaaaa8,
  0xffffffffaaab2aaa, 0x0000000000000000,
  0xffffffff80008002, 0xffffffffffffffff,
  0xffffffff80008001, 0xfffffffffffffffe,
  0xffffffff80008000, 0xfffffffffffffffd,
  0xffffffff80007fff, 0xfffffffffffffffc,
  0xffffffff80007ffe, 0xffffffffd5555553,
  0xffffffff5555d555, 0xffffffffb3333331,
  0xffffffff3333b333, 0xffffffff80007ffd,
  0xffffffff0000ffff, 0xffffffff80007ffc,
  0xffffffff0000fffe, 0xffffffff80007ffb,
  0xffffffff0000fffd, 0xffffffff80007ffa,
  0xffffffff0000fffc, 0xffffffff8000007d,
  0xffffffff0000807f, 0xffffffff8000007c,
  0xffffffff0000807e, 0xffffffff8000007b,
  0xffffffff0000807d, 0xffffffff8000007a,
  0xffffffff0000807c, 0xffffffff8000001d,
  0xffffffff0000801f, 0xffffffff80000000,
  0xffffffff80000000, 0xffffffff80000000,
  0xffffffff7fffffff, 0xffffffff7fffffff,
  0xffffffff7ffffffe, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007ffffffd,
  0x000000007ffffffc, 0x000000007ffffffc,
  0x000000007ffffffb, 0x000000007fffffde,
  0x000000007fffffdd, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff7f,
  0x000000007fffff7e, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff7fff,
  0x000000007fff7ffe, 0x000000004ccccccb,
  0x000000004cccccca, 0x000000002aaaaaa9,
  0x000000002aaaaaa8, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xfffffffffffffffd,
  0xfffffffffffffffc, 0xffffffffd5555554,
  0xffffffffd5555553, 0xffffffffb3333332,
  0xffffffffb3333331, 0xffffffff80007ffe,
  0xffffffff80007ffd, 0xffffffff80007ffd,
  0xffffffff80007ffc, 0xffffffff80007ffc,
  0xffffffff80007ffb, 0xffffffff80007ffb,
  0xffffffff80007ffa, 0xffffffff8000007e,
  0xffffffff8000007d, 0xffffffff8000007d,
  0xffffffff8000007c, 0xffffffff8000007c,
  0xffffffff8000007b, 0xffffffff8000007b,
  0xffffffff8000007a, 0xffffffff8000001e,
  0xffffffff8000001d, 0xffffffff80000001,
  0xffffffff80000001, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000000,
  0xffffffff7fffffff, 0x000000007fffffff,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007ffffffd,
  0x000000007ffffffc, 0x000000007fffffdf,
  0x000000007fffffde, 0x000000007fffff82,
  0x000000007fffff81, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fff8002,
  0x000000007fff8001, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000004ccccccc,
  0x000000004ccccccb, 0x000000002aaaaaaa,
  0x000000002aaaaaa9, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffd5555555,
  0xffffffffd5555554, 0xffffffffb3333333,
  0xffffffffb3333332, 0xffffffff80007fff,
  0xffffffff80007ffe, 0xffffffff80007ffe,
  0xffffffff80007ffd, 0xffffffff80007ffd,
  0xffffffff80007ffc, 0xffffffff80007ffc,
  0xffffffff80007ffb, 0xffffffff8000007f,
  0xffffffff8000007e, 0xffffffff8000007e,
  0xffffffff8000007d, 0xffffffff8000007d,
  0xffffffff8000007c, 0xffffffff8000007c,
  0xffffffff8000007b, 0xffffffff8000001f,
  0xffffffff8000001e, 0xffffffff80000002,
  0xffffffff80000002, 0x3333333233333335,
  0xffffffff80000001, 0x3333333233333334,
  0xffffffff80000000, 0x3333333333333333,
  0x000000007fffffff, 0x3333333333333332,
  0x000000007ffffffe, 0x3333333333333331,
  0x000000007ffffffd, 0x3333333333333313,
  0x000000007fffffdf, 0x33333333333332b6,
  0x000000007fffff82, 0x33333333333332b5,
  0x000000007fffff81, 0x33333333333332b4,
  0x000000007fffff80, 0x333333333332b336,
  0x000000007fff8002, 0x333333333332b335,
  0x000000007fff8001, 0x333333333332b334,
  0x000000007fff8000, 0x3333333300000000,
  0x000000004ccccccc, 0x33333332ddddddde,
  0x000000002aaaaaaa, 0x33333332b3333336,
  0x0000000000000002, 0x33333332b3333335,
  0x0000000000000001, 0x33333332b3333334,
  0x0000000000000000, 0x33333332b3333333,
  0xffffffffffffffff, 0x33333332b3333332,
  0xfffffffffffffffe, 0x3333333288888889,
  0xffffffffd5555555, 0x3333333266666667,
  0xffffffffb3333333, 0x333333323333b333,
  0xffffffff80007fff, 0x333333323333b332,
  0xffffffff80007ffe, 0x333333323333b331,
  0xffffffff80007ffd, 0x333333323333b330,
  0xffffffff80007ffc, 0x33333332333333b3,
  0xffffffff8000007f, 0x33333332333333b2,
  0xffffffff8000007e, 0x33333332333333b1,
  0xffffffff8000007d, 0x33333332333333b0,
  0xffffffff8000007c, 0x3333333233333353,
  0xffffffff8000001f, 0x3333333233333336,
  0x3333333233333336, 0x5555555455555557,
  0x3333333233333335, 0x5555555455555556,
  0x3333333233333334, 0x5555555555555555,
  0x3333333333333333, 0x5555555555555554,
  0x3333333333333332, 0x5555555555555553,
  0x3333333333333331, 0x5555555555555535,
  0x3333333333333313, 0x55555555555554d8,
  0x33333333333332b6, 0x55555555555554d7,
  0x33333333333332b5, 0x55555555555554d6,
  0x33333333333332b4, 0x555555555554d558,
  0x333333333332b336, 0x555555555554d557,
  0x333333333332b335, 0x555555555554d556,
  0x333333333332b334, 0x5555555522222222,
  0x3333333300000000, 0x5555555500000000,
  0x33333332ddddddde, 0x55555554d5555558,
  0x33333332b3333336, 0x55555554d5555557,
  0x33333332b3333335, 0x55555554d5555556,
  0x33333332b3333334, 0x55555554d5555555,
  0x33333332b3333333, 0x55555554d5555554,
  0x33333332b3333332, 0x55555554aaaaaaab,
  0x3333333288888889, 0x5555555488888889,
  0x3333333266666667, 0x555555545555d555,
  0x333333323333b333, 0x555555545555d554,
  0x333333323333b332, 0x555555545555d553,
  0x333333323333b331, 0x555555545555d552,
  0x333333323333b330, 0x55555554555555d5,
  0x33333332333333b3, 0x55555554555555d4,
  0x33333332333333b2, 0x55555554555555d3,
  0x33333332333333b1, 0x55555554555555d2,
  0x33333332333333b0, 0x5555555455555575,
  0x3333333233333353, 0x5555555455555558,
  0x5555555455555558, 0x7ffffffeffffffff,
  0x5555555455555557, 0x7ffffffefffffffe,
  0x5555555455555556, 0x7ffffffffffffffd,
  0x5555555555555555, 0x7ffffffffffffffc,
  0x5555555555555554, 0x7ffffffffffffffb,
  0x5555555555555553, 0x7fffffffffffffdd,
  0x5555555555555535, 0x7fffffffffffff80,
  0x55555555555554d8, 0x7fffffffffffff7f,
  0x55555555555554d7, 0x7fffffffffffff7e,
  0x55555555555554d6, 0x7fffffffffff8000,
  0x555555555554d558, 0x7fffffffffff7fff,
  0x555555555554d557, 0x7fffffffffff7ffe,
  0x555555555554d556, 0x7fffffffccccccca,
  0x5555555522222222, 0x7fffffffaaaaaaa8,
  0x5555555500000000, 0x7fffffff80000000,
  0x55555554d5555558, 0x7fffffff7fffffff,
  0x55555554d5555557, 0x7fffffff7ffffffe,
  0x55555554d5555556, 0x7fffffff7ffffffd,
  0x55555554d5555555, 0x7fffffff7ffffffc,
  0x55555554d5555554, 0x7fffffff55555553,
  0x55555554aaaaaaab, 0x7fffffff33333331,
  0x5555555488888889, 0x7fffffff00007ffd,
  0x555555545555d555, 0x7fffffff00007ffc,
  0x555555545555d554, 0x7fffffff00007ffb,
  0x555555545555d553, 0x7fffffff00007ffa,
  0x555555545555d552, 0x7fffffff0000007d,
  0x55555554555555d5, 0x7fffffff0000007c,
  0x55555554555555d4, 0x7fffffff0000007b,
  0x55555554555555d3, 0x7fffffff0000007a,
  0x55555554555555d2, 0x7fffffff0000001d,
  0x5555555455555575, 0x7fffffff00000000,
  0x7fffffff00000000, 0x7fffffff00000000,
  0x7ffffffeffffffff, 0x7ffffffeffffffff,
  0x7ffffffefffffffe, 0x7ffffffffffffffe,
  0x7ffffffffffffffd, 0x7ffffffffffffffd,
  0x7ffffffffffffffc, 0x7ffffffffffffffc,
  0x7ffffffffffffffb, 0x7fffffffffffffde,
  0x7fffffffffffffdd, 0x7fffffffffffff81,
  0x7fffffffffffff80, 0x7fffffffffffff80,
  0x7fffffffffffff7f, 0x7fffffffffffff7f,
  0x7fffffffffffff7e, 0x7fffffffffff8001,
  0x7fffffffffff8000, 0x7fffffffffff8000,
  0x7fffffffffff7fff, 0x7fffffffffff7fff,
  0x7fffffffffff7ffe, 0x7fffffffcccccccb,
  0x7fffffffccccccca, 0x7fffffffaaaaaaa9,
  0x7fffffffaaaaaaa8, 0x7fffffff80000001,
  0x7fffffff80000000, 0x7fffffff80000000,
  0x7fffffff7fffffff, 0x7fffffff7fffffff,
  0x7fffffff7ffffffe, 0x7fffffff7ffffffe,
  0x7fffffff7ffffffd, 0x7fffffff7ffffffd,
  0x7fffffff7ffffffc, 0x7fffffff55555554,
  0x7fffffff55555553, 0x7fffffff33333332,
  0x7fffffff33333331, 0x7fffffff00007ffe,
  0x7fffffff00007ffd, 0x7fffffff00007ffd,
  0x7fffffff00007ffc, 0x7fffffff00007ffc,
  0x7fffffff00007ffb, 0x7fffffff00007ffb,
  0x7fffffff00007ffa, 0x7fffffff0000007e,
  0x7fffffff0000007d, 0x7fffffff0000007d,
  0x7fffffff0000007c, 0x7fffffff0000007c,
  0x7fffffff0000007b, 0x7fffffff0000007b,
  0x7fffffff0000007a, 0x7fffffff0000001e,
  0x7fffffff0000001d, 0x7fffffff00000001,
  0x7fffffff00000001, 0x7fffffff00000001,
  0x7fffffff00000000, 0x7fffffff00000000,
  0x7ffffffeffffffff, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0x7ffffffffffffffe,
  0x7ffffffffffffffd, 0x7ffffffffffffffd,
  0x7ffffffffffffffc, 0x7fffffffffffffdf,
  0x7fffffffffffffde, 0x7fffffffffffff82,
  0x7fffffffffffff81, 0x7fffffffffffff81,
  0x7fffffffffffff80, 0x7fffffffffffff80,
  0x7fffffffffffff7f, 0x7fffffffffff8002,
  0x7fffffffffff8001, 0x7fffffffffff8001,
  0x7fffffffffff8000, 0x7fffffffffff8000,
  0x7fffffffffff7fff, 0x7fffffffcccccccc,
  0x7fffffffcccccccb, 0x7fffffffaaaaaaaa,
  0x7fffffffaaaaaaa9, 0x7fffffff80000002,
  0x7fffffff80000001, 0x7fffffff80000001,
  0x7fffffff80000000, 0x7fffffff80000000,
  0x7fffffff7fffffff, 0x7fffffff7fffffff,
  0x7fffffff7ffffffe, 0x7fffffff7ffffffe,
  0x7fffffff7ffffffd, 0x7fffffff55555555,
  0x7fffffff55555554, 0x7fffffff33333333,
  0x7fffffff33333332, 0x7fffffff00007fff,
  0x7fffffff00007ffe, 0x7fffffff00007ffe,
  0x7fffffff00007ffd, 0x7fffffff00007ffd,
  0x7fffffff00007ffc, 0x7fffffff00007ffc,
  0x7fffffff00007ffb, 0x7fffffff0000007f,
  0x7fffffff0000007e, 0x7fffffff0000007e,
  0x7fffffff0000007d, 0x7fffffff0000007d,
  0x7fffffff0000007c, 0x7fffffff0000007c,
  0x7fffffff0000007b, 0x7fffffff0000001f,
  0x7fffffff0000001e, 0x7fffffff00000002,
  0x7fffffff00000002, 0x7fffffff00000002,
  0x7fffffff00000001, 0x7fffffff00000001,
  0x7fffffff00000000, 0x8000000000000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0x7ffffffffffffffe,
  0x7ffffffffffffffd, 0x7fffffffffffffe0,
  0x7fffffffffffffdf, 0x7fffffffffffff83,
  0x7fffffffffffff82, 0x7fffffffffffff82,
  0x7fffffffffffff81, 0x7fffffffffffff81,
  0x7fffffffffffff80, 0x7fffffffffff8003,
  0x7fffffffffff8002, 0x7fffffffffff8002,
  0x7fffffffffff8001, 0x7fffffffffff8001,
  0x7fffffffffff8000, 0x7fffffffcccccccd,
  0x7fffffffcccccccc, 0x7fffffffaaaaaaab,
  0x7fffffffaaaaaaaa, 0x7fffffff80000003,
  0x7fffffff80000002, 0x7fffffff80000002,
  0x7fffffff80000001, 0x7fffffff80000001,
  0x7fffffff80000000, 0x7fffffff80000000,
  0x7fffffff7fffffff, 0x7fffffff7fffffff,
  0x7fffffff7ffffffe, 0x7fffffff55555556,
  0x7fffffff55555555, 0x7fffffff33333334,
  0x7fffffff33333333, 0x7fffffff00008000,
  0x7fffffff00007fff, 0x7fffffff00007fff,
  0x7fffffff00007ffe, 0x7fffffff00007ffe,
  0x7fffffff00007ffd, 0x7fffffff00007ffd,
  0x7fffffff00007ffc, 0x7fffffff00000080,
  0x7fffffff0000007f, 0x7fffffff0000007f,
  0x7fffffff0000007e, 0x7fffffff0000007e,
  0x7fffffff0000007d, 0x7fffffff0000007d,
  0x7fffffff0000007c, 0x7fffffff00000020,
  0x7fffffff0000001f, 0x7fffffff00000003,
  0x7fffffff00000003, 0x7fffffff00000003,
  0x7fffffff00000002, 0x7fffffff00000002,
  0x7fffffff00000001, 0x8000000000000001,
  0x8000000000000000, 0x8000000000000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0x7fffffffffffffe1,
  0x7fffffffffffffe0, 0x7fffffffffffff84,
  0x7fffffffffffff83, 0x7fffffffffffff83,
  0x7fffffffffffff82, 0x7fffffffffffff82,
  0x7fffffffffffff81, 0x7fffffffffff8004,
  0x7fffffffffff8003, 0x7fffffffffff8003,
  0x7fffffffffff8002, 0x7fffffffffff8002,
  0x7fffffffffff8001, 0x7fffffffccccccce,
  0x7fffffffcccccccd, 0x7fffffffaaaaaaac,
  0x7fffffffaaaaaaab, 0x7fffffff80000004,
  0x7fffffff80000003, 0x7fffffff80000003,
  0x7fffffff80000002, 0x7fffffff80000002,
  0x7fffffff80000001, 0x7fffffff80000001,
  0x7fffffff80000000, 0x7fffffff80000000,
  0x7fffffff7fffffff, 0x7fffffff55555557,
  0x7fffffff55555556, 0x7fffffff33333335,
  0x7fffffff33333334, 0x7fffffff00008001,
  0x7fffffff00008000, 0x7fffffff00008000,
  0x7fffffff00007fff, 0x7fffffff00007fff,
  0x7fffffff00007ffe, 0x7fffffff00007ffe,
  0x7fffffff00007ffd, 0x7fffffff00000081,
  0x7fffffff00000080, 0x7fffffff00000080,
  0x7fffffff0000007f, 0x7fffffff0000007f,
  0x7fffffff0000007e, 0x7fffffff0000007e,
  0x7fffffff0000007d, 0x7fffffff00000021,
  0x7fffffff00000020, 0x7fffffff00000004,
  0x7fffffff00000004, 0x7fffffff00000004,
  0x7fffffff00000003, 0x7fffffff00000003,
  0x7fffffff00000002, 0x8000000000000002,
  0x8000000000000001, 0x8000000000000001,
  0x8000000000000000, 0x8000000000000000,
  0x7fffffffffffffff, 0x7fffffffffffffe2,
  0x7fffffffffffffe1, 0x7fffffffffffff85,
  0x7fffffffffffff84, 0x7fffffffffffff84,
  0x7fffffffffffff83, 0x7fffffffffffff83,
  0x7fffffffffffff82, 0x7fffffffffff8005,
  0x7fffffffffff8004, 0x7fffffffffff8004,
  0x7fffffffffff8003, 0x7fffffffffff8003,
  0x7fffffffffff8002, 0x7fffffffcccccccf,
  0x7fffffffccccccce, 0x7fffffffaaaaaaad,
  0x7fffffffaaaaaaac, 0x7fffffff80000005,
  0x7fffffff80000004, 0x7fffffff80000004,
  0x7fffffff80000003, 0x7fffffff80000003,
  0x7fffffff80000002, 0x7fffffff80000002,
  0x7fffffff80000001, 0x7fffffff80000001,
  0x7fffffff80000000, 0x7fffffff55555558,
  0x7fffffff55555557, 0x7fffffff33333336,
  0x7fffffff33333335, 0x7fffffff00008002,
  0x7fffffff00008001, 0x7fffffff00008001,
  0x7fffffff00008000, 0x7fffffff00008000,
  0x7fffffff00007fff, 0x7fffffff00007fff,
  0x7fffffff00007ffe, 0x7fffffff00000082,
  0x7fffffff00000081, 0x7fffffff00000081,
  0x7fffffff00000080, 0x7fffffff00000080,
  0x7fffffff0000007f, 0x7fffffff0000007f,
  0x7fffffff0000007e, 0x7fffffff00000022,
  0x7fffffff00000021, 0x7fffffff00000005,
  0x7fffffff00000005, 0x7fffffff00000005,
  0x7fffffff00000004, 0x7fffffff00000004,
  0x7fffffff00000003, 0x8000000000000003,
  0x8000000000000002, 0x8000000000000002,
  0x8000000000000001, 0x8000000000000001,
  0x8000000000000000, 0x7fffffffffffffe3,
  0x7fffffffffffffe2, 0x7fffffffffffff86,
  0x7fffffffffffff85, 0x7fffffffffffff85,
  0x7fffffffffffff84, 0x7fffffffffffff84,
  0x7fffffffffffff83, 0x7fffffffffff8006,
  0x7fffffffffff8005, 0x7fffffffffff8005,
  0x7fffffffffff8004, 0x7fffffffffff8004,
  0x7fffffffffff8003, 0x7fffffffccccccd0,
  0x7fffffffcccccccf, 0x7fffffffaaaaaaae,
  0x7fffffffaaaaaaad, 0x7fffffff80000006,
  0x7fffffff80000005, 0x7fffffff80000005,
  0x7fffffff80000004, 0x7fffffff80000004,
  0x7fffffff80000003, 0x7fffffff80000003,
  0x7fffffff80000002, 0x7fffffff80000002,
  0x7fffffff80000001, 0x7fffffff55555559,
  0x7fffffff55555558, 0x7fffffff33333337,
  0x7fffffff33333336, 0x7fffffff00008003,
  0x7fffffff00008002, 0x7fffffff00008002,
  0x7fffffff00008001, 0x7fffffff00008001,
  0x7fffffff00008000, 0x7fffffff00008000,
  0x7fffffff00007fff, 0x7fffffff00000083,
  0x7fffffff00000082, 0x7fffffff00000082,
  0x7fffffff00000081, 0x7fffffff00000081,
  0x7fffffff00000080, 0x7fffffff00000080,
  0x7fffffff0000007f, 0x7fffffff00000023,
  0x7fffffff00000022, 0x7fffffff00000006,
  0x7fffffff00000006, 0xaaaaaaa9aaaaaaac,
  0x7fffffff00000005, 0xaaaaaaa9aaaaaaab,
  0x7fffffff00000004, 0xaaaaaaaaaaaaaaaa,
  0x8000000000000003, 0xaaaaaaaaaaaaaaa9,
  0x8000000000000002, 0xaaaaaaaaaaaaaaa8,
  0x8000000000000001, 0xaaaaaaaaaaaaaa8a,
  0x7fffffffffffffe3, 0xaaaaaaaaaaaaaa2d,
  0x7fffffffffffff86, 0xaaaaaaaaaaaaaa2c,
  0x7fffffffffffff85, 0xaaaaaaaaaaaaaa2b,
  0x7fffffffffffff84, 0xaaaaaaaaaaaa2aad,
  0x7fffffffffff8006, 0xaaaaaaaaaaaa2aac,
  0x7fffffffffff8005, 0xaaaaaaaaaaaa2aab,
  0x7fffffffffff8004, 0xaaaaaaaa77777777,
  0x7fffffffccccccd0, 0xaaaaaaaa55555555,
  0x7fffffffaaaaaaae, 0xaaaaaaaa2aaaaaad,
  0x7fffffff80000006, 0xaaaaaaaa2aaaaaac,
  0x7fffffff80000005, 0xaaaaaaaa2aaaaaab,
  0x7fffffff80000004, 0xaaaaaaaa2aaaaaaa,
  0x7fffffff80000003, 0xaaaaaaaa2aaaaaa9,
  0x7fffffff80000002, 0xaaaaaaaa00000000,
  0x7fffffff55555559, 0xaaaaaaa9ddddddde,
  0x7fffffff33333337, 0xaaaaaaa9aaab2aaa,
  0x7fffffff00008003, 0xaaaaaaa9aaab2aa9,
  0x7fffffff00008002, 0xaaaaaaa9aaab2aa8,
  0x7fffffff00008001, 0xaaaaaaa9aaab2aa7,
  0x7fffffff00008000, 0xaaaaaaa9aaaaab2a,
  0x7fffffff00000083, 0xaaaaaaa9aaaaab29,
  0x7fffffff00000082, 0xaaaaaaa9aaaaab28,
  0x7fffffff00000081, 0xaaaaaaa9aaaaab27,
  0x7fffffff00000080, 0xaaaaaaa9aaaaaaca,
  0x7fffffff00000023, 0xaaaaaaa9aaaaaaad,
  0xaaaaaaa9aaaaaaad, 0xcccccccbccccccce,
  0xaaaaaaa9aaaaaaac, 0xcccccccbcccccccd,
  0xaaaaaaa9aaaaaaab, 0xcccccccccccccccc,
  0xaaaaaaaaaaaaaaaa, 0xcccccccccccccccb,
  0xaaaaaaaaaaaaaaa9, 0xccccccccccccccca,
  0xaaaaaaaaaaaaaaa8, 0xccccccccccccccac,
  0xaaaaaaaaaaaaaa8a, 0xcccccccccccccc4f,
  0xaaaaaaaaaaaaaa2d, 0xcccccccccccccc4e,
  0xaaaaaaaaaaaaaa2c, 0xcccccccccccccc4d,
  0xaaaaaaaaaaaaaa2b, 0xcccccccccccc4ccf,
  0xaaaaaaaaaaaa2aad, 0xcccccccccccc4cce,
  0xaaaaaaaaaaaa2aac, 0xcccccccccccc4ccd,
  0xaaaaaaaaaaaa2aab, 0xcccccccc99999999,
  0xaaaaaaaa77777777, 0xcccccccc77777777,
  0xaaaaaaaa55555555, 0xcccccccc4ccccccf,
  0xaaaaaaaa2aaaaaad, 0xcccccccc4cccccce,
  0xaaaaaaaa2aaaaaac, 0xcccccccc4ccccccd,
  0xaaaaaaaa2aaaaaab, 0xcccccccc4ccccccc,
  0xaaaaaaaa2aaaaaaa, 0xcccccccc4ccccccb,
  0xaaaaaaaa2aaaaaa9, 0xcccccccc22222222,
  0xaaaaaaaa00000000, 0xcccccccc00000000,
  0xaaaaaaa9ddddddde, 0xcccccccbcccd4ccc,
  0xaaaaaaa9aaab2aaa, 0xcccccccbcccd4ccb,
  0xaaaaaaa9aaab2aa9, 0xcccccccbcccd4cca,
  0xaaaaaaa9aaab2aa8, 0xcccccccbcccd4cc9,
  0xaaaaaaa9aaab2aa7, 0xcccccccbcccccd4c,
  0xaaaaaaa9aaaaab2a, 0xcccccccbcccccd4b,
  0xaaaaaaa9aaaaab29, 0xcccccccbcccccd4a,
  0xaaaaaaa9aaaaab28, 0xcccccccbcccccd49,
  0xaaaaaaa9aaaaab27, 0xcccccccbccccccec,
  0xaaaaaaa9aaaaaaca, 0xcccccccbcccccccf,
  0xcccccccbcccccccf, 0xfffffffe80000002,
  0xcccccccbccccccce, 0xfffffffe80000001,
  0xcccccccbcccccccd, 0xffffffff80000000,
  0xcccccccccccccccc, 0xffffffff7fffffff,
  0xcccccccccccccccb, 0xffffffff7ffffffe,
  0xccccccccccccccca, 0xffffffff7fffffe0,
  0xccccccccccccccac, 0xffffffff7fffff83,
  0xcccccccccccccc4f, 0xffffffff7fffff82,
  0xcccccccccccccc4e, 0xffffffff7fffff81,
  0xcccccccccccccc4d, 0xffffffff7fff8003,
  0xcccccccccccc4ccf, 0xffffffff7fff8002,
  0xcccccccccccc4cce, 0xffffffff7fff8001,
  0xcccccccccccc4ccd, 0xffffffff4ccccccd,
  0xcccccccc99999999, 0xffffffff2aaaaaab,
  0xcccccccc77777777, 0xffffffff00000003,
  0xcccccccc4ccccccf, 0xffffffff00000002,
  0xcccccccc4cccccce, 0xffffffff00000001,
  0xcccccccc4ccccccd, 0xffffffff00000000,
  0xcccccccc4ccccccc, 0xfffffffeffffffff,
  0xcccccccc4ccccccb, 0xfffffffed5555556,
  0xcccccccc22222222, 0xfffffffeb3333334,
  0xcccccccc00000000, 0xfffffffe80008000,
  0xcccccccbcccd4ccc, 0xfffffffe80007fff,
  0xcccccccbcccd4ccb, 0xfffffffe80007ffe,
  0xcccccccbcccd4cca, 0xfffffffe80007ffd,
  0xcccccccbcccd4cc9, 0xfffffffe80000080,
  0xcccccccbcccccd4c, 0xfffffffe8000007f,
  0xcccccccbcccccd4b, 0xfffffffe8000007e,
  0xcccccccbcccccd4a, 0xfffffffe8000007d,
  0xcccccccbcccccd49, 0xfffffffe80000020,
  0xcccccccbccccccec, 0xfffffffe80000003,
  0xfffffffe80000003, 0xfffffffe80000003,
  0xfffffffe80000002, 0xfffffffe80000002,
  0xfffffffe80000001, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000000,
  0xffffffff7fffffff, 0xffffffff7fffffff,
  0xffffffff7ffffffe, 0xffffffff7fffffe1,
  0xffffffff7fffffe0, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fffff82,
  0xffffffff7fffff81, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff7fff8002,
  0xffffffff7fff8001, 0xffffffff4cccccce,
  0xffffffff4ccccccd, 0xffffffff2aaaaaac,
  0xffffffff2aaaaaab, 0xffffffff00000004,
  0xffffffff00000003, 0xffffffff00000003,
  0xffffffff00000002, 0xffffffff00000002,
  0xffffffff00000001, 0xffffffff00000001,
  0xffffffff00000000, 0xffffffff00000000,
  0xfffffffeffffffff, 0xfffffffed5555557,
  0xfffffffed5555556, 0xfffffffeb3333335,
  0xfffffffeb3333334, 0xfffffffe80008001,
  0xfffffffe80008000, 0xfffffffe80008000,
  0xfffffffe80007fff, 0xfffffffe80007fff,
  0xfffffffe80007ffe, 0xfffffffe80007ffe,
  0xfffffffe80007ffd, 0xfffffffe80000081,
  0xfffffffe80000080, 0xfffffffe80000080,
  0xfffffffe8000007f, 0xfffffffe8000007f,
  0xfffffffe8000007e, 0xfffffffe8000007e,
  0xfffffffe8000007d, 0xfffffffe80000021,
  0xfffffffe80000020, 0xfffffffe80000004,
  0xfffffffe80000004, 0xfffffffe80000004,
  0xfffffffe80000003, 0xfffffffe80000003,
  0xfffffffe80000002, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000000,
  0xffffffff7fffffff, 0xffffffff7fffffe2,
  0xffffffff7fffffe1, 0xffffffff7fffff85,
  0xffffffff7fffff84, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fff8005,
  0xffffffff7fff8004, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff4ccccccf,
  0xffffffff4cccccce, 0xffffffff2aaaaaad,
  0xffffffff2aaaaaac, 0xffffffff00000005,
  0xffffffff00000004, 0xffffffff00000004,
  0xffffffff00000003, 0xffffffff00000003,
  0xffffffff00000002, 0xffffffff00000002,
  0xffffffff00000001, 0xffffffff00000001,
  0xffffffff00000000, 0xfffffffed5555558,
  0xfffffffed5555557, 0xfffffffeb3333336,
  0xfffffffeb3333335, 0xfffffffe80008002,
  0xfffffffe80008001, 0xfffffffe80008001,
  0xfffffffe80008000, 0xfffffffe80008000,
  0xfffffffe80007fff, 0xfffffffe80007fff,
  0xfffffffe80007ffe, 0xfffffffe80000082,
  0xfffffffe80000081, 0xfffffffe80000081,
  0xfffffffe80000080, 0xfffffffe80000080,
  0xfffffffe8000007f, 0xfffffffe8000007f,
  0xfffffffe8000007e, 0xfffffffe80000022,
  0xfffffffe80000021, 0xfffffffe80000005,
  0xfffffffe80000005, 0xfffffffe80000005,
  0xfffffffe80000004, 0xfffffffe80000004,
  0xfffffffe80000003, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff7fffffe3,
  0xffffffff7fffffe2, 0xffffffff7fffff86,
  0xffffffff7fffff85, 0xffffffff7fffff85,
  0xffffffff7fffff84, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fff8006,
  0xffffffff7fff8005, 0xffffffff7fff8005,
  0xffffffff7fff8004, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff4cccccd0,
  0xffffffff4ccccccf, 0xffffffff2aaaaaae,
  0xffffffff2aaaaaad, 0xffffffff00000006,
  0xffffffff00000005, 0xffffffff00000005,
  0xffffffff00000004, 0xffffffff00000004,
  0xffffffff00000003, 0xffffffff00000003,
  0xffffffff00000002, 0xffffffff00000002,
  0xffffffff00000001, 0xfffffffed5555559,
  0xfffffffed5555558, 0xfffffffeb3333337,
  0xfffffffeb3333336, 0xfffffffe80008003,
  0xfffffffe80008002, 0xfffffffe80008002,
  0xfffffffe80008001, 0xfffffffe80008001,
  0xfffffffe80008000, 0xfffffffe80008000,
  0xfffffffe80007fff, 0xfffffffe80000083,
  0xfffffffe80000082, 0xfffffffe80000082,
  0xfffffffe80000081, 0xfffffffe80000081,
  0xfffffffe80000080, 0xfffffffe80000080,
  0xfffffffe8000007f, 0xfffffffe80000023,
  0xfffffffe80000022, 0xfffffffe80000006,
  0xfffffffe80000006, 0xfffffffeffff8002,
  0xfffffffe80000005, 0xfffffffeffff8001,
  0xfffffffe80000004, 0xffffffffffff8000,
  0xffffffff80000003, 0xffffffffffff7fff,
  0xffffffff80000002, 0xffffffffffff7ffe,
  0xffffffff80000001, 0xffffffffffff7fe0,
  0xffffffff7fffffe3, 0xffffffffffff7f83,
  0xffffffff7fffff86, 0xffffffffffff7f82,
  0xffffffff7fffff85, 0xffffffffffff7f81,
  0xffffffff7fffff84, 0xffffffffffff0003,
  0xffffffff7fff8006, 0xffffffffffff0002,
  0xffffffff7fff8005, 0xffffffffffff0001,
  0xffffffff7fff8004, 0xffffffffcccc4ccd,
  0xffffffff4cccccd0, 0xffffffffaaaa2aab,
  0xffffffff2aaaaaae, 0xffffffff7fff8003,
  0xffffffff00000006, 0xffffffff7fff8002,
  0xffffffff00000005, 0xffffffff7fff8001,
  0xffffffff00000004, 0xffffffff7fff8000,
  0xffffffff00000003, 0xffffffff7fff7fff,
  0xffffffff00000002, 0xffffffff5554d556,
  0xfffffffed5555559, 0xffffffff3332b334,
  0xfffffffeb3333337, 0xffffffff00000000,
  0xfffffffe80008003, 0xfffffffeffffffff,
  0xfffffffe80008002, 0xfffffffefffffffe,
  0xfffffffe80008001, 0xfffffffefffffffd,
  0xfffffffe80008000, 0xfffffffeffff8080,
  0xfffffffe80000083, 0xfffffffeffff807f,
  0xfffffffe80000082, 0xfffffffeffff807e,
  0xfffffffe80000081, 0xfffffffeffff807d,
  0xfffffffe80000080, 0xfffffffeffff8020,
  0xfffffffe80000023, 0xfffffffeffff8003,
  0xfffffffeffff8003, 0xfffffffeffff8003,
  0xfffffffeffff8002, 0xfffffffeffff8002,
  0xfffffffeffff8001, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff7fff, 0xffffffffffff7fff,
  0xffffffffffff7ffe, 0xffffffffffff7fe1,
  0xffffffffffff7fe0, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f82,
  0xffffffffffff7f81, 0xffffffffffff0004,
  0xffffffffffff0003, 0xffffffffffff0003,
  0xffffffffffff0002, 0xffffffffffff0002,
  0xffffffffffff0001, 0xffffffffcccc4cce,
  0xffffffffcccc4ccd, 0xffffffffaaaa2aac,
  0xffffffffaaaa2aab, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff7fff8002,
  0xffffffff7fff8001, 0xffffffff7fff8001,
  0xffffffff7fff8000, 0xffffffff7fff8000,
  0xffffffff7fff7fff, 0xffffffff5554d557,
  0xffffffff5554d556, 0xffffffff3332b335,
  0xffffffff3332b334, 0xffffffff00000001,
  0xffffffff00000000, 0xffffffff00000000,
  0xfffffffeffffffff, 0xfffffffeffffffff,
  0xfffffffefffffffe, 0xfffffffefffffffe,
  0xfffffffefffffffd, 0xfffffffeffff8081,
  0xfffffffeffff8080, 0xfffffffeffff8080,
  0xfffffffeffff807f, 0xfffffffeffff807f,
  0xfffffffeffff807e, 0xfffffffeffff807e,
  0xfffffffeffff807d, 0xfffffffeffff8021,
  0xfffffffeffff8020, 0xfffffffeffff8004,
  0xfffffffeffff8004, 0xfffffffeffff8004,
  0xfffffffeffff8003, 0xfffffffeffff8003,
  0xfffffffeffff8002, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff7fff, 0xffffffffffff7fe2,
  0xffffffffffff7fe1, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff0005,
  0xffffffffffff0004, 0xffffffffffff0004,
  0xffffffffffff0003, 0xffffffffffff0003,
  0xffffffffffff0002, 0xffffffffcccc4ccf,
  0xffffffffcccc4cce, 0xffffffffaaaa2aad,
  0xffffffffaaaa2aac, 0xffffffff7fff8005,
  0xffffffff7fff8004, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff7fff8002,
  0xffffffff7fff8001, 0xffffffff7fff8001,
  0xffffffff7fff8000, 0xffffffff5554d558,
  0xffffffff5554d557, 0xffffffff3332b336,
  0xffffffff3332b335, 0xffffffff00000002,
  0xffffffff00000001, 0xffffffff00000001,
  0xffffffff00000000, 0xffffffff00000000,
  0xfffffffeffffffff, 0xfffffffeffffffff,
  0xfffffffefffffffe, 0xfffffffeffff8082,
  0xfffffffeffff8081, 0xfffffffeffff8081,
  0xfffffffeffff8080, 0xfffffffeffff8080,
  0xfffffffeffff807f, 0xfffffffeffff807f,
  0xfffffffeffff807e, 0xfffffffeffff8022,
  0xfffffffeffff8021, 0xfffffffeffff8005,
  0xfffffffeffff8005, 0xfffffffeffff8005,
  0xfffffffeffff8004, 0xfffffffeffff8004,
  0xfffffffeffff8003, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff7fe3,
  0xffffffffffff7fe2, 0xffffffffffff7f86,
  0xffffffffffff7f85, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff0006,
  0xffffffffffff0005, 0xffffffffffff0005,
  0xffffffffffff0004, 0xffffffffffff0004,
  0xffffffffffff0003, 0xffffffffcccc4cd0,
  0xffffffffcccc4ccf, 0xffffffffaaaa2aae,
  0xffffffffaaaa2aad, 0xffffffff7fff8006,
  0xffffffff7fff8005, 0xffffffff7fff8005,
  0xffffffff7fff8004, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff7fff8002,
  0xffffffff7fff8001, 0xffffffff5554d559,
  0xffffffff5554d558, 0xffffffff3332b337,
  0xffffffff3332b336, 0xffffffff00000003,
  0xffffffff00000002, 0xffffffff00000002,
  0xffffffff00000001, 0xffffffff00000001,
  0xffffffff00000000, 0xffffffff00000000,
  0xfffffffeffffffff, 0xfffffffeffff8083,
  0xfffffffeffff8082, 0xfffffffeffff8082,
  0xfffffffeffff8081, 0xfffffffeffff8081,
  0xfffffffeffff8080, 0xfffffffeffff8080,
  0xfffffffeffff807f, 0xfffffffeffff8023,
  0xfffffffeffff8022, 0xfffffffeffff8006,
  0xfffffffeffff8006, 0xfffffffeffffff82,
  0xfffffffeffff8005, 0xfffffffeffffff81,
  0xfffffffeffff8004, 0xffffffffffffff80,
  0xffffffffffff8003, 0xffffffffffffff7f,
  0xffffffffffff8002, 0xffffffffffffff7e,
  0xffffffffffff8001, 0xffffffffffffff60,
  0xffffffffffff7fe3, 0xffffffffffffff03,
  0xffffffffffff7f86, 0xffffffffffffff02,
  0xffffffffffff7f85, 0xffffffffffffff01,
  0xffffffffffff7f84, 0xffffffffffff7f83,
  0xffffffffffff0006, 0xffffffffffff7f82,
  0xffffffffffff0005, 0xffffffffffff7f81,
  0xffffffffffff0004, 0xffffffffcccccc4d,
  0xffffffffcccc4cd0, 0xffffffffaaaaaa2b,
  0xffffffffaaaa2aae, 0xffffffff7fffff83,
  0xffffffff7fff8006, 0xffffffff7fffff82,
  0xffffffff7fff8005, 0xffffffff7fffff81,
  0xffffffff7fff8004, 0xffffffff7fffff80,
  0xffffffff7fff8003, 0xffffffff7fffff7f,
  0xffffffff7fff8002, 0xffffffff555554d6,
  0xffffffff5554d559, 0xffffffff333332b4,
  0xffffffff3332b337, 0xffffffff00007f80,
  0xffffffff00000003, 0xffffffff00007f7f,
  0xffffffff00000002, 0xffffffff00007f7e,
  0xffffffff00000001, 0xffffffff00007f7d,
  0xffffffff00000000, 0xffffffff00000000,
  0xfffffffeffff8083, 0xfffffffeffffffff,
  0xfffffffeffff8082, 0xfffffffefffffffe,
  0xfffffffeffff8081, 0xfffffffefffffffd,
  0xfffffffeffff8080, 0xfffffffeffffffa0,
  0xfffffffeffff8023, 0xfffffffeffffff83,
  0xfffffffeffffff83, 0xfffffffeffffff83,
  0xfffffffeffffff82, 0xfffffffeffffff82,
  0xfffffffeffffff81, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff7f, 0xffffffffffffff7f,
  0xffffffffffffff7e, 0xffffffffffffff61,
  0xffffffffffffff60, 0xffffffffffffff04,
  0xffffffffffffff03, 0xffffffffffffff03,
  0xffffffffffffff02, 0xffffffffffffff02,
  0xffffffffffffff01, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f82,
  0xffffffffffff7f81, 0xffffffffcccccc4e,
  0xffffffffcccccc4d, 0xffffffffaaaaaa2c,
  0xffffffffaaaaaa2b, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fffff82,
  0xffffffff7fffff81, 0xffffffff7fffff81,
  0xffffffff7fffff80, 0xffffffff7fffff80,
  0xffffffff7fffff7f, 0xffffffff555554d7,
  0xffffffff555554d6, 0xffffffff333332b5,
  0xffffffff333332b4, 0xffffffff00007f81,
  0xffffffff00007f80, 0xffffffff00007f80,
  0xffffffff00007f7f, 0xffffffff00007f7f,
  0xffffffff00007f7e, 0xffffffff00007f7e,
  0xffffffff00007f7d, 0xffffffff00000001,
  0xffffffff00000000, 0xffffffff00000000,
  0xfffffffeffffffff, 0xfffffffeffffffff,
  0xfffffffefffffffe, 0xfffffffefffffffe,
  0xfffffffefffffffd, 0xfffffffeffffffa1,
  0xfffffffeffffffa0, 0xfffffffeffffff84,
  0xfffffffeffffff84, 0xfffffffeffffff84,
  0xfffffffeffffff83, 0xfffffffeffffff83,
  0xfffffffeffffff82, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff7f, 0xffffffffffffff62,
  0xffffffffffffff61, 0xffffffffffffff05,
  0xffffffffffffff04, 0xffffffffffffff04,
  0xffffffffffffff03, 0xffffffffffffff03,
  0xffffffffffffff02, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffcccccc4f,
  0xffffffffcccccc4e, 0xffffffffaaaaaa2d,
  0xffffffffaaaaaa2c, 0xffffffff7fffff85,
  0xffffffff7fffff84, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fffff82,
  0xffffffff7fffff81, 0xffffffff7fffff81,
  0xffffffff7fffff80, 0xffffffff555554d8,
  0xffffffff555554d7, 0xffffffff333332b6,
  0xffffffff333332b5, 0xffffffff00007f82,
  0xffffffff00007f81, 0xffffffff00007f81,
  0xffffffff00007f80, 0xffffffff00007f80,
  0xffffffff00007f7f, 0xffffffff00007f7f,
  0xffffffff00007f7e, 0xffffffff00000002,
  0xffffffff00000001, 0xffffffff00000001,
  0xffffffff00000000, 0xffffffff00000000,
  0xfffffffeffffffff, 0xfffffffeffffffff,
  0xfffffffefffffffe, 0xfffffffeffffffa2,
  0xfffffffeffffffa1, 0xfffffffeffffff85,
  0xfffffffeffffff85, 0xfffffffeffffff85,
  0xfffffffeffffff84, 0xfffffffeffffff84,
  0xfffffffeffffff83, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff63,
  0xffffffffffffff62, 0xffffffffffffff06,
  0xffffffffffffff05, 0xffffffffffffff05,
  0xffffffffffffff04, 0xffffffffffffff04,
  0xffffffffffffff03, 0xffffffffffff7f86,
  0xffffffffffff7f85, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffcccccc50,
  0xffffffffcccccc4f, 0xffffffffaaaaaa2e,
  0xffffffffaaaaaa2d, 0xffffffff7fffff86,
  0xffffffff7fffff85, 0xffffffff7fffff85,
  0xffffffff7fffff84, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fffff82,
  0xffffffff7fffff81, 0xffffffff555554d9,
  0xffffffff555554d8, 0xffffffff333332b7,
  0xffffffff333332b6, 0xffffffff00007f83,
  0xffffffff00007f82, 0xffffffff00007f82,
  0xffffffff00007f81, 0xffffffff00007f81,
  0xffffffff00007f80, 0xffffffff00007f80,
  0xffffffff00007f7f, 0xffffffff00000003,
  0xffffffff00000002, 0xffffffff00000002,
  0xffffffff00000001, 0xffffffff00000001,
  0xffffffff00000000, 0xffffffff00000000,
  0xfffffffeffffffff, 0xfffffffeffffffa3,
  0xfffffffeffffffa2, 0xfffffffeffffff86,
  0xfffffffeffffff86, 0xfffffffeffffffc2,
  0xfffffffeffffff85, 0xfffffffeffffffc1,
  0xfffffffeffffff84, 0xffffffffffffffc0,
  0xffffffffffffff83, 0xffffffffffffffbf,
  0xffffffffffffff82, 0xffffffffffffffbe,
  0xffffffffffffff81, 0xffffffffffffffa0,
  0xffffffffffffff63, 0xffffffffffffff43,
  0xffffffffffffff06, 0xffffffffffffff42,
  0xffffffffffffff05, 0xffffffffffffff41,
  0xffffffffffffff04, 0xffffffffffff7fc3,
  0xffffffffffff7f86, 0xffffffffffff7fc2,
  0xffffffffffff7f85, 0xffffffffffff7fc1,
  0xffffffffffff7f84, 0xffffffffcccccc8d,
  0xffffffffcccccc50, 0xffffffffaaaaaa6b,
  0xffffffffaaaaaa2e, 0xffffffff7fffffc3,
  0xffffffff7fffff86, 0xffffffff7fffffc2,
  0xffffffff7fffff85, 0xffffffff7fffffc1,
  0xffffffff7fffff84, 0xffffffff7fffffc0,
  0xffffffff7fffff83, 0xffffffff7fffffbf,
  0xffffffff7fffff82, 0xffffffff55555516,
  0xffffffff555554d9, 0xffffffff333332f4,
  0xffffffff333332b7, 0xffffffff00007fc0,
  0xffffffff00007f83, 0xffffffff00007fbf,
  0xffffffff00007f82, 0xffffffff00007fbe,
  0xffffffff00007f81, 0xffffffff00007fbd,
  0xffffffff00007f80, 0xffffffff00000040,
  0xffffffff00000003, 0xffffffff0000003f,
  0xffffffff00000002, 0xffffffff0000003e,
  0xffffffff00000001, 0xffffffff0000003d,
  0xffffffff00000000, 0xfffffffeffffffe0,
  0xfffffffeffffffa3, 0xfffffffeffffffc3,
  0xfffffffeffffffc3, 0xfffffffeffffffff,
  0xfffffffeffffffc2, 0xfffffffefffffffe,
  0xfffffffeffffffc1, 0xfffffffffffffffd,
  0xffffffffffffffc0, 0xfffffffffffffffc,
  0xffffffffffffffbf, 0xfffffffffffffffb,
  0xffffffffffffffbe, 0xffffffffffffffdd,
  0xffffffffffffffa0, 0xffffffffffffff80,
  0xffffffffffffff43, 0xffffffffffffff7f,
  0xffffffffffffff42, 0xffffffffffffff7e,
  0xffffffffffffff41, 0xffffffffffff8000,
  0xffffffffffff7fc3, 0xffffffffffff7fff,
  0xffffffffffff7fc2, 0xffffffffffff7ffe,
  0xffffffffffff7fc1, 0xffffffffccccccca,
  0xffffffffcccccc8d, 0xffffffffaaaaaaa8,
  0xffffffffaaaaaa6b, 0xffffffff80000000,
  0xffffffff7fffffc3, 0xffffffff7fffffff,
  0xffffffff7fffffc2, 0xffffffff7ffffffe,
  0xffffffff7fffffc1, 0xffffffff7ffffffd,
  0xffffffff7fffffc0, 0xffffffff7ffffffc,
  0xffffffff7fffffbf, 0xffffffff55555553,
  0xffffffff55555516, 0xffffffff33333331,
  0xffffffff333332f4, 0xffffffff00007ffd,
  0xffffffff00007fc0, 0xffffffff00007ffc,
  0xffffffff00007fbf, 0xffffffff00007ffb,
  0xffffffff00007fbe, 0xffffffff00007ffa,
  0xffffffff00007fbd, 0xffffffff0000007d,
  0xffffffff00000040, 0xffffffff0000007c,
  0xffffffff0000003f, 0xffffffff0000007b,
  0xffffffff0000003e, 0xffffffff0000007a,
  0xffffffff0000003d, 0xffffffff0000001d,
  0xfffffffeffffffe0, 0xffffffff00000000,
  0xffffffff00000000, 0xffffffff00000000,
  0xfffffffeffffffff, 0xfffffffeffffffff,
  0xfffffffefffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xfffffffffffffffd,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffffb, 0xffffffffffffffde,
  0xffffffffffffffdd, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff7f, 0xffffffffffffff7f,
  0xffffffffffffff7e, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff7fff, 0xffffffffffff7fff,
  0xffffffffffff7ffe, 0xffffffffcccccccb,
  0xffffffffccccccca, 0xffffffffaaaaaaa9,
  0xffffffffaaaaaaa8, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000000,
  0xffffffff7fffffff, 0xffffffff7fffffff,
  0xffffffff7ffffffe, 0xffffffff7ffffffe,
  0xffffffff7ffffffd, 0xffffffff7ffffffd,
  0xffffffff7ffffffc, 0xffffffff55555554,
  0xffffffff55555553, 0xffffffff33333332,
  0xffffffff33333331, 0xffffffff00007ffe,
  0xffffffff00007ffd, 0xffffffff00007ffd,
  0xffffffff00007ffc, 0xffffffff00007ffc,
  0xffffffff00007ffb, 0xffffffff00007ffb,
  0xffffffff00007ffa, 0xffffffff0000007e,
  0xffffffff0000007d, 0xffffffff0000007d,
  0xffffffff0000007c, 0xffffffff0000007c,
  0xffffffff0000007b, 0xffffffff0000007b,
  0xffffffff0000007a, 0xffffffff0000001e,
  0xffffffff0000001d, 0xffffffff00000001,
  0xffffffff00000001, 0xffffffff00000001,
  0xffffffff00000000, 0xffffffff00000000,
  0xfffffffeffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xfffffffffffffffd,
  0xfffffffffffffffc, 0xffffffffffffffdf,
  0xffffffffffffffde, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff7f, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff7fff, 0xffffffffcccccccc,
  0xffffffffcccccccb, 0xffffffffaaaaaaaa,
  0xffffffffaaaaaaa9, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000000,
  0xffffffff7fffffff, 0xffffffff7fffffff,
  0xffffffff7ffffffe, 0xffffffff7ffffffe,
  0xffffffff7ffffffd, 0xffffffff55555555,
  0xffffffff55555554, 0xffffffff33333333,
  0xffffffff33333332, 0xffffffff00007fff,
  0xffffffff00007ffe, 0xffffffff00007ffe,
  0xffffffff00007ffd, 0xffffffff00007ffd,
  0xffffffff00007ffc, 0xffffffff00007ffc,
  0xffffffff00007ffb, 0xffffffff0000007f,
  0xffffffff0000007e, 0xffffffff0000007e,
  0xffffffff0000007d, 0xffffffff0000007d,
  0xffffffff0000007c, 0xffffffff0000007c,
  0xffffffff0000007b, 0xffffffff0000001f,
  0xffffffff0000001e, 0xffffffff00000002,
};
const unsigned kExpectedCount_NEON_usubw_2D = 1240;

#endif  // VIXL_SIM_USUBW_2D_TRACE_AARCH64_H_
