#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Encodya
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250409.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='encodya'
GAME_NAME='Encodya'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

ARCHIVE_BASE_0_NAME='encodya_1_1_46120.sh'
ARCHIVE_BASE_0_MD5='6fdadc42c828896389de2a9fd3a355fb'
ARCHIVE_BASE_0_SIZE='3300000'
ARCHIVE_BASE_0_VERSION='1.1-gog46120'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/encodya'

## This free demo has been removed from itch.io since the release of the full game.
ARCHIVE_BASE_DEMO_0_NAME='ENCODYA_DemoV1linux.zip'
ARCHIVE_BASE_DEMO_0_MD5='4b3dfbbd37585615791acf13b4bb7ecd'
ARCHIVE_BASE_DEMO_0_SIZE='1100000'
ARCHIVE_BASE_DEMO_0_VERSION='1-itch'

UNITY3D_NAME='ENCODYA'
UNITY3D_NAME_DEMO='ENCODYA_DemoV1'
UNITY3D_PLUGINS='
abci.so
UnityFbxSdkNative.so'
## TODO: Check if the Steam library can be dropped
UNITY3D_PLUGINS="$UNITY3D_PLUGINS
libsteam_api.so"

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_PATH_DEFAULT_DEMO='ENCODYA_DemoV1'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libxml2.so.2
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
