#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Tomb Raider Remastered:
# - Tomb Raider
# - Tomb Raider 2
# - Tomb Raider 3
# send your bug reports to vv221@dotslashplay.it
###

script_version=20251113.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='tomb-raider-remastered-1-2-3'
GAME_NAME='Tomb Raider I-III Remastered'

ARCHIVE_BASE_0_NAME='setup_tomb_raider_i-iii_remastered_1.01_patch_4_(77558).exe'
ARCHIVE_BASE_0_MD5='9172c7570c8c0dfd47c3925aaecf360d'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_tomb_raider_i-iii_remastered_1.01_patch_4_(77558)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='dbcec0aba1dd597efe96bace51e79140'
ARCHIVE_BASE_0_SIZE='6109084'
ARCHIVE_BASE_0_VERSION='1.01-gog77558'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/tomb_raider_i_to_iii_remastered'

CONTENT_PATH_DEFAULT='.'
## The game crashes on launch if any of the following libraries is missing.
CONTENT_LIBS_BIN_FILES='
1/tomb1.dll
2/tomb2.dll
3/tomb3.dll'
CONTENT_GAME_BIN_FILES='
tomb123.exe'
CONTENT_GAME_DATA_FILES='
?/cuts
?/data
?/fmv
?/item
?/pix
?/sfx
?/tex
?/text
?/tracks'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/TRX'

APP_MAIN_EXE='tomb123.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
## Easier upgrades from pre-20251113.1 packages
PKG_DATA_PROVIDES='
tomb-raider-remastered-1-2-3-data-episode-1
tomb-raider-remastered-1-2-3-data-episode-2
tomb-raider-remastered-1-2-3-data-episode-3'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## Install shipped libraries.
wineprefix_init_custom() {
	cat <<- EOF
	# Install shipped libraries.
	PATH_LIBRARIES_SYSTEM='$(path_libraries)'
	EOF
	cat <<- 'EOF'
	find "$PATH_LIBRARIES_SYSTEM" -iname '*.dll' | while read -r dll_source; do
		dll_destination="${PATH_PREFIX}${dll_source#"${PATH_LIBRARIES_SYSTEM}"}"
	    mkdir --parents "$(dirname "$dll_destination")"
	    ln --symbolic "$dll_source" "$dll_destination"
	done
	EOF
}

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
