# Generated by Django 4.2.15 on 2024-12-17 10:57

from django.db import migrations, models
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.migrations.state import StateApps

from debusine.db.models.work_requests import compute_workflow_runtime_status
from debusine.tasks.models import TaskTypes


def update_workflows_runtime_status(
    apps: StateApps, schema_editor: BaseDatabaseSchemaEditor
) -> None:
    """Update workflows workflow_runtime_status field."""
    WorkRequest = apps.get_model('db', 'WorkRequest')

    for work_request in WorkRequest.objects.filter(
        task_type=TaskTypes.WORKFLOW
    ):
        work_request.workflow_runtime_status = compute_workflow_runtime_status(
            work_request
        )
        work_request.save()


class Migration(migrations.Migration):
    dependencies = [
        ('db', '0110_workrequest_workflow_last_activity_at'),
    ]

    operations = [
        migrations.AddField(
            model_name='workrequest',
            name='workflow_runtime_status',
            field=models.CharField(
                blank=True,
                choices=[
                    ('Needs_Input', 'Needs Input'),
                    ('Running', 'Running'),
                    ('Waiting', 'Waiting'),
                    ('Pending', 'Pending'),
                    ('Aborted', 'Aborted'),
                    ('Completed', 'Completed'),
                    ('Blocked', 'Blocked'),
                ],
                editable=False,
                max_length=11,
                null=True,
            ),
        ),
        migrations.RunPython(
            update_workflows_runtime_status, migrations.RunPython.noop
        ),
    ]
