/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpimagesamplepoints_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimpimagesamplepoints
 * @title: gimpimagesamplepoints
 * @short_description: Functions for manipulating an image's sample points.
 *
 * Functions for manipulating an image's sample points.
 **/


/**
 * gimp_image_add_sample_point:
 * @image: The image.
 * @position_x: The sample point's x-offset from left of image.
 * @position_y: The sample point's y-offset from top of image.
 *
 * Add a sample point to an image.
 *
 * This procedure adds a sample point to an image. It takes the input
 * image and the position of the new sample points as parameters. It
 * returns the sample point ID of the new sample point.
 *
 * Returns: The new sample point.
 *
 * Since: 2.10
 **/
guint
gimp_image_add_sample_point (GimpImage *image,
                             gint       position_x,
                             gint       position_y)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  guint sample_point = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_INT, position_x,
                                          G_TYPE_INT, position_y,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-image-add-sample-point",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    sample_point = GIMP_VALUES_GET_UINT (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return sample_point;
}

/**
 * gimp_image_delete_sample_point:
 * @image: The image.
 * @sample_point: The ID of the sample point to be removed.
 *
 * Deletes a sample point from an image.
 *
 * This procedure takes an image and a sample point ID as input and
 * removes the specified sample point from the specified image.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.10
 **/
gboolean
gimp_image_delete_sample_point (GimpImage *image,
                                guint      sample_point)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_UINT, sample_point,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-image-delete-sample-point",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_image_find_next_sample_point:
 * @image: The image.
 * @sample_point: The ID of the current sample point (0 if first invocation).
 *
 * Find next sample point on an image.
 *
 * This procedure takes an image and a sample point ID as input and
 * finds the sample point ID of the successor of the given sample point
 * ID in the image's sample point list. If the supplied sample point ID
 * is 0, the procedure will return the first sample point. The
 * procedure will return 0 if given the final sample point ID as an
 * argument or the image has no sample points.
 *
 * Returns: The next sample point's ID.
 *
 * Since: 2.10
 **/
guint
gimp_image_find_next_sample_point (GimpImage *image,
                                   guint      sample_point)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  guint next_sample_point = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_UINT, sample_point,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-image-find-next-sample-point",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    next_sample_point = GIMP_VALUES_GET_UINT (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return next_sample_point;
}

/**
 * gimp_image_get_sample_point_position:
 * @image: The image.
 * @sample_point: The guide.
 * @position_y: (out): The sample point's y-offset relative to top of image.
 *
 * Get position of a sample point on an image.
 *
 * This procedure takes an image and a sample point ID as input and
 * returns the position of the sample point relative to the top and
 * left of the image.
 *
 * Returns: The sample point's x-offset relative to left of image.
 *
 * Since: 2.10
 **/
gint
gimp_image_get_sample_point_position (GimpImage *image,
                                      guint      sample_point,
                                      gint      *position_y)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint position_x = G_MININT;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_UINT, sample_point,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-image-get-sample-point-position",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    {
      position_x = GIMP_VALUES_GET_INT (return_vals, 1);
      *position_y = GIMP_VALUES_GET_INT (return_vals, 2);
    }

  gimp_value_array_unref (return_vals);

  return position_x;
}
