<?php

namespace Kanboard\Action;

use Kanboard\Model\TaskModel;

/**
 * Assign a task to the logged user on column change if no user is assigned already
 *
 * @package Kanboard\Action
 * @author  Glukose1
 */
class TaskAssignCurrentUserColumnIfNoUserAlreadySet extends Base
{
    /**
     * Get automatic action description
     *
     * @access public
     * @return string
     */
    public function getDescription()
    {
        return t('Assign a task to the logged user on column change to specified column if no user is assigned');
    }

    /**
     * Get the list of compatible events
     *
     * @access public
     * @return array
     */
    public function getCompatibleEvents()
    {
        return array(
            TaskModel::EVENT_MOVE_COLUMN,
        );
    }

    /*** Get the required parameter for the action (defined by the user)
     *
     * @access public
     * @return array
     */
    public function getActionRequiredParameters()
    {
        return array(
            'column_id' => t('Column'),
        );
    }

    /**
     * Get the required parameter for the event
     *
     * @access public
     * @return string[]
     */
    public function getEventRequiredParameters()
    {
        return array(
            'task_id',
            'task' => array(
                'project_id',
                'column_id',
                'owner_id',
            ),
        );
    }

    /**
     * Execute the action
     *
     * @access public
     * @param  array   $data   Event data dictionary
     * @return bool            True if the action was executed or false when not executed
     */
    public function doAction(array $data)
    {
        if (!$this->userSession->isLogged()) {
            return false;
        }

        if (!$data['task']['owner_id']) {
            $values = array(
                'id' => $data['task_id'],
                'owner_id' => $this->userSession->getId(),
            );
            return $this->taskModificationModel->update($values);
        }
        return false;
    }

    /**
     * Check if the event data meet the action condition
     *
     * @access public
     * @param  array   $data   Event data dictionary
     * @return bool
     */
    public function hasRequiredCondition(array $data)
    {
        return $data['task']['column_id'] == $this->getParam('column_id');
    }
}
