/*
 *  The ManaPlus Client
 *  Copyright (C) 2004-2009  The Mana World Development Team
 *  Copyright (C) 2009-2010  The Mana Developers
 *  Copyright (C) 2011-2019  The ManaPlus Developers
 *  Copyright (C) 2019-2021  Andrei Karas
 *
 *  This file is part of The ManaPlus Client.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "gui/widgets/attrs/derdisplay.h"

#include "gui/widgets/containerplacer.h"
#include "gui/widgets/layouthelper.h"

#include "debug.h"

DerDisplay::DerDisplay(const Widget2 *const widget,
                       const AttributesT id,
                       const std::string &restrict name,
                       const std::string &restrict shortName) :
    AttrDisplay(widget, id, name, shortName)
{
    ContainerPlacer place = mLayout->getPlacer(0, 0);

    place(0, 0, mLabel, 3, 1);
    place(3, 0, mValue, 2, 1);
}
