---
layout: documentation
title: Documentation index
---

### Introduction

* [Getting started](getting-started.md)
* [Understanding dependency injection](understanding-di.md)
* [Best practices guide](best-practices.md)

### Usage

* [Configure the container](container-configuration.md)
* [Use the container](container.md)

### Definitions

* [Introduction](definition.md)
* [Autowiring](autowiring.md)
* [PHP definitions](php-definitions.md)
* [Attributes](attributes.md)
* [Definition extensions and overriding](definition-overriding.md)

### Frameworks integration

- [Symfony](frameworks/symfony2.md)
- [Silex](frameworks/silex.md)
- [Zend Framework 1](frameworks/zf1.md)
- [Zend Framework 2](frameworks/zf2.md)
- [Zend Expressive](frameworks/zend-expressive.md)
- [Slim](frameworks/slim.md)
- [Silly](frameworks/silly.md)

### Advanced topics

* [Performances](performances.md)
* [Lazy injection](lazy-injection.md)
* [Inject on an existing instance](inject-on-instance.md)
* [Injections depending on the environment](environments.md)
* [IDE integration](ide-integration.md)

### Migration guides

* [Migration from PHP-DI 3.x to 4.0](migration/4.0.md)
* [Migration from PHP-DI 4.x to 5.0](migration/5.0.md)
* [Migration from PHP-DI 5.x to 6.0](migration/6.0.md)
* [Migration from PHP-DI 6.x to 7.0](migration/7.0.md)

### Internals

* [Contribute](../CONTRIBUTING.md)
* [How PHP-DI works](how-it-works.md)

### License

PHP-DI is released under the MIT license.

This documentation is also embedded in [PHP-DI's git repository](https://github.com/PHP-DI/PHP-DI/tree/master/doc)
so you can read it offline (in the `doc/` folder).
