# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from typing import Any, Callable, Dict, List, Optional, TypeVar

from azure.core import AsyncPipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._utils.serialization import Deserializer, Serializer
from ...operations._virtual_machine_images_operations import (
    build_get_request,
    build_list_by_edge_zone_request,
    build_list_offers_request,
    build_list_publishers_request,
    build_list_request,
    build_list_skus_request,
    build_list_with_properties_request,
)
from .._configuration import ComputeManagementClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class VirtualMachineImagesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.compute.aio.ComputeManagementClient`'s
        :attr:`virtual_machine_images` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: ComputeManagementClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list_by_edge_zone(
        self, location: str, edge_zone: str, **kwargs: Any
    ) -> _models.VmImagesInEdgeZoneListResult:
        """Gets a list of all virtual machine image versions for the specified edge zone.

        :param location: The name of Azure region. Required.
        :type location: str
        :param edge_zone: The name of the edge zone. Required.
        :type edge_zone: str
        :return: VmImagesInEdgeZoneListResult or the result of cls(response)
        :rtype: ~azure.mgmt.compute.models.VmImagesInEdgeZoneListResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-11-01"))
        cls: ClsType[_models.VmImagesInEdgeZoneListResult] = kwargs.pop("cls", None)

        _request = build_list_by_edge_zone_request(
            location=location,
            edge_zone=edge_zone,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("VmImagesInEdgeZoneListResult", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_publishers(self, location: str, **kwargs: Any) -> List[_models.VirtualMachineImageResource]:
        """Gets a list of virtual machine image publishers for the specified Azure location.

        :param location: The name of Azure region. Required.
        :type location: str
        :return: list of VirtualMachineImageResource or the result of cls(response)
        :rtype: list[~azure.mgmt.compute.models.VirtualMachineImageResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-11-01"))
        cls: ClsType[List[_models.VirtualMachineImageResource]] = kwargs.pop("cls", None)

        _request = build_list_publishers_request(
            location=location,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[VirtualMachineImageResource]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_offers(
        self, location: str, publisher_name: str, **kwargs: Any
    ) -> List[_models.VirtualMachineImageResource]:
        """Gets a list of virtual machine image offers for the specified location and publisher.

        :param location: The name of Azure region. Required.
        :type location: str
        :param publisher_name: A valid image publisher. Required.
        :type publisher_name: str
        :return: list of VirtualMachineImageResource or the result of cls(response)
        :rtype: list[~azure.mgmt.compute.models.VirtualMachineImageResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-11-01"))
        cls: ClsType[List[_models.VirtualMachineImageResource]] = kwargs.pop("cls", None)

        _request = build_list_offers_request(
            location=location,
            publisher_name=publisher_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[VirtualMachineImageResource]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_skus(
        self, location: str, publisher_name: str, offer: str, **kwargs: Any
    ) -> List[_models.VirtualMachineImageResource]:
        """Gets a list of virtual machine image SKUs for the specified location, publisher, and offer.

        :param location: The name of Azure region. Required.
        :type location: str
        :param publisher_name: A valid image publisher. Required.
        :type publisher_name: str
        :param offer: A valid image publisher offer. Required.
        :type offer: str
        :return: list of VirtualMachineImageResource or the result of cls(response)
        :rtype: list[~azure.mgmt.compute.models.VirtualMachineImageResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-11-01"))
        cls: ClsType[List[_models.VirtualMachineImageResource]] = kwargs.pop("cls", None)

        _request = build_list_skus_request(
            location=location,
            publisher_name=publisher_name,
            offer=offer,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[VirtualMachineImageResource]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list(
        self,
        location: str,
        publisher_name: str,
        offer: str,
        skus: str,
        expand: Optional[str] = None,
        top: Optional[int] = None,
        orderby: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.VirtualMachineImageResource]:
        """Gets a list of all virtual machine image versions for the specified location, publisher, offer,
        and SKU.

        :param location: The name of Azure region. Required.
        :type location: str
        :param publisher_name: A valid image publisher. Required.
        :type publisher_name: str
        :param offer: A valid image publisher offer. Required.
        :type offer: str
        :param skus: A valid image SKU. Required.
        :type skus: str
        :param expand: The expand expression to apply on the operation. Default value is None.
        :type expand: str
        :param top: Default value is None.
        :type top: int
        :param orderby: Default value is None.
        :type orderby: str
        :return: list of VirtualMachineImageResource or the result of cls(response)
        :rtype: list[~azure.mgmt.compute.models.VirtualMachineImageResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-11-01"))
        cls: ClsType[List[_models.VirtualMachineImageResource]] = kwargs.pop("cls", None)

        _request = build_list_request(
            location=location,
            publisher_name=publisher_name,
            offer=offer,
            skus=skus,
            subscription_id=self._config.subscription_id,
            expand=expand,
            top=top,
            orderby=orderby,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[VirtualMachineImageResource]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get(
        self, location: str, publisher_name: str, offer: str, skus: str, version: str, **kwargs: Any
    ) -> _models.VirtualMachineImage:
        """Gets a virtual machine image.

        :param location: The name of Azure region. Required.
        :type location: str
        :param publisher_name: A valid image publisher. Required.
        :type publisher_name: str
        :param offer: A valid image publisher offer. Required.
        :type offer: str
        :param skus: A valid image SKU. Required.
        :type skus: str
        :param version: A valid image SKU version. Required.
        :type version: str
        :return: VirtualMachineImage or the result of cls(response)
        :rtype: ~azure.mgmt.compute.models.VirtualMachineImage
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-11-01"))
        cls: ClsType[_models.VirtualMachineImage] = kwargs.pop("cls", None)

        _request = build_get_request(
            location=location,
            publisher_name=publisher_name,
            offer=offer,
            skus=skus,
            version=version,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("VirtualMachineImage", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_with_properties(
        self,
        location: str,
        publisher_name: str,
        offer: str,
        skus: str,
        expand: str,
        top: Optional[int] = None,
        orderby: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.VirtualMachineImage]:
        """list_with_properties.

        :param location: The name of Azure region. Required.
        :type location: str
        :param publisher_name: A valid image publisher. Required.
        :type publisher_name: str
        :param offer: A valid image publisher offer. Required.
        :type offer: str
        :param skus: A valid image SKU. Required.
        :type skus: str
        :param expand: The expand expression to apply on the operation. Required.
        :type expand: str
        :param top: Default value is None.
        :type top: int
        :param orderby: Default value is None.
        :type orderby: str
        :return: list of VirtualMachineImage or the result of cls(response)
        :rtype: list[~azure.mgmt.compute.models.VirtualMachineImage]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-11-01"))
        cls: ClsType[List[_models.VirtualMachineImage]] = kwargs.pop("cls", None)

        _request = build_list_with_properties_request(
            location=location,
            publisher_name=publisher_name,
            offer=offer,
            skus=skus,
            subscription_id=self._config.subscription_id,
            expand=expand,
            top=top,
            orderby=orderby,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[VirtualMachineImage]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
