% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Baseline.R
\name{testBaseline}
\alias{testBaseline}
\title{Two-sided test of BASELINe PDFs}
\usage{
testBaseline(baseline, groupBy)
}
\arguments{
\item{baseline}{\code{Baseline} object containing the \code{db} and grouped 
BASELINe PDFs returned by \link{groupBaseline}.}

\item{groupBy}{string defining the column in the \code{db} slot of the 
\code{Baseline} containing sequence or group identifiers.}
}
\value{
A data.frame with test results containing the following columns:
          \itemize{
            \item  \code{region}:  sequence region, such as \code{cdr} and \code{fwr}.
            \item  \code{test}:    string defining the groups be compared. The
                                   string is formatted as the conclusion associated with the
                                   p-value in the form \code{GROUP1 != GROUP2}. Meaning,
                                   the p-value for rejection of the null hypothesis that 
                                   GROUP1 and GROUP2 have equivalent distributions.
            \item  \code{pvalue}:  two-sided p-value for the comparison.
            \item  \code{fdr}:     FDR corrected \code{pvalue}.
          }
}
\description{
\code{testBaseline} performs a two-sample significance test of BASELINe 
posterior probability density functions (PDFs).
}
\examples{
\donttest{
# Subset example data as a demo
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, c_call \%in\% c("IGHM", "IGHG"))
set.seed(112)
db <- dplyr::slice_sample(db, n=200)

# Collapse clones
db <- collapseClones(db, cloneColumn="clone_id",
                     sequenceColumn="sequence_alignment",
                     germlineColumn="germline_alignment_d_mask",
                     method="thresholdedFreq", minimumFrequency=0.6,
                     includeAmbiguous=FALSE, breakTiesStochastic=FALSE)
                     
# Calculate BASELINe
baseline <- calcBaseline(db, 
                         sequenceColumn="clonal_sequence",
                         germlineColumn="clonal_germline", 
                         testStatistic="focused",
                         regionDefinition=IMGT_V,
                         targetingModel=HH_S5F,
                         nproc=1)

# Group PDFs by the isotype
grouped <- groupBaseline(baseline, groupBy="c_call")

# Visualize isotype PDFs
plot(grouped, "c_call")

# Perform test on isotype PDFs
testBaseline(grouped, groupBy="c_call")
}
}
\references{
\enumerate{
  \item  Yaari G, et al. Quantifying selection in high-throughput immunoglobulin 
           sequencing data sets. 
           Nucleic Acids Res. 2012 40(17):e134. 
           (Corrections at http://selection.med.yale.edu/baseline/correction/)
 }
}
\seealso{
To generate the \link{Baseline} input object see \link{groupBaseline}.
}
