// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ExternalSensorSlot.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.sensors {
  public class ExternalSensorSlot : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("sensors.ExternalSensorSlot:1.0.0", null);

    public ExternalSensorSlot(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public ExternalSensorSlot(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new ExternalSensorSlot StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new ExternalSensorSlot(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public enum Events {
      EVT_KEY_INFO_CHANGED,
    }

    public class Location : ICloneable {
      public object Clone() {
        Location copy = new Location();
        copy.x = this.x;
        copy.y = this.y;
        copy.z = this.z;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["x"] = this.x;
        json["y"] = this.y;
        json["z"] = this.z;
        return json;
      }

      public static Location Decode(LightJson.JsonObject json, Agent agent) {
        Location inst = new Location();
        inst.x = (string)json["x"];
        inst.y = (string)json["y"];
        inst.z = (string)json["z"];
        return inst;
      }

      public string x = "";
      public string y = "";
      public string z = "";
    }

    public class Settings : ICloneable {
      public object Clone() {
        Settings copy = new Settings();
        copy.name = this.name;
        copy.description = this.description;
        copy.location = this.location;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["name"] = this.name;
        json["description"] = this.description;
        json["location"] = this.location.Encode();
        return json;
      }

      public static Settings Decode(LightJson.JsonObject json, Agent agent) {
        Settings inst = new Settings();
        inst.name = (string)json["name"];
        inst.description = (string)json["description"];
        inst.location = Com.Raritan.Idl.sensors.ExternalSensorSlot.Location.Decode(json["location"], agent);
        return inst;
      }

      public string name = "";
      public string description = "";
      public Com.Raritan.Idl.sensors.ExternalSensorSlot.Location location = new Com.Raritan.Idl.sensors.ExternalSensorSlot.Location();
    }

    public class Info : ICloneable {
      public object Clone() {
        Info copy = new Info();
        copy.settings = this.settings;
        copy.assigned = this.assigned;
        copy.data = this.data;
        copy.numericSensor = this.numericSensor;
        copy.stateSensor = this.stateSensor;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["settings"] = this.settings.Encode();
        json["assigned"] = this.assigned;
        json["data"] = this.data.Encode();
        json["numericSensor"] = this.numericSensor != null ? this.numericSensor.Encode() : JsonValue.Null;
        json["stateSensor"] = this.stateSensor != null ? this.stateSensor.Encode() : JsonValue.Null;
        return json;
      }

      public static Info Decode(LightJson.JsonObject json, Agent agent) {
        Info inst = new Info();
        inst.settings = Com.Raritan.Idl.sensors.ExternalSensorSlot.Settings.Decode(json["settings"], agent);
        inst.assigned = (bool)json["assigned"];
        inst.data = Com.Raritan.Idl.sensors.ExternalSensorData.Decode(json["data"], agent);
        inst.numericSensor = Com.Raritan.Idl.sensors.NumericSensor.StaticCast(ObjectProxy.Decode(json["numericSensor"], agent));
        inst.stateSensor = Com.Raritan.Idl.sensors.StateSensor.StaticCast(ObjectProxy.Decode(json["stateSensor"], agent));
        return inst;
      }

      public Com.Raritan.Idl.sensors.ExternalSensorSlot.Settings settings = new Com.Raritan.Idl.sensors.ExternalSensorSlot.Settings();
      public bool assigned = false;
      public Com.Raritan.Idl.sensors.ExternalSensorData data = new Com.Raritan.Idl.sensors.ExternalSensorData();
      public Com.Raritan.Idl.sensors.NumericSensor numericSensor = null;
      public Com.Raritan.Idl.sensors.StateSensor stateSensor = null;
    }

    public class GetInfoResult {
      public Com.Raritan.Idl.sensors.ExternalSensorSlot.Info _ret_;
    }

    public GetInfoResult getInfo() {
      JsonObject _parameters = null;
      var _result = RpcCall("getInfo", _parameters);
      var _ret = new GetInfoResult();
      _ret._ret_ = Com.Raritan.Idl.sensors.ExternalSensorSlot.Info.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getInfo(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getInfo", _parameters,
        _result => {
          try {
            var _ret = new GetInfoResult();
            _ret._ret_ = Com.Raritan.Idl.sensors.ExternalSensorSlot.Info.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSettingsResult {
      public Com.Raritan.Idl.sensors.ExternalSensorSlot.Settings _ret_;
    }

    public GetSettingsResult getSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSettings", _parameters);
      var _ret = new GetSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.sensors.ExternalSensorSlot.Settings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.sensors.ExternalSensorSlot.Settings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSettingsResult {
      public int _ret_;
    }

    public SetSettingsResult setSettings(Com.Raritan.Idl.sensors.ExternalSensorSlot.Settings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSettings", _parameters);
      var _ret = new SetSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.sensors.ExternalSensorSlot.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.sensors.ExternalSensorSlot.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class AssignResult {
      public int _ret_;
    }

    public AssignResult assign(Com.Raritan.Idl.sensors.ExternalSensorData data) {
      var _parameters = new LightJson.JsonObject();
      _parameters["data"] = data.Encode();

      var _result = RpcCall("assign", _parameters);
      var _ret = new AssignResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest assign(Com.Raritan.Idl.sensors.ExternalSensorData data, AsyncRpcResponse<AssignResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return assign(data, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest assign(Com.Raritan.Idl.sensors.ExternalSensorData data, AsyncRpcResponse<AssignResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["data"] = data.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("assign", _parameters,
        _result => {
          try {
            var _ret = new AssignResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class UnassignResult {
    }

    public UnassignResult unassign() {
      JsonObject _parameters = null;
      var _result = RpcCall("unassign", _parameters);
      var _ret = new UnassignResult();
      return _ret;
    }

    public AsyncRequest unassign(AsyncRpcResponse<UnassignResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return unassign(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest unassign(AsyncRpcResponse<UnassignResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("unassign", _parameters,
        _result => {
          try {
            var _ret = new UnassignResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
