# 2022-07-19 Triage Log

A rather rough week for compiler performance with regressions outweighing improvements by a considerable margin, in particular in real world crates. To add insult to injury, the biggest regressions came in rollups which make it difficult to trace the cause.

Triage done by **@rylev**.
Revision range: [b3f4c3119957aa0a250cab08ab586b7a9a680ef1..8bd12e8cca3f28f302b9cc0f1f47bb64bd1f98fd](https://perf.rust-lang.org/?start=b3f4c3119957aa0a250cab08ab586b7a9a680ef1&end=8bd12e8cca3f28f302b9cc0f1f47bb64bd1f98fd&absolute=false&stat=instructions%3Au)

**Summary**:

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 1.5% | 4.0% | 176   |
| Regressions 😿 <br /> (secondary) | 1.8% | 6.4% | 147   |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | -1.6% | -4.1% | 9     |
| All 😿🎉 (primary) | 1.5% | 4.0% | 176   |


7 Regressions, 5 Improvements, 3 Mixed; 4 of them in rollups
48 artifact comparisons made in total

#### Regressions

Rollup of 6 pull requests [#99177](https://github.com/rust-lang/rust/pull/99177) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b3f4c3119957aa0a250cab08ab586b7a9a680ef1&end=1c7b36d4db582cb47513a6c7176baaec1c3346ab&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | 0.5% | 0.6% | 9     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | N/A  | N/A | 0     |
- Relatively small regression in secondary benchmarks. Nothing stands out as an obvious culprit, so we can mark as triaged.


Pull Derefer before ElaborateDrops [#98145](https://github.com/rust-lang/rust/pull/98145) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ca4e39400ef33198e2715973d1c67a1d3cee15e7&end=42bd138126b0a9d38d65bc9973e72de3c5b6c37f&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.5% | 0.8% | 13    |
| Regressions 😿 <br /> (secondary) | 0.7% | 1.1% | 20    |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | 0.5% | 0.8% | 13    |
- Slowdowns are happening in MIR borrow checking which this PR directly changes, so regressions are not surprising. 
- An issue should be opened to look into whether this can be improved. 
- [A comment](https://github.com/rust-lang/rust/pull/98145#issuecomment-1189186166) was left asking for a follow up.


Rollup of 5 pull requests [#99210](https://github.com/rust-lang/rust/pull/99210) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=42bd138126b0a9d38d65bc9973e72de3c5b6c37f&end=c80dde43f992f3eb419899a34551b84c6301f8e8&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 2.6% | 4.5% | 7     |
| Regressions 😿 <br /> (secondary) | 1.6% | 4.1% | 55    |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | 2.6% | 4.5% | 7     |
- Seems the issue comes from calling an LLVM API more often due to needing to have unstable feature information kept around longer for use with the `asm!` macro. 
- Ran a cachegrind diff and found that the likely culprit is [#99155](https://github.com/rust-lang/rust/pull/99155) calling `LLVMRustHasFeature` more often.
- [Left a comment](https://github.com/rust-lang/rust/pull/99210#issuecomment-1189222172) asking for a follow up.


Rollup of 5 pull requests [#99231](https://github.com/rust-lang/rust/pull/99231) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0ed9c64c3e63acac9bd77abce62501696c390450&end=f1a8854f9be2e5cad764d630a53d26c7b72f8162&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 1.2% | 3.2% | 117   |
| Regressions 😿 <br /> (secondary) | 1.7% | 6.4% | 35    |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | -0.3% | -0.3% | 1     |
| All 😿🎉 (primary) | 1.2% | 3.2% | 117   |
- It's very hard to tell which PR might be responsible. Luckily, there are only 5 PRs in total so it should be possible to track the issue down. 
- [Left a comment](https://github.com/rust-lang/rust/pull/99231#issuecomment-1189372635) suggesting as much.


Support unstable moves via stable in unstable items [#95956](https://github.com/rust-lang/rust/pull/95956) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f1a8854f9be2e5cad764d630a53d26c7b72f8162&end=24699bcbadff59693a89a5184afed87f6416cdea&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.5% | 0.9% | 13    |
| Regressions 😿 <br /> (secondary) | 0.6% | 1.2% | 10    |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | 0.5% | 0.9% | 13    |
- The change seems to be localized to incremental compilation scenarios. 
- It seems queries like `incr_comp_encode_dep_graph` are being hit more often. I'm unsure whether this is simply because of the additional pass that's happening or something else.
- [Left a comment](https://github.com/rust-lang/rust/pull/95956#issuecomment-1189256819) asking for more insight.


Rollup of 10 pull requests [#99346](https://github.com/rust-lang/rust/pull/99346) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7210e46dc69a4b197a313d093fe145722c248b7d&end=d5e7f4782e4b699728d0a08200ecd1a54d56a85d&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.6% | 2.6% | 136   |
| Regressions 😿 <br /> (secondary) | 1.0% | 5.8% | 100   |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | 0.6% | 2.6% | 136   |
- Regression was found [in #98582](https://github.com/rust-lang/rust/pull/98582) and will be reverted [in #99368](https://github.com/rust-lang/rust/pull/99368) or a follow up.


Use ICF (identical code folding) for building rustc [#99062](https://github.com/rust-lang/rust/pull/99062) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=263edd43c5255084292329423c61a9d69715ebfa&end=246f66a905c2815f2c9b9c3d6b1e0649f3360ef8&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.3% | 0.4% | 2     |
| Regressions 😿 <br /> (secondary) | 2.6% | 2.6% | 3     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | 0.3% | 0.4% | 2     |
- Small performance changes and some wins for binary size.
- Asked in the PR whether [this can be marked as triaged](https://github.com/rust-lang/rust/pull/99062#issuecomment-1189293635).


#### Improvements

gather body owners [#98203](https://github.com/rust-lang/rust/pull/98203) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1ba1fec234d07f43765c3c65ac341a4e64fb911a&end=30243dd87e7dbd17d68e1a1d16ba066a7d2cebe5&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | 0.6% | 0.6% | 1     |
| Improvements 🎉 <br /> (primary) | -0.4% | -0.7% | 30    |
| Improvements 🎉 <br /> (secondary) | -0.5% | -0.8% | 18    |
| All 😿🎉 (primary) | -0.4% | -0.7% | 30    |


interpret: get rid of MemPlaceMeta::Poison [#99013](https://github.com/rust-lang/rust/pull/99013) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=522abf6d88a45f9f49a1b2217426eef1c3a09b52&end=6077b7cda466afa2b75a62b232ab46dbeb148bcb&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | 0.5% | 0.5% | 1     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | -1.6% | -2.5% | 12    |
| All 😿🎉 (primary) | N/A  | N/A | 0     |


stop using `FnCtxt` outside of hir typeck [#99015](https://github.com/rust-lang/rust/pull/99015) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0fe5390a885eb47f506bf481cd9ea2b449705d79&end=23e21bdd25026e2839ebe946c2a937c1904887d2&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.6% | -0.9% | 11    |
| Improvements 🎉 <br /> (secondary) | -0.4% | -0.6% | 11    |
| All 😿🎉 (primary) | -0.6% | -0.9% | 11    |


Use constant eval to do strict mem::uninit/zeroed validity checks [#99033](https://github.com/rust-lang/rust/pull/99033) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c2ecd3af87477147695aa3f6e1237e3185044e62&end=263edd43c5255084292329423c61a9d69715ebfa&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | -2.2% | -2.9% | 6     |
| All 😿🎉 (primary) | N/A  | N/A | 0     |


`replace_bound_vars` fast path: check predicates, don't check consts [#99232](https://github.com/rust-lang/rust/pull/99232) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9ed0bf9f2bd63933785fb8a380c177d2d70e88ec&end=144227dae949fb98896a2ba077d8fe7f36c3238e&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.6% | -0.7% | 6     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | -0.6% | -0.7% | 6     |


#### Mixed

Stop keeping metadata in memory before writing it to disk [#96544](https://github.com/rust-lang/rust/pull/96544) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c2f428d2f3340a0e7d995f4726223db91b93704c&end=1ba1fec234d07f43765c3c65ac341a4e64fb911a&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | 0.3% | 0.4% | 3     |
| Improvements 🎉 <br /> (primary) | -0.3% | -0.3% | 1     |
| Improvements 🎉 <br /> (secondary) | -4.1% | -4.1% | 2     |
| All 😿🎉 (primary) | -0.3% | -0.3% | 1     |
- The perf here is a wash.


Final derive output improvements [#99046](https://github.com/rust-lang/rust/pull/99046) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=116819f54f062a2f425deac4ec29245038c26613&end=0fe5390a885eb47f506bf481cd9ea2b449705d79&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.5% | 0.6% | 8     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.6% | -0.9% | 19    |
| Improvements 🎉 <br /> (secondary) | -2.8% | -3.7% | 6     |
| All 😿🎉 (primary) | -0.2% | -0.9% | 27    |
- Improvements much outweigh the regressions as [noted here](https://github.com/rust-lang/rust/pull/99046#issuecomment-1186032948).

proc_macro/bridge: stop using a remote object handle for proc_macro Ident and Literal [#98189](https://github.com/rust-lang/rust/pull/98189) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=96c2df810b0b681fee63cae11ca63844792b6190&end=c3f35504d15e80b4727872c17c8c2f4bbaee58cf&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 1.0% | 2.2% | 4     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.7% | -1.7% | 19    |
| Improvements 🎉 <br /> (secondary) | -3.0% | -3.1% | 3     |
| All 😿🎉 (primary) | -0.4% | 2.2% | 23    |
- Still more improvements than regressions, and this is an active area of performance work as [noted here](https://github.com/rust-lang/rust/pull/98189#issuecomment-1189240748).

