[comment {-*- tcl -*- doctools manpage}]
[manpage_begin tcl::transform::counter n 1]
[keywords {channel transformation}]
[keywords counter]
[keywords {reflected channel}]
[keywords {tip 230}]
[keywords transformation]
[keywords {virtual channel}]
[copyright {2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Reflected/virtual channel support}]
[category  Channels]
[titledesc {Counter transformation}]
[require Tcl 8.6]
[require tcl::transform::core [opt 1]]
[require tcl::transform::counter [opt 1]]
[description]
[para]

The [package tcl::transform::counterr] package provides a command
creating a channel transformation which passes the read and written
bytes through unchanged (like [package tcl::transform::identity]), but
additionally counts the bytes it has seen for each direction and
stores these counts in Tcl variables specified at construction time.

[para] Related transformations in this module are
[package tcl::transform::adler32],
[package tcl::transform::crc32],
[package tcl::transform::identity], and
[package tcl::transform::observe].

[para] The internal [package TclOO] class implementing the transform
handler is a sub-class of the [package tcl::transform::core]
framework.

[section API]

[list_begin definitions]

[call [cmd ::tcl::transform::counter] [arg chan] [option -option] [arg value]...]

This command creates a counter transformation on top of the channel
[arg chan] and returns its handle. The accepted options are

[list_begin options]
[opt_def -read-variable varname]

The value of the option is the name of a global or namespaced
variable, the location where the transformation has to store the
byte count of the data read from the channel.

[para] If not specified, or the empty string, the counter of the read
direction is not saved.

[opt_def -write-variable varname]

The value of the option is the name of a global or namespaced
variable, the location where the transformation has to store the
byte count of the data written to the channel.

[para] If not specified, or the empty string, the counter of the
write direction is not saved.

[list_end]
[list_end]

[vset CATEGORY virtchannel]
[include ../common-text/feedback.inc]
[manpage_end]
