#ifndef INCLUDED_TYPES_H
#define INCLUDED_TYPES_H
/* vim: set ts=8 sts=4 sw=4 tw=80 noet: */
/*======================================================================
Copyright (C) 2004,2005,2009,2011 Walter Doekes <walter+tthsum@wjd.nu>
This file is part of tthsum.

tthsum is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

tthsum is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with tthsum.  If not, see <http://www.gnu.org/licenses/>.
======================================================================*/

/**
 * A portable way to get fixed width integer types, most notably the
 * 64-bit unsigned integer and its printf formatting macro. (And a
 * macro for portable function inlining.)
 */

#ifdef __cplusplus
    /* Request PRI* macros */
#   define __STDC_FORMAT_MACROS
#endif

#include <limits.h>

/* define (u)int*_t types */
#ifdef _MSC_VER
    typedef signed __int8 int8_t;
    typedef signed __int16 int16_t;
    typedef signed __int32 int32_t;
    typedef signed __int64 int64_t;
    typedef unsigned __int8 uint8_t;
    typedef unsigned __int16 uint16_t;
    typedef unsigned __int32 uint32_t;
    typedef unsigned __int64 uint64_t;
    typedef signed long ssize_t;
#else /* !_MSC_VER */
#   include <inttypes.h>
#endif /* !_MSC_VER */

/* define initialization and formatting types */
#ifdef _MSC_VER
#   define _LL(x) x##LL
#   define _ULL(x) x##ULL
#   define PRIu64 "I64u"
#   define PRIx64 "I64x"
#elif ULONG_MAX == 4294967295U
#   define _LL(x) x##LL
#   define _ULL(x) x##ULL
#else /* !_MSC_VER && ULONG_MAX != 4294967295u */
#   define _LL(x) x##L
#   define _ULL(x) x##UL
#endif /* !_MSC_VER && ULONG_MAX != 4294967295u */

/* use inline if compiler supports it */
#if _MSC_VER
#   define _INLINE __inline
#elif __STRICT_ANSI__
#   define _INLINE
#else
#   define _INLINE inline
#endif

#endif /* INCLUDED_TYPES_H */
