/* twpsk  - A gui application for PSK
 * Copyright (C) 1999-2014 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 4.3 - Aug 2017
 */

#ifndef INCLUDED_SCOPE_H
#define INCLUDED_SCOPE_H

#define LINE_WIDTH 2

#include "GUI.h"

/*
 * Scope class
 */
class Scope
{
   private:
      GC gc;
      XGCValues gcv;
      Display *display;
      int screen;
      Window window;
      XColor color[5];
      Dimension w, h;    /* size of scopeDA */
      Position x, y;     /* end point of last line */
      int agcState;

   public:
      int border_width;  /* space from side to circle */
      int xc, yc;        /* corner of box to draw circle */
      int xo, yo;        /* cooridinates of circle center */
      int scope_width;
      int outer_circle_width;
      Widget scopeDA;
      Scope()
      {
         border_width = 0;
         scope_width = 0;
         outer_circle_width = 4;
         agcState = 0;
      }

      void setup (Widget shell, Widget scopeDA);
      void drawline(int phdelta, int strength, int icolor);
      void drawcirc(void);
}; 
#endif
